/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	write stdin to a series of cartridges
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef USE_SYS_MALLOC
#include <sys/malloc.h>
#else
#include <malloc.h>
#endif
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#define CHD_ERROR 99999
#define CHD_INITIAL_LOAD -99999
#define CHD_RELOAD 500

typedef struct {
	char *unit;
	char *density;
	char *compression;
	char *bsd;
	char *byte_swap;
	char *variable_block;
	char *rewind;
	char *author;
	int blockSize;
	short verbose;
	Boolean totape;
	Boolean help;
	short tattle;
	Boolean segy;
	Boolean mvs;
	Boolean green;
	String host;
	} ApplicationData, *ApplicationDataPtr;

typedef struct {
	XtPointer density;
	XtPointer compression;
	XtPointer bsd;
	XtPointer byte_swap;
	XtPointer variable_block;
	XtPointer rewind;
	} DriveDataInfo;

extern DriveDataInfo drive_info;

enum drive_option_constants {  DENSITY_OPTION,
	REWIND_OPTION,
	COMPRESSION_OPTION,
	BSD_OPTION,
	VARIABLE_BLOCKSIZE_OPTION,
	BYTE_SWAP_OPTION,
	DRIVE_WIDGET_MAX };

#define DEFAULT_OPTION	"default"
#define ON_OPTION 	"on"
#define OFF_OPTION	"off"

#ifdef SUNSYSTEM
#define ULTRA_HIGH_DENSITY 	"ud"
#define HIGH_DENSITY 	"hd"
#define MEDIUM_DENSITY 	"md"
#define LOW_DENSITY	"ld"
#endif

#ifdef SGISYSTEM
#define BPI_800_DENSITY 	"800"
#define BPI_1600_DENSITY 	"1600"
#define BPI_3200_DENSITY	"3200"
#define BPI_6250_DENSITY	"6250"
#define BPI_8200_DENSITY	"8200"
#define BPI_8500_DENSITY	"8500"
#endif

extern XtAppContext app_con;
extern Widget   toplevel,chd_stat_text,quit_dialog;
extern Widget   drive_list,slot_list,selected_list;
extern Widget   history_dialog,history_text1,history_text2;
extern Window	busy_win;
extern Display	*dpy;
extern XtWorkProcId WorkProcID;

extern Boolean	segy_skip;
extern Boolean	mvs_skip;
extern Boolean	hdr_skip;
extern int	cartNumber;
extern float	totalBytes;
extern char*	sampleDeviceName;
extern char	volume[32];
extern char	deviceName[1024];
extern char	*version[];
extern unsigned int deviceNumber;
extern unsigned int den;
extern unsigned int slot;
extern unsigned int unit;

extern FILE* tattle;

extern int tape;
extern int datain,dataout;
extern ApplicationData data;

extern char* iobuffer;
extern long blen;
extern long bout;
extern int  inputEOF;
extern long bgood;
extern char msg_text[];

int fileIsOk();
void finishDrive();
long getInput();
void chd_cmd();
int chd_stat();
void chd_response();
char *get_chd_line();
void delete_selection();
void make_selection();
void listDrives();
void unloadSlot();
void list_slots();
void send_to_chd();
void extra_stuff();
void doit();
void ok_enable();
void interrupt();
void confirm_quit();
void mypause();
void resume();
void quit();
void pop_dialog();
void drop_dialog();
void destroy_dialog();
void save_drive_options();
void disable_button();
void set_delay();
void check_delay();
void dialog_at_cursor();
void date_motion();
void comments();
char **parse_cmd();
Window GetVRoot();
void do_save_history();
void save_history();

Boolean loader();
Boolean IOfromTape();
Boolean IOtoTape();
