/*******************************************************************************
**
** Program name:        ExpandFile (subroutine workhorse)
**
** Language:            C
**
** Author:              Gary Murphy
**
** Date written:        June 2, 92
**
**
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
**
** Abstract:    Expand ~ character for file opens in borne shell
**
** Modification history:        June 2, 1992    Initial release
**
**
********************************************************************************
**
*/

/*
#include <fcntl.h>
*/
#include <localsys.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <pwd.h>
#ifndef __SVR4
extern void setpwent(void);
#endif
#ifdef USE_SYS_MALLOC
#include <sys/malloc.h>
#else
#include <malloc.h>
#endif

/*
 *      CRAY System
 */
#ifdef CRAYSYSTEM
#else

/*
 *      SUN System
 */
#endif

#define TRUE 1
#define FALSE 0
#define MAXLINE 256

char *ExpandFile (char *input, int verbos)
{
  char *output, *base_name;
  struct passwd *pwent;
  int i;

  if (verbos)
    fprintf (stderr, "input file name is %s %d\n", input, strlen(input));

  if (strncmp (input, "~", 1) == 0) {
    if (strncmp (&input[1], "/", 1) == 0) {
      output = malloc(sizeof(char) * MAXLINE);
      pwent = getpwuid(getuid());
      strncpy(output, pwent->pw_dir, MAXLINE);
      strncat(output, &input[1], MAXLINE);
      setpwent();
      return output;
    } else {
      for (i=1; i<(int)strlen(input); i++) {
        if (strncmp(&input[i], "/", 1) == 0) {
          output = malloc(sizeof(char) * MAXLINE);
          base_name = malloc (i);
          base_name[0] = '\0';
          strncpy (base_name, &input[1], i-1);
          base_name[i-1]='\0';
          if (verbos)
             fprintf (stderr, "user name is %s %d\n", base_name, 
                              strlen(base_name));
          pwent = getpwnam (base_name);
          if (verbos)
             fprintf (stderr, "directory is %s\n", pwent->pw_dir);
          strncpy(output, pwent->pw_dir, MAXLINE);
          strncat(output, &input[i], MAXLINE);
          setpwent();
          return output;
        } 
      }
      output = NULL;
      return output;
    }
  } else {
    output = input;
    return output;
  }
}
