/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	Name:		agm_to_picks
	Purpose:	return picks from an AGM file.
	Author:		Bob Mars
	Date:		9/27/91
*/


#include <stdio.h>
#include <string.h>
#ifdef USE_SYS_MALLOC
#include <sys/malloc.h>
#else
#include <malloc.h>
#endif
#include "std.h"
#include "agm.h"
#include "agm_io.h"
#include "agm_datatypes.h"
#include "agm_collection_types.h"


/* #define TEST */


int agm_to_picks( String fn, Tuple ***curves, unsigned **nptspercurve,
		unsigned *ncurves, String *modelname, Units *units )
{
	extern int	agm( unsigned, ... );
	extern int	agm_io( unsigned, ... );

	Version		version;
	Tuple		**segs;
	Type		collectiontype;
	Extents	extents;
	unsigned	*nptsperseg, nsegs, curve, seg;
	unsigned	nversions, ncollections, nthcollection;
	int		rc, type, pt;


	*curves = NULL;
	*nptspercurve = NULL;
	*ncurves = 0;
	*modelname = NULL;

	(void)agm_io( PutFileName, fn );
	if( (rc = agm_io( Action, Read )) != 0 )
		return rc;

	if( (rc = agm( GetModelName, modelname )) != 0 )
		return rc;

	if( (rc = agm( GetUnits, units )) != 0 )
		return rc;

	if( (rc = agm( GetExtents, &extents )) != 0 )
		return rc;

	if( (rc = agm( GetNumberVersions, &nversions )) != 0 )
		return rc;

	if( (rc = agm( GetNthVersionNumber, nversions, &version )) != 0 )
		return rc;

	for( collectiontype = 0;  collectiontype < 2;  collectiontype++ ) {
		switch( collectiontype ) {
		case 0:		type = Horizon;		break;
		case 1:		type = Fault;		break;
		}

		if( (rc = agm( GetNumberOfCollectionType, type, &ncollections ))
		    != 0 )
			return rc;

		if( (rc = agm( RestrictCollectionType, type )) != 0 )
			return rc;

		for( nthcollection = 1;  nthcollection <= ncollections;
		     nthcollection++ )  {
			if( (rc = agm( ActivateIndexedCollection,
					nthcollection )) != 0 )
				break;

			if( (rc = agm( GetCollectionSegments, &nsegs,
					&nptsperseg, &segs )) != 0 )
				break;

			if( !*curves ) {
				*curves = (Tuple **)malloc( nsegs
							* sizeof( Tuple * ) );
				*nptspercurve = (unsigned *)malloc( nsegs
							* sizeof( unsigned ) );
				*ncurves = nsegs;
				for( seg = 0;  seg < nsegs;  seg++ ) {
					for( pt = 0; pt < nptsperseg[seg]; pt++ ) {
						if( segs[seg][pt].x < extents.min.x )
							segs[seg][pt].x = extents.min.x;
						else if( segs[seg][pt].x > extents.max.x )
							segs[seg][pt].x = extents.max.x;

						if( segs[seg][pt].y < extents.min.y )
							segs[seg][pt].y = extents.min.y;
						else if( segs[seg][pt].y > extents.max.y )
							segs[seg][pt].y = extents.max.y;

						if( segs[seg][pt].z < extents.min.z )
							segs[seg][pt].z = extents.min.z;
						else if( segs[seg][pt].z > extents.max.z )
							segs[seg][pt].z = extents.max.z;
					}
					(*curves)[seg] = (Tuple *)malloc(
							nptsperseg[seg] * sizeof( Tuple ) );
					(void)memcpy( (char *)(*curves)[seg],
							(char *)segs[seg], nptsperseg[seg] * sizeof( Tuple ) );
					(*nptspercurve)[seg] = nptsperseg[seg];
				}
			} else {
				*ncurves += nsegs;
				*curves = (Tuple **)realloc( *curves,
						*ncurves * sizeof( Tuple * ) );
				*nptspercurve = (unsigned *)realloc( *nptspercurve,
						*ncurves * sizeof( unsigned ) );
				for( curve = *ncurves-nsegs, seg = 0;
				     seg < nsegs;  curve++, seg++ ) {
					for( pt = 0; pt < nptsperseg[seg]; pt++ ) {
						if( segs[seg][pt].x < extents.min.x )
							segs[seg][pt].x = extents.min.x;
						else if( segs[seg][pt].x > extents.max.x )
							segs[seg][pt].x = extents.max.x;

						if( segs[seg][pt].y < extents.min.y )
							segs[seg][pt].y = extents.min.y;
						else if( segs[seg][pt].y > extents.max.y )
							segs[seg][pt].y = extents.max.y;

						if( segs[seg][pt].z < extents.min.z )
							segs[seg][pt].z = extents.min.z;
						else if( segs[seg][pt].z > extents.max.z )
							segs[seg][pt].z = extents.max.z;
					}
					(*curves)[curve] = (Tuple *)malloc(
							nptsperseg[seg] * sizeof( Tuple ) );
					(void)memcpy( (char *)(*curves)[curve],
							(char *)segs[seg], nptsperseg[seg] * sizeof( Tuple ) );
					(*nptspercurve)[curve] =nptsperseg[seg];
				}
			}
		}
	}

	(void)agm( DeleteModel, *modelname );

	if( rc != 0 )
		return rc;

	return 0;
}


#ifdef TEST
void main()
{
	Tuple		**curves;
	int		*nptspercurve, ncurves;
	Units		units;
	String		modelname, message;
	unsigned	i, j;


	if( agm_to_picks( "Bob.agm",
			&curves, &nptspercurve, &ncurves, &modelname, &units )
	    != 0 ) {
		(void)agm( GetMessage, &message );
		(void)fprintf( stderr, "%s\n", message );
		(void)agm_io( GetIOMessage, &message );
		(void)fprintf( stderr, "%s\n", message );
	} else
		(void)printf( "Success.\n" );


	(void)printf( "agm_to_picks: ncurves=%u\n", ncurves );
	for( i = 0; i < ncurves;  i++ ) {
		(void)printf( "\tnptspercurve[%u]=%u\n", i, nptspercurve[i] );
		for( j = 0;  j < nptspercurve[i];  j++ )
			(void)printf( "\t\t%f, %f, %f\n", curves[i][j].x,
					curves[i][j].y, curves[i][j].z );
	}
}
#endif
