/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdarg.h>
#include <string.h>
#include <sys/types.h>
#ifdef USE_SYS_MALLOC
#include <sys/malloc.h>
#else
#include <malloc.h>
#endif
#include <stdio.h>
#include "std.h"

/*
	Notes: strdup obtains the space for the new string using malloc(3C).
		realloc'ing this space is dicey since realloc may be linked
		with malloc(3X).
		(The malloc(3X)  routines  are  space-efficient,  but have
		slower performance.
		The standard, fully  SCD-compliant  malloc(3C)  routines
		are a trade-off between performance and space-efficiency.)
*/


String concat( String s, ... )
{
	va_list		args;
	String		compoundString = NULL;
	unsigned int	newlen;

	va_start( args, s );
	while( s )
	{
		if( compoundString )
			(void)strcat(
				compoundString = realloc( compoundString,
					(newlen+=(size_t)strlen(s)) + 1 ),
				s );
		else
#if defined(sun) && defined(__SVR4)
		{
			/* strlen/strdup combo unsafe on SOLARIS */
			compoundString = (String)malloc( (newlen=(size_t)strlen(s))+1 );
			(void)strcpy( compoundString, s );
		}
#else
			newlen = (size_t)strlen( compoundString = strdup( s ) );
#endif

		s = va_arg( args, String );
	}

	va_end( args );

	return compoundString;
}
