/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#ifdef USE_SYS_MALLOC
#include <sys/malloc.h>
#else
#include <malloc.h>
#endif
#include <memory.h>
#include <math.h>	/* fabs */
#include "std.h"


/* #define TEST */


typedef struct {
	double	x;
	double	y;
} Dtuple2D;


Boolean dconnect_segs2D( segs, nptsperseg, nsegs, conseg, npts, epsilon )
	Dtuple2D	**segs;
	unsigned	*nptsperseg;
	unsigned	nsegs;
	Dtuple2D	**conseg;
	unsigned	*npts;
	double		epsilon;
{
	Boolean		connected = FALSE;
	Boolean		*used;
	int		i, j, k;


	if( nsegs == 0 )
		return FALSE;

	used = (Boolean *)calloc( nsegs, sizeof( Boolean ) );
	*conseg = NULL;
	*npts = 0;

	connected = TRUE;
	while( connected )
	{
		connected = FALSE;
		for( i = 0;  i < nsegs;  i++ )
		{
			if( used[i] )
				continue;

			if( *conseg == NULL )
			{
				*conseg = (Dtuple2D *)malloc( nptsperseg[i]
							* sizeof( Dtuple2D ) );

				(void)memcpy( (char *)*conseg, (char *)segs[i],
					nptsperseg[i] * sizeof( Dtuple2D ) );
				*npts = nptsperseg[i];
				used[i] = TRUE;
				connected = TRUE;
			}
			else if( fabs( segs[i][0].x
					- (*conseg)[0].x ) < epsilon  &&
				 fabs( segs[i][0].y
					- (*conseg)[0].y ) < epsilon )
			{	/* shift (less 1 pt.) & backward copy */
				*conseg = (Dtuple2D *)realloc( *conseg,
						(*npts+nptsperseg[i]-1)
						* sizeof( Dtuple2D ) );
				for( j = *npts+nptsperseg[i]-2, k = *npts-1;
				     j >= nptsperseg[i];  j--, k-- )
					(*conseg)[j] = (*conseg)[k];
				for( j = nptsperseg[i]-1, k = 0;  j >= 0;
				     j--, k++ )
					(*conseg)[k] = segs[i][j];
				*npts += nptsperseg[i] - 1;
				used[i] = TRUE;
				connected = TRUE;
			}
			else if( fabs( segs[i][nptsperseg[i]-1].x
					- (*conseg)[0].x ) < epsilon  &&
				 fabs( segs[i][nptsperseg[i]-1].y
					- (*conseg)[0].y ) < epsilon )
			{	/* shift (less 1 pt.) & backward copy */
				*conseg = (Dtuple2D *)realloc( *conseg,
						(*npts+nptsperseg[i]-1)
						* sizeof( Dtuple2D ) );
				for( j = *npts+nptsperseg[i]-2, k = *npts-1;
				     j >= nptsperseg[i];  j--, k-- )
					(*conseg)[j] = (*conseg)[k];
				(void)memcpy( (char *)*conseg, (char *)segs[i],
					nptsperseg[i] * sizeof( Dtuple2D ) );
				*npts += nptsperseg[i] - 1;
				used[i] = TRUE;
				connected = TRUE;
			}
			else if( fabs( segs[i][0].x
					- (*conseg)[*npts-1].x ) < epsilon  &&
				 fabs( segs[i][0].y
					- (*conseg)[*npts-1].y ) < epsilon )
			{	/* copy (less 1 pt.) */
				*conseg = (Dtuple2D *)realloc( *conseg,
						(*npts+nptsperseg[i]-1)
						* sizeof( Dtuple2D ) );
				(void)memcpy( (char *)&(*conseg)[*npts],
					(char *)&segs[i][1],
					(nptsperseg[i]-1) * sizeof( Dtuple2D ));
				*npts += nptsperseg[i] - 1;
				used[i] = TRUE;
				connected = TRUE;
			}
			else if( fabs( segs[i][nptsperseg[i]-1].x
					- (*conseg)[*npts-1].x ) < epsilon  &&
				 fabs( segs[i][nptsperseg[i]-1].y
					- (*conseg)[*npts-1].y ) < epsilon )
			{	/* backward copy (less 1 pt.) */
				*conseg = (Dtuple2D *)realloc( *conseg,
						(*npts+nptsperseg[i]-1)
						* sizeof( Dtuple2D ) );
				for( j = nptsperseg[i]-2, k = *npts;  j >= 0;
				     j--, k++ )
					(*conseg)[k] = segs[i][j];
				*npts += nptsperseg[i] - 1;
				used[i] = TRUE;
				connected = TRUE;
			}
		}
	}

	for( i = 0;  i < nsegs;  i++ )
		if( !used[i] )
		{
			free( (char *)used );
			free( (char *)*conseg );
			return FALSE;
		}

	free( (char *)used );

	if( (*conseg)[0].x  !=  (*conseg)[*npts-1].x  ||
	    (*conseg)[0].y  !=  (*conseg)[*npts-1].y )
	{
		free( (char *)*conseg );
		return FALSE;
	}
	else
		return TRUE;
}


#ifdef TEST
#define EPSILON		1.0e-6


void main()
{
	static Dtuple2D		seg1[] = { {0.0, 0.0}, {1.0, 1.0}, {2.0, 2.0} };
	static Dtuple2D		seg2[] = { {8.0, 8.0}, {9.0, 9.0}, {2.0, 2.0} };
	static Dtuple2D		seg3[] = { {0.0, 0.0}, {3.0, 3.0}, {4.0, 4.0} };
	static Dtuple2D		seg4[] = { {8.0, 8.0}, {5.0, 5.0}, {4.0, 4.0} };
	static Dtuple2D		seg5[] = { {8.0, 8.0}, {7.0, 7.0}, {6.0, 6.0} };
	static Dtuple2D		seg6[] = { {1.1, 1.1}, {2.2, 2.2}, {3.3, 3.3} };
	static Dtuple2D		*segs[] = { seg1, seg2, seg3, seg4, seg5 };
	static unsigned		nptsperseg[] = { 3, 3, 3, 3, 3 };

	Dtuple2D		*conseg;
	Boolean			yup;
	unsigned		npts, i;


	yup = dconnect_segs2D( segs, nptsperseg, 4, &conseg, &npts, EPSILON );
	printf( "dconnect_segs2D should = True: %s\n", yup ? "True" : "False" );
	if( yup )
	{
		for( i = 0;  i < npts;  i++ )
			printf( "%d: %f,%f\n", i+1, conseg[i].x, conseg[i].y);
		printf( "\n\n" );
	}

	yup = dconnect_segs2D( segs, nptsperseg, 5, &conseg, &npts, EPSILON );
	printf( "dconnect_segs2D should = True: %s\n", yup ? "True" : "False" );
	if( yup )
	{
		for( i = 0;  i < npts;  i++ )
			printf( "%d: %f,%f\n", i+1, conseg[i].x, conseg[i].y);
		printf( "\n\n" );
	}

	segs[4] = seg6;
	yup = dconnect_segs2D( segs, nptsperseg, 5, &conseg, &npts, EPSILON );
	printf( "dconnect_segs2D should = True: %s\n", yup ? "True" : "False" );
	if( yup )
	{
		for( i = 0;  i < npts;  i++ )
			printf( "%d: %f,%f\n", i+1, conseg[i].x, conseg[i].y);
		printf( "\n\n" );
	}
}
#endif
