/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  converts picks to agm format and then
  writes it to a file.
*/

#include <sys/types.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <pwd.h>
#include "xdisplayP.h"
#include "prototyping.h"

extern Boolean honor_flag;
extern float axis_units[3],axis_offset[3];

typedef struct {
  float x;
  float y;
  float z;
} Tuple, *Tupleptr; 

typedef struct {
  char *x;
  char *y;
  char *z;
} Units;

void convert_to_agm(long id, char *filename, char *modelname,Units *units)
{
  extern int picks_to_agm( Tuple**, unsigned*, unsigned, char*, Units*, char*, Boolean);
  Tupleptr ptr;
  Tuple *curves;
  Tuple **curves_array;
  int *nptspercurve;
  int ncurves,size,n,m,count;
  float record,trace,sample;

  fprintf(stderr,"Model %s\n",modelname);

  ncurves=0;
  size=0;
  for (n=0; n<MAX_PICKS; n++) 
    if (picks[n].init==-1) {
      if (visible_segment(id,picks[n].group)) {
	ncurves++;
	size+=picks[n].size;
      }
    }

  curves=(Tuple *)malloc(size*sizeof(Tuple));
  curves_array=(Tuple **)malloc(ncurves*sizeof(Tuple *));
  nptspercurve=(int *)malloc(ncurves*sizeof(int *));
  
  ptr=&curves[0];

	count=0;
	for (n=0; n<MAX_PICKS; n++) 
		if (picks[n].init==-1) {
			if (visible_segment(id,picks[n].group)) {
				nptspercurve[count]=picks[n].size;
				curves_array[count]=ptr;
				count++;
				for (m=0; m<picks[n].size; m++) {
/*					if (honor_flag)
						record=((float)*(picks[n].record+m)*axis_units[0])+axis_offset[0];
					else
						record=(1.0*axis_units[0])+axis_offset[0];
					trace=((float)*(picks[n].trace+m)*axis_units[1])+axis_offset[1];
					sample=((float)*(picks[n].sample+m)*axis_units[2])+axis_offset[2];
*/
					if (honor_flag)
						record=(float)picks[n].record[m]*xdisplay[id].axis_units[0]+xdisplay[id].axis_offset[0];
						else
					record=1.0*xdisplay[id].axis_units[0]+xdisplay[id].axis_offset[0];
					trace=(float)picks[n].trace[m]*xdisplay[id].axis_units[1]+xdisplay[id].axis_offset[1];
					sample=(float)picks[n].sample[m]*xdisplay[id].axis_units[2]+xdisplay[id].axis_offset[2];
					ptr->x=trace;
					ptr->y=record;
					ptr->z=sample;
					ptr++;
				}	
			}
		}

  if (picks_to_agm(curves_array,(unsigned*)nptspercurve,
		   ncurves,modelname,units,filename,True)!= 0 ) {
    fprintf( stderr, "Error xsd: Can't write agm file.\n");
  }

  if(curves)
    free(curves); curves=NULL;
  if(curves_array)
    free(curves_array); curves_array=NULL;
  if(nptspercurve)
    free(nptspercurve); nptspercurve=NULL;
}


/*                  Extra stuff supporting agm.          */


char *current_time(void)
{
  static char  currenttime[8+1];
  time_t       timeval;
  char         *date;
  
  time( &timeval );   date = ctime( &timeval );
  
  strncpy( currenttime, date+11, 8 );   currenttime[8] = '\0';
  
  return( currenttime );
}


char *owner_name(void)
{
  struct passwd   *passwd_ptr;
  
  static char     *ownername = NULL;
  char            *userid;
  
  if( (userid = getlogin( )) == NULL )  {
    if( (passwd_ptr = getpwuid( getuid() )) != NULL )  {
      if( !ownername )  {
	ownername = (char *)malloc( strlen( passwd_ptr->pw_gecos ) + 1 );
	(void) strcpy( ownername, passwd_ptr->pw_gecos );
      } else {
	free( ownername );
	ownername = (char *)malloc( strlen( passwd_ptr->pw_gecos ) + 1 );
	(void) strcpy( ownername, passwd_ptr->pw_gecos );
      }
    }
  } else {
    if( (passwd_ptr = getpwnam( userid )) != NULL )  {
      if( !ownername )  {
	ownername = (char *)malloc( strlen( passwd_ptr->pw_gecos ) + 1 );
	(void) strcpy( ownername, passwd_ptr->pw_gecos );
      } else {
	free( ownername );
	ownername = (char *)malloc( strlen( passwd_ptr->pw_gecos ) + 1 );
	(void) strcpy( ownername, passwd_ptr->pw_gecos );
      }
    }
  }
  return( ownername );
}



char *todays_date(void)
{
  static char  today[11+1];
  time_t       timeval;
  char         *date;
  
  time( &timeval );
  date = ctime( &timeval );
  
  (void) strncpy( today, date+4, 7 );   today[7] = '\0';
  (void) strncat( &today[7], date+20, 4 );
  
  return( today );
}
