/***********************************************************************
/
/		       Disco & SIS Server for xsd
/
/          	          Copyright (C) 1993  
/          	AMOCO Production Company, Tulsa, OK 74102
/
/ Revised: Mar 13, 93 by Jerry Ehlers - Initial Version modified from
/			Doug Horn
/ Revised: Oct 28, 93 by Jerry Ehlers - Add checks if read larger SIS
/			buffers than expected
/ Revised: Nov  2, 93 by Jerry Ehlers - Try to allow continuation even
/			when reading too many bytes.
/ Revised: Mar  8, 94 by Jerry Ehlers - Turn of using Large Buffers in
/			I/O when doing a lot of seeks.
/ Revised: Dec 14, 98 by Joe M. Wade - Added provisions for byte swapping
/			on Intel platforms.
/ Note: Jan 15, 00 -  Joe M. Wade - For FreeUSP release, this program is
/			built as xsdServer, since it does not handle SEGY
/                       format as the real ddsServer3 does. The name 
/                       change alone tells xsd to hide format-related 
/			toggle buttons and panels.
/**********************************************************************/
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <math.h>
#include "io_defs.h"
#include "mathadv.h"
#include "usp_headers.h"
#include "save.h"
#ifdef USE_SYS_MALLOC
#include <sys/malloc.h>
#else
#include <malloc.h>
#endif

#define HistogramScaling	0
#define MaximumScaling		1
#define FixedScaling		2
#define RangeScaling		3
#define VelocityScaling		4
#define MinMaxScaling		5

/* #define DEBUG */


#ifdef __convex__
#define  TIME_OUT 	300 	/* Seconds (5 min due to Virtual disk system) */
#else
#define  TIME_OUT 	1200 	/* Seconds (20 min) */
#endif
#define  MAXHEADER 	50000	/* Max Line Header size. */
#define  XTRA 		12	/* Extra words for trace buffer. */

void end_server();

FILE 		*debug;
int machine=0;
int start_color=55;
int end_color=255;
    
/***********************************************************************
/*
/* 	Main
/*
/**********************************************************************/
main (argc, argv)
int argc;
char **argv;
{
	FILE 		*in;
	int		i;
	int 		srec,   erec,   irec;
	int		strace, etrace, itrace;
	int		ssamp,  esamp,  isamp;
	int 		type, s_offset, junk, length, flag, vds;
	int		sequence, trace_flag, invert_flag, level;
	float 		s_scalar, s_exponent;
	char 		buf[1124], command[10], file[1024], format[8];
	static int	old_seq = -1;

	/*	Show revision	*/

	gethostname(buf,1124);
/*	fprintf(stderr,"%s:xsd_server (Dec 22, 95)", buf); */
	fprintf(stderr,"%s:xsdServer (Jan 12, 01 - USP format only)", buf);
	for (i=0;i<argc;i++) fprintf(stderr," %s",argv[i]);
	fprintf(stderr,"\n");

	/*	Signal handling	*/

	signal(SIGALRM, end_server);
	alarm(TIME_OUT);

#ifdef DISCO
	/*	Set environment to access Disco VDS files	*/
	init_vds();
#endif
#ifdef DEBUG
	debug = fopen("xsdServer.db","w");
	setbuf(debug,NULL);
#else
	debug = NULL;
#endif
	if (debug != NULL) fprintf(debug,"xsdServer\n");
	

	/*	Get which machine type we're running on	*/
  
	if (debug != NULL) fprintf(debug,"argc = %d\n",argc);
	if (argc==2) sscanf(argv[1],"%d",&machine);
	if (debug != NULL) fprintf(debug,"machine = %d\n",machine);

#ifdef CRAY2
	/*  	Needed on Cray for freeing memory?	*/
	_memlimit(1000000,100000);
#endif

	do 
	{
	   flag = 0;
	   fgets(buf, 500, stdin);

	   sscanf(buf, "%d %s", &sequence, command);
	if (debug != NULL) fprintf(debug,"seq %d %s\n",sequence,command);
	   if (sequence == old_seq) exit(-1);
	   old_seq = sequence;
	   alarm(TIME_OUT);

	   /*	Check if Server is Alive	*/

	   if (strcmp(command, "Check") == 0) 
	   {
	      flag = 1;
	      sprintf(buf, "OK");
	      write(1, buf, 3);
	   }	
           else if (strcmp(command, "AutoFmt") == 0)
           {
              /* do nothing */
	      flag = 1;
           }
           else if (strcmp(command, "SpecFmt") == 0)
           {
              /* do nothing */
	      flag = 1;
	      sscanf(buf, "%d %s %s", &sequence, command,format);
	      if (strcmp(format,"usp") != 0) {
	        sprintf(buf,"Format %s not supported by this server",format);
	        write(1, buf, strlen(buf));
		}
           }
	   else if (strcmp(command, "ColorR") == 0) 
	   { /*	Get color table range Info	*/
	      flag = 1;
	      sscanf(buf, "%d %s %d %d", &sequence, command, 
		&start_color, &end_color);
	   }
	   else if (strcmp(command, "Files") == 0)
	   { /*	Send List of Files	*/
	      flag = 1;
	      sscanf(buf, "%d %s %s", &sequence, command, file);
	      sprintf(buf, "ls -Fa %s |wc", file);
	      in = popen(buf, "r");
	      fscanf(in, "%d %d %d", &junk, &junk, &length);
	      pclose(in);
	      sprintf(buf, "%9d\n", length);
	      write(1, buf, 10);
	      sprintf(buf, "ls -Fa %s |cat", file);
	      system(buf); 
	   }	
	   else if (strcmp(command, "LineH") == 0)
	   { /*	Send Line Header Info	*/
	      flag = 1;
	      sscanf(buf, "%d %s %s", &sequence, command, file);
if (debug != NULL) fprintf(debug,"calling read_sis_header, file = %s\n", file);
#ifdef DISCO
	      read_disco_header_f(file, &vds);
#else
	      vds=0;
#endif
	      if (!vds) read_sis_header(file);
	   }
	   else if (strcmp(command, "Data") == 0) 
	   { /*	Send Data Sorted	*/
	      flag = 1;
	      sscanf(buf,
		   "%d %s %s %d %d %d %d %d %d %d %d %d %d %d %e %e %d %d %d",
            		&sequence, command, file, &srec, &erec, &irec,  
			&strace, &etrace, &itrace, &ssamp, &esamp, 
			&isamp, &type, &s_offset, &s_scalar, 
			&s_exponent, &trace_flag, &invert_flag, &level);
#ifdef DISCO
	      if (vds) read_disco_data_f(file, srec, erec, irec, 
			strace, etrace, itrace, ssamp, esamp, isamp,  
			type, s_offset, s_scalar, s_exponent, 0,  
			trace_flag, start_color, end_color);
#else
	      if (vds) fprintf(stderr, "xsd_server: VDS ERROR?\n"); 
#endif
	      else read_sis_data(file, srec, erec, irec,
			strace, etrace, itrace, ssamp, esamp, isamp,
			type, s_offset, s_scalar, s_exponent, 0, 
			trace_flag, invert_flag, level);
	   }
	   else if (strcmp(command, "DataNS") == 0) 
	   { /*	Send Data Unsorted	*/
	      flag = 1;
	      sscanf(buf,
		   "%d %s %s %d %d %d %d %d %d %d %d %d %d %d %e %e %d %d %d",
            		&sequence, command, file, &srec, &erec, &irec,  
			&strace, &etrace, &itrace, &ssamp, &esamp, 
			&isamp, &type, &s_offset, &s_scalar, 
			&s_exponent, &trace_flag, &invert_flag, &level);
#ifdef DISCO
	      if (vds) read_disco_data_f(file, srec, erec, irec, 
			strace, etrace, itrace, ssamp, esamp, isamp,  
			type, s_offset, s_scalar, s_exponent, 1,  
			trace_flag, start_color, end_color);
#else
	      if (vds) fprintf(stderr, "xsd_server: VDS ERROR?\n"); 
#endif
	      else read_sis_data(file, srec, erec, irec,
			strace, etrace, itrace, ssamp, esamp, isamp,
			type, s_offset, s_scalar, s_exponent, 1, 
			trace_flag, invert_flag, level);
	   }

	   fflush(stdout);
	} while ((strcmp(command, "End") != 0) && (flag == 1));

}
  
/***********************************************************************
/*
/* 	end_server
/*
/**********************************************************************/
void end_server()
{
	exit(0);
}
  

#ifdef DISCO

/***********************************************************************
/*
/* 	send_disco_dir
/*
/*	Sends the Disco ensemble directly (call from READ_DISCO_HEADER)
/*
/**********************************************************************/
send_disco_dir(keys, nkey, maxntr, ns)
int 	*keys, nkey, maxntr, ns;
{
	int		i;
	char		*header, buf[14];

	header = (char *)malloc(36 + nkey*10*sizeof(char));

	sprintf(header, "%d %d %d ", nkey, maxntr, ns);
	for (i=0; i<nkey; i++) 
	{
	   sprintf(buf, "%d ", keys[i]);
	   strcat(header, buf);
	}
  
	sprintf(buf, "VDS %9d", strlen(header));
	write(1, buf, 14);
	write(1, header, strlen(header));

	free(header);
}
  
/***********************************************************************
/*
/* 	send_disco_data
/*
/*	Sends the Disco data (call from READ_DISCO_DATA)
/*
/**********************************************************************/
send_disco_data(buf, nras, nhdr, offset, scale)
unsigned char 	*buf;
int	nras, nhdr, offset;
float	scale;
{
	char		buffer[80];

 	sprintf(buffer,"%d %d %e %d", nras, offset, scale, nhdr);
	write(1, buffer, 80);
	write(1, buf, nras+nhdr);
}
  
/***********************************************************************
/*
/* 	send_error
/*
/*	Sends error msg (call from READ_DISCO_HEADER & READ_DISCO_DATA)
/*
/**********************************************************************/
send_error()
{
	printf("-1\n");
}
  
/***********************************************************************
/*
/* 	init_vds
/*
/*	Initializes environmental variable so Disco VDS routines work
/*
/**********************************************************************/
init_vds()
{
	char		*env, host[24];

	if (getenv("dci_root")==NULL)
	{
	   gethostname(host, 23);
	   env = (char *)malloc(15+strlen(host));
	   sprintf(env,"dci_sitenam=%s",host);
	   putenv("dci_systype=IEEE");
	   putenv("dci_hpl=/disco/r90/dcilcl/help/disco.hpl");
	   putenv("dci_pldef=/disco/r90/dci_config/pldef.dat");
	   putenv("dci_colordef=/disco/r90/dci_lib/colordef.col");
	   putenv("dci_plshade=/disco/r90/dci_lib/shadedef.bwp");
	   putenv("dci_hcomdeb=/export/data2/disco/scratch/hcom.dbg");
	   putenv(env);
	}
}

#endif


/***********************************************************************
/*
/* 	read_sis_header
/*
/**********************************************************************/
read_sis_header(file)
char 	*file;
{
	char 		buf[14];
	unsigned char 	header[MAXHEADER];
	int 		n, unit, nbytes, data, number;


	if (check_sis_file(file)==-1) 
	{
if (debug != NULL) fprintf(debug,"check_sis_file(%s) failed\n",file);
 	   printf("-1\n");
	   return;
  	}
#ifdef DEBUG
	fprintf(stderr,"read_sis_header: machine = %d\n",machine);
#endif

	if (machine) C_LBOPEN(&unit,file,"r");
	else unit=open(file,O_RDONLY);
	if (unit==-1)
	{
	   fprintf(stderr, "Cannot open sis file '%s'.\n", file);
	   close_file(unit);
	   return;
  	}
if (debug != NULL) fprintf(debug,"%s opened, unit = %d\n",file,unit);

	if (machine) C_RTAPE(unit,header,&nbytes);
	else 
	{
	   nbytes=read(unit,header,4);
	   if (nbytes==-1) 
	   {
	      fprintf(stderr,"Error reading line header.\n");
	      close_file(unit);
	      return;
  	   }
	   number=(int)(header[2]<<8)+(int)header[3];
	   if (number>MAXHEADER) n=MAXHEADER;
if (debug != NULL) fprintf(debug,"%s green word = %d\n",file,number);
	   nbytes=read(unit,header,number);
  	} 

	if (nbytes==-1) 
	{
	   fprintf(stderr,"Error reading line header.\n");
	   close_file(unit);
	   return;
  	}

	sprintf(buf,"SIS %9d",nbytes);
if (debug != NULL) fprintf(debug,"%s\n",buf);
	write(1,buf,14);
	write(1,header,nbytes); 


	if (machine) C_LBCLOS(unit);
	else close(unit);
}
  
/***********************************************************************
/*
/* 	check_sis_file
/*
/**********************************************************************/
int check_sis_file(file)
char *file;
{
	int	unit;

	unit=open(file,O_RDONLY);

	if (unit==-1) 
	{
	   fprintf(stderr, "Cannot open sis file '%s'.\n", file);
	   close(unit);
	   return(-1);
	}

	close(unit);
	return(1);
}
  
/***********************************************************************
/*
/* 	close_file
/*
/**********************************************************************/
close_file(unit)
int unit;
{
	printf("-1\n");
	if (machine) C_LBCLOS(unit);
	else close(unit);
}
  
/***********************************************************************
/*
/* 	read_sis_data
/*
/*	Sends the SIS data 
/*
/*	type=0:	Histogram scaling
/*	     1:	Maximum scaling
/*	     2:	Fixed scaling
/*	     3:	Range scaling
/*	     4:	16-b Velocity
/*	     5:	Min/Max scaling
/*
/**********************************************************************/
read_sis_data(file, srec, erec, irec, strace, etrace, itrace, ssamp, 
		esamp, isamp, type, s_offset, s_scalar, s_exponent, 
		sort_flag, trace_flag, invert_flag, level)
char 	*file;
int 	srec, erec, irec, strace, etrace, itrace, ssamp, esamp, isamp;
int	type, s_offset;
float 	s_scalar,s_exponent;
int 	sort_flag,trace_flag, invert_flag, level;
{
	int		i;
	int		zero=0,one=1;
	int		m,n,ntr_total,count;
	int		debug1,debug2;
	int		unit,stride,skip,loc,trace_skip,skip_ntr;
	int		nbytes,mbytes,nwords,ntr,nrec,nsamp,nsmp,ndata,nhdr;
	int		tmp,tmp1,hist_tmp;
	int		dummy_scalar;
	int		header[MAXHEADER];
	float 		*trace,*data,*traceH,*scale;
	float 		*dummy_hist1,*dummy_hist2;
	float		max_mag,offset,scalar,min_value,max_value, *trash;
	float		clip_min, clip_max;
/*	unsigned char 	*raster, *trash;	/* RJM: bad Douggyism */
	unsigned char 	*raster;
	unsigned int 	*trash_vel;
	char 		buf[80];
	float		min_amp, max_amp;
	unsigned int	*dummy_vel;

#ifdef DEBUG
	fprintf( stderr, "read_sis_data: file='%s', machine=%d\n", file, machine );
	fprintf( stderr, "              level=%d\n", level);
#endif

	if (check_sis_file(file)==-1) 
	{
	   printf("-1\n");
	   return;
	}
#ifdef DEBUG
	fprintf( stderr, "read_sis_data: check_sis_file passed.\n" );
#endif

	stride=isamp;
	C_LBOPEN(&unit,file,"r");
#ifdef DEBUG
	fprintf( stderr, "read_sis_data: called C_LBOPEN, unit=%d\n", unit );
#endif
	if (unit==-1) 
	{
 	   fprintf(stderr,"Cannot open sis file '%s'.\n", file);
	   printf("-1\n");
	   C_LBCLOS(unit);
	   return;
	}

	C_RTAPE(unit,(char *)header,&nbytes);
#ifdef DEBUG
	fprintf( stderr, "read_sis_data: read %d header bytes\n", nbytes );
#endif
	if (nbytes>MAXHEADER)
	{
	   fprintf(stderr,"SIS Line header too large (%d>%d)\n", 
			nbytes, MAXHEADER);
	   fprintf(stderr,"   Memory may be corrupted!\n");
	}
	if (nbytes==0) 
	{
	   fprintf(stderr,"Error reading line header.\n");
	   printf("-1\n");
	   C_LBCLOS(unit);
	   return;
	}

	ntr_total = ((usp_line_header *)header)->NumTrc;
	nsmp = ((usp_line_header *)header)->NumSmp;

	if (s_exponent!=0.0) 
	{
	   scale=(float *)malloc(nsmp*sizeof(float));
	   if (scale==NULL) 
	   {
	      fprintf(stderr,"Cannot allocate %d bytes for scale.\n",
		nsmp*sizeof(float));
	      printf("-1\n");
	      C_LBCLOS(unit);
	      return;
	   }
	   for (m=0; m<nsmp; m++) scale[m]=pow((double)m+1,s_exponent);
	}
	else
           scale=NULL;


#ifdef CRAY
	trace_skip=128;
#else
	trace_skip=64;
#endif
	nsamp = nsmp+trace_skip;

	trace=(float *)malloc((nsamp+XTRA)*sizeof(float));
	if (trace==NULL) 
	{
	   fprintf(stderr,"Cannot allocate %d bytes for trace.\n",
	      (nsamp+XTRA)*sizeof(float));
	   printf("-1\n");
	   if (scale) free(scale);
	   C_LBCLOS(unit);
	   return;
	}

#ifdef DEBUG
	fprintf( stderr, "read_sis_data: malloc'd %d bytes for trace\n", (nsamp+XTRA)*sizeof(float));
#endif
	nrec  =((erec-srec)/irec)+1;
	ntr   =((etrace-strace)/itrace)+1;
	nsamp =((esamp-ssamp)/isamp)+1;
	nwords=ntr*nsamp*nrec;

	data=(float *)malloc(nwords*sizeof(float));
	if (data==NULL) 
	{
	   fprintf(stderr,"Error can not allocate storage for data.\n");
	   printf("-1\n");
	   if (scale) free(scale);
	   free(trace);
	   C_LBCLOS(unit);
	   return;
	} 
	if (trace_flag==1) traceH = (float *)malloc(ntr*trace_skip*
			nrec*sizeof(float));
	else traceH=NULL;
 
#ifdef DEBUG
	fprintf( stderr, "read_sis_data: skipping %d bytes\n", (srec-1)*ntr_total+(strace-1));
#endif
	C_SKIPT(unit,(srec-1)*ntr_total+(strace-1));
#ifdef DEBUG
	fprintf( stderr, "read_sis_data: skipped %d bytes\n", (srec-1)*ntr_total+(strace-1));
#endif

	skip	=ntr*nrec;
	mbytes	=(nsmp+trace_skip)*sizeof(float);
	skip_ntr=ntr_total-etrace+(irec-1)*ntr_total+(strace-1);
	if (skip_ntr && etrace==strace) C_SISLGBUF(unit,"off");

	for (m=0; m<nrec; m++) 
	{
	   count=0;
	   for (n=0; n<=(etrace-strace); n++) 
	   {
	      nbytes=0;
#ifdef DEBUG
	fprintf( stderr, "read_sis_data: reading record %d, trace %d\n", m+srec, n+strace );
#endif
	      C_RTAPE(unit,(char *)trace,&nbytes);
#ifdef DEBUG
	fprintf( stderr, "read_sis_data: read %d bytes\n", nbytes );
#endif
	      if (m==0 && n==0 && nbytes>mbytes)
	      {
	         nbytes = nbytes/sizeof(float) - trace_skip;
	         fprintf(stderr,"SIS Line header LIED!!\n");
	         fprintf(stderr,
			"   Expected %d samples, but read %d!\n",
			nsmp, nbytes);
	         fprintf(stderr,"   Memory may be corrupted!\n");
	      }
	      if (nbytes==0) 
	      {
	         fprintf(stderr,"Error reading in trace.\n");
		 printf("-1\n");
	         if (scale)  free(scale);
	         free(trace);
	         free(data);
	         if (traceH) free(traceH);
		 C_LBCLOS(unit);
		 return;
	      }
	      if ((n%itrace==0)&&((int)(n/itrace)<ntr)) 
	      {
		 if (sort_flag) 
	         {
	            if (s_exponent!=0.0) 
	            {
	    	       D_vmul(trace+trace_skip+(ssamp-1), &stride, 
				scale+(ssamp-1), &stride, 
				data+count+ntr*m, &skip, &nsamp);
                    }
	            else
	            {
	               D_vmov(trace+trace_skip+(ssamp-1), &stride, 
				data+count+ntr*m, &skip, &nsamp);
                    }
	            if (trace_flag==1) memcpy((traceH+count*trace_skip 
				+m*trace_skip*ntr), trace, trace_skip 
				*sizeof(float));
	         } 
	         else 
	         {
	            if (s_exponent!=0.0) 
	            {
	               D_vmul(trace+trace_skip+(ssamp-1), &stride, 
	                        scale+(ssamp-1), &stride,
				data+count*nrec+m, &skip, &nsamp);
	            }
	            else
	            {
	               D_vmov(trace+trace_skip+(ssamp-1), &stride, data
				+count*nrec+m, &skip, &nsamp);
	            }
	            if (trace_flag==1) memcpy(traceH+count*trace_skip 
				*nrec+m*trace_skip, trace, trace_skip
				*sizeof(float));
	         }
	         count++;
              }
           }
           if (skip_ntr) C_SKIPT(unit,skip_ntr);
	}

	if (type != VelocityScaling) {
	   if (type == FixedScaling) {
	      offset = start_color +(int)((end_color-start_color+1)/2)
		+(s_offset*(end_color-start_color+1))/100.0;
	   } else {
	      offset = start_color +(float)(end_color-start_color+1)/2
		+(s_offset*(end_color-start_color+1))/100.0;
	   }

	   if (type == MaximumScaling) {
	      D_maxmgv(data, &one, &max_mag, &loc, &nwords);

	      if (max_mag == 0.0) {
		 scalar  = 1.0;
	      } else {
	 	 scalar  = ((end_color-start_color+1)/(2.0*max_mag))*s_scalar; 
	      }

	      if (debug != NULL) {
		 fprintf(debug, "MaxScaling:\n\t\tuser offset=%d, new offset=%g\n", 
			 s_offset, offset);
		 fprintf(debug, "\t\tuser scalar=%g, new scalar=%g\n", 
			 s_scalar, scalar);
		 fprintf(debug, "\t\tmaxmg=%g\n", max_mag);
	      }
	      s_scalar = scalar/100.0;
	   }
	   else if (type == FixedScaling)
	   {
	      scalar = ((end_color-start_color+1)/2.0)*s_scalar;

	      if (debug != NULL) {
		 fprintf(debug, "FixedScaling:\n\t\tuser offset=%d, new offset=%g\n", 
			 s_offset, offset);
		 fprintf(debug, "\t\tuser scalar=%g, new scalar=%g\n", 
			 s_scalar, scalar);
	      }
	   }
	   else if (type == RangeScaling)
	   {	
	      /* min/max already converted to scalar/offset */
	      scalar = ((end_color-start_color+1)/2.0)*s_scalar;

	      if (debug != NULL) {
		 float min=data[0], max=data[0];
		 for(i=1;i<nwords;i++) {
		    if (data[i] < min) min=data[i];
		    else if (data[i] > max) max=data[i];
		 }
		 fprintf(debug, "RangeScaling:\n\t\tuser offset=%d, new offset=%g\n", 
			 s_offset, offset);
		 fprintf(debug, "\t\tuser scalar=%g, new scalar=%g\n", 
			 s_scalar, scalar);
		 fprintf(debug, "\t\tmin=%g max=%g\n", min, max);
	      }
	   } else if (type == HistogramScaling) {
	      dummy_hist1 = (float *)malloc(nwords*sizeof(float));
	      dummy_hist2 = (float *)malloc(nwords*sizeof(float));

	      D_vmov(data, &one, dummy_hist1, &one, &nwords);
	      D_psort(dummy_hist1, &dummy_scalar, dummy_hist2, &nwords, &zero);

	      hist_tmp = (int)(s_scalar*nwords-.5);
	      if (hist_tmp >= nwords) hist_tmp = nwords-1;
	      if (hist_tmp < 0) hist_tmp = 0;
	      max_amp = dummy_hist2[hist_tmp];
	      
	      hist_tmp = (int)((1-s_scalar)*nwords-.5);
	      if (hist_tmp >= nwords) hist_tmp = nwords-1;
	      if (hist_tmp < 0) hist_tmp = 0;
	      min_amp = dummy_hist2[hist_tmp];

	      if (min_amp == max_amp) {
		 scalar = (end_color-start_color+1)/2.0;
	      } else if (max_amp*min_amp >= 0) {
	 	 scalar  = ((end_color-start_color+1)/(max_amp-min_amp))*s_scalar; 
		 offset  = start_color - scalar*min_amp;
		 s_offset= -50.0*(min_amp+max_amp)/(max_amp-min_amp);
	      } else {
		 D_vabs(data, &one, dummy_hist1, &one, &nwords);
		 D_psort(dummy_hist1, &dummy_scalar, dummy_hist2, &nwords, &zero);

		 hist_tmp = (int)(s_scalar*nwords-.5);
		 if (hist_tmp >= nwords) hist_tmp = nwords-1;
		 if (hist_tmp < 0) hist_tmp = 0;
		 scalar = ((end_color-start_color+1)/2.0)/dummy_hist2[hist_tmp];
	      }
	      free(dummy_hist1);
	      free(dummy_hist2);

	      if (debug != NULL) {
		 fprintf(debug, "HistScaling:\n\t\tuser offset=%d, new offset=%g\n", 
			 s_offset, offset);
		 fprintf(debug, "\t\tuser scalar=%g, new scalar=%g\n", 
			 s_scalar, scalar);
		 fprintf(debug, "\t\tmin=%g max=%g\n", min_amp, max_amp);
	      }
	      s_scalar = scalar/100.0;
	   } else if (type == MinMaxScaling) {
	      D_minv(data, &one, &min_amp, &loc, &nwords);
	      D_maxv(data, &one, &max_amp, &loc, &nwords);

	      if (min_amp == max_amp) {
		 scalar  = 1.0;
	      } else {
	 	 scalar  = ((end_color-start_color+1)/(max_amp-min_amp))*s_scalar; 
		 offset  = (end_color+start_color+1)/2 - scalar*(min_amp+max_amp)/2;
		 s_offset= 50.0/(end_color-start_color+1)
		   -50.0*s_scalar*(min_amp+max_amp)/(max_amp-min_amp);
	      }

	      if (debug != NULL) {
		 fprintf(debug, "MinMaxScaling:\n\t\tuser offset=%d, new offset=%g\n", 
			 s_offset, offset);
		 fprintf(debug, "\t\tuser scalar=%g, new scalar=%g\n", 
			 s_scalar, scalar);
		 fprintf(debug, "\t\tmin=%g max=%g\n", min_amp, max_amp);
	      }
	      s_scalar = scalar/100.0;
	   }
	}

	if (type != VelocityScaling) {
	   raster = (unsigned char*)malloc(nwords*sizeof(char));
	} else {
	   raster = (unsigned char*)malloc(2*nwords*sizeof(char));
	}

	if (raster == NULL) {
	   if (scale) free(scale);
	   free(trace);
	   free(data);
	   if (traceH) free(traceH);
	   fprintf(stderr, 
	   	"Cannot allocate %d bytes of storage for raster.\n", 
		(int)(2*nwords*sizeof(char)));
	   printf("-15\n");
	   return -15;
	}

	/* 	mult data by scalar, add offset,	*/
	/*	clip to min & max and integerize 	*/

	if (type != VelocityScaling) {
	   ndata = nwords;
	   clip_min = start_color;
	   clip_max = end_color;
	   if (invert_flag) scalar = -scalar;
	   
	   D_vsocf8(data, &one, &scalar, &offset, &clip_min, &clip_max, 
		raster, &nwords); 
	} else {	/* 16-b Velocity scaling */
	   ndata = 2*nwords;
	   clip_min = 0; 
	   clip_max = 65536;
	   scalar = invert_flag ? -1.0 : 1.0; 
	   offset = 0;
	   s_offset = 0;
	   s_scalar = 1.0;
	   dummy_vel = (unsigned int *)malloc(nwords*sizeof(unsigned 
			int));
	   D_vsocfx(data, &one, &scalar, &offset, &clip_min, 
			&clip_max, dummy_vel, &one, &nwords, &one);
	   for (i=0;i<nwords;i++) {
              *(raster+2*i) = ((*(dummy_vel+i)>>8)&0xff);
              *(raster+(2*i)+1) = (*(dummy_vel+i)&0xff);
           }
	   free(dummy_vel);
  	}
	   
	if (debug != NULL) {
	   fprintf(debug, "\t\tclip_min=%f, clip_max=%f, nwords=%d\n",
		   clip_min, clip_max, nwords);
	}

	if (trace_flag==0) ntr=0;
        nhdr = ntr*256*nrec;

/*
   OK, I went ahead and added the hacked routines from the gnu gzip
   that Jerry Ehlers used in the BP version of ddsServer3.
   A more portable method might be to take advantage of the routines
   in the public zlib library of compression routines.
						- joe m. wade 1/15/00 
*/
	if (level > 0 && level <= 9) {
	  zip(&ndata, &raster, level);
	  }


	if (trace_flag==1) 
	{
/*
 this CRAY block has been changed since it was last used. We have no
 machine for testing at this point, though.
					- Joe M. Wade - Jan 15, 2000
*/
#ifdef CRAY
/*	   trash=(unsigned char*)malloc(ntr*128*nrec*sizeof(float)); RJM: bad Douggyism */
	   trash=(float*)malloc(ntr*128*nrec*sizeof(float));/* RJM: correct */
	   if (trash==NULL) 
	   {
	      fprintf(stderr,"Cannot allocate %d bytes for trash.\n",
	         ntr*128*nrec*sizeof(float));
	      printf("-1\n");
	      if (scale)  free(scale);
	      free(trace);
	      free(data);
	      if (traceH) free(traceH);
	      free(raster);
	      C_LBCLOS(unit);
	      return;
	   } 

	   /* Tranlates trace header back to ieee. */

	   tmp=1024;
	   for (n=0; n<ntr*256*nrec; n+=256)
/*		sicsth(traceH+(n/2), &tmp, trash+n, &tmp1); RJM: unsigned char*/
		sicsth(traceH+(n/2), &tmp,
			trash+(n/sizeof(float)), &tmp1); /* RJM: proper fix */

	   if (level > 0 && level <= 9) {
	      zip(&nhdr, &traceH, level);
	      }

	   sprintf(buf, "%d %d %e %d %d", ndata, s_offset, s_scalar, nhdr, level);
	   write(1,buf,80);
	   write(1,raster,ndata); 
	   write(1,traceH,nhdr);
/*
	   write(1,trash,ntr*256*nrec);
*/
	   free(trash);
#else
#ifdef LINUXSYSTEM
	{
	int thbytes = 256;
	   for (debug1=0; debug1<ntr*256*nrec; debug1+=256) {
	      sisinth(((char *)traceH)+debug1,&thbytes,((char *)traceH)+debug1,&thbytes);
	      }
	}
#endif
	   if (level > 0 && level <= 9) {
	      zip(&nhdr, &traceH, level);
	      }

	   sprintf(buf, "%d %d %e %d %d", ndata, s_offset, s_scalar, nhdr, level);
	   write(1,buf,80);
	   write(1,raster,ndata); 
	   write(1,traceH,nhdr);
#endif
	}
	if (scale)  free(scale);
	free(trace);
	free(data);
	if (traceH) free(traceH);
	free(raster);
	C_LBCLOS(unit);
}


