/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	rtape.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	Reads a record from the specified unit, translating to CRAY format
	if necessary, and returning its length in bytes.  If the file is at
	EOF, no data will be read, and length will be set to 0.

	FORTRAN:

	CALL RTAPE( unit, buffer, length )

	unit	input	integer	Unit number to read from.
	buffer	output	array	Buffer to read data into.
	length	output	integer	Size of record read in bytes.

	C:

	rtape( unit, buffer, length );

	unit	input	int	Unit number to read from.
	buffer	output	array	Buffer to read data into.
	length	output	int *	Size of record read in bytes.


	$Header: /m/s1/dmk/xlate/sisio/RCS/rtape.c,v 4.3 91/09/11 08:48:30 dmk Exp $

	Moved tempbfr declaration to top-level and made it static to prevent
	stack overflow on the Convex.
		      94/08/25            zjmw36

	$Log:	rtape.c,v $
	Revision 4.3  91/09/11  08:48:30  dmk
	MODSET: 4.3
	Changed entry point names to macros.  Tests for CRAY, not sun.
	
	Revision 4.1  90/07/13  09:17:56  dmk
	MODSET: 4.1
	Added code for format L and V.  Changed calls to eliminate need for
	dmklib.  Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:54:42  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.2  88/07/20  08:55:50  dmk
	MODSET: 2.2
	Added CHECKDOIO.
	
	Revision 2.1  88/07/12  15:35:06  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.
	
	Revision 1.1  88/06/28  08:39:03  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include <stdio.h>
#include	"sisio.h"

#define	MODULE	"RTAPE"

static	char	tempbfr[ SMBUFSIZE ];

void	F_RTAPE( unit, buffer, length )

	int *	unit;
	char *	buffer;
	int *	length;

{
	C_RTAPE( *unit, buffer, length );
}


void	C_RTAPE( unit, buffer, length )

	int	unit;
	char *	buffer;
	int *	length;

{
	int	nrecs;
	int	reclen;
/*
	char	tempbfr[ SMBUFSIZE ];
*/
	LOGICAL	translate;
	int	c1 = 1;
	int	ieeefmtbyte = IEEEFMTBYTE, ieeefmtsize = IEEEFMTSIZE;

	/*
		Initialize package if necessary.  Check for outstanding
		error condition.  Check unit for range and to make sure 
		it's open.  Check to make sure we really want to do I/O.
	*/

	INITIALIZE;
	CHECKERROR(MODULE,unit);
	CHECKRANGE(MODULE,unit);
	CHECKOPEN(MODULE,unit);
	CHECKDOIO(MODULE,unit);

	/*
		Determine whether to translate the record.
	*/

	translate =	( _sisfit[ unit ].trwhen == W_ALWAYS ||
			( _sisfit[ unit ].trwhen == W_IFDISK &&
			_sisfit[ unit ].isdisk ) );

	/*
		If we don't need to translate the record, just read it into
		the output buffer and return.
	*/

	if ( ! translate )
	{
		reclen = _readit( unit, buffer, SMBUFSIZE );

		if ( reclen < 0 )
		{
			_error( MODULE, unit, -reclen );
			return;
		}

		*length = reclen;
		return;
	}

	/*
		Otherwise, fall through to here, read the record into a
		temporary buffer and translate it.
	*/

	reclen = _readit( unit, tempbfr, _sisfit[ unit ].bufsize );

	if ( reclen < 0 )
	{
		_error( MODULE, unit, -reclen );
		return;
	}

	if ( reclen == 0 )
	{
		*length = 0;
		return;
	}

	if ( _sisfit[ unit ].pointer - 1 == _sisfit[ unit ].headerat )

	{
		/*
			Translate a line header.
			First, figure out the format, if we don't know.
		*/

		if ( _sisfit[ unit ].format == 0 )
		{
#ifdef	CRAY
		USICTC( tempbfr, &ieeefmtbyte, & ( _sisfit[ unit ].format ),
				&c1, &ieeefmtsize );
#else
			_error( MODULE, unit, E_INTERNAL );
			exit( E_SISIO + E_INTERNAL );
#endif
		if ( _sisfit[ unit ].format == 0 || _sisfit[ unit ].format > 5 )
				_sisfit[ unit ].format = 'L';
		}

		switch ( _sisfit[ unit ].format )
		{
			case 0:
				_error( MODULE, unit, E_NOFMT );
				return;

			case 1:
			case 3:
#ifdef	IEEE
				sisclh( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siiclh( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 5:
#ifdef	IEEE
				sisclh5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siiclh5( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 'L':
#ifdef	IEEE
				vascah( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vaicah( tempbfr, &reclen, buffer, length );
#endif
	( void ) memcpy( ( char * ) & nrecs, buffer + CRAYNRECBYTE - 1,
					CRAYNRECSIZE );
				_sisfit[ unit ].headerat += nrecs + 1;
				break;

			case 'V':
#ifdef	IEEE
				vfts2c( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vfti2c( tempbfr, &reclen, buffer, length );
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}

	else if ( _sisfit[ unit ].dotraces )

	{
		/*
			Translate a trace header and samples.
		*/

		switch( _sisfit[ unit ].format )
		{
			case 0:
				_error( MODULE, unit, E_NOFMT );
				return;

			case 1:
#ifdef	IEEE
				sisct1( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siict1( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 3:
#ifdef	IEEE
				sisct3( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siict3( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 5:
#ifdef	IEEE
				sisct5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siict5( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 'L':
#ifdef	IEEE
				vasccr( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vaiccr( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 'V':
#ifdef	IEEE
				vfts2c( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vfti2c( tempbfr, &reclen, buffer, length );
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}

	else

	{
		/*
			Translate a trace header only.
		*/

		switch( _sisfit[ unit ].format )
		{
			case 0:
				_error( MODULE, unit, E_NOFMT );
				return;

			case 1:
			case 3:
#ifdef	IEEE
				siscth( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siicth( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 5:
#ifdef	IEEE
				sisct5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siict5( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 'L':
#ifdef	IEEE
				vasccv( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vaiccv( tempbfr, &reclen, buffer, length );
#endif
				break;

			case 'V':
#ifdef	IEEE
				vfts2c( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vfti2c( tempbfr, &reclen, buffer, length );
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}
}
