/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	siswhen.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISWHEN specifies when to translate data on the specified unit.

	FORTRAN:

	CALL SISWHEN( unit, fswitch )

	unit	input	integer	Unit number.
	fswitch	input	charact	Set to 'never', 'always' or 'ifdisk'.

	C:

	siswhen( unit, cswitch );

	unit	input	int	Unit number.
	cswitch	input	char *	Set to 'never', 'always' or 'ifdisk'.


	$Header: /m/s1/dmk/xlate/sisio/RCS/siswhen.c,v 4.3 91/09/11 09:02:00 dmk Exp $

	$Log:	siswhen.c,v $
	Revision 4.3  91/09/11  09:02:00  dmk
	MODSET: 4.3
	Changed entry point names to macros.   Tests for NEVER_TRANSLATE.
	
	Revision 4.1  90/07/13  09:28:50  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:59:15  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.3  88/08/16  12:41:20  dmk
	MODSET: 2.3
	Added the fswlen parameter to fix a bug in the SUN version.
	
	Revision 2.1  88/07/12  15:31:16  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.  Added SUN clause:  never changes
	trwhen from W_NEVER.  Sets cwlen to WORDSIZE rather than 8.  Now uses
	CHECKRANGE.
	
	Revision 1.1  88/06/27  12:42:49  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#ifdef	CRAY
#include	<fortran.h>
#endif

#include	"sisio.h"
#include	<stdio.h>

#define	MODULE	"SISWHEN"

#define STRLEN	128


#ifdef	CRAY
void	F_SISWHEN( unit, fswitch )

	int *	unit;
	_fcd	fswitch;
#endif
#ifdef	STRLEN_IS_ARG
void	F_SISWHEN( unit, fswitch, fswlen )

	int *	unit;
	char *	fswitch;
	int	fswlen;
#endif

{
	char	cswitch[ STRLEN ];

	/*
		Check and translate switch.
	*/

#ifdef	CRAY
	if ( _strf2c( fswitch, cswitch, STRLEN ) < 0 )
#endif
#ifdef	STRLEN_IS_ARG
	if ( _strf2c( fswitch, fswlen, cswitch, STRLEN ) < 0 )
#endif
	{
		_error( MODULE, *unit, E_BADSWITCH );
		return;
	}

	/*
		Call C version.
	*/

	C_SISWHEN( *unit, cswitch );
}


void	C_SISWHEN( unit, cswitch )

	int	unit;
	char *	cswitch;

{
	/*
		Initialize if necessary and check unit for range and
		outstanding error.
	*/

	INITIALIZE;
	CHECKRANGE( MODULE, unit );
	CHECKERROR( MODULE, unit );

	/*
		Set trwhen field.
	*/

	_strlower( cswitch );

	if ( ! strcmp( cswitch, "never" ) )
	{
		_sisfit[ unit ].trwhen = W_NEVER;
		_sisfit[ unit ].cwlen = WORDSIZE;
	}
	else if ( ! strcmp( cswitch, "always" ) )
	{
#ifdef	NEVER_TRANSLATE
		/* do nothing */ ;
#else
		_sisfit[ unit ].trwhen = W_ALWAYS;
		_sisfit[ unit ].cwlen = 4;
#endif
	}
	else if ( ! strcmp( cswitch, "ifdisk" ) )
	{
#ifdef	NEVER_TRANSLATE
		/* do nothing */ ;
#else
		_sisfit[ unit ].trwhen = W_IFDISK;
		if ( _sisfit[ unit ].isdisk )
			_sisfit[ unit ].cwlen = 4;
		else
			_sisfit[ unit ].cwlen = WORDSIZE;
#endif
	}
	else
	{
		_error( MODULE, unit, E_BADSWITCH );
		return;
	}
}
