/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef LOCALSYS_H	/*  if LOCALSYS_H is undefined, define it */

#define LOCALSYS_H

#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN 1234
#endif

#ifndef BIG_ENDIAN
#define BIG_ENDIAN    4321
#endif

#ifndef PDP_ENDIAN
#define PDP_ENDIAN    3412
#endif

#ifdef __hpux		/* hp's cpp guarantees 'hpux' will be defined */

#define HAVEASYSTEM
#define	HPUXSYSTEM
#define	X11versionR4
#define HAVE_LIMITS_H 1
#define HAVE_SYS_IOCTL_H 1
#define ASSUMED_SIZE_CHARACTER_POINTEE 1
#define REMSH_DEFINED
#ifdef __ia64
#ifndef BYTE_ORDER
#define BYTE_ORDER LITTLE_ENDIAN
#endif
#define FTN_TO_C_UNDERSCORE_SUFFIX
#else
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif
#define FTN_TO_C_NAME_COMPATIBILITY
#endif

#endif

#ifdef sun 		/* sun's cpp guarantees 'sun' will be defined */

#define HAVEASYSTEM
#define	SUNSYSTEM
#define	X11versionR4
#define RSH_DEFINED
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif
#ifdef SOLARIS
#define HAVE_LIMITS_H 1
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#define HAVE_GETLOADAVG 1
#else
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define LPR_PRINT_CMD
#endif

#endif

#ifdef __sun 	/* ..unless -Xc was used, wherein __sun is defined instead */

#define HAVEASYSTEM
#define	SUNSYSTEM
#define	X11versionR4
#define RSH_DEFINED
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif
#ifdef SOLARIS
#define HAVE_LIMITS_H 1
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#else
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define LPR_PRINT_CMD
#endif

#endif

#ifdef _AIX  /* ibm's cpp guarantees '_AIX' will be defined - was _IBMR2*/

#define HAVEASYSTEM
#define AIXSYSTEM
#define	X11versionR3
#define HAVE_LIMITS_H 1
#define REMSH_DEFINED	/* just taking a guess here.... */
#define FTN_TO_C_UNDERSCORE_SUFFIX
#define C_COMMENTS_DISALLOWED 1
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif

#endif

#ifdef _PPC64  /* defined in gmake.init compiler rules for PowerPC */

#define HAVEASYSTEM
#define PPCSYSTEM
#define	X11versionR6
#define HAVE_LIMITS_H 1
#define REMSH_DEFINED	/* just taking a guess here.... */
#define FTN_TO_C_NAME_COMPATIBILITY
#define C_COMMENTS_DISALLOWED 1
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif

#endif

#ifdef CRAY	/* cray's cpp guarantees 'CRAY' will be defined */

#define HAVEASYSTEM
#define CRAYSYSTEM
#define	X11versionR4
#define HAVE_LIMITS_H 1
#define HAVE_SYS_IOCTL_H 1
#define ASSUMED_SIZE_CHARACTER_POINTEE 1
#define COLUMN_6_CONTINUATION 1
#define C_COMMENTS_DISALLOWED 1
#define REMSH_DEFINED
#define FTN_TO_C_UPPERCASE
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif

#endif

#ifdef __convex__   /* convex's cpp guarantees '__convex__' will be defined */

#define HAVEASYSTEM
#define	CONVEXSYSTEM
#define	X11versionR4
#define HAVE_SYS_IOCTL_H 1
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#define C_COMMENTS_DISALLOWED 1
#define RSH_DEFINED
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif

#endif

#ifdef CM5

#define HAVEASYSTEM
#define	CM5SYSTEM
#define	X11versionR5
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#define RSH_DEFINED
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif

#endif

#ifdef __sgi

#define HAVEASYSTEM
#define	SGISYSTEM
#define	X11versionR5
#define HAVE_LIMITS_H 1
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#define COLUMN_6_CONTINUATION 1
#define RSH_DEFINED
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#endif

#endif

#ifdef __i686__

#define HAVEASYSTEM
#define LINUXSYSTEM
#define HAVE_LIMITS_H 1
#define HAVE_SYS_IOCTL_H 1
#define REMSH_DEFINED
#define COLUMN_6_CONTINUATION 1
#define HAVE_GETLOADAVG 1
/* #define FTN_TO_C_NAME_COMPATIBILITY - try using underscores for Sun compatibility */
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef BYTE_ORDER
#define BYTE_ORDER LITTLE_ENDIAN
#endif

#endif

#ifdef __alpha		/* NCP's cpp guarantees '__alpha' will be defined */

#define HAVEASYSTEM
#define	DECSYSTEM
#define HAVE_LIMITS_H 1
#define HAVE_SYS_IOCTL_H 1
#define ASSUMED_SIZE_CHARACTER_POINTEE 1
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef BYTE_ORDER
#define BYTE_ORDER LITTLE_ENDIAN
#endif

#endif

#ifdef __ppc__		/* Macintosh PowerPC running OS X */

#define HAVEASYSTEM
#define APPLESYSTEM
#define MACOSXSYSTEM
#define HAVE_LIMITS_H 1
#define HAVE_SYS_IOCTL_H 1
#define REMSH_DEFINED
#define COLUMN_6_CONTINUATION 1
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef BYTE_ORDER
#define BYTE_ORDER BIG_ENDIAN
#define NO_VALUES_HEADER 1
#define __SVR4 1
#endif
#endif

/*
 we have to check to see if we've already detected and HP ia64 system
*/
#ifndef HAVEASYSTEM
#ifdef __ia64__

#define HAVEASYSTEM

#define LINUXSYSTEM
#define IA64SYSTEM
#define HAVE_LIMITS_H 1
#define HAVE_SYS_IOCTL_H 1
#define REMSH_DEFINED
#define COLUMN_6_CONTINUATION 1
#define HAVE_GETLOADAVG 1
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifndef BYTE_ORDER
#define BYTE_ORDER LITTLE_ENDIAN
#endif

#endif
#endif


#ifndef HAVEASYSTEM	/* if nothing has been defined by now, kill compiler
				by entering garbage */
	kill <- the -> compiler  :: NO SYSTEM
#endif

#ifdef _PPC64 
#undef LITTLE_ENDIAN
#undef BIG_ENDIAN
#undef PDP_ENDIAN
#undef BYTE_ORDER
#endif

#endif
