/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	fortran-callable string-to-double conversion.
**
**	fortran access is:
**
**		integer u0stodpr
**		i = u0stodpr( string, dblvalue )
**
**	the converted value is stored in dblvalue, which MUST be
**	double precision.  the function's returned value is the
**	number of characters used in the conversion.
**
**	if string does not begin with a sensible value, dbvalue
**	will still receive a value (namely, 0).  this case can be
**	detected by inspecting the returned value to see if any
**	characters were used.
**
**	only 'e' and 'E' are recognized in exponential formats.
*/
/*
	changed long declarations to int; these are NOT the same!
						- joe m. wade 4/26/95
*/
/*
	changed second entry point type of dval to double. Don't know
        why it was a float.
						- joe m. wade 5/26/95
*/
/*
	reject numbers if the whole string was not used by strtod
						- joe m. wade 5/26/95
*/
#include <stdio.h>
#include <localsys.h>
#include <fu_defs.h>
#define MAX_S_LEN	128

#ifndef CRAYSYSTEM
int F_U0STODPR( s, dval, sl )
char *s;
int sl;
double *dval;
{
	double strtod();
#else
#include <fortran.h>
int U0STODPR( fs, dval )
_fcd fs;
double *dval;
{
	double strtod();
#endif
	char t[ MAX_S_LEN ];
	char *p;
	int rl, i, skipped;

#ifdef CRAYSYSTEM
	char *s, *u0f2cstr();
	int sl;
	s = u0f2cstr( fs );
	sl = strlen( s );
#endif
/*
**	advance s and sl over leading blanks.  remember that sl is
**	the number of characters in s.
*/
	skipped = 0L;
	while( ( sl > 0L ) && ( *s == ' ' ) ) {
		--sl;
		++s;
		++skipped;
	}
/*
**	now strip trailing blanks.  rl is the index of the last
**	interesting character, or -1.
*/
	rl = sl - 1;
	while( ( rl >= 0 ) && ( s[ rl ] == ' ' ) )
		--rl;
	if( rl > MAX_S_LEN ) {
		*dval = 0.0;
		return 0;
	}
/*
**	copy the "real" fortran string into a temporary array and
**	add a trailing null.
*/
	for( i = 0; i <= rl; i++ )
		t[ i ] = s[ i ];
	t[ i ] = '\0';

	*dval = strtod( t, &p );

/*
**	if p != t[i], then the whole argument was not a number.
**	bail out as if no number was found.
**					- added - 5/26/95 - jmw
*/
	if( p != t+i )	return 0L;

	if( p == t )	return 0L;
	return ( p - t ) + skipped;
#ifdef CRAYSYSTEM
	free( s );
#endif
}
