C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fairway (iunit,nsamp,si,velhi,vello,velav,
     1                    tmp1, tmp2, gamma)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real      velhi(*), vello(*), velav (*)
      real      tmp1(*), tmp2(*)
      real      velp (SZLNHD,2), telp (SZLNHD,2)
      integer   nvpik (2)
      character junk * 80, keywrd * 6, tmp * 10
      character tag1 * 5, tag2 * 6, tag3 * 5
      logical   xsd, xsdn, flat, gamma

c----c
c  If input semblances are gamma records from 3D pre-stack migration
c  then we don't need a velocity fairway
c----c
      IF (gamma) THEN

         do  i = 1, nsamp
             vello (i) = 0.
             velhi (i) = 9999999.
         enddo
         return
      ENDIF

      write(LERR,*)' '
      write(LERR,*)'Fairway pick read messages:',iunit
      write(LERR,*)' '

      rewind iunit
 
      read (iunit, '(a80)') junk
 
      rewind iunit
 
      if (junk(1:1) .eq. 'U') then
         xsd  = .true.
         xsdn = .false.
         flat = .false.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is xsd pick format'
         write(LERR,*)'File is xsd pick format'
         write(LER,*)' '
         write(LERR,*)' '
         call fsscnf (junk,
     1        '%s %f %f %f %f %f %f %s %f %f %f %s %f %f'//char(0),
     2        tag1,d1,d2,sp,d3,d4,d5,tag2,d6,d7,d8,tag3,val,d)
         nseg = val
      elseif (junk(1:1) .eq. 'N') then
         xsd  = .false.
         xsdn = .true.
         flat = .false.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is extended xsd pick format'
         write(LERR,*)'File is extended xsd pick format'
         write(LER,*)' '
         write(LERR,*)' '
         do  i = 1, 11
             read(iunit,'(a80)',end=999,err=666)junk
             if (junk(1:7) .eq. 'UnitSmp') then
                 call fsscnf (junk, '%s %f'//char(0), tmp, dt)
             elseif (junk(1:6) .eq. 'No_Seg') then
                 call fsscnf (junk, '%s %f'//char(0), tmp, val)
                 nseg = val
             endif
         enddo
         write(LERR,*)junk
         nseg = val
      else
         xsd  = .false.
         xsdn = .false.
         flat = .true.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is simple 2-col format (rec time)'
         write(LERR,*)'File is simple 2-col format (rec time)'
         write(LER,*)' '
         write(LERR,*)' '
         stop
      endif

      if (nseg .ne. 2) then
         write(LERR,*)'FATAL error in fairway pick read:'
         write(LERR,*)'Number of segments must = 2'
         stop
      endif

      rewind iunit

      IF (flat) then
 
         do  j = 1, nf
             read (iunit, '(a80)') junk
             call fsscnf (junk,'%f %f %f'//char(0), xli, ydi, timj)
         enddo
11       continue
 
      ELSEIF (xsd) THEN
 
         do while (1.eq.1)
            read(iunit,'(a80)',end=999,err=666)junk
            read(junk,'(a1)')keywrd
            if(keywrd(1:1).eq.'S')then
               go to 20
            endif
         enddo
 
20       continue
 
         i = 0
         j = 1
         do while (1.eq.1)
            read(iunit,'(a80)',end=21,err=666)junk
            read(junk,'(a1)')keywrd
            if(keywrd(1:1).ne.'S')then
               i = i + 1
               call fsscnf (junk,'%f %f %f'//char(0),
     1			rr, velp(i,j), telp(i,j))
               nvpik (j) = i
            else
               i = 0
               j = j + 1
            endif
         enddo
21       continue
 
      ELSEIF (xsdn) THEN
 
         i = 0
         j = 0
         do  while (1.eq.1)
             read(iunit,'(a80)',end=33,err=666)junk
             if (junk(1:7) .eq. 'Segment') then
                 j = j + 1
                 i = 0
             elseif (junk(1:5) .eq. 'Pick ')   then
                 i = i + 1
                 nvpik (j) = i
             elseif (junk(1:6) .eq. 'Sample') then
                 call fsscnf (junk,'%s %f'//char(0),tmp,val)
                 telp (i,j) = (val-1.0) * dt
             elseif (junk(1:6) .eq. 'DstSgn') then
                 call fsscnf (junk,'%s %f'//char(0),tmp,val)
                 velp (i,j) = val
             endif
         enddo
33       continue

      ENDIF

      telp (1,1) = 0.0
      telp (1,2) = 0.0
      telp (nvpik(1),1) = (nsamp - 1) * si
      telp (nvpik(2),2) = (nsamp - 1) * si

      write(LERR,*)' '
      write(LERR,*)'Fairway segment 1:'
      do  i = 1, nvpik(1)
          write(LERR,*)'T= ',telp(i,1),'  V= ',velp(i,1)
      enddo
      write(LERR,*)' '
      write(LERR,*)'Fairway segment 2:'
      do  i = 1, nvpik(2)
          write(LERR,*)'T= ',telp(i,2),'  V= ',velp(i,2)
      enddo
      write(LERR,*)' '

      call vel (telp(1,1), velp(1,1), nsamp, si, nvpik(1), tmp1)
      call vel (telp(1,2), velp(1,2), nsamp, si, nvpik(2), tmp2)

      if (tmp1(1) .gt. tmp2(1)) then
         call vmov (tmp1, 1, velhi, 1, nsamp)
         call vmov (tmp2, 1, vello, 1, nsamp)
      elseif (tmp1(1) .lt. tmp2(1)) then
         call vmov (tmp1, 1, vello, 1, nsamp)
         call vmov (tmp2, 1, velhi, 1, nsamp)
      endif
 
      do  i = 2, nsamp
          if (velhi(i) .le. vello(i)) then
             write(LERR,*)'Fairway velocity functions cross -- FATAL'
             stop
          endif
      enddo
      do  i = 1, nsamp
          velav (i) = .5 * (vello(i) + velhi(i))
      enddo
      write(LERR,*)' '
c     if (verbos) then
         write(LERR,*)'Low Velocity Fairway (every 10 samps)'
         write(LERR,*)(vello(ii),ii=1,nsamp,10)
         write(LERR,*)'High Velocity Fairway (every 10 samps)'
         write(LERR,*)(velhi(ii),ii=1,nsamp,10)
         write(LERR,*)' '
c     endif

      return

666   continue
      write(LERR,*)'FATAL ERROR in reading pick file'
      write(LER ,*)'FATAL ERROR in reading pick file'
      stop 666
999   continue
      write(LERR,*)'FATAL ERROR in pick file: premature end of file'
      write(LER ,*)'FATAL ERROR in pick file: premature end of file'
      stop 666

      end
