C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---
c  this routine reads in the horizons picked from the stacked volume
c  and checks them.
c  each horizon (which extends areally in LI & DI index) is keyed to
c  a pick color number (in xsd) so the goal is to identify the distinct
c  color numbers first
c---
      subroutine horint (iunit,nf,maxcol,dcolor,ncolor,SZSMPD,
     1                   lmrk,nstk)

#include <f77/iounit.h>

      integer    dcolor (*), iunit
      integer    curcol, lstcol, color, key, SZSMPD
      pointer    (wkcolor, color(1))
      pointer    (wkkey  , key  (1))
      character  junk * 80, tmp * 10, tag * 1
      logical    xsd, flat, xsdn, lmrk

      if (lmrk) then

         ncolor = nstk
         return
      endif

      write(LERR,*)' '
      write(LERR,*)'Horizon initialization messages:',iunit
      write(LERR,*)' '
      
      rewind iunit
 
      read (iunit, '(a1)',end=999,err=666) tag
 
      rewind iunit
 
      if (tag .eq. 'U') then
         xsd  = .true.
         xsdn = .false.
         flat = .false.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is xsd pick format: must be header format'
         write(LERR,*)'File is xsd pick format: must be header format'
         write(LER,*)' '
         write(LERR,*)' '
         stop
      elseif (tag .eq. 'N') then
         xsd  = .false.
         xsdn = .true.
         flat = .false.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is extended xsd pick format'
         write(LERR,*)'File is extended xsd pick format'
         write(LER,*)' '
         write(LERR,*)' '
         do  i = 1, 11
             read(iunit,'(a80)',end=999,err=666)junk
             if (junk(1:7) .eq. 'UnitSmp') then
                 call fsscnf (junk, '%s %f'//char(0), tmp, dt)
             elseif (junk(1:6) .eq. 'No_Seg') then
                 call fsscnf (junk, '%s %f'//char(0), tmp, val)
                 nseg = val
             endif
         enddo
         write(LERR,*)junk
         nseg = val
      else
         xsd  = .false.
         xsdn = .false.
         flat = .true.
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'File is simple 2-col format (rec time)'
         write(LERR,*)'File is simple 2-col format (rec time)'
         write(LER,*)'Must be xsd header pick format'
         write(LERR,*)'Must be xsd header pick format'
         write(LER,*)' '
         write(LERR,*)' '
         stop
      endif
 
      rewind iunit

c----
c   find # pick segments in stack pick file
c----
      ncolor = 0
      nf     = 0
      do while (1 .eq. 1)
         read (iunit, '(a80)', end = 11, err=666) junk
         if (junk(1:5) .eq. 'Pick ') nf = nf + 1
         if (junk(1:5) .eq. 'Color') ncolor = ncolor + 1
      enddo
11    continue

      if (nf .le. 1) then
         write(LERR,*)'FATAL error in horvel3d:'
         write(LERR,*)'Less than 2 picks in horizon pick file'
         go to 999
      endif
      nseg = ncolor

      if (ncolor .eq. 0) then
         write(LERR,*)'FATAL error in horizon pick file:'
         write(LERR,*)'no areal horizon keyed on a pick color found'
         stop 666
      endif
 
      item = ncolor * SZSMPD
      call galloc (wkcolor, item, ierr, iab)
      if (ierr .ne. 0) then
         write(LERR,*)'Unable to allocate color vector memory'
         stop
      endif
      call galloc (wkkey, item, ierr, iab)
      if (ierr .ne. 0) then
         write(LERR,*)'Unable to allocate key vector memory'
         stop
      endif

c----
c   figure out distinct # segments & max # picks in any seg
c----
      rewind iunit
      i = 0
      do while (1 .eq. 1)
         read (iunit, '(a80)', end = 21, err=666) junk
         if (junk(1:5) .eq. 'Color') then
             i = i + 1
             call fsscnf (junk,'%s %f'//char(0),tmp,val)
             color (i) = val
         endif
      enddo
21    continue
      nc = i

c----
c   order color numbers from min to max. find out distinct color numbers.
c   we will find the max number of picks in any color
c----
      write(LERR,*)'Color numbers:'
      write(LERR,*)(color(ii),ii=1,nc)
      write(LERR,*)' '

      call sort (color, key, nc)

      write(LERR,*)'Sorted Color numbers:'
      write(LERR,*)(color(ii),ii=1,nc)
      write(LERR,*)' '

      lstcol = color (1)
      maxcol = 0
      icol   = 1
      ni     = 1
      dcolor (1) = color (1)

      do  i = 2, nc
          curcol = color (i)
          if (curcol .ne. lstcol) then
              if (icol .ge. maxcol) maxcol = icol
              ni = ni + 1
              dcolor (ni) = curcol
              icol = 1
              lstcol = curcol
          else
              icol = icol + 1
          endif
      enddo
      write(LERR,*)'Unique Color numbers:'
      write(LERR,*)(dcolor(ii),ii=1,ni)
      write(LERR,*)'Max picks in any color= ',maxcol
      call gfree  (wkcolor)
      call gfree  (wkkey)
      ncolor = ni
      return

666   continue
      write(LERR,*)'FATAL ERROR in reading pick file'
      write(LER ,*)'FATAL ERROR in reading pick file'
      stop 666
999   continue
      write(LERR,*)'FATAL ERROR in pick file: premature end of file'
      write(LER ,*)'FATAL ERROR in pick file: premature end of file'
      stop 666


      end
