C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine lanmrk (lupik, times, IX1, IY1,
     1                   XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, NDI, NLI, minli, maxli,
     3                   mindi, maxdi, xyscl, verbos)

#include <f77/iounit.h>

      real        times (ndi, nli)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     minli, maxli, mindi, maxdi, li, di
      character   card * 80
      logical     verbos

      do  j = 1, nli
          do  i = 1, ndi
              times (i,j) = 0.
          enddo
      enddo

      rewind lupik
C**********************************************************************C
C     read input workstation pick file
C**********************************************************************C
      il = 0
      nl = 0
      DO while (1.eq.1)
 
         read (lupik, '(a80)', end=10, err=666) card
 
         go to 12
10       continue
 
         if (il .eq. 0) then
           write(LERR,*)' '
           write(LERR,*)'ERROR in tim2hed3d:'
           write(LERR,*)'Hit end of file without reading any picks'
           write(LERR,*)'within survey coordinates'
           write(LER ,*)' '
           write(LER ,*)'ERROR in tim2hed3d:'
           write(LER ,*)'Hit end of file without reading any picks'
           write(LER ,*)'within survey coordinates'
           stop 666
         else
           write(LERR,*)' '
           write(LERR,*)'Return from LandMark file reader:'
           write(LERR,*)'Found ',il,' picks within survey coordinates'
           go to 999
         endif

12       continue
 
         nl = nl + 1

         call fsscnf (card,'%f %f %f %f %f'//char(0),
     1                aline,xline,CX,CY,time)
 
            CX = xyscl * CX
            CY = xyscl * CY
            IWRN = 0
            CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                   IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, NDI, NLI)
 
            IF (LI .LT. MINLI) IWRN = 1
            IF (LI .GT. MAXLI) IWRN = 1
            IF (DI .LT. MINDI) IWRN = 1
            IF (DI .GT. MAXDI) IWRN = 1
 
            IF (IWRN .eq. 0) THEN

               il = il + 1
               jj = li - minli + 1
               ii = di - mindi + 1
               times (ii, jj) = nint ( time )

            ENDIF
 
      ENDDO

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in tim2hed3d:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nl,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in tim2hed3d:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nl,' line was:',card
 
999   continue

      return
      end
