C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine lanmrk (lupik, times, IX1, IY1,
     1                   XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, NDI, NLI, minli, maxli,
     3                   mindi, maxdi, xyscl, verbos, nhor, name)

#include <f77/iounit.h>

      real        times (ndi, nli, nhor)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      real        DX, DY
      integer     minli, maxli, mindi, maxdi, li, di
      integer     nli, ndi, IX1, IY1
      character   card * 80, name*(*)
      logical     verbos

      DO  K = 1, nhor
          do  j = 1, nli
              do  i = 1, ndi
                  times (i,j,k) = 0.
              enddo
          enddo
      ENDDO

      rewind lupik

C**********************************************************************C
C     read input workstation pick file
C**********************************************************************C
      DO  IH = 1, nhor

      il = 0
      nl = 0
      DO while (1.eq.1)
 
         read (lupik, '(a80)', end=10, err=666) card
         nent = lenth (card)
         if (nent .eq. 0) then
             go to 10
         endif
 
         go to 12
10       continue
 
         if (il .eq. 0) then
           write(LERR,*)' '
           write(LERR,*)'ERROR in ',name
           write(LERR,*)'Hit end of horizon ',IH,' without reading any'
           write(LERR,*)'picks within survey coordinates'
           write(LER ,*)' '
           write(LER ,*)'ERROR in ',name
           write(LER ,*)'Hit end of horizon ',IH,' without reading any'
           write(LER ,*)'picks within survey coordinates'
           call ccexit (666)
         else
           if (IH .eq. nhor) then
             write(LERR,*)' '
             write(LERR,*)'Return from LandMark file reader:'
             write(LERR,*)'Read ',IH,' horizons and found ',il,' picks'
             write(LERR,*)'within survey coordinates'
             go to 999
           else
             write(LERR,*)' '
             write(LERR,*)'Read horizon ',IH,' with ',il,' picks'
             go to 15
           endif
         endif

12       continue
 
         nl = nl + 1

         call fsscnf (card,'%f %f %f %f %f'//char(0),
     1                aline,xline,CX,CY,time)
 
            IWRN = 0

            CX = xyscl * CX
            CY = xyscl * CY
            CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                   IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT,YYT,
     2                   DX, DY, NDI, NLI)
 
            IF (LI .LT. MINLI) IWRN = 1
            IF (LI .GT. MAXLI) IWRN = 1
            IF (DI .LT. MINDI) IWRN = 1
            IF (DI .GT. MAXDI) IWRN = 1
 
            IF (IWRN .eq. 0) THEN

               il = il + 1
               jj = li - minli + 1
               ii = di - mindi + 1
               times (ii, jj, ih) = nint ( time )

            ENDIF
 
      ENDDO

15    continue

      ENDDO

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR in ',name
      write(LERR,*)'Something bad happened while reading input horz'
      write(LERR,*)'file for function number ',il,' line was:',card
      write(LERR,*)'horizon number for read attempt was ',IH
      write(LER ,*)' '
      write(LER ,*)'FATAL ERROR in ',name
      write(LER ,*)'Something bad happened while reading input horz'
      write(LER ,*)'file for function number ',il,' line was:',card
      write(LER ,*)'horizon number for read attempt was ',IH
      call ccexit (666)
 
999   continue

      return
      end
