C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c     CHANGES:
c
c     Jun 4, 2004 --> made it possible to do a mode 3 sort and then ask for 
c                     mode 5 output.  In this case you get the shot sorted 
c                     data with the shot X,Y in the usual place AND the
c                     shot bin X,Y center in CDPBCX, CDPBCY.  Without this 
c                     capability you only ever got the centroid or nothing.
c     Garossino
c
c     Aug 99 --> fixed bug in bin center coordinate algorithm that resulted in 
c                no CDPBCY or DstSgn in certain cases.  This happened when the
c                YY1 variable went negative.  I have added a dabs() condition to
c                account for this.  YY1 goes negative when your grid is close to
c                NS-EW and the Inline direction is from large to small Y values.
c     Garossino
c
c     Nov 98 --> fixed bug in flexbinning algorithm that put out CDPBCX,Y
c                data in error when no flexing was required for that bin
c     Garossino
c
c     June 98 --> added radius[] limitation on flexbinning, corrected CDPBCX,Y
c                 calculation, added Guto restart implimentation
c     Garossino
c
c       August 1997 --> added flexbinning and other fixups....Garossino
c
c       Man, I have changed so much of this code I don't know where to 
c       start.  
c I have put in flexbinning
c I have put flexbinning in offset sort option
c I have cleaned up and added lots of stderr output to both
c   the printout file and the screen
c I have removed several unused variables that were cluttering up
c   the logic of the routine
c I added a cmdln and verbal subroutine set to clean up the main
c I added several VVerbose outputs useful in seeing exactly what is 
c   being binned.
c I added logic to put the correct nrec and ntrc in the -go output lineheader
c I have changed the trdist array to deal in floating point, no integer assignment
c   is done without a nint()
c I now allow LI,DI limits on offset sorts.
c
c
c       I still have to add to the offset sort the capablility of getting
c       the offset closest to the offset desired and closest to the bin
c       center of the bin desired.  At the moment the first offset that 
c       fits the search criteria is used regardless of its position.  I 
c       can imagine using the distance search and min radial distance 
c       routines from flexbin to do this.
c
c       before doing any of this I need to thoroughly test what I have done
c       so far.
c
c     I also intend to add local cosine compression of the sr3d2 volume
c     at the next go around.  Conceptually this involves compressing by
c     bins and placing the compressed bins out in INLINE or XLINE order
c     and keeping a compression table that contains a pointer to the 
c     1st byte of each compressed bin.  This table can reside in the 
c     sr3d1 table in the same fashion as the current pointer table does.
c
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
c Here is some historical stuff from the old code.  I thought I would
c keep it around for posterity....would not want to do an injustice to
c Gary and Gary:
c
C     PROGRAM NAME: SR3D (3-D TRACE SORTING) - STEP 2 OF 2
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: GARY RUCKGABER & GARY DONATHAN
C
C     DATE WRITTEN: 02/??/77
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SORTS TRACES INTO COMMON MIDPOINT (CDP), COMMON
C               RECEIVER GROUP, OR COMMON SOURCE POINT ORDER OVER
C               A USER-DEFINED AREAL GRID.
C               STEP 1 DOES THE COORDINATE TRANSFORMATION AND OUTPUTS
C               THE FOLD DISTRIBUTION.
C               STEP 2 DOES THE ACTUAL TRACE SORTING.
C
C     PROGRAM RESTRICTIONS:
C          1- INPUT DATA SET FORMAT MUST BE 1 OR 3
C          2- MAXIMUM NUMBER OF SAMPLES PER TRACE IS 9000 (4500 FMT 3)
C          3- MAXIMUM FOLD IS 256
C
C     SUBROUTINES USED: SELF-CONTAINED
C
C     LOADERIZED ROUTINES USED:
C          CCEXIT     DACLOS     DAOPEN     DAREAD
C          DAWRTE     GAMOCO     HLH        LBCLOS
C          LBOPEN     MOVE       NACCT      NACCT2
C          RTAPE      WRTAPE
C
C     MODIFICATION HISTORY: 05/??/78 - M.MARTIN
C                           06/??/79 - G.RUCKGABER
C                           07/??/79 - G.RUCKGABER
C                           03/??/80 - G.RUCKGABER
C                           07/02/82 - G.SHIBA
C          INCREASE MAXIMUM NUMBER OF CELLS PER EXECUTION FROM 20000
C          TO 32000.
C                           07/19/82 - G.SHIBA
C          REMOVE "ONE RECORD PER LINE" RESTRICTION.
C                           10/06/82 - G.SHIBA
C          PLACE GRID CORNERS & CELL INCREMENTS IN PROCESS HISTORY (HLH)
C          IMPLIMENT 2-D CDP NUMBERING SCHEME (CURRENTLY COMMENTED OUT
C          UNTIL OTHER PROGRAMS CAN ACCEPT IT).
C          ALLOW USER SPECIFIED STARTING RECORD NUMBER, LINE NUMBER, &
C          DEPTH POINT NUMBER FOR THE GRID, & ASSOCIATED INCREMENTS.
C          ALLOW FORMAT 3 INPUT DATA SETS.
C          INCREASE NUMBER OF DISK UNITS TO 10.
C          WRITE TO DISK ONLY THE USABLE TRACES; NOT ALL LIVE TRACES.
C                           11/12/82 - G.SHIBA
C          IMPLEMENT 2-D CDP NUMBERING SCHEME (UNCOMMENT STATEMENTS).
C                           04/15/83 - G.SHIBA
C          WINDOWING CAPABILITY
C                           05/04/83 - G.SHIBA
C          PLACE MINIMUM & MAXIMUM LINE INDEX, MINIMUM & MAXIMUM DEPTH
C          INDEX, AND CELL INCREMENTS IN LINE HEADER.
C                           06/20/83 - D.BODDY
C          CHANGE X-COORDINATE & Y-COORDINATE LOCATIONS IN THE TRACE
C          HEADER.
C          PLACE COMMON MIDPOINT BIN CENTER IN TRACE HEADERS
C                           09/19/83 - G.SHIBA
C          ADD OPTION TO OUTPUT DATA SET IN "RT3D" (SERPENTINE)
C          FORMAT.
C                           11/22/83 - G.SHIBA
C          FIX "SIGN" ERROR IN CDP BIN CENTER COMPUTATION.
C                           05/28/85 - G.SHIBA
C          SPECIAL VERSION FOR JOEY HAMMOND, DENVER REGION
C          INCREASE MAXIMUM FOLD FROM 256 TO 512.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     DEFINE, DECLARE, & INITIALIZE VARIABLES
C
C-----------------------------------------------------------------------
      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer   itr0(SZLNHD)
      integer   nsamp, nrec, ntrc, nsi, iform, luin, luout, argis
      integer   lbytes, NBYTES, IBYTES, lbyout

      character ntap*256, otap*256, name*5

      logical verbos

c declare program dependant variables

      INTEGER   luout1(1000), npart(1000), nstart(1000), lstart(1000)
      INTEGER   DATA4(SZLNHD), LHEAD4(SZLNHD)
      INTEGER   DATA2(SZLNHD), LHEAD2(SZLNHD)
      INTEGER   LINE2D, DI2D, CDP2D
      INTEGER   DIINC, LIINC
      INTEGER   RI1, RIINCR, LINE1, LININC, DI1, DIINCR
      INTEGER   RI1_tab, RIINCR_tab, LINE1_tab, LININC_tab
      integer   DI1_tab, DIINCR_tab
      integer   IX, IY, LASTRI, ICELL, NX, NY, IFOLD, lentrc
      integer   MODE, IDUM, IWNDWS, IWNDWE, IRT3D, IDXWND, IMULT
      integer   IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4   
      integer   NBYTESO, NBYTR
      integer   NTR, NTROUT, NTRKS, NS
      integer   intbin, length, num_sr3d2_vols, irt3d0, irisav, jerr
      integer   mode0, ilog, nsampi, isli, isdi, ieli, iedi
      integer   noff, lu_sr3d1, lrec, lenth, i, ierr, irestart, ifoldi
      integer   newli, newdi, j, jnxny, ir, irr, idx, idy, ifor,isr
      integer   itfs, ifoldnx, ncdpl, nxout, nyout, nxny, ntrksi
      integer   icnt, ii, k, ndum, n23, n12, iwrn, itrc, irtrc, irrec
      integer   left, IX0, IY0, IPT, lui, ipti, inxny, ntr2d, iswap
      integer   icount, IYs, IYe, IYi, IPTS, IPTE, icx, icy
      integer   icndx, icndy, istrt, IXs, IXe, IXi, joff, ioff
      integer   ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
      integer   ifmt_DstUsg, l_DstUsg, ln_DstUsg, DstUsg
      integer   ifmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum
      integer   ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer   ifmt_DphInd, l_DphInd, ln_DphInd, DphInd
      integer   ifmt_LinInd, l_LinInd, ln_LinInd, LinInd
      integer   ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer   ifmt_FoldNm, l_FoldNm, ln_FoldNm, INDEX
      integer   ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC, SrPtXC
      integer   ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, SrPtYC
      integer   ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC, RcPtXC
      integer   ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC, RcPtYC
      integer   ifmt_SrRcMX, l_SrRcMX, ln_SrRcMX, SrRcMX
      integer   ifmt_SrRcMY, l_SrRcMY, ln_SrRcMY, SrRcMY
      integer   ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, CDPBCX
      integer   ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY, CDPBCY
      integer   ifmt_indexx, l_indexx, ln_indexx, indexx
      integer   ifmt_indexy, l_indexy, ln_indexy, indexy
      integer limit_ntrc, limit_nrec

      REAL*8    XX, XY, YX, YY
      REAL*8    XX1, XY1, YX1, YY1, E, F, DE, DF, XYYXXY

      REAL  TFS, YINCR, XINCR, tdist, dist, dstmin_tab, dstmax_tab
      real DX, DY, arec, CDPX, CDPY
      real dxt, dyt

      character dtap(1000)*256, ptap*256
      CHARACTER*120 SR3D
      CHARACTER*120 CORNR1
      CHARACTER*120 CORNR2
      CHARACTER*120 CORNR3
      CHARACTER*120 CORNR4
      CHARACTER*120 DELTAS

      LOGICAL   go, stp , oline, xline, off, nodead
      LOGICAL   found, stack, vverbos, limit, restart, newpass

c variables used with dynamic memory allocation

      INTEGER   KOUNT, JOUNT, IND, IFL, PARTS, gather
      integer itemi, itemk, itemu, items, errcd, abort
      integer itemt, itemd
 
      REAL      spread, TRDIST

      pointer   (wkkount ,  kount(100000))
      pointer   (wkjount ,  jount(100000))
      pointer   (wktrdist, trdist(1))
      pointer   (wkparts , parts (1))
      pointer   (wkind   ,  ind  (1))
      pointer   (wkifl   ,  ifl  (1))
      pointer   (wkgather, gather(1))
      pointer   (wkspread, spread(1))

      logical heap

c variables used in flexbinning

      integer num_flex_traces, flex_count

      real dstmin, dstmax, dstdel, radius

      logical flexbin, off_found

c dynamic memory flexbin variables

      integer flex_trdist, flex_pointer, flex_lui
      integer iteme

      real flex_dist_required, flex_hist, flex_radial_dist

      pointer   (ptr_flex_dist_required, flex_dist_required (1))
      pointer   (ptr_flex_hist, flex_hist (1))
      pointer   (ptr_flex_trdist, flex_trdist (1))
      pointer   (ptr_flex_pointer, flex_pointer (1))
      pointer   (ptr_flex_radial_dist, flex_radial_dist (1))
      pointer   (ptr_flex_lui, flex_lui (1))

c set up backward compatible equivalence

      EQUIVALENCE (DATA2(1),DATA4(1)),(LHEAD2(1),LHEAD4(1))

c initialize variables

      DATA IRISAV/0/
      DATA itr0/SZLNHD*0/
      DATA name/'SR3D2'/
      DATA go/.false./
      DATA limit/.false./
      DATA restart/.false./

c feed up command line help and stop if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help(LER)
         stop
      endif

c open printout file

#include <f77/open.h>

c parse the command line

      call cmdln ( vverbos, verbos, stp, oline, go, off, 
     :     ntap, otap, dtap, ptap, num_sr3d2_vols, irt3d0, mode0, ilog, 
     :     nsampi, RI1, RIINCR, LINE1, LININC, DI1, DIINCR, isli, isdi, 
     :     ieli, iedi, dstmin, dstmax, dstdel, flexbin, nodead,
     :     newpass, radius)

      call verbal ( vverbos, verbos, stp, oline, go, off, 
     :     ntap, otap, dtap, ptap, num_sr3d2_vols, irt3d0, mode0, ilog, 
     :     nsampi, RI1, RIINCR, LINE1, LININC, DI1, DIINCR, isli, isdi, 
     :     ieli, iedi, dstmin, dstmax, dstdel, flexbin, nodead, radius )

c conditional POLICEMEN

      if (stp .AND. go) then
         write(LERR,*)' '
         write(LERR,*)'SR3D2: '
         write(LERR,*)'Cannot have both command line flags -go & -stop'
         write(LERR,*)'Decide on one & rerun: if you have already made'
         write(LERR,*)'a first pass with sr3d2 then you wont want to'
         write(LERR,*)'recreate the intermediate sort file again.'
         write(LER ,*)' '
         write(LER ,*)'SR3D2: '
         write(LER ,*)' Cannot have both command line flags -go & -stop'
         write(LER ,*)' Decide on one & rerun: if you have already made'
         write(LER ,*)' a first pass with sr3d2 then you wont want to'
         write(LER ,*)' recreate the intermediate sort file again.'
         write(LER ,*)'FATAL'
         stop
      endif

      if (.not. go) then

c open input datastream, we say .not. go so that we can go all the way
c from input data to binned output data in one step if desired [as 
c may be used when processing tape to tape

          call getln ( luin  , ntap, 'r', 0 )
          if (luin .lt. 0) then
             length = lenth(ntap)
             write(LERR,*)'Cannot open ',ntap(1:length)
             write(LERR,*)'FATAL'
             write(LER ,*)' '
             write(LER ,*)'SR3D2:'
             write(LER ,*)' Cannot open ',ntap(1:length)
             write(LER ,*)' Check existence/permissions and try again'
             write(LER ,*)'FATAL'
             stop
          endif

c read lineheader off input datastream

          call rtape ( luin, LHEAD2, lbytes )
          if (lbytes  .eq. 0) then
             length = lenth(ntap)
             write(LERR,*)'No line header on input dataset ',
     :            ntap(1:length)
             write(LER ,*)' '
             write(LER ,*)'SR3D2:'
             write(LER ,*)' No line header on input dataset ',
     :            ntap(1:length)
             write(LER ,*)' File appears to be empty'
             write(LER ,*)'FATAL'
             stop
          endif
      else
          luin = 0
      endif

      if ( .not. stp ) then
         call getln ( luout , otap, 'w', 1 )
         if (luout .lt. 0) then
             length = lenth(otap)
             write(LERR,*)'Cannot open ',otap(1:length)
             write(LERR,*)'FATAL'
             write(LER ,*)' '
             write(LER ,*)'SR3D2:'
             write(LER ,*)' Cannot open ',otap(1:length)
             write(LER ,*)' Check existence/permissions and try again'
             write(LER ,*)'FATAL'
             stop
          endif
      endif

      if (go) then
          do  i = 1, num_sr3d2_vols
              call getln ( luout1(i), dtap(i), 'r' , -1 )
          enddo
      else
          do  i = 1, num_sr3d2_vols
              if (newpass) then
                 call getln ( luout1(i), dtap(i), 'r+', -1 )
                 call sislgbuf ( luout1(i), 'off' )
              else
                 call getln ( luout1(i), dtap(i), 'w+', -1 )
              endif
          enddo
      endif

      if (dtap(1) .eq. ' ') then
         write(LERR,*)'Must supply at least 1 sr3d2 disk volume'
         write(LERR,*)'using -D[] command line arg'
         write(LER,*)' '
         write(LER,*)'SR3D2: '
         write(LER,*)' Must supply at least 1 sr3d2 disk volume'
         write(LER,*)' using -D[] command line arg'
         write(LER,*)'FATAL'
         stop
      endif
      
      do  i = 1, num_sr3d2_vols
         if (luout1(i) .le. 0) then
            write(LERR,*)'Cannot create ',i,'th disk file for sort'
            write(LERR,*)'and dont really know why: write perms?'
            write(LER,*)' '
            write(LER,*)'SR3D2: '
            write(LER,*)' Cannot create ',i,'th sr3d2 volume disk file'
            write(LER,*)' and dont really know why: check permissions'
            write(LER,*)'FATAL'
            stop
         endif
      enddo

      write(LERR,*)' sr3d2 volume(s) '
      write(LERR,*)' -------------- '
      write(LERR,*)' '
      do i = 1, num_sr3d2_vols
         write(LERR,*)' ',dtap(i),' logical unit number = ',luout1(i)
      enddo
      write(LERR,*)' '

c open pre-existing sr3d1 table

      call alloclun(lu_sr3d1)

      open (unit = lu_sr3d1, file = ptap, form = 'unformatted',
     1      access = 'sequential', status = 'old', iostat = ierr)

      if(ierr .ne. 0) then
         write(LERR,*)'Could not open input sr3d1 table'
         write(LERR,*)'check existance/permissions'
         write(LER,*)' '
         write(LER,*)'SR3D2: '
         write(LER,*)' Could not open input sr3d1 table'
         write(LER,*)' check existance/permissions'
         write(LER,*)'FATAL'
         stop
      endif


C-----------------------------------------------------------------------
C
C     READ THE DATA STORED ON TEMPORARY DISK DATA SET BY STEP 1
C
c the entries suffixed with _tab were put there by sr3d1 but will not
c be used.  We will leave the table read list alone for continuity for
c if the user has entered -ris -rie etc. on the command line of a -stop
c run the sr3d1 table will be updated at that time.
c
C-----------------------------------------------------------------------
111   continue


      if ( newpass ) then

      READ  (lu_sr3d1) MODE, NX, NY, IDUM, IFOLD,
     $     IX1, IY1, IX2, IY2, IX3,
     $     IY3, IX4, IY4, DX, DY,
     $     IDUM, XX, XY, YX, YY,
     $     NTR, NTROUT, RI1_tab, RIINCR_tab, LINE1_tab,
     $     LININC_tab, DI1_tab, DIINCR_tab, IWNDWS, IWNDWE,
     $     IRT3D, ifmt_indexx, l_indexx, ln_indexx,
     $     ifmt_indexy, l_indexy, ln_indexy,
     $     TFS, IDXWND, NS, IMULT , NBYTESO,
     $     dstmin_tab, dstmax_tab, XLINE, stack, restart, irestart

           write(LER,*)'restart: ',restart,irestart
           if ( newpass ) restart = .true.
           irestart = irestart + 1

           write(LER,*)'restart: ',restart,irestart
      else

      READ  (lu_sr3d1) MODE, NX, NY, IDUM, IFOLD,
     $     IX1, IY1, IX2, IY2, IX3,
     $     IY3, IX4, IY4, DX, DY,
     $     IDUM, XX, XY, YX, YY,
     $     NTR, NTROUT, RI1_tab, RIINCR_tab, LINE1_tab,
     $     LININC_tab, DI1_tab, DIINCR_tab, IWNDWS, IWNDWE,
     $     IRT3D, ifmt_indexx, l_indexx, ln_indexx,
     $     ifmt_indexy, l_indexy, ln_indexy,
     $     TFS, IDXWND, NS, IMULT , NBYTESO,
     $     dstmin_tab, dstmax_tab, XLINE, stack

           if (IDUM .eq. 666) then
               newpass = .true.
               rewind lu_sr3d1
               go to 111
           endif

      endif

      if (.not. restart .AND. .not. go) irestart = 1
      if ( irestart .eq. 0 ) irestart = 1

      if ( flexbin ) then
         call argi4 ('-fold', ifoldi, 0, 0)
         if (ifoldi .gt. 0 .and. ifoldi .ge. ifold ) then
            write(LERR,*)'sr3d2:'
            write(LERR,*)' resetting output fold from ',ifold,' to ',
     1      ifoldi
            write(LERR,*)'SR3D2:'
            write(LER ,*)' resetting output fold from ',ifold,' to ',
     1      ifoldi
            write(LER ,*)'WARNING'
            ifold = ifoldi
         else
            write(LERR,*)'SR3D2:'
            write(LERR,*)' resetting output fold from ',ifold,' to ',
     1      ifoldi, 'NOT ALLOWED'
            write(LERR,*)' fold cannot be less than default of ',ifold
            write(LER,*)'SR3D2:'
            write(LER,*)' resetting output fold from ',ifold,' to ',
     1      ifoldi, 'NOT ALLOWED'
            write(LER,*)' fold cannot be less than default of ',ifold
            write(LER,*)' fold of ',ifold, ' will be used'
            write(LER ,*)'WARNING'
         endif
      endif

c the nsamp output override allows the user to build the sr3d1 table using
c a header only dataset then use that table to build the sr3d2 volume.

      if (nsampi .eq. 0) then
          nsamp = NS
      else
          nsamp = nsampi
          NBYTESO = SZTRHD + IMULT * nsamp
      endif
      NS = nsamp
 
c check the status on the serpentine output flag.  This was set during
c the sr3d1 run and resides in the sr3d1 table.  It may be reassigned on
c the sr3d2 command line however and must be checked here.  If it comes
c from cmdln[] as -999 then use the default.  If it comes from cmdln[]
c assigned as either zero or one then use the command line override.

      if (irt3d0 .eq. 0 .OR. irt3d0 .eq. 1) then
          IRT3D = irt3d0
      endif

c warn user that Serpentine sort has been requested

      if ( IRT3D .eq. 1 ) then
         write(LERR,*)' '
         write(LERR,*)' Ouput bins will increment in Serpentine order'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'SR3D2:'
         write(LER,*)' '
         write(LER,*)' Ouput bins will increment in Serpentine order'
         write(LER,*)' '
         write(LER,*)'WARNING '
      endif

      if (isli .ne. 1) then
        limit = .true.
      endif

      if (isdi .ne. 1) then
        limit = .true.
      endif

      if (ieli .ne. 99999999) then
        limit = .true.
        if (ieli .lt. 1 .OR. ieli .gt. NX) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR in sr3d2:'
            write(LERR,*)'Ending LI outside range 1 - ',NX
            write(LER,*)' '
            write(LER,*)'SR3D2:'
            write(LER,*)' Ending LI outside range 1 - ',NX
            write(LER,*)'FATAL '
            stop
        endif

      else
        ieli = NX
      endif

      if (iedi .ne. 99999999) then
         limit = .true.
         if (iedi .lt. 1 .OR. iedi .gt. NY) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR in sr3d2:'
            write(LERR,*)'Ending DI outside range 1 - ',NY
            write(LER,*)' '
            write(LER,*)'SR3D2:'
            write(LER,*)'Ending DI outside range 1 - ',NY
            write(LER,*)'FATAL '
            stop
         endif

      else
         iedi = NY
      endif

      if ( limit ) then
         newli = ieli - isli + 1
         newdi = iedi - isdi + 1
         if ( vverbos ) then
            write(LERR,*)' '
            write(LERR,*)'newli = ',newli
            write(LERR,*)'newdi = ',newdi
         endif
      endif

        write(LERR,*)' '
        write(LER ,*)' '

c if the user has not chosen to renumber in some form other than sequential for the
c output sorted data then make sure sequential numbering is used

      IF (RI1   .EQ.0) RI1    = 1
      IF (RIINCR.EQ.0) RIINCR = 1
      IF (LINE1 .EQ.0) LINE1  = 1
      IF (LININC.EQ.0) LININC = 1
      IF (DI1   .EQ.0) DI1    = 1
      IF (DIINCR.EQ.0) DIINCR = 1

      IF ( off .or. flexbin ) THEN

         if (dstmax .eq. 0.0 .AND. dstmin .eq. 0.0) then
            write(LERR,*)'For common offset sort or flexbin option must'
            write(LERR,*)'specify a maximum offset  -dmax[]'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'SR3D2: '
            write(LER,*)' For common offset sort or flexbin option must'
            write(LER,*)' specify a maximum offset  -dmax[]'
            write(LER,*)'FATAL'
            stop
         endif

         if (dstdel .eq. 0.0) then
            write(LERR,*)'For common offset sort or flexbin option must'
            write(LERR,*)'specify a delta distance -ddel[]'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'SR3D2: '
            write(LER,*)' For common offset sort or flexbin option must'
            write(LER,*)' specify a delta distance -ddel[]'
            write(LER,*)'FATAL'
            stop
         endif

         noff = (dstmax - dstmin) / dstdel + 1
 
         heap = .true.
         items = noff + 1
         call galloc ( wkspread, items * SZSMPD, errcd, abort )
         if (errcd .ne. 0.) heap = .false.
         if (.not. heap) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) items,'  bytes'
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*) items,'  bytes'
            go to 1410
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) items,'  bytes'
         endif

c initialize memory
         
         call vclr ( spread, 1, items )
         
c-------
c compute spread model
c-------
c         noff2 = noff / 2
 
         if ( vverbos) then
            write(LERR,*)' '
            write(LERR,*)' Offset Spread Model '
            write(LERR,*)' ------------------- '
            write(LERR,*)' '
         endif

         do  j = 1, noff
 
            spread (j) = dstmin + (j-1) * dstdel

            if ( vverbos) then
               write(LERR,*)'j= ',j,'  x= ',spread(j)
            endif
         enddo

      ENDIF

      write(LERR,*)' '
      write(LERR,*)' Corner Coordinates '
      write(LERR,*)' ------------------ '
      write(LERR,*)' '
      write(LERR,*)' IX1, IY1 = ',IX1,' ',IY1
      write(LERR,*)' IX2, IY2 = ',IX2,' ',IY2
      write(LERR,*)' IX3, IY3 = ',IX3,' ',IY3
      write(LERR,*)' IX4, IY4 = ',IX4,' ',IY4
      write(LERR,*)' '

      if ( vverbos ) then
         write(LERR,*)' '
         write(LERR,*)' sr3d1 Table Entries '
         write(LERR,*)' ------------------- '
         write(LERR,*)' '
         write(LERR,*)'NTR, NTROUT, RI1, RIINCR, LINE1= ',
     1        NTR,NTROUT,RI1,RIINCR,LINE1
         write(LERR,*)'LININC, DI1, DIINCR, IWNDWS, IWNDWE, IRT3D= ',
     1        LININC,DI1,DIINCR,IWNDWS,IWNDWE,IRT3D
         write(LERR,*)'IWNDWS, IWNDWE, IRT3D= ',IWNDWS,IWNDWE,IRT3D
         write(LERR,*)'TFS, IDXWND, NS, IMULT, NBYTESO= ',TFS,IDXWND,NS,
     :        IMULT,NBYTESO
      endif

      JNXNY = NX * NY
      itemk = (NX+2) * (NY+2)
      itemt = JNXNY * irestart
      itemi = (IFOLD + 1)
      lentrc = nsamp + ITRWRD
      heap = .true.

      if (stp .or. off) then
         itemd = 1 * (nsamp + ITRWRD)
      else
         itemd = IFOLD * (nsamp + ITRWRD) 
      endif

c dynamic allocation of indexing arrays

      call galloc ( wkkount, itemk * SZSMPD, errcd, abort )
      if (errcd .ne. 0.) heap = .false.
      call galloc ( wkjount, itemt * SZSMPD, errcd, abort )
      if (errcd .ne. 0.) heap = .false.
      call galloc ( wkind  , itemi  * SZSMPD, errcd, abort )
      if (errcd .ne. 0.) heap = .false.
      call galloc ( wktrdist, itemi  * SZSMPD, errcd, abort )
      if (errcd .ne. 0.) heap = .false.
      call galloc ( wkifl  , itemk * SZSMPD, errcd, abort )
      if (errcd .ne. 0.) heap = .false.
      call galloc ( wkgather, itemd * SZSMPD, errcd, abort )
      if (errcd .ne. 0.) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemk * SZSMPD,'  bytes'
         write(LERR,*) itemt * SZSMPD,'  bytes'
         write(LERR,*) itemi  * SZSMPD,'  bytes'
         write(LERR,*) itemi  * SZSMPD,'  bytes'
         write(LERR,*) itemk * SZSMPD,'  bytes'
         write(LERR,*) itemd * SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'SR3D2: '
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*) itemk * SZSMPD,'  bytes'
         write(LER,*) itemt * SZSMPD,'  bytes'
         write(LER,*) itemi  * SZSMPD,'  bytes'
         write(LER,*) itemi  * SZSMPD,'  bytes'
         write(LER,*) itemk * SZSMPD,'  bytes'
         write(LER,*) itemd * SZSMPD,'  bytes'
         write(LER,*)'FATAL'
         write(LER,*)' '
         go to 1410
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemk * SZSMPD,'  bytes'
         write(LERR,*) itemt * SZSMPD,'  bytes'
         write(LERR,*) itemi  * SZSMPD,'  bytes'
         write(LERR,*) itemi  * SZSMPD,'  bytes'
         write(LERR,*) itemk * SZSMPD,'  bytes'
         write(LERR,*) itemd * SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( TRDIST, 1, itemi )

      do i = 1, itemd
         gather(i) = 0
      enddo

      do i = 1, itemi
         IND(i) = 0
      enddo

      do i = 1, itemk
         KOUNT(i) = 0
         IFL(i) = 0
      enddo
      do i = 1, itemt
         JOUNT(i) = 0
      enddo

      if ( flexbin ) then

c dynamic memory allocation for arrays used in flexbinning

         iteme = IFOLD * 8 + 1
         heap = .true.

         call galloc ( ptr_flex_dist_required, noff * SZSMPD, errcd, 
     :        abort )
         if (errcd .ne. 0.) heap = .false.
         call galloc ( ptr_flex_hist, noff * SZSMPD, errcd, abort )
         if (errcd .ne. 0.) heap = .false.
         call galloc ( ptr_flex_trdist, iteme * SZSMPD, errcd, abort )
         if (errcd .ne. 0.) heap = .false.
         call galloc ( ptr_flex_pointer, iteme * SZSMPD, errcd, abort )
         if (errcd .ne. 0.) heap = .false.
         call galloc ( ptr_flex_radial_dist, iteme * SZSMPD, errcd, 
     :        abort )
         if (errcd .ne. 0.) heap = .false.
         call galloc ( ptr_flex_lui, iteme * SZSMPD, errcd, abort )
         if (errcd .ne. 0.) heap = .false.

         if (.not. heap) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 2 * noff * SZSMPD,'  bytes'
            write(LERR,*) 4 * iteme * SZSMPD,'  bytes'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'SR3D2:'
            write(LER,*)' '
            write(LER,*)' Unable to allocate workspace:'
            write(LER,*) 2 * noff * SZSMPD,'  bytes'
            write(LER,*) 4 * iteme * SZSMPD,'  bytes'
            write(LER,*)'FATAL '
            go to 1410
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 2 * noff * SZSMPD,'  bytes'
            write(LERR,*) 4 * iteme * SZSMPD,'  bytes'
            write(LERR,*)' '
         endif

c initialize memory

         do i = 1, iteme
            flex_trdist(i) = 0
            flex_pointer(i) = 0
            flex_lui(i) = 0
         enddo

         call vclr ( flex_dist_required, 1, noff )
         call vclr ( flex_hist, 1, noff )
         call vclr ( flex_radial_dist, 1, iteme )
         
      endif

c read fold information [number of live traces for each bin] 
c from sr3d1 table and hold in the KOUNT[] array
      
      if (.not.xline) then

         DO IR = 1, irestart
         DO IX = 1,NX
            I              = (IX - 1) * NY + 1
            J              = IX * NY
            READ  (lu_sr3d1) (KOUNT(IY),IY=I,J)
            do  iy = I, J
                irr = (IR-1) * JNXNY
                JOUNT(IY+irr) = KOUNT(IY)
            enddo
         ENDDO
         ENDDO

      else

         DO IR = 1, irestart
         DO IY = 1,NY
            I              = (IY - 1) * NX + 1
            J              = IY * NX
            READ  (lu_sr3d1) (KOUNT(IX),IX=I,J)
            do  ix = I, J
                irr = (IR-1) * JNXNY
                JOUNT(IX+irr) = KOUNT(IX)
            enddo
         ENDDO
         ENDDO

      endif

c if this is a -stop run then rebuild the sr3d1 table to account for
c any valid changes made on the sr3d2 command line.  In a -go run
c do not do this, simply read the information that is presented.

      if (.not. go) then

         rewind lu_sr3d1

         IDUM = 666
         write (lu_sr3d1) MODE  , NX    , NY    , IDUM  , IFOLD ,
     $                  IX1   , IY1   , IX2   , IY2   , IX3   ,
     $                  IY3   , IX4   , IY4   , DX    , DY    ,
     $                  IDUM  , XX    , XY    , YX    , YY    ,
     $                  NTR   , NTROUT, RI1   , RIINCR, LINE1 ,
     $                  LININC, DI1   , DIINCR, IWNDWS, IWNDWE,
     $                  IRT3D , ifmt_indexx, l_indexx, ln_indexx,
     $                          ifmt_indexy, l_indexy, ln_indexy,
     $                  TFS   , IDXWND, NS    , IMULT , NBYTESO,
     $                  dstmin_tab, dstmax_tab, XLINE, stack, restart,
     $                  irestart

         if (.not.xline) then

            DO IR = 1, irestart
            DO IX = 1,NX
               I              = (IX - 1) * NY + 1
               J              = IX * NY
               irr = (IR-1) * JNXNY
               WRITE  (lu_sr3d1) (JOUNT(IY+irr),IY=I,J)
            ENDDO
            ENDDO

         else

            DO IR = 1, irestart
            DO IY = 1,NY
               I              = (IY - 1) * NX + 1
               J              = IY * NX
               irr = (IR-1) * JNXNY
               WRITE  (lu_sr3d1) (JOUNT(IX+irr),IX=I,J)
            ENDDO
            ENDDO

         endif

      endif

C-----------------------------------------------------------------------
C
C     GENERATE ARRAY CONTAINING POINTERS TO FIRST LOCATION OF EACH CELL:
C
C     ifl(1) = 1                              (trc 1)
C     ifl(2) = 1 + kount(1)
C     ifl(2) = 1 + kount(1) + kount(2)
C             ...
C     ifl(J) = 1 + kount(1) + ... + kount(j)
c     NTRKS  = total number live traces
C
C-----------------------------------------------------------------------

      J                 = NX * NY - 1
      NTRKS             = 0
      IFL(1)            = 1
      irr               = (irestart-1) * JNXNY

      DO 200 I = 1,J

c note that IFOLD came from the initial sr3d1 run and was read in from 
c the sr3d1 table.
         IF (JOUNT(I).GT.IFOLD)    JOUNT(I) = IFOLD
         IFL(I+1)       = IFL(I) + JOUNT(I)
         if ( restart ) then
            KOUNT(I)       = JOUNT(I+irr)
         else
            KOUNT(I)       = 0
         endif
 200  CONTINUE

      JNXNY             = NX * NY
      IF (JOUNT(JNXNY).GT.IFOLD)   JOUNT(JNXNY) = IFOLD

c the following NTRKS is the total number of live traces in the volume

      NTRKS             = IFL (JNXNY) + JOUNT(JNXNY)

         if ( restart ) then
            KOUNT(JNXNY)       = JOUNT(JNXNY+irr)
         else
           KOUNT(JNXNY)       = 0
         endif

      if ( vverbos ) then
         write(LERR,*)'Total number of bins = ',JNXNY
         write(LERR,*)'Maximum number of traces/bin = ', ifold
      endif

C-----------------------------------------------------------------------
C
C     DEPENDING  ON SORT TYPE, SET TRACE HEADER INDEX TO KEY ON
C
C-----------------------------------------------------------------------

      if (mode0 .ge. 1 .AND. mode0 .le. 5) MODE = mode0

C-----------------------------------------------------------------------
C
C     PLACE THE SORT TYPE (MODE) & FOLD INTO THE PROCESS HISTORY
C     PLACE GRID CORNERS & CELL INCREMENTS INTO THE PROCESS HISTORY
C
C-----------------------------------------------------------------------

      write (SR3D, 1070) mode, ifold
1070  format('SR3D2: mode = ',i5,'   fold = ',i5)

      IDX = dx
      IDY = dy
      write (CORNR1, 1071) IX1, IY1
      write (CORNR2, 1072) IX2, IY2
      write (CORNR3, 1073) IX3, IY3
      write (CORNR4, 1074) IX4, IY4
      write (DELTAS, 1075) IDX, IDY
1071  format('    Corner1 (X,Y) = ',i8,'  ',i8)
1072  format('    Corner2 (X,Y) = ',i8,'  ',i8)
1073  format('    Corner3 (X,Y) = ',i8,'  ',i8)
1074  format('    Corner4 (X,Y) = ',i8,'  ',i8)
1075  format('    DX = ',i5,'  DY= ',i5)

C-----------------------------------------------------------------------
C
C     TAKE INPUT LINE HEADER & PLACE HISTORY INFORMATION IN BUFFER
C
C-----------------------------------------------------------------------

      IF (.not. go) THEN

         if ( restart ) then

            do  i = 1, num_sr3d2_vols
               call rtape ( luout1(i), lhead2, lbytes )
            enddo

            call saver ( LHEAD2, 'NumRec', nrec, LINHED )
            call saver ( LHEAD2, 'NumTrc', ntrc, LINHED )
 
         else

            CALL HLHPRT ( LHEAD2, lbytes,  SR3D , 36, LERR )
            CALL HLHPRT ( LHEAD2, lbytes, CORNR1, 39, LERR )
            CALL HLHPRT ( LHEAD2, lbytes, CORNR2, 39, LERR )
            CALL HLHPRT ( LHEAD2, lbytes, CORNR3, 39, LERR )
            CALL HLHPRT ( LHEAD2, lbytes, CORNR4, 39, LERR )
            CALL HLHPRT ( LHEAD2, lbytes, DELTAS, 26, LERR )
         
c note: lrec contains the number of single trace records in a sr3d2 volume.

            arec = float(NTRKS) / float(num_sr3d2_vols) + .5
            lrec = nint (arec)
            call saver ( LHEAD2, 'NumRec', nrec, LINHED )
            call saver ( LHEAD2, 'NumTrc', ntrc, LINHED )
            call savew ( LHEAD2, 'NumRec', lrec, LINHED )
            call savew ( LHEAD2, 'NumTrc', 1, LINHED )
         
            do  i = 1, num_sr3d2_vols
               call wrtape ( luout1(i), lhead2, lbytes )
            enddo
         
            call savew ( LHEAD2, 'NumRec', nrec, LINHED )
            call savew ( LHEAD2, 'NumTrc', ntrc, LINHED )

         endif
         
      ELSE
         
c read the sr3d2_volume line header

         call rtape ( luout1(1), LHEAD2, lbytes )
         
      ENDIF

      if (ilog .le. 1) then
         ilog = ntrc
      else
         verbos = .true.
      endif

      if (nsampi .eq. 0) then
         call saver ( LHEAD2, 'NumSmp', nsamp, LINHED )
      endif

      call saver ( LHEAD2, 'SmpInt', nsi, LINHED )
      call saver ( LHEAD2, 'NumTrc', ntrc, LINHED )
      call saver ( LHEAD2, 'NumRec', nrec, LINHED )
      call saver ( LHEAD2, 'Format', iform, LINHED )

      if ( vverbos ) then
         write(LERR,*)'input dataset line header info:'
         write(LERR,*)'nsamp,nsi,ntrc,nrec = ',nsamp,nsi,ntrc,nrec
      endif

      ifor   = iform
      isr    = nsi

c set up pointers to trace header mnemonics for use later in the 
c program

      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

C-----------------------------------------------------------------------
C
C     SET GRID DIMENSIONS IN THE LINE HEADER
C
C-----------------------------------------------------------------------

      call savew ( lhead2, 'APIWN9', 'D', LINHED )
      IF (.not. xline) THEN
         call savew ( lhead2, 'APIWNA', 'L', LINHED )
         call savew ( lhead2, 'APIWNB', 'D', LINHED )
      ELSE
         call savew ( lhead2, 'APIWNA', 'D', LINHED )
         call savew ( lhead2, 'APIWNB', 'L', LINHED )
      ENDIF

      if ( limit ) then
         call savew ( lhead2, 'MnDpIn', isdi, LINHED )
         call savew ( lhead2, 'MxDpIn', iedi, LINHED )
         call savew ( lhead2, 'MnLnIn', isli, LINHED )
         call savew ( lhead2, 'MxLnIn', ieli, LINHED )
      else
         call savew ( lhead2, 'MnDpIn', LINE1, LINHED )
         call savew ( lhead2, 'MxDpIn', NY+LINE1-1, LINHED )
         call savew ( lhead2, 'MnLnIn', DI1, LINHED )
         call savew ( lhead2, 'MxLnIn', NX+DI1-1, LINHED )
      endif

      write(LERR,*)' '
      write(LERR,*)' Global LI and DI Indexing '
      write(LERR,*)' --------------------------'
      write(LERR,*)' '
      write(LERR,*)' Min Depth Index = ',LINE1
      write(LERR,*)' Max Depth Index = ',NY+LINE1-1
      write(LERR,*)' Min Line Index = ',DI1
      write(LERR,*)' Max Line Index = ',NX+DI1-1
      write(LERR,*)' '

      YINCR              = DY
      XINCR              = DX

C-----------------------------------------------------------------------
C
C     RETRIEVE "NO. OF SAMPLES PER TRACE" & FORMAT CODE &
C     SAMPLE INTERVAL FROM LINE HEADER
C     SET TIME OF FIRST SAMPLE IN LINE HEADER
C     COMPUTE NUMBER OF SAMPLES TO BE OUTPUT
C
C-----------------------------------------------------------------------

      call savew ( lhead2, 'Format', IFOR, LINHED )
      call savew ( lhead2, 'SmpInt', ISR, LINHED )

c note: IWNDWS comes from the sr3d1 table

      TFS =  IWNDWS

      call savew ( lhead2, 'NumSmp',  NS, LINHED )

      IMULT = SZSMPD

      if ( vverbos ) then
         write(LERR,*)' '
         write(LERR,*)'Samp Interval = ',ISR
         write(LERR,*)'Format        = ',IFOR
         write(LERR,*)'Number Samps  = ',NS
         write(LERR,*)' '
      endif

C-----------------------------------------------------------------------
C
C     COMPUTE THE AMOUNT OF DISK SPACE REQUIRED, OPEN, & ALLOCATE DISK
C
C-----------------------------------------------------------------------

      NBYTES            = IMULT * NS
      NBYTR             = NBYTES    + SZTRHD

      if ( .not. go ) then

c note: NTR comes from the sr3d1 table

         WRITE (LERR,249) NTR
 249     FORMAT (// 10X, 'NUMBER OF LIVE TRACES IN THE GRID . . ', I9)
 
c note: NTRKS is the number of traces to be written to the sr3d2 volume
c       which may or may note be equal to NTR depending on the command
c       line options used in sr3d2 -stop
        
         WRITE (LERR,250) NTRKS, NBYTR
 250     FORMAT ( / 10X, 'DISK INFORMATION:',
     $        / 10X, '   NUMBER OF TRACES TO BE WRITTEN . . ', I9,
     $        / 10X, '   NUMBER OF BYTES PER TRACE  . . . . ', I9,
     $        //)
      endif

C-----------------------------------------------------------------------
C
C     STUFF LINE HEADER INFORMATION
C         1- NO. OF TRACES PER LINE
C         2- NO. OF TRACES PER RECORD
C         3- NO. OF RECORDS PER JOB
C         4- FOLD
C
C-----------------------------------------------------------------------

      ITFS = TFS
      call savew ( lhead4, 'TmMsFS', ITFS, LINHED )

c total number of traces in X direction

      IFOLDNX           = IFOLD * NX
      call savew ( lhead4, 'NTrLnS', IFOLDNX, LINHED )

      call savew ( lhead4, 'ILClIn', YINCR, LINHED )
      call savew ( lhead4, 'CLClIn', XINCR, LINHED )

      IF (.not. xline) THEN
         NCDPL             = NY
      ELSE
         NCDPL             = IFOLDNX / IFOLD
      ENDIF

c number of X bins out and number of Y bins out

      NXOUT             = IFOLDNX / IFOLD
      NYOUT             = (JNXNY + NXOUT - 1) / NXOUT

c total number of bins out

      NXNY = NX * NY

      if (oline) then

c putting out all X bins for a given Y bin in a single record

         call savew ( lhead4, 'NumTrc', IFOLDNX, LINHED )
         call savew ( lhead4, 'NumRec', NYOUT, LINHED )
      else

c putting out all X bins for a given Y bin in individual records
c of ifold traces each [the default]

         call savew ( lhead4, 'NumTrc', IFOLD, LINHED )
         call savew ( lhead4, 'NumRec', NXNY, LINHED )
      endif

      call savew ( lhead2, 'CDPFld', IFOLD, LINHED )

      IF (off) THEN
         call savew ( lhead4, 'NumTrc', NXNY, LINHED )
         call savew ( lhead4, 'NumRec', noff, LINHED )
      ENDIF

      write(LERR,*)' '
      write(LERR,*)' Global Binning Information '
      write(LERR,*)' --------------------------'
      write(LERR,*)' '
      write(LERR,*)' Number of bins in X or 2-3 dimension  = ',nx
      write(LERR,*)' Number to output                      = ',nxout
      write(LERR,*)' X cell dimension                      = ',XINCR
      write(LERR,*)' '
      write(LERR,*)' Number of bins in Y  or 1-2 dimension = ',ny
      write(LERR,*)' Number to output                      = ',ncdpl
      write(LERR,*)' Y cell dimension                      = ',YINCR
      write(LERR,*)' '
      write(LERR,*)' Time of 1st Samp                      = ',itfs
      write(LERR,*)' '

      IF (oline) THEN
         write(LERR,*)' Total number of bins                  = ',nyout
      ELSE
         write(LERR,*)' Total number of bins                  = ',NXNY
      ENDIF
      
      IF (oline) THEN
         write(LERR,*)' Number of Traces/Bin                  = ',
     :        ifoldnx
      ELSE
         write(LERR,*)' Number of Traces/Bin                  = ',ifold
      ENDIF

      if (mode0 .ge. 1 .and. mode0 .le. 5) then
         write(LERR,*)' Binning Mode                          = ',MODE0
      else
         write(LERR,*)' Binning Mode                          = ',MODE
      endif

      write(LERR,*)' '

      write(LER ,*)' '
      write(LER,*)' sr3d2 Global Binning Information '
      write(LER,*)' ---------------------------------'
      write(LER,*)' '
      write(LER,*)' Number of bins in X or 2-3 dimension  = ',nx
      write(LER,*)' X cell dimension                      = ',XINCR
      write(LER,*)' '
      write(LER,*)' Number of bins in Y  or 1-2 dimension = ',ny
      write(LER,*)' Y cell dimension                      = ',YINCR
      write(LER,*)' '
      write(LER,*)' Time of 1st Samp                      = ',itfs
      write(LER,*)' '

      IF (oline) THEN
         write(LER,*)' Total number of bins                  = ',nyout
      ELSE
         write(LER,*)' Total number of bins                  = ',NXNY
      ENDIF
      
      IF (oline) THEN
         write(LER,*)' Number of Traces/Bin                  = ',
     :        ifoldnx
      ELSE
         write(LER,*)' Number of Traces/Bin                  = ',ifold
      ENDIF

      if (mode0 .ge. 1 .and. mode0 .le. 5) then
         write(LER,*)' Binning Mode                          = ',MODE0
      else
         write(LER,*)' Binning Mode                          = ',MODE
      endif

      write(LER,*)' '


c-----
c    for first pass or at user discretion...
c    write out line header for sorted disk file
c-----

      itemu = ntrks
      call galloc ( wkparts, itemu * SZSMPD, errcd, abort )
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemu * SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'SR3D2: '
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*) itemu * SZSMPD,'  bytes'
         write(LER,*)'FATAL'
         write(LER,*)' '
         go to 1410
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemu * SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      do i = 1, itemu
         PARTS(i) = 0
      enddo

      ntrksi = ntrks / num_sr3d2_vols
      left   = ntrks - (ntrksi * num_sr3d2_vols)

      do  i = 1, num_sr3d2_vols
         npart (i) = ntrksi
      enddo

      if (left .ne. 0) then
         icnt = 0
         do  i = 1, num_sr3d2_vols
            icnt = icnt + 1
            if (icnt .le. left) then
               npart(i) = npart(i) + 1
            endif
         enddo
      endif

      nstart (1) = 1
      do  i = 2, num_sr3d2_vols
         nstart (i) = nstart (i-1) + npart (i)
      enddo

      do  i = 1, num_sr3d2_vols
         lstart (luout1(i)) = nstart (i)
      enddo

      if ( vverbos ) then
         write(LERR,*)'ntrks= ',ntrks
         write(LERR,*)'npart= ',( npart(ii), ii = 1, num_sr3d2_vols )
         write(LERR,*)'nstart= ',( nstart(ii), ii = 1, num_sr3d2_vols )
         write(LERR,*)'lstart= ',( lstart( luout1(ii) ), ii = 1, 
     :        num_sr3d2_vols )
      endif

      k = 0
      do  j = 1, num_sr3d2_vols
         do  i = 1, npart(j)
            k = k + 1
            parts (k) = luout1(j)
         enddo
      enddo

      IF (.not. go .AND. .not. restart) THEN

c in -stop mode will need to ensure that enough disk space exists to hold
c the sr3d2  volume.  Try to build it using zero trace entries.  If this 
c passes then off we go.

         k = 0
         write(LER,*)' '
         do  j = 1, num_sr3d2_vols
            do  i = 1, npart(j)
               call wrtape ( luout1(j), ITR0, NBYTESO )
            enddo
            write(LER,*)'SR3D2:'
            write(LER,*)' Created disk space for sr3d2 volume'
            write(LER,*)' for partion ',j,' of ',num_sr3d2_vols
         enddo
         write(LER,*)'***************************************'
         write(LER,*)'You have enough disk space for the sort'
         write(LER,*)'***************************************'

      ENDIF

c rewind all sr3d2 volume files and read past the line header in 
c each.

      do  i = 1, num_sr3d2_vols
         call rwd ( luout1(i) )
         call sislgbuf ( luout1(i), 'off' )
         call rtape    ( luout1(i), data2, ndum )
      enddo

C     +-------------------------------------------------+
C     |             MODE 5 INITIALIZATION  
C     |       CMP with bin center [NOT centroid] in trace header
C     +-------------------------------------------------+

      IF ( mode .eq. 5 .or. flexbin ) THEN

         CALL XFMI ( IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4, DY, DX, 
     :        N23, N12, IWRN, XX, XY, YX, YY, XX1, XY1, YX1, YY1 )

         DE = DBLE(FLOAT(IX1)) * XX1 + DBLE(FLOAT(IY1)) * XY1
         DF = DBLE(FLOAT(IX1)) * YX1 + DBLE(FLOAT(IY1)) * YY1
         XYYXXY =  XY1 * YX1 - XX1 * YY1
         if (XYYXXY .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR in sr3d2:'
            write(LERR,*)'Attempt to use survey coords to fill in bin'
            write(LERR,*)'centers failed due to coord transform'
            write(LERR,*)'singularity (bad coord choice most likely)'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'SR3D2:'
            write(LER,*)' Attempt to use survey coords to fill in bin'
            write(LER,*)' centers failed due to coord transform'
            write(LER,*)' singularity (bad corner choice most likely)'
            write(LER,*)'FATAL'
            stop
         endif

         if ( vverbos ) then
            write(LERR,*)' Mode 5 initialization parameters'
            write(LERR,*)' '
            write(LERR,*)'XX1, XY1, YX1, YY1= ',XX1, XY1, YX1, YY1
            write(LERR,*)'DE, DF, XYYXXY= ',DE, DF, XYYXXY
            write(LERR,*)' '
            write(LER,*)' '
         endif

      ENDIF

C-----------------------------------------------------------------------
C
C     For first pass or at user discretion...
C     READ A TRACE FROM THE INPUT DATA SET
c     figure out where it needs to be put in the sr3d2 volume
c     (i.e. from a computed pointer into the bin map), and put it there
C
C-----------------------------------------------------------------------

      itrc = 0
      ir   = 1

      IF (.not. go) THEN 
         

 300     IBYTES = 0

         CALL RTAPE ( LUIN, DATA2, IBYTES )

         itrc = itrc + 1
         if ((itrc .eq. ilog) .AND. verbos) then
            write(LER,*)'sr3d2: Read record ',ir,' of ',itrc,' traces fr
     :om input'
            itrc = 0
            ir = ir + 1
         endif

         IF ( IBYTES .EQ. 0 ) GO TO 400

         call saver2 ( data4, ifmt_StaCor, l_StaCor, ln_StaCor,
     1        StaCor, TRACEHEADER )
         call saver2 ( data4, ifmt_RecNum, l_RecNum, ln_RecNum,
     1        RecNum, TRACEHEADER )
         call saver2 ( data4, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     1        irtrc, TRACEHEADER )
         irrec = RecNum

c-----
c          For pre-stack input we need to recover shot & recvr
c          indexing. For stack data we don't want this stuff - try
c          to extract distances from input trace headers
c-----
         IF ( .not. stack) THEN

c-----
c  rcvr XYs
c-----
            call saver2 ( data4, ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC,
     1           RcPtXC, TRACEHEADER )
            call saver2 ( data4, ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC,
     1           RcPtYC, TRACEHEADER )
c-----
c  shot XYs
c-----
            call saver2 ( data4, ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,
     1           SrPtXC, TRACEHEADER )
            call saver2 ( data4, ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC,
     1           SrPtYC, TRACEHEADER )

            dxt  = float ( SrPtXC - RcPtXC )
            dyt  = float ( SrPtYC - RcPtYC )
            dist = sqrt ( dxt * dxt + dyt * dyt ) + 0.5

            SrRcMX = 0.5 * float (SrPtXC + RcPtXC) + 0.5
            SrRcMY = 0.5 * float (SrPtYC + RcPtYC) + 0.5

            call savew2 ( data4, ifmt_SrRcMX, l_SrRcMX, ln_SrRcMX,
     1           SrRcMX, TRACEHEADER )
            call savew2 ( data4, ifmt_SrRcMY, l_SrRcMY, ln_SrRcMY,
     1           SrRcMY, TRACEHEADER )

         ELSE

            call saver2 ( data4, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     1           DstSgn, TRACEHEADER )
            dist = float(DstSgn)
            
         ENDIF

         IF (RecNum .EQ. IRISAV) GO TO 350

         IRISAV            = RecNum

         if (vverbos) then
            WRITE (LERR,340) IRISAV
            WRITE (LER  ,340) IRISAV
 340        FORMAT (10X, 'WRITING RECORD NUMBER ', I5, ' TO DISK')
         endif

C-----------------------------------------------------------------------
C
C     DETERMINE IF TRACE IS USABLE (IE; LIVE & WITHIN GRID BOUNDARIES)
C
C-----------------------------------------------------------------------

 350     IF (StaCor .EQ. 30000) GO TO 300

         call saver2 ( data4, ifmt_indexx, l_indexx, ln_indexx,
     1        indexx , TRACEHEADER )
         call saver2 ( data4, ifmt_indexy, l_indexy, ln_indexy,
     1        indexy , TRACEHEADER )

         IX = (indexx - IX1) * XX  + (indexy - IY1) * XY  +  .999999
         IF ( IX .LE. 0 .OR. IX .GT. NX ) GO TO 300
         IY = (indexx - IX1) * YX  + (indexy - IY1) * YY  +  .999999
         IF ( IY .LE. 0 .OR. IY .GT. NY ) GO TO 300

         IF ( MODE .NE. 5 ) GO TO 370

c mode 5 is Common Midpoint Sort in which case the CDPBCX and
c CDPBCY entries are the bin center for a given LI,DI location

         E = (DBLE(FLOAT(IX)) - 0.5) * DX + DE
         F = (DBLE(FLOAT(IY)) - 0.5) * DY + DF

 360     continue

         CDPX = (F * XY1 - E * YY1) / XYYXXY
         CDPBCX = nint(CDPX)

         call savew2 ( data4, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     1        CDPBCX , TRACEHEADER )


         if ( dabs(YY1) .ge. 0.001 ) then 

            CDPY = (F - CDPX * YX1) / YY1
            CDPBCY = nint(CDPY)

            call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     1           CDPBCY , TRACEHEADER )

         elseif ( XY1 .ne. 0. ) then

            CDPY = (E - CDPX * XX1) / XY1
            CDPBCY = nint(CDPY)

            call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     1           CDPBCY , TRACEHEADER )

            if ( .not. off) then
               DstSgn = nint(dist)
               call savew2( data4, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     1              DstSgn, TRACEHEADER)
            endif

         endif

C-----------------------------------------------------------------------
C
C     WRITE TRACE TO DISK, AND KEEP COUNT OF TRACES PER CELL
C     IPT is the pointer into the disk file.  We assume that each
C     IPT value means the next wrtape puts the trace into its correct
C     disk location
C
C-----------------------------------------------------------------------

 370     CONTINUE


         IF (.not. xline) THEN
            
            IY0 = IY
            IX0 = IX
            IY                = (IX - 1) * NY + IY
            IF (KOUNT(IY).GE.IFOLD) GO TO 300
            IPT               = IFL(IY) + KOUNT(IY)
            
         ELSE

            IY0 = IY
            IX0 = IX
            IX                = (IY - 1) * NX + IX
            IF (KOUNT(IX).GE.IFOLD) GO TO 300
            IPT               = IFL(IX) + KOUNT(IX)
            
         ENDIF


         if (IPT .gt. NTRKS) then
            write(LER,*)' '
            write(LER,*)'SR3D2: '
            write(LER,*)' pointer ran off end of disk sort file '
            write(LER,*)' at IX, IY, IPT, NTRKS= ',ix0,iy0,ipt,ntrks
            write(LER,*)'WARNING'
            write(LER,*)' '
            if (.not. xline) then
               write(LER,*)'IY, IFL, KOUNT= ',iy,ifl(iy),kount(iy)
            else
               write(LER,*)'IX, IFL, KOUNT= ',ix,ifl(ix),kount(ix)
            endif
            go to 300
         endif

         lui = parts (IPT)
         ipti = ipt - lstart (lui) + 1
         call sisseek ( lui, ipti )

         call wrtape ( lui, DATA4, NBYTESO )

         if (.not. xline) then
            KOUNT(IY)         = KOUNT(IY) + 1
         else
            KOUNT(IX)         = KOUNT(IX) + 1
         endif

c go read the next trace and keep doing so until you reach the 
c end of input data

         go to 300

 400     continue

c update the sr3d1 table for traces output to the sr3d2 volume 
c during this sr3d2 -stop run

         if (.not.xline) then

            DO IX = 1,NX
               I              = (IX - 1) * NY + 1
               J              = IX * NY
               WRITE (lu_sr3d1) (KOUNT(IY),IY=I,J)
            ENDDO

         else

            DO IY = 1,NY
               I              = (IY - 1) * NX + 1
               J              = IY * NX
               WRITE (lu_sr3d1) (KOUNT(IX),IX=I,J)
            ENDDO
         endif

      ELSE 

c read the fold array from the sr3d1 table for the pre-existing sr3d2 volume
c attached to this sr3d2 -go run
         if ( restart ) then

            IR = 1
            do  ii = 1, JNXNY
                irr = (IR-1) * JNXNY
                KOUNT(ii) = JOUNT(ii+irr)
            enddo

         else
            
            read (lu_sr3d1) INXNY
            READ  (lu_sr3d1) (KOUNT(ii),ii= 1, INXNY)

         endif

      ENDIF

      if (stp ) then
         write(LERR,*)'********************************************'
         write(LERR,*)'sr3d2 volume built. Ready for sr3d2 -go step'
         write(LERR,*)'********************************************'
         write(LER ,*)'********************************************'
         write(LER ,*)'sr3d2 volume built. Ready for sr3d2 -go step'
         write(LER ,*)'********************************************'
         go to 1400
      else

C-----------------------------------------------------------------------
C
C     WRITE THE LINE OUTPUT LINE HEADER and do the -go stuff.  There is 
c     no need to look at the code between here and statement 1410 if you
c     are looking at -stop logic only.
C
C-----------------------------------------------------------------------


c this is a -go mode so the whole dataset is going out as a single
c datastream.  It would be useful if we took what we know from
c the command line and adjust the lineheader entries for nrec and
c ntrc accordingly

c command line options that have an effect here are:
c -minli -maxli -mindi -maxdi -dmin -dmax -ddel -flexbin -off
c here I will only change things that need to be changed on output

         if ( .not. off .and. .not. flexbin ) then

c this is the default but if limits are applied the number of output
c records will change as follows:

            if ( limit ) then
               limit_nrec = newli * newdi
               call savew ( LHEAD2, 'NumRec', limit_nrec, LINHED )
            endif
         elseif ( .not. off .and. flexbin ) then

c now the number of records output is a function of whether or not
c limiting was used soooooooooo.
            
            if ( limit ) then
               limit_nrec = newli * newdi
               call savew ( LHEAD2, 'NumRec', limit_nrec, LINHED )
            endif

         elseif ( off ) then

c with offset sort output the number of records becomes the number
c of offset bins used

            call savew ( LHEAD2, 'NumRec', noff, LINHED )

c the number of traces per record depends on whether or not
c limiting was used
            
            if ( limit ) then
               limit_ntrc = newli*newdi
               call savew ( LHEAD2, 'NumTrc', limit_ntrc, LINHED )
            else
               limit_ntrc = nx*ny
               call savew ( LHEAD2, 'NumTrc', limit_ntrc, LINHED )
            endif
         endif

         call savhlh ( LHEAD2, lbytes, lbyout )
         CALL WRTAPE ( LUOUT ,LHEAD2, lbyout )
      endif

c if very verbose output requested then print out the fold distribution

      if (vverbos) then
         write(LERR,*)'nx,ny= ',nx,ny
         write(LER  ,*)'nx,ny= ',nx,ny
         do j = 1, ny
            write(LERR,*)'j= ',j
            write(LERR,*)(kount((j-1)*ny+ii),ii=1,ny)
            write(LER  ,*)'j= ',j
            write(LER  ,*)(kount((j-1)*ny+ii),ii=1,ny)
         enddo
      endif

C-----------------------------------------------------------------------
C
C     USE THE LINE HEADER ARRAY TO STORE A DEAD TRACE FOR LATER USES
C
C-----------------------------------------------------------------------

      IBYTES            = NS * IMULT + SZTRHD
      CALL MOVE ( 0, LHEAD2, 0, IBYTES )

C-----------------------------------------------------------------------
C
C     DO THE FOLLOWING FOR EACH CELL:
C         1- DETERMINE COORDINATES OF CENTROID OF LIVE TRACES
C         2- SORT COMPONENT LIVE TRACES BY INCREASING TRACE DISTANCE
C         3- WRITE THE TRACES TO OUTPUT DEVICE IN "RT3D" FORMAT IF
C            REQUESTED [RT3D format is serpentine format]
C         4- FILL CELL TO FULL FOLD WITH DEAD TRACES
C
C-----------------------------------------------------------------------

      write(LER,*)'***************************************'
      write(LER,*)'    sr3d2 Output Sorted Data'
      write(LER,*)'***************************************'

      NTR2D = 0
      CDP2D = 1

      IF (isli .ne. 1) then
         LINE2D = LINE1 + isli
      ELSE
         LINE2D = LINE1
      ENDIF

      IF (isdi .ne. 1) then
         DI2D = DI1 + isdi
      ELSE
         DI2D = DI1
      ENDIF

      IF (.not. xline) THEN
         LASTRI = (NXOUT - 1) * RIINCR + RI1
      ELSE
         LASTRI = (NYOUT - 1) * RIINCR + RI1
      ENDIF

      ICELL                  = 0
      ISWAP                  = 1
      ICOUNT                 = 0
      DIINC                  = DIINCR
      LIINC                  = LININC

      if ( vverbos ) then
         write(LERR,*)' '
         write(LERR,*)'LINE2D     = ',LINE2D
         write(LERR,*)'LINE1      = ',LINE1
         write(LERR,*)'DI2D       = ',DI2D
         write(LERR,*)'DI1        = ',DI1
         write(LERR,*)'LASTRI     = ',LASTRI
         write(LERR,*)'DIINC      = ',DIINC
         write(LERR,*)'DIINCR     = ',DIINCR
         write(LERR,*)'LIINC      = ',LIINC
         write(LERR,*)'LININC     = ',LININC
         write(LERR,*)' '
         write(LER ,*)' '
      endif
      do  i = 1, num_sr3d2_vols
          call rwd ( luout1(i) )
          call sislgbuf ( luout1(i), 'off' )
          call rtape ( luout1(i), data2, ndum )
      enddo

c*******************************************************************

      IF ( .not. xline .AND. .not. off ) THEN

c*******************************************************************

c feed data up in LI order
c secondary sort being DI
c tertiary sort DstSgn

      if (line1 .gt. 1) line1 = line1 + 1
      if (di1 .gt. 1) di1 = di1 + 1
      
      DO 1300 IX = RI1,LASTRI,RIINCR

         if (IRT3D .eq. 1) then

c provide output in serpentine format

            if (mod(IX,2) .eq. 0) then
               IYs = NYOUT
               IYe = 1
               IYi = -1
            else
               IYs = 1
               IYe = NYOUT
               IYi = 1
            endif

         else

c provide output in non-serpentine format

            IYs = 1
            IYe = NYOUT
            IYi = 1
         endif

         DO 1300 IY = IYs, IYe, IYi

            TrcNum                 = 0
            IF(ICELL .EQ. 0 .OR. ICOUNT .NE. NY .OR. IRT3D .EQ. 0)
     *           GO TO 450
            ICOUNT           = 0
            ISWAP            =-ISWAP
            ICELL            = ICELL  + NY - ISWAP
 450        ICELL            = ICELL       + ISWAP
            ICOUNT           = ICOUNT + 1

            IF (IX .lt. isli .OR. IY .lt. isdi) go to 1300
            IF (IX .gt. ieli .OR. IY .gt. iedi) go to 1300

            DphInd = (IY - 1) * DIINC + DI1
            LinInd = (IX - 1) * LIINC + LINE1

c note: IPTS is the trace count to the first trace in the current bin
c       IPTE is the trace count to the last trace in the current bin

            IPTS             = IFL(ICELL)
            INDEX = 0
            IF (KOUNT(ICELL).EQ.0) GO TO 1100
            INDEX            = KOUNT(ICELL)
            IPTE             = IPTS  - 1 + INDEX
            J                = 0
            ICX              = 0
            ICY              = 0

c load the gather

            DO 500 I = IPTS,IPTE

               J             = J   + 1
               lui = parts (I)
               ipti = i - lstart (lui) + 1
               call sisseek ( lui, ipti )
               call rtape ( lui, DATA2, nbytes )

               call saver2 ( data4, ifmt_indexx, l_indexx, ln_indexx,
     1              ICNDX    , TRACEHEADER )
               call saver2 ( data4, ifmt_indexy, l_indexy, ln_indexy,
     1              ICNDY    , TRACEHEADER )
               call saver2 ( data4, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     1              DstSgn , TRACEHEADER )

c note: lentrc is the length of the trace time series plus the trace header
c       so that the following stores the entire trace plus the header in
c       the gather array.  This must be done to keep all trace header information
c       attached to the correct trace.  We could have used a data array and a 
c       header array but this would have been a possible source of error and 
c       would also have added extra overhead that would slow this already 
c       cumbersome code down even more

               istrt = (J-1) * lentrc
               call vmov ( DATA2, 1, gather(istrt+1), 1, lentrc )

c accumulate indexx and indexy in ICX and ICY for centroid calculation
c prior to writing out bin [for output modes not equal to 5]
 
               ICX           = ICX + ICNDX
               ICY           = ICY + ICNDY

               TRDIST(J)     = abs( float(DstSgn) )

 500        CONTINUE

            IF ( flexbin ) then

c run data through histogram to see if any significant range of
c offsets is missing from dstmin to dstmax using dstdel

               call vclr (  flex_dist_required, 1, noff )

               call flex_o_gram ( itemi, trdist, INDEX, noff,
     :              num_flex_traces, flex_dist_required, flex_hist, 
     :              dstmin, dstmax, dstdel )

               if ( num_flex_traces .gt. 0 ) then

c if missings offsets have been identified then search adjacent
c bins [see figure] for qualified traces and return the arrays
c 
c flex_radial_dist() --> containing radial distance from current bin
c                        center to  trace
c
c flex_trdist() --> containing source - receiver offset of trace
c
c flex_pointer() --> containing pointer to trace in sr3d2 volume
c
c      |_|_|_|_|_|
c      |_|1|2|3|_|
c      |_|4|x|5|_|
c      |_|6|7|8|_|
c      |_|_|_|_|_|
c
c  compute bin center for this bin

                  E = (DBLE(FLOAT(IX)) - 0.5) * DX + DE
                  F = (DBLE(FLOAT(IY)) - 0.5) * DY + DF
                  CDPX  = (F * XY1 - E * YY1) / XYYXXY
                  CDPBCX = nint(CDPX)

                  if ( dabs(YY1) .ge. 0.001 ) then
                     CDPY  = (F - CDPX * YX1) / YY1
                  elseif (XY1 .ne. 0. ) then
                     CDPY = ( E - CDPX * XX1) / XY1
                  endif

                  CDPBCY = nint(CDPY)

                  call flex_get_traces( IX, IY, LASTRI, IYE, ICELL, 
     :                 itemk, KOUNT, num_flex_traces,  
     :                 flex_dist_required, itemu, PARTS, lstart, NX, NY,
     :                 CDPBCX, CDPBCY, off, dstdel,
     :                 ifmt_indexx, l_indexx, ln_indexx,
     :                 ifmt_indexy, l_indexy, ln_indexy, 
     :                 ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :                 iteme, flex_radial_dist, flex_pointer, 
     :                 flex_trdist, flex_lui, flex_count, IFL, radius )

c search through the candidate traces for those fitting the criteria choosen
c by the user for actual inclusion in the current gather.   The first test
c is using minimum radial distance criteria

                  if ( IX .gt. 1 .and. IX .lt. LASTRI .and. IY .gt. 1
     :                 .and. IY .lt. IYE .and. flex_count .gt. 0 )
     :             call flex_min_radial_dist ( IFOLD, INDEX, itemd, 
     :                 gather, num_flex_traces, flex_dist_required, 
     :                 iteme, flex_radial_dist, flex_pointer, flex_lui,
     :                 dstdel, flex_trdist, flex_count, itemi, 
     :                 trdist, LinInd, DphInd, lentrc, off, off_found,
     :                 radius)
                  
               endif
            ENDIF

c sort based on trace distance

            call sort (trdist, ind, INDEX)

            DO 1000 I = 1,INDEX

               J = ind (i)
               istrt = (J-1) * lentrc
               call vmov (gather(istrt+1), 1, DATA2, 1, lentrc)

               TrcNum           = TrcNum + 1

               IF (MODE.EQ.5) then

c  compute bin center for this bin

                  E = (DBLE(FLOAT(IX)) - 0.5) * DX + DE
                  F = (DBLE(FLOAT(IY)) - 0.5) * DY + DF
                  CDPX  = (F * XY1 - E * YY1) / XYYXXY
                  CDPBCX = nint(CDPX)
                  
                  if ( dabs(YY1) .ge. 0.001 ) then
                     CDPY  = (F - CDPX * YX1) / YY1
                  elseif (XY1 .ne. 0. ) then
                     CDPY = ( E - CDPX * XX1) / XY1
                  endif
                  
                  CDPBCY = nint(CDPY)

                  call savew2 ( data4, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     1                 CDPBCX, TRACEHEADER )
                  call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     1                 CDPBCY, TRACEHEADER )

               ELSE

c perform centroid calculation for all modes except 5

                  call savew2 ( data4, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     1                 ICX / INDEX, TRACEHEADER )
                  call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     1                 ICY / INDEX, TRACEHEADER )

               ENDIF

               call savew2 ( data4, ifmt_FoldNm, l_FoldNm, ln_FoldNm,
     1              INDEX , TRACEHEADER )
               call savew2 ( data4, ifmt_RecNum, l_RecNum, ln_RecNum,
     1              IY, TRACEHEADER )
               call savew2 ( data4, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     1              TrcNum, TRACEHEADER )
               call savew2 ( data4, ifmt_LinInd, l_LinInd, ln_LinInd,
     1              LinInd, TRACEHEADER )
               call savew2 ( data4, ifmt_DphInd, l_DphInd, ln_DphInd,
     1              DphInd, TRACEHEADER )

               if ( flexbin .and. ( num_flex_traces .gt. 0 ) ) then

c make sure that the flexed traces have the current bin-center information
c as opposed to the bincenter information from their original location.  
c also do not allow changes otherwise to bins that do not require flexing
c hence the double condition of both flexbin and num_flex_traces
c greater than zero

                  call savew2 ( data4, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     1                 CDPBCX, TRACEHEADER )
                  call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     1                 CDPBCY, TRACEHEADER )
               endif

               CALL WRTAPE (LUOUT,DATA2,IBYTES)

 1000       CONTINUE

            IF (INDEX.EQ.IFOLD) GO TO 1298

c note: if INDEX equals IFOLD then no padding of dead traces is required

 1100       INDEX            = INDEX + 1

            if ( nodead .AND. INDEX .eq. 1 ) go to 1300

c flush out bin with dead traces up to max fold being output

            DO 1200 I = INDEX,IFOLD

               TrcNum           = TrcNum   + 1
               call savew2 ( LHEAD4, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     1              TrcNum, TRACEHEADER )
               call savew2 ( LHEAD4, ifmt_RecNum, l_RecNum, ln_RecNum,
     1              IY, TRACEHEADER )
               call savew2 ( LHEAD4, ifmt_LinInd, l_LinInd, ln_LinInd,
     1              LinInd, TRACEHEADER )
               call savew2 ( LHEAD4, ifmt_DphInd, l_DphInd, ln_DphInd,
     1              DphInd, TRACEHEADER )
               call savew2 ( LHEAD4, ifmt_StaCor, l_StaCor, ln_StaCor,
     1              30000, TRACEHEADER )

c write out dead trace

               CALL WRTAPE (LUOUT,LHEAD2,IBYTES)

 1200       CONTINUE

 1298       CONTINUE

            if (verbos) then
               write(LERR,*)'Written LI ',LinInd,'  DI ',DphInd,
     1              '  with ',INDEX,' live traces'
               write(LER ,*)'Written LI ',LinInd,'  DI ',DphInd,
     1              '  with ',INDEX,' live traces'
            endif

 1300    CONTINUE

c*******************************************************************

      ELSEIF ( xline .AND. .not. off ) THEN

c*******************************************************************
c feed data up in DI order
c secondary sort is LI
c tertiary sort is DstSgn

         if (line1 .gt. 1) line1 = line1 + 1
         if (di1 .gt. 1) di1 = di1 + 1

         DO 1301 IY = RI1,LASTRI,RIINCR

            if (IRT3D .eq. 1) then

c output data in serpentine order
               
               if (mod(IY,2) .eq. 0) then
                  IXs = NXOUT
                  IXe = 1
                  IXi = -1
               else
                  IXs = 1
                  IXe = NXOUT
                  IXi = 1
               endif
               
            else

c output data in non-serpentine order
               
               IXs = 1
               IXe = NXOUT
               IXi = 1
            endif
            
            DO 1301 IX = IXs, IXe, IXi
               
               
               TrcNum                 = 0
               IF(ICELL .EQ. 0 .OR. ICOUNT .NE. NX .OR. IRT3D .EQ. 0)
     *              GO TO 451
               ICOUNT           = 0
               ISWAP            =-ISWAP
               ICELL            = ICELL  + NX - ISWAP
 451           ICELL            = ICELL       + ISWAP
               ICOUNT           = ICOUNT + 1
               
               IF (IX .lt. isli .OR. IY .lt. isdi) go to 1301
               IF (IX .gt. ieli .OR. IY .gt. iedi) go to 1301
               
               DphInd = (IY - 1) * DIINC + DI1
               LinInd = (IX - 1) * LIINC + LINE1
               
               IPTS             = IFL(ICELL)
               INDEX = 0
               IF (KOUNT(ICELL).EQ.0) GO TO 1101
               INDEX            = KOUNT(ICELL)
               IPTE             = IPTS  - 1 + INDEX
               J                = 0
               ICX              = 0
               ICY              = 0
               
               
               DO 501 I = IPTS,IPTE
                  
                  J             = J   + 1
                  lui = parts (I)
                  ipti = i - lstart (lui) + 1
                  call sisseek (lui, ipti)
                  call rtape   (lui, DATA2, nbytes)
                  
                  call saver2 ( data4, ifmt_indexx, l_indexx, ln_indexx,
     1                 ICNDX    , TRACEHEADER )
                  call saver2 ( data4, ifmt_indexy, l_indexy, ln_indexy,
     1                 ICNDY    , TRACEHEADER )
                  call saver2 ( data4, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     1                 DstSgn , TRACEHEADER )

                  istrt = (J-1) * lentrc
                  call vmov (DATA2, 1, gather(istrt+1), 1, lentrc)
 
                  ICX           = ICX + ICNDX
                  ICY           = ICY + ICNDY
                  
                  TRDIST(J)     = abs( float(DstSgn) )
                  
 501           CONTINUE
               
               IF ( flexbin ) then

c run data through histogram to see if any significant range of
c offsets is missing from dstmin to dstmax using dstdel

                  call vclr (  flex_dist_required, 1, noff )

                  call flex_o_gram ( itemi, trdist, INDEX, noff,
     :                 num_flex_traces, flex_dist_required, flex_hist, 
     :                 dstmin, dstmax, dstdel )

                  if ( num_flex_traces .gt. 0 ) then
                  
c if missings offsets have been identified then search adjacent
c bins [see figure] for qualified traces and return the arrays
c 
c flex_radial_dist() --> containing radial distance from current bin
c                        center to  trace
c
c flex_trdist() --> containing source - receiver offset of trace
c
c flex_pointer() --> containing pointer to trace in sr3d2 volume
c
c      |_|_|_|_|_|
c      |_|1|2|3|_|
c      |_|4|x|5|_|
c      |_|6|7|8|_|
c      |_|_|_|_|_|
c
c
c  compute bin center for this bin

                     E = (DBLE(FLOAT(IX)) - 0.5) * DX + DE
                     F = (DBLE(FLOAT(IY)) - 0.5) * DY + DF
                     CDPX  = (F * XY1 - E * YY1) / XYYXXY
                     CDPBCX = nint(CDPX)

                     if ( dabs(YY1) .ge. 0.001 ) then
                        CDPY  = (F - CDPX * YX1) / YY1
                     elseif (XY1 .ne. 0. ) then
                        CDPY = ( E - CDPX * XX1) / XY1
                     endif

                     CDPBCY = nint(CDPY)
                     IYe = NYOUT

                     call flex_get_traces( IX, IY, LASTRI, IYE, ICELL, 
     :                    itemk, KOUNT, num_flex_traces,  
     :                    flex_dist_required, itemu, PARTS, lstart, NX, 
     :                    NY, CDPBCX, CDPBCY, off, dstdel,
     :                    ifmt_indexx, l_indexx, ln_indexx,
     :                    ifmt_indexy, l_indexy, ln_indexy, 
     :                    ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :                    iteme, flex_radial_dist, flex_pointer, 
     :                    flex_trdist, flex_lui, flex_count, IFL, 
     :                    radius )

c search through the candidate traces for those fitting the criteria choosen
c by the user for actual inclusion in the current gather.   The first test
c is using minimum radial distance criteria

                     if ( IX .gt. 1 .and. IX .lt. LASTRI .and. IY .gt. 1
     :                    .and. IY .lt. IYE .and. flex_count .gt. 0 )
     :                    call flex_min_radial_dist( IFOLD, INDEX, 
     :                    itemd, gather, num_flex_traces, 
     :                    flex_dist_required, iteme, flex_radial_dist, 
     :                    flex_pointer, flex_lui,
     :                    dstdel, flex_trdist, flex_count, itemi, 
     :                    trdist, LinInd, DphInd, lentrc, off, 
     :                    off_found, radius )
                  
                  endif
               ENDIF

c sort based on trace distance then output gather

               call sort (trdist, ind, INDEX)

               DO 1001 I = 1,INDEX

                  J = ind (i)
                  istrt = (J-1) * lentrc
                  call vmov (gather(istrt+1), 1, DATA2, 1, lentrc)

                  TrcNum           = TrcNum + 1

                  IF (MODE.EQ.5)  GO TO 921

C     +-------------------------------------------------+
C     |        MODE 5 VARIABLES HAVE ALREADY            |
C     |        BEEN SET FOR CDPBCX and CDPBCY           |
C     |        so skip the centroid stuff               |
C     +-------------------------------------------------+

                  call savew2 ( data4, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     1                 ICX / INDEX, TRACEHEADER )
                  call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     1                 ICY / INDEX, TRACEHEADER )

 921              continue

                  call savew2 ( data4, ifmt_FoldNm, l_FoldNm, ln_FoldNm,
     1                 INDEX, TRACEHEADER )
                  call savew2 ( data4, ifmt_RecNum, l_RecNum, ln_RecNum,
     1                 IX, TRACEHEADER )
                  call savew2 ( data4, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     1                 TrcNum, TRACEHEADER )
                  call savew2 ( data4, ifmt_LinInd, l_LinInd, ln_LinInd,
     1                 LinInd, TRACEHEADER )
                  call savew2 ( data4, ifmt_DphInd, l_DphInd, ln_DphInd,
     1                 DphInd, TRACEHEADER )

                  if ( flexbin ) then

c make sure that the flexed traces have the current bin-center information
c as opposed to the bincenter information from their original location.

                     call savew2 ( data4, ifmt_CDPBCX, l_CDPBCX, 
     1                    ln_CDPBCX, CDPBCX, TRACEHEADER )
                     call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, 
     1                    ln_CDPBCY, CDPBCY, TRACEHEADER )
                  endif

                  CALL WRTAPE (LUOUT,DATA2,IBYTES)

 1001          CONTINUE

               IF (INDEX.EQ.IFOLD) GO TO 1299

c note:  if INDEX equals IFOLD then no dead trace padding is required

 1101          INDEX            = INDEX + 1

               if ( nodead .AND. INDEX .eq. 1 ) go to 1301
               
               DO 1201 I = INDEX,IFOLD
                  
                  TrcNum           = TrcNum   + 1
                  call savew2 ( LHEAD4, ifmt_TrcNum, l_TrcNum, 
     :                 ln_TrcNum, TrcNum, TRACEHEADER )
                  call savew2 ( LHEAD4, ifmt_RecNum, l_RecNum, 
     :                 ln_RecNum, IX, TRACEHEADER )
                  call savew2 ( LHEAD4, ifmt_LinInd, l_LinInd, 
     :                 ln_LinInd, LinInd, TRACEHEADER )
                  call savew2 ( LHEAD4, ifmt_DphInd, l_DphInd, 
     :                 ln_DphInd, DphInd, TRACEHEADER )
                  call savew2 ( LHEAD4, ifmt_StaCor, l_StaCor, 
     :                 ln_StaCor, 30000, TRACEHEADER )
                  
                  CALL WRTAPE (LUOUT,LHEAD2,IBYTES)
                  
 1201          CONTINUE
               
 1299          CONTINUE
               
               if (verbos) then
                  write(LERR,*)'Written LI ',LinInd,'  DI ',DphInd,
     1                 '  with ',INDEX,' live traces'
                  write(LER ,*)'Written LI ',LinInd,'  DI ',DphInd,
     1                 '  with ',INDEX,' live traces'
               endif

 1301       CONTINUE

c*******************************************************************

      ELSEIF ( .not. xline .AND. off ) THEN

c*******************************************************************
c feed data up as an offset sorted  volume
c secondary sort is LI
c tertiary sort is DI

         if (line1 .gt. 1) line1 = line1 + 1
         if (di1 .gt. 1) di1 = di1 + 1
         
         write(LERR,*)' '
         write(LERR,*)' Offsets Generated '
         write(LERR,*)' -----------------'
         write(LERR,*)' '

         DO  joff = 1, noff
            
            ICELL  = 0
            ISWAP  = 1
            ICOUNT = 0
            DIINC  = DIINCR
            LIINC  = LININC
            dist   = spread (joff)
            
            write(LERR,*)' sr3d2 Offset = ',dist
            write(LER,*)' sr3d2 Offset = ',dist
            
            DO 1302 IX = RI1, LASTRI, RIINCR
               
               DO  1302 IY = 1, NYOUT
                  
                  
                  IF(ICELL .EQ. 0 .OR. ICOUNT .NE. NY .OR. IRT3D .EQ. 0)
     *                 GO TO 650
                  ICOUNT           = 0
                  ISWAP            =-ISWAP
                  ICELL            = ICELL  + NY - ISWAP
 650              ICELL            = ICELL       + ISWAP
                  ICOUNT           = ICOUNT + 1
                  
                  IF (IX .lt. isli .OR. IY .lt. isdi) go to 1302
                  IF (IX .gt. ieli .OR. IY .gt. iedi) go to 1302
                  
                  DphInd = (IY - 1) * DIINC + DI1
                  LinInd = (IX - 1) * LIINC + LINE1
                  
                  IPTS             = IFL(ICELL)
                  INDEX = 0
                  IF (KOUNT(ICELL).EQ.0) GO TO 1102
                  INDEX            = KOUNT(ICELL)
                  IPTE             = IPTS  - 1 + INDEX
                  J                = 0
                  ICX              = 0
                  ICY              = 0
                  found            = .false.
                  
                  do I = IPTS,IPTE
                     
                     J             = J   + 1
                     lui = parts (I)
                     ipti = i - lstart (lui) + 1
                     call sisseek (lui, ipti)
                     
                     call rtape   (lui, data4, nbytes)
                     
                     call saver2 ( data4, ifmt_DstSgn, l_DstSgn, 
     :                    ln_DstSgn, DstSgn, TRACEHEADER )
                     tdist = abs ( float( DstSgn ) )
                     
                     ioff = intbin (noff, dstdel, spread(1), tdist)
                     
                     if (ioff .eq. joff) then
                        found = .true.
                        go to 1102
                     endif
                     
                  enddo
 1102             continue
                  
                  IF ( flexbin .and. .not. found ) then
                     
c assign offset to search for
                     
                     num_flex_traces = 1
                     flex_dist_required(1) = dist
                     
c if missings offsets have been identified then search adjacent
c bins [see figure] for qualified traces and return the arrays
c 
c flex_radial_dist() --> containing radial distance from current bin
c                        center to  trace
c
c flex_trdist() --> containing source - receiver offset of trace
c
c flex_pointer() --> containing pointer to trace in sr3d2 volume
c
c      |_|_|_|_|_|
c      |_|1|2|3|_|
c      |_|4|x|5|_|
c      |_|6|7|8|_|
c      |_|_|_|_|_|
c
c
c  compute bin center for this bin

                     E = (DBLE(FLOAT(IX)) - 0.5) * DX + DE
                     F = (DBLE(FLOAT(IY)) - 0.5) * DY + DF
                     CDPX  = (F * XY1 - E * YY1) / XYYXXY
                     CDPBCX = nint(CDPX)

                     if ( dabs(YY1) .ge. 0.001 ) then
                        CDPY  = (F - CDPX * YX1) / YY1
                     elseif (XY1 .ne. 0. ) then
                        CDPY = ( E - CDPX * XX1) / XY1
                     endif

                     CDPBCY = nint(CDPY)
                     IYe = NYOUT

                     call flex_get_traces( IX, IY, LASTRI, IYE, ICELL, 
     :                    itemk, KOUNT, num_flex_traces,  
     :                    flex_dist_required, itemu, PARTS, lstart, NX, 
     :                    NY, CDPBCX, CDPBCY, off, dstdel, 
     :                    ifmt_indexx, l_indexx, ln_indexx,
     :                    ifmt_indexy, l_indexy, ln_indexy, 
     :                    ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :                    iteme, flex_radial_dist, flex_pointer, 
     :                    flex_trdist, flex_lui, flex_count, IFL,
     :                    radius )
                     
c search through the candidate traces for those fitting the criteria choosen
c by the user for actual inclusion in the current gather.   The test
c is using minimum radial distance criteria and we are looking for the closest
c trace to the current bin center having an offset that fits with dist required

                     off_found = .false.

                     if ( IX .gt. 1 .and. IX .lt. LASTRI .and. IY .gt. 1
     :                    .and. IY .lt. IYE .and. flex_count .gt. 0 ) 
     :                    then

                        call flex_min_radial_dist ( IFOLD, INDEX, 
     :                      itemd, 
     :                      gather, num_flex_traces, flex_dist_required, 
     :                      iteme, flex_radial_dist, flex_pointer, 
     :                      flex_lui,
     :                      dstdel, flex_trdist, flex_count, itemi, 
     :                      trdist, LinInd, DphInd, lentrc, off, 
     :                      off_found, radius )
                     endif

                     if ( off_found ) then
                        found = .true.
                        call vmov ( gather, 1, data4, 1, lentrc )
                     else
                        found = .false.
                     endif
                     
                  ENDIF

                  DstUsg = nint(dist)

                  if (found) then

c output live trace
                     
                     call savew2 ( data4, ifmt_DstUsg, l_DstUsg, 
     :                    ln_DstUsg, DstUsg, TRACEHEADER )
                     call savew2 ( data4, ifmt_DphInd, l_DphInd, 
     :                    ln_DphInd, DphInd, TRACEHEADER )
                     call savew2 ( data4, ifmt_LinInd, l_LinInd, 
     :                    ln_LinInd, LinInd, TRACEHEADER )
                     call savew2 ( data4, ifmt_RecNum, l_RecNum, 
     :                    ln_RecNum, joff, TRACEHEADER )
                     call savew2 ( data4, ifmt_TrcNum, l_TrcNum, 
     :                    ln_TrcNum, DphInd, TRACEHEADER )
                     
                     if ( flexbin ) then

c make sure that the flexed traces have the current bin-center information
c as opposed to the bincenter information from their original location.

                        call savew2 ( data4, ifmt_CDPBCX, l_CDPBCX, 
     1                       ln_CDPBCX, CDPBCX, TRACEHEADER )
                        call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, 
     1                       ln_CDPBCY, CDPBCY, TRACEHEADER )
                     endif

                     CALL WRTAPE ( luout, data4, ibytes )
                     
                  else

c pad dead trace
                     
                     call savew2 ( LHEAD4, ifmt_DstUsg, l_DstUsg, 
     :                    ln_DstUsg, DstUsg, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_DphInd, l_DphInd, 
     :                    ln_DphInd, DphInd, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_LinInd, l_LinInd, 
     :                    ln_LinInd, LinInd, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_RecNum, l_RecNum, 
     :                    ln_RecNum, joff, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_TrcNum, l_TrcNum, 
     :                    ln_TrcNum, DphInd, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_StaCor, l_StaCor, 
     :                    ln_StaCor, 30000, TRACEHEADER )
                     
                     CALL WRTAPE (LUOUT,LHEAD2,IBYTES)

                  endif

 1302       CONTINUE

         ENDDO

c*******************************************************************

      ELSEIF (xline .AND. off) THEN

c*******************************************************************
c feed data up as an offset sorted volume
c secondary sort is DI
c tertiary sort is LI

         if (line1 .gt. 1) line1 = line1 + 1
         if (di1 .gt. 1) di1 = di1 + 1
         
 
         write(LERR,*)' '
         write(LERR,*)' Offsets Generated '
         write(LERR,*)' -----------------'
         write(LERR,*)' '

         DO  joff = 1, noff
 
            DI2D   = DI1
            LINE2D = LINE1
            ICELL  = 0
            ISWAP  = 1
            ICOUNT = 0
            DIINC  = DIINCR
            LIINC  = LININC
            NTR2D  = 1
            CDP2D  = 1
            dist   = spread (joff)
 
            write(LERR,*)' sr3d2 Offset = ',dist
            write(LER,*)' sr3d2 Offset = ',dist
            
            DO 1303 IY = RI1, LASTRI, RIINCR
               
               DO  1303 IX = 1, NXOUT, 1
                  
                  
                  IF(ICELL .EQ. 0 .OR. ICOUNT .NE. NX .OR. IRT3D .EQ. 0)
     *                 GO TO 651
                  ICOUNT           = 0
                  ISWAP            =-ISWAP
                  ICELL            = ICELL  + NX - ISWAP
 651              ICELL            = ICELL       + ISWAP
                  ICOUNT           = ICOUNT + 1
                  
                  IF (IX .lt. isli .OR. IY .lt. isdi) go to 1303
                  IF (IX .gt. ieli .OR. IY .gt. iedi) go to 1303
                  
                  DphInd = (IY - 1) * DIINC + DI1
                  LinInd = (IX - 1) * LIINC + LINE1
                  
                  IPTS             = IFL(ICELL)
                  INDEX = 0
                  IF (KOUNT(ICELL).EQ.0) GO TO 1103
                  INDEX            = KOUNT(ICELL)
                  IPTE             = IPTS  - 1 + INDEX
                  J                = 0
                  ICX              = 0
                  ICY              = 0
                  found            = .false.
                  
                  do I = IPTS,IPTE
                     
                     J             = J   + 1
                     lui = parts (I)
                     ipti = i - lstart (lui) + 1
                     call sisseek (lui, ipti)
                     
                     call rtape   (lui, DATA2, nbytes)
                     
                     call saver2 ( data4, ifmt_DstSgn, l_DstSgn, 
     :                    ln_DstSgn, DstSgn , TRACEHEADER )
                     tdist = abs ( float( DstSgn ) )

c determine which offset bin this trace resides in.  Remember that in this
c logic a trace belongs to a bin if tdist .le. spread(i), i=1,noff
c which is a little different that the flexbin logic that says the bin
c goes from spread(i) +/- dstdel/2.  I will have to fix this to make this
c routine internally consistent.

                     ioff = intbin (noff, dstdel, spread(1), tdist)
                     
                     if (ioff .eq. joff) then
                        found = .true.
                        go to 1103
                     endif
                     
                  enddo
 1103             continue
                  
                  IF ( flexbin .and. .not. found ) then
                     
c     assign offset to look for
                     
                     num_flex_traces = 1
                     flex_dist_required(1) = dist

c if missings offsets have been identified then search adjacent
c bins [see figure] for qualified traces and return the arrays
c 
c flex_radial_dist() --> containing radial distance from current bin
c                        center to  trace
c
c flex_trdist() --> containing source - receiver offset of trace
c
c flex_pointer() --> containing pointer to trace in sr3d2 volume
c
c      |_|_|_|_|_|
c      |_|1|2|3|_|
c      |_|4|x|5|_|
c      |_|6|7|8|_|
c      |_|_|_|_|_|
c
c
c  compute bin center for this bin

                     E = (DBLE(FLOAT(IX)) - 0.5) * DX + DE
                     F = (DBLE(FLOAT(IY)) - 0.5) * DY + DF
                     CDPX  = (F * XY1 - E * YY1) / XYYXXY
                     CDPBCX = nint(CDPX)

                     if ( dabs(YY1) .ge. 0.001 ) then
                        CDPY  = (F - CDPX * YX1) / YY1
                     elseif (XY1 .ne. 0. ) then
                        CDPY = ( E - CDPX * XX1) / XY1
                     endif

                     CDPBCY = nint(CDPY)
                     IYe = NYOUT

                     call flex_get_traces( IX, IY, LASTRI, IYE, ICELL, 
     :                    itemk, KOUNT, num_flex_traces,  
     :                    flex_dist_required, itemu, PARTS, lstart, NX, 
     :                    NY, CDPBCX, CDPBCY, off, dstdel, 
     :                    ifmt_indexx, l_indexx, ln_indexx,
     :                    ifmt_indexy, l_indexy, ln_indexy, 
     :                    ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :                    iteme, flex_radial_dist, flex_pointer, 
     :                    flex_trdist, flex_lui, flex_count, IFL,
     :                    radius )
                  
c search through the candidate traces for those fitting the criteria choosen
c by the user for actual inclusion in the current gather.   The test
c is using minimum radial distance criteria and we are looking for the closest
c trace to the current bin center having an offset that fits with dist required

                     off_found = .false.

                     if ( IX .gt. 1 .and. IX .lt. LASTRI .and. IY .gt. 1
     :                    .and. IY .lt. IYE .and. flex_count .gt. 0 )
     :                    call flex_min_radial_dist ( IFOLD, INDEX, 
     :                    itemd, 
     :                    gather, num_flex_traces, flex_dist_required, 
     :                    iteme, flex_radial_dist, flex_pointer, 
     :                    flex_lui,
     :                    dstdel, flex_trdist, flex_count, itemi, 
     :                    trdist, LinInd, DphInd, lentrc, off, 
     :                    off_found, radius )

                     if ( off_found) then
                        found = .true.
                        call vmov ( gather, 1, data4, 1, lentrc )
                     else
                        found = .false.
                     endif

                  ENDIF
 
                  DstUsg = nint(dist)

                  if (found) then

c write live trace
 
                     call savew2 ( data4, ifmt_DstUsg, l_DstUsg, 
     :                    ln_DstUsg, DstUsg, TRACEHEADER )
                     call savew2 ( data4, ifmt_DphInd, l_DphInd, 
     :                    ln_DphInd, DphInd, TRACEHEADER )
                     call savew2 ( data4, ifmt_LinInd, l_LinInd, 
     :                    ln_LinInd, LinInd, TRACEHEADER )
                     call savew2 ( data4, ifmt_RecNum, l_RecNum, 
     :                    ln_RecNum, joff, TRACEHEADER )
                     call savew2 ( data4, ifmt_TrcNum, l_TrcNum, 
     :                    ln_TrcNum, LinInd, TRACEHEADER )
                     
                     if ( flexbin ) then

c make sure that the flexed traces have the current bin-center information
c as opposed to the bincenter information from their original location.

                        call savew2 ( data4, ifmt_CDPBCX, l_CDPBCX, 
     1                       ln_CDPBCX, CDPBCX, TRACEHEADER )
                        call savew2 ( data4, ifmt_CDPBCY, l_CDPBCY, 
     1                       ln_CDPBCY, CDPBCY, TRACEHEADER )
                     endif

                     CALL WRTAPE ( luout, data4, ibytes )
                   
                  else

c pad dead trace
 
                     call savew2 ( LHEAD4, ifmt_DstUsg, l_DstUsg, 
     :                    ln_DstUsg, DstUsg, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_DphInd, l_DphInd, 
     :                    ln_DphInd, DphInd, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_LinInd, l_LinInd, 
     :                    ln_LinInd, LinInd, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_RecNum, l_RecNum, 
     :                    ln_RecNum, joff, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_TrcNum, l_TrcNum, 
     :                    ln_TrcNum, LinInd, TRACEHEADER )
                     call savew2 ( LHEAD4, ifmt_StaCor, l_StaCor, 
     :                    ln_StaCor, 30000, TRACEHEADER )
                     
                     CALL WRTAPE ( LUOUT, LHEAD2, IBYTES )
                     
                  endif

 1303       CONTINUE

         ENDDO
      ENDIF

C-----------------------------------------------------------------------
C
C     DO THE ACCOUNTING & CLOSE THE I/O DEVICES
C
C-----------------------------------------------------------------------

 1400 continue

      if ( .not. go ) CALL LBCLOS ( luin )

      if ( .not. stp ) CALL LBCLOS ( luout )
      
      do  i = 1, num_sr3d2_vols
         CALL LBCLOS ( luout1(i) )
      enddo

      close ( lu_sr3d1 )
      
      write (LERR,*) ' Normal Termination'
      write(LER,*) ' sr3d2: Normal Termination'

      close ( LERR )
      stop

 1410 continue

      if ( .not. go ) CALL LBCLOS ( luin )

      if ( .not. stp ) CALL LBCLOS ( luout )
      
      do  i = 1, num_sr3d2_vols
         CALL LBCLOS ( luout1(i) )
      enddo

      close ( lu_sr3d1 )
      
      write (LERR,*) ' Abnormal Termination'
      write(LER,*) ' sr3d2: Abnormal Termination'

      close ( LERR )
      stop
      END
