C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine CosTaper ( x, x1, x2, value, pi, flag )

      integer flag
      real    x, x1, x2, value, pi, arg

c as x goes from x1 to x2 arg goes from 0.0 to pi/2 radians
c cos(arg) goes from 1.0 to 0.0 to provide a cosine taper

      arg = ( ( x2 - x ) / ( x2 - x1 ) ) * ( pi / 2. )

c if flag is 0 then taper down to reject, if flag is 1 then
c taper up to pass

      if ( flag .eq. 0 ) then
         value = cos(arg)
      else
         value = 1.0 - cos(arg)
      endif

c cos**2 suggested by S. Levin so that pass + reject = original

      value = value * value

      return
      end

      
