C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetAzimuth( dkx, dky, pi, Azimuth )

      real dkx, dky, pi, Azimuth

c this routine assumes that North on the untransformed grid is the Y axis
c running along first crossline and East is the X axis running along the
c first inline.
 
      if ( abs(dkx) .lt. 1.0e-30 .and. abs(dky) .lt. 1.0e-30 ) then

c Origin, here the azimuth is undefined but we do NOT want to filter
c out Kx = Ky = 0.0 as we will toast all flat events so lets set the
c Azimuth negative so no azimuthal rejection will be done.

         Azimuth = -999.99

      else

c Want 360-theta, with theta measured counterclockwise from kx axis

         Azimuth = atan2 ( dky, dkx )
         Azimuth = Azimuth  * 180. / pi
         if(Azimuth .lt. 0) Azimuth = Azimuth + 360.
         Azimuth = 360. - Azimuth

      endif

      return
      end
