C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine WGTAVG ( velocity_fcns, MAXVEL, weight, neighborhood, 
     :     MaxNumFunctions, Nfound, nsampo, work, USP_trace,
     :     vel_scalar ) 

      implicit none

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

C     ABSTRACT: perform a weighted average of an array on a neighborhood 
c               of points. 
C 
C                WHERE: velocity_fcns - array containing all input control 
c                                       velocity functions
C                       MAXVEL  -  maximum size of "velocity_fcns" 
C                       weight  -  array of trace weights for neighbor functions
C                       neighborhood  - array of neighbor functions
C                       MaxNumFunctions -  maximum size of "weight" & "neighborhood" 
C                       Nfound - number of neighbors 
C                       nsampo - number of output samples
C                       work - work space array
C                       USP_trace - array to contain output trace
C 

c declare variables passed from calling routine

      integer MAXVEL, MaxNumFunctions, Nfound, nsampo
      integer neighborhood( MaxNumFunctions ) 

      real velocity_fcns( MAXVEL) 
      real weight(MaxNumFunctions) 
      real work( nsampo ), USP_trace( nsampo )
      real vel_scalar

c declare local variables

      integer trndx, J, K

      real SumOfTheWeights

c initialize variables

      call vclr ( work, 1, nsampo )
      call vclr ( USP_trace, 1, nsampo )
      SumOfTheWeights         = 0.0 

C compute the weighted averaged velocity function 
C  2- APPLY THE WEIGHT TO THE VELOCITY FUNCTION 
C  3- SUM THE WEIGHTED VELOCITY FUNCTIONS 

      DO J = 1, Nfound 

C  for every neighbor, get the velocity function from velocity_fcns[]

         trndx = ( neighborhood(J) - 1 ) * nsampo + 1 
         call vmov ( velocity_fcns( trndx ), 1, USP_trace, 1, nsampo )

c  apply the appropriate weight to the velocity function 

         do K = 1, nsampo 
            work(K) = work(K) + ( weight(J) * USP_trace(K) ) 
         enddo

         SumOfTheWeights = weight(J) + SumOfTheWeights 

      ENDDO

C Normalize trace by weights of the contributors and multiply by scalar

      if ( SumOfTheWeights .lt. 1.e-32 ) then
         write(LERR,*)' Sum of Weights found to be zero.  This'
         write(LERR,*)' implies that you have a zero weighted '
         write(LERR,*)' set of velocities being used to create'
         write(LERR,*)' a trace.  This should never happen so'
         write(LERR,*)' the programmer messed up.  Call the'
         write(LERR,*)' USP shop for debug services'
         write(LER,*)'VI3D:'
         write(LER,*)' Sum of Weights found to be zero.  This'
         write(LER,*)' implies that you have a zero weighted '
         write(LER,*)' set of velocities being used to create'
         write(LER,*)' a trace.  This should never happen so'
         write(LER,*)' the programmer messed up.  Call the'
         write(LER,*)' USP shop for debug services'
         write(LER,*)' FATAL'
         stop
      endif

      do J = 1, nsampo 
         USP_trace(J) = vel_scalar * ( work(J) / SumOfTheWeights )
      enddo

      return 
      end 
