C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  vi3d Main Routine -----------------------

c Changes:

c     - fixed bug in Get_Neighbors.F when a condition was set 
c       to see if a velocity was inside the radius.  The condition
c       was .le. which unfortunately ended up creating a zero weight
c       for that trace later.  The zero weight [dist = radius] would
c       cause a zero valued velocity trace and if the only traces
c       found had dist values of radius then the sum of weights used
c       in the denominator of the output trace would be zero.  The test
c       has been changed to .lt. which solved this problem.
c       June 22, 2004 -- Garossino

c     - added -scoping to allow the user to get a quick look at how
c       the interpolation is affected by the choice of -tol[].  This
c       option shuts off the expanding radius search for -num[] 
c       functions within the radius.  It also allows dead traces to 
c       be output where no valid velocity can be interpolated using
c       the current -tol[].  This was asked for by Nick Burke as a way
c       to get a quick visualization of velocity data to go into 
c       Landmark. While I was at it I put a lower limit on -num[]
c       of 3 to make sure that weighing functions etc always work.
c       May 3 2001 -- Garossino
c
c     - changed minLI, maxLI policeman to allow a single LI or DI
c       to be output from the routine.
c       May 3, 2001 -- Garossino
c
c     - added -median option for Steve Johnson to allow a median
c       interpolation of traces within the radius of investigation.
c       He found this useful for interpolating salt bodies with less
c       edge effects.
c       Aug 2000 -- Garossino
c
c     - replaced amneb with a new routine Get_Neighbors which introduces
c       distance weighting based on radius of investigation, velocity
c       scaling, cosine weighting, expanding radius search in the case
c       of no functions found.  The results do not suffer from the tangent
c       circus tent weighting put out by amneb and are much smoother
c       in nature.  I also added -rec1, -trc1, -dtrc and -drec to allow
c       indexing override for RecNum and TrcNum to aid in Landmark 
c       loads of velocity data.  I also added -num and -vs to allow for
c       control over the overall velocity scale and the smoothness of the
c       extrapolated area.  I got rid of -isttrc and -istlin as they 
c       never did anything useful anyway.  I got rid of -avg as the 
c       output was always shitty, one always saw the sampling radius in
c       the time slice output.  A cosine is much better anyway.  
c       Feb 1997 -- Garossino

c     - A complete re-write of the old code.  If you wish to view the old
c       code look in the OldCodeHome under vi3d 
c       Feb 1996 -- Garossino

c get machine dependent parameters 

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsampo, luin, luout, nrec, nreco, ntrc, ntrco, nsi 
      integer     lbytes, obytes, nbytes, lbyout
      integer     argis, jerr

      character   ntap*255, otap*255, name*4, tag*1

      logical     verbos

c variables used with dynamic memory allocation

      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, errcd7
      integer errcd8, errcd9, errcd10, errcd11, errcd12, errcd13
      integer errcd14, abort
      integer X_pointer, Y_pointer, neighborhood
 
      real velocity, time_depth, USP_trace, velocity_fcns, sample
      real work, X, Y, weight, X_sorted, Y_sorted

      pointer ( mem_velocity, velocity(1) )
      pointer ( mem_time_depth, time_depth(1) )
      pointer ( mem_USP_trace, USP_trace(1) )
      pointer ( mem_X, X(1) )
      pointer ( mem_Y, Y(1) )
      pointer ( mem_velocity_fcns, velocity_fcns(1) )
      pointer ( mem_sample, sample(1) )
      pointer ( mem_X_pointer, X_pointer(1) )
      pointer ( mem_Y_pointer, Y_pointer(1) )
      pointer ( mem_neighborhood, neighborhood(1) )
      pointer ( mem_work, work(1) )
      pointer ( mem_weight, weight(1) )
      pointer ( mem_X_sorted, X_sorted(1) )
      pointer ( mem_Y_sorted, Y_sorted(1) )

c dimension local variables

      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer LinInd, ifmt_LinInd, l_LinInd, ln_LinInd
      integer DphInd, ifmt_DphInd, l_DphInd, ln_DphInd
      integer StaCor, ifmt_StaCor, l_StaCor, ln_StaCor

      integer MaxNumElements, MaxNumFunctions, MAXVEL
      integer minLI, maxLI, minDI, maxDI
      integer npairs, nfunc, le1, done, LI, DI, LIincr, DIincr 
      integer trace_length, trndx, JJ, KK, gamma_scaler
      integer TrcNum_start, RecNum_start
      integer delta_RecNum, delta_TrcNum
      integer min_num_desired, lenth, i

      real tol, vel_scalar, exponent, cell_X, cell_Y, si

      logical tdfn, EOF_error, gamma, Cosine, median, scoping

c following can be turned on again to trip on bad math
c      integer ieee_handler
c      external invkill
c      integer ieeer

c Initialize variables

      data name/"VI3D"/
      data done/1/
      data nfunc/0/
      data LIincr/1/
      data DIincr/1/
      data EOF_error/.false./
      data abort/0/
      data gamma/.false./

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c      ieeer = ieee_handler('set','invalid',invkill)
c      if (ieeer .ne. 0) then
c        write(LER,*) 'Unable to set IEEE trap; abort'
c 	stop 100
c      endif

#include <f77/open.h>

c get command line input parameters

      call cmdln ( trace_length, nsi, otap, ntap, cell_X, cell_Y, minLI,
     :     minDI, maxLI, maxDI, LIincr, DIincr, tol, tdfn, name, 
     :     TrcNum_start, RecNum_start, delta_TrcNum, delta_RecNum, 
     :     Cosine, min_num_desired, vel_scalar, exponent, median, 
     :     scoping, verbos )

c policeman: if -num[] has been chosen less than 3 then set it to 3
c            otherwise median calculations etc. down the road all fail
c
      if ( min_num_desired .lt. 3 ) then

         min_num_desired = 3

         write(LERR,*)' -num[] less than three has been reset to 3'
         write(LERR,*)' this is necessary to allow interpolation '
         write(LERR,*)'WARNING'
         write(LER,*)'VI3D:'
         write(LER,*)' -num[] less than three has been reset to 3'
         write(LER,*)' this is necessary to allow interpolation '
         write(LER,*)'WARNING'

      endif

      IF ( tdfn ) then

c open input tdfn file [cannot be a pipe stream because we have
c to check for presence of 1MC3D card.

         call alloclun(luin)
         le1 = lenth(ntap)
         open ( luin, file=ntap(1:le1), status='old', err=990 )

c----
c   if "G" is on the first line of the TDFN file then the data
c   are gamma's [ gamma = Vold / Vnew ] from MBS
c----
         read (luin, '(a1)') tag
         if (tag .eq. 'G') then
            gamma = .true.
            gamma_scaler = 1000
         else
            rewind luin
            gamma_scaler = 1
         endif
         si = nsi

c determine global volume parameters for output

         if ( nsi .eq. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' You must specify an output sample interval'
         write(LERR,*)' Correct command line for -dt and resubmit job'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VI3D: '
         write(LER,*)' You must specify an output sample interval'
         write(LER,*)' Correct command line for -dt and resubmit job'
         write(LER,*)'FATAL'
         goto 999
         endif

         if ( trace_length .eq. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' You must specify an output trace length'
         write(LERR,*)' Correct command line for -e and resubmit job'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VI3D: '
         write(LER,*)' You must specify an output trace length'
         write(LER,*)' Correct command line for -e and resubmit job'
         write(LER,*)'FATAL'
         goto 999
         endif

c check to see if  1MC3D card is present.  If so then get any parameters
c not already input on the command line.  Remember command line
c parameterization overrides anything present on the 1MC3D card.

         call Read_MC3D ( luin, minLI, maxLI, minDI, maxDI, LIincr, 
     :        DIincr, tol, cell_Y, cell_X, MaxNumElements, 
     :        MaxNumFunctions , gamma, si)


         nsampo = trace_length / nsi + 1

      ELSE
         
c the input is a USP velocity dataset that may or may not be on
c a pipe

         call getln ( luin, ntap, 'r', 0 )

c read the input line header
         
         lbytes = 0
         call rtape ( luin, itr, lbytes )
         if(lbytes.eq.0)then
            write(LER,*)'VI3D: no line header on input dataset',ntap
            write(LER,*)'FATAL'
            stop
         endif

c glean input nrec, ntrc and global nsampo and nsi from input line header

         call saver ( itr, 'NumRec', nrec, LINEHEADER )
         call saver ( itr, 'NumTrc', ntrc, LINEHEADER )
         call saver ( itr, 'NumSmp', nsampo, LINEHEADER )
         call saver ( itr, 'SmpInt', nsi, LINEHEADER )

         trace_length = ( nsampo - 1 ) * nsi

      ENDIF

c open output file

      call getln(luout, otap,'w', 1)

c Policemen
c test to make sure there is enough information to continue at this point
 
      if ( minLI .gt. maxLI .or. minDI .gt. maxDI ) then
         write(LERR,*)' '
         write(LERR,*)' LI and DI limits do not make sense'
         write(LERR,*)' Correct command line or 1MC3D card '
         write(LERR,*)' and resubmit job'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VI3D:  LI and DI limits do not make sense'
         write(LER,*)'       Correct command line or 1MC3D card '
         write(LER,*)'       and resubmit job'
         write(LER,*)'FATAL'
         goto 999
      endif
      
      if ( abs(tol) .lt. 1.e-30 ) then
         write(LERR,*)' '
         write(LERR,*)' Interpolation radius cannot be zero'
         write(LERR,*)' Correct command line or 1MC3D card '
         write(LERR,*)' and resubmit job'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VI3D:  Interpolation radius cannot be zero'
         write(LER,*)'       Correct command line or 1MC3D card '
         write(LER,*)'       and resubmit job'
         write(LER,*)'FATAL'
         goto 999
      endif

      if ( abs(cell_X) .lt. 1.e-30  .or. abs(cell_Y) .lt. 1.e-30  ) then
         write(LERR,*)' '
         write(LERR,*)' You must specify the cell dimensions in x and y'
         write(LERR,*)' Correct command line or 1MC3D card for cellx '
         write(LERR,*)' and celly and resubmit job'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VI3D: '
         write(LER,*)'  You must specify the cell dimensions in x and y'
         write(LER,*)'  Correct command line or 1MC3D card for cellx '
         write(LER,*)'  and celly and resubmit job'
         write(LER,*)'FATAL'
         goto 999
      endif

      if ( nsi .eq. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' You must specify an output sample interval'
         write(LERR,*)' Correct command line for -dt and resubmit job'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VI3D: '
         write(LER,*)' You must specify an output sample interval'
         write(LER,*)' Correct command line for -dt and resubmit job'
         write(LER,*)'FATAL'
         goto 999
      endif

      if ( trace_length .eq. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' You must specify an output trace length'
         write(LERR,*)' Correct command line for -e and resubmit job'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VI3D: '
         write(LER,*)' You must specify an output trace length'
         write(LER,*)' Correct command line for -e and resubmit job'
         write(LER,*)'FATAL'
         goto 999
      endif

      if ( RecNum_start .ne. -9999  .or. TrcNum_start .ne. -9999 ) then
         if ( TrcNum_start .eq. -9999 .or. RecNum_start .eq. -9999 )then
            write(LERR,*)' '
            write(LERR,*)' If you wish to renumber the output RecNum'
            write(LERR,*)' and TrcNum entries you must specify on the'
            write(LERR,*)' command line BOTH -trc1 AND -rec1.  You '
            write(LERR,*)' have only specified one of these.  correct'
            write(LERR,*)' your command line and resubmit'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VI3D: '
            write(LER,*)' If you wish to renumber the output RecNum'
            write(LER,*)' and TrcNum entries you must specify on the'
            write(LER,*)' command line BOTH -trc1 AND -rec1.  You '
            write(LER,*)' have only specified one of these.  correct'
            write(LER,*)' your command line and resubmit'
            write(LER,*)'FATAL'
            goto 999
         endif
      endif

      if ( LIincr .eq. -9999 ) LIincr = 1
      if ( DIincr .eq. -9999 ) DIincr = 1

c dynamic memory allocation

      if ( .not. tdfn ) then
         MaxNumElements = nsampo
         MaxNumFunctions = nrec * ntrc
      endif

      call galloc ( mem_velocity, MaxNumElements * SZSMPD, errcd1, 
     :     abort )
      call galloc ( mem_time_depth, MaxNumElements * SZSMPD, errcd2, 
     :     abort )
      call galloc ( mem_USP_trace, nsampo * SZSMPD, errcd3, abort )
      call galloc ( mem_X, MaxNumFunctions * SZSMPD, errcd4, abort )
      call galloc ( mem_Y, MaxNumFunctions * SZSMPD, errcd5, abort )
      call galloc ( mem_velocity_fcns, MaxNumFunctions * nsampo*SZSMPD, 
     :     errcd6, abort )
      call galloc ( mem_sample, nsampo * SZSMPD, errcd7, abort )
      call galloc ( mem_X_pointer, MaxNumFunctions * SZSMPD, errcd8, 
     :     abort )
      call galloc ( mem_Y_pointer, MaxNumFunctions * SZSMPD, errcd9, 
     :     abort )
      call galloc ( mem_neighborhood, MaxNumFunctions * SZSMPD, errcd10, 
     :     abort )
      call galloc ( mem_work, nsampo * SZSMPD, errcd11, abort )
      call galloc ( mem_weight, MaxNumFunctions * SZSMPD, errcd12, 
     :     abort )
      call galloc ( mem_X_sorted, MaxNumFunctions * SZSMPD, errcd13, 
     :     abort )
      call galloc ( mem_Y_sorted, MaxNumFunctions * SZSMPD, errcd14, 
     :     abort )

c verify that memory was available

      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 .or.
     :     errcd10 .ne. 0 .or.
     :     errcd11 .ne. 0 .or.
     :     errcd12 .ne. 0 .or.
     :     errcd13 .ne. 0 .or.
     :     errcd14 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2 * MaxNumElements * SZSMPD, '  bytes'
         write(LERR,*) 3 * nsampo * SZSMPD, '  bytes'
         write(LERR,*) 8 * MaxNumFunctions * SZSMPD, '  bytes'
         write(LERR,*) nsampo * MaxNumFunctions * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2 * MaxNumElements * SZSMPD, '  bytes'
         write(LER,*) 3 * nsampo * SZSMPD, '  bytes'
         write(LER,*) 8 * MaxNumFunctions * SZSMPD, '  bytes'
         write(LER,*) nsampo * MaxNumFunctions * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2 * MaxNumElements * SZSMPD, '  bytes'
         write(LERR,*) 3 * nsampo * SZSMPD, '  bytes'
         write(LERR,*) 8 * MaxNumFunctions * SZSMPD, '  bytes'
         write(LERR,*) nsampo * MaxNumFunctions * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif
           
c initialize memory [velocity, time_depth and USP_trace initialized at each read]

      MAXVEL = MaxNumFunctions * nsampo
         
      call vclr ( sample, 1, nsampo )
      call vclr ( velocity_fcns, 1, MAXVEL )
      call vclr ( X, 1, MaxNumFunctions )
      call vclr ( Y, 1, MaxNumFunctions )
      call vclr ( weight, 1, MaxNumFunctions )
      call vclr ( X_sorted, 1, MaxNumFunctions )
      call vclr ( Y_sorted, 1, MaxNumFunctions )
      call vclr ( work, 1, nsampo )

      do i = 1, MaxNumFunctions
         X_pointer(i) = 0
         Y_pointer(i) = 0
         neighborhood(i) = 0
      enddo

c define required trace header pointers

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)

c print historical line header to printout file if input is a USP dataset

      if ( .not. tdfn ) call hlhprt ( itr, lbytes, name, 4, LERR )

c number output bytes

      obytes = SZTRHD + SZSMPD * nsampo 

c create an output line header 

      ntrco = nint ( float (maxDI - minDI)/ float(DIincr) ) + 1
      nreco = nint ( float (maxLI - minLI)/ float(LIincr) ) + 1 

      call savew( itr, 'NumTrc', ntrco  , LINHED)
      call savew( itr, 'NumRec', nreco  , LINHED)
      call savew( itr, 'SmpInt',  nsi   , LINHED)
      call savew( itr, 'NumSmp', nsampo , LINHED)
      call savew( itr, 'Format',   3    , LINHED)
      call savew( itr, 'T_Unit', gamma_scaler , LINHED)

      if ( tdfn ) then

c must build historical line header from scratch if VDS3D input
         
         lbytes = HSTOFF
         nbytes = 2 * SZHFWD
         call savew( itr, 'HlhEnt',  0   , LINHED)
         call savew( itr, 'HlhByt', nbytes , LINHED)
      endif

c update historical line header for current command line entry

      call savhlh( itr, lbytes, lbyout )

c write output line header

      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, minLI, maxLI, minDI, maxDI, LIincr, 
     :     DIincr, tol, cell_Y, cell_X, tdfn, nsi, trace_length, 
     :     nrec, ntrc, nsampo, verbos , gamma, TrcNum_start,
     :     RecNum_start, delta_TrcNum, delta_RecNum, Cosine, 
     :     min_num_desired, vel_scalar, exponent, median, scoping )

c convert scalar from percentage to scalar quantity

      vel_scalar = vel_scalar / 100.

c BEGIN PROCESSING

      IF ( tdfn ) then
 
c start by reading in all the TDFN data and building a USP trace database 
c in velocity_fcns[] array containing the basic traces to be used in the
c interpolation.  The coordinates for each trace are stored in the 
c X[] and Y[] arrays.

         if ( verbos ) then
            write(LERR,*) ' '
            write(LERR,*) ' Input Velocity Functions '
            write(LERR,*) ' -------------------------'
         endif

         do while ( done .eq. 1 )
            
            call vclr ( velocity, 1, MaxNumElements )
            call vclr ( time_depth, 1, MaxNumElements )
            call vclr ( USP_trace, 1, nsampo )

c read a single function location

            call Read_TDFN ( luin, MaxNumElements, npairs, velocity, 
     :           time_depth, LI, DI, verbos , gamma, si)

            if ( npairs .ne. 0 ) then

c if there were velocity entries for this location then build a USP
c trace and store it in velocity_fcns[] with the function coordinates
c stored in X[] and Y[]

               nfunc = nfunc + 1

               call vi3d1 (minLI, minDI, cell_X, cell_Y, LI, DI, 
     :              X, Y, MaxNumFunctions, time_depth, velocity, npairs, 
     :              USP_trace, MAXVEL, nsampo, nsi, velocity_fcns, 
     :              nfunc )

            else

c have reached the end of the input functions

               done = 0
            endif

         enddo

      ELSE

c input is USP velocity trace dataset. Load all traces to velocity_fcns[]
c with DphInd contributing to X[] and LinInd contributing to Y[] coordinate
c arrays

         trndx = 1 - nsampo

         do JJ = 1, nrec
            do KK = 1, ntrc
               
               lbytes = 0
               call rtape ( luin, itr, lbytes )
               if ( lbytes .eq. 0 ) then
                  write(LERR,*)' Premature EOF on input USP Velocity 
     :                 dataset '
                  write(LERR,*)' WARNING'
                  EOF_error = .true.
               endif
               
               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
               call saver2( itr, ifmt_LinInd, l_LinInd, ln_LinInd, 
     :              LinInd, TRACEHEADER )
               call saver2( itr, ifmt_DphInd, l_DphInd, ln_DphInd, 
     :              DphInd, TRACEHEADER )

c read in live traces only

               if ( StaCor .ne. 30000 ) then
                  
                  trndx = trndx + nsampo
                  nfunc = nfunc + 1

c load input function to global database                  

                  call vmov ( itr(ITHWP1), 1, velocity_fcns(trndx), 1, 
     :                 nsampo )
                  
c compute a relative coordinate for a given LI, DI

                  X(nfunc) = cell_X * float( DphInd - minDI )
                  Y(nfunc) = cell_Y * float( LinInd - minLI )

               endif
            enddo
         enddo

      ENDIF

c do the interpolation and output the interpolated volume.  Control will
c only return to this routine upon completion.

      call vi3d2 ( minLI, maxLI, LIincr, minDI, maxDI, DIincr, 
     :     cell_X, cell_Y, tol, X, Y, X_pointer, Y_pointer, obytes,
     :     weight, neighborhood, MaxNumFunctions, work, USP_trace, 
     :     sample, nfunc , velocity_fcns, MAXVEL, luout, nsi, nsampo,
     :     ifmt_RecNum, l_RecNum, ln_RecNum,
     :     ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :     ifmt_LinInd, l_LinInd, ln_LinInd,
     :     ifmt_DphInd, l_DphInd, ln_DphInd,
     :     ifmt_StaCor, l_StaCor, ln_StaCor, exponent,
     :     TrcNum_start, RecNum_start, delta_TrcNum, delta_RecNum, 
     :     vel_scalar, X_sorted, Y_sorted, Cosine, min_num_desired,
     :     median, scoping )
  
c processing complete, check for errors and close all files

      if ( EOF_error ) goto 999

c Normal Termination

      if ( tdfn ) then
         close ( luin )
      else
         call lbclos ( luin )
      endif
      call lbclos ( luout )
      write(LERR,*)'vi3d: Normal Termination'
      write(LER,*)'vi3d: Normal Termination'
      stop

 990  continue

      write(LERR,*)' '
      write(LERR,*)' Cannot open input velocity function file ',
     :     ntap(1:le1)
      write(LERR,*)' Check spelling / existence and try again'
      write(LERR,*)' FATAL'
      write(LER,*)' '
      write(LER,*)' VI3D: Cannot open input velocity function file ',
     :     ntap(1:le1)
      write(LER,*)'       Check spelling / existence and try again'
      write(LER,*)' FATAL'
      stop
 999  continue

      if ( tdfn ) then
         close ( luin )
      else
         call lbclos ( luin )
      endif
      call lbclos ( luout )
      write(LERR,*)'vi3d: ABNORMAL Termination'
      write(LER,*)'vi3d: ABNORMAL Termination'
      stop
      end
c following can be uncommented if we need to turn the event
c handler on again
c      integer function invkill(sig,code,sigcontext)
c      integer sig,code,sigcontext(5)
c      write(LER,*) 'Invalid: ieee exception code ',loc(code)
c      call abortfu()
c      stop 100
c      end
