C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c----
c   routine to read bfile format velocity functions and convert
c   them using their XY position into TDFN cards suitable for
c   vi3d
c----
      subroutine bfile (luin, luout, ivel, itim, IX1, IY1,
     1                  XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                  DX, DY, NDI, NLI, minli, maxli,
     3                  mindi, maxdi, tt, vv, key, itmp, 
     4                  scl, tscl, itmax, verbos)

#include <f77/iounit.h>

      integer     itim (*), ivel (*), key (*), itmp (*)
      real        tt (*), vv (*)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     minli, maxli, mindi, maxdi, li, di
      character   card * 80, tag * 4
      character   tard * 80, c1 * 1, c2 * 1
      logical     verbos

c----
c   set up constants for TDFN cards
c----
      tag = 'TDFN'
      ir0 = 0
      ir1 = 1
      i9  = 9

C**********************************************************************C
C     read input vel file until the end
C**********************************************************************C
      nf = 0
 
c----
c   read every line in input velocity file. Check for EOF and if so
c   make sure we have at least 1 valid function, otherwise emit error
c   message
c----
      DO while (1.eq.1)
 
         read (luin, '(a80)', end=10, err=666) card
c----
c   As we read each card we find any blank offset and use this as a
c   pointer offset into the card field
c----
         ib = 0
         do  i = 1, 80
             if (card(i:i) .eq. ' ') then
                ib = ib + 1
             else
                go to 1
             endif
         enddo
1        continue

c----
c   jump around EOF messages
c----
         go to 12
10       continue
 
         if (nf .gt. 0) then
            write (LERR,*)'bfile format input file:'
            write (LERR,*)'Hit end of file finding ',nf,' functions'
            go to 999
         else
            write(LERR,*)'FATAL ERROR in vi3din bfile format:'
            write(LERR,*)'Found no functions. Check input file format'
            go to 999
         endif
 
12       continue
 
c----
c   If a card begins with 'sp' it contains XY info and is the start of
c   the next function
c----
         IF (card(1+ib:3+ib) .eq. 'col') THEN

c----
c   Increment function counter. Then check for the first occurrence of
c   either an X or a Y. Starting from this point in the card field copy
c   the remaining columns to another character vector to simplify reading
c   the XY fields with fsscnf.
c   Accomodate possible order switching of XYs and extract XY into. If
c   there's not XY into branch to error messages.
c----
            nf = nf + 1
            ip = 0
            do  i = 1, 80

                if (card(i:i) .eq. 'x' .OR. card(i:i) .eq. 'y') then
                    ip = i
                    il = 0
                    do  ii = i, 80
                        il = il + 1
                        tard (il:il) = card (ii:ii)
                    enddo
                    call fsscnf (tard,'%s %d %s %d'//char(0),
     1                 c1,iv1,c2,iv2)
                    if (c1 .eq. 'x' .AND. c2 .eq. 'y') then
                       ICX = iv1
                       ICY = iv2
                    elseif (c1 .eq. 'y' .AND. c2 .eq. 'y') then
                       ICX = iv2
                       ICY = iv1
                    else
                       go to 13
                    endif
                    go to 14
                endif
            enddo
13          continue

            write(LERR,*)'FATAL ERROR in vi3din bfile format:'
            write(LERR,*)'Unable to locate X or Y coords for function '
            write(LERR,*)nf,' Check this function in input file.'
            go to 999
 
14          continue

c----
c   XY info looks ok. Determine if the XY point is within the survey
c   boundaries. If not then go read input to start of next function.
c----
            CX = ICX * scl
            CY = ICY * scl
            IWRN = 0
            CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                   IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, NDI, NLI)
 
            IF (LI .LT. MINLI) IWRN = 1
            IF (LI .GT. MAXLI) IWRN = 1
            IF (DI .LT. MINDI) IWRN = 1
            IF (DI .GT. MAXDI) IWRN = 1

            if (IWRN .eq. 1) then
            write(LERR,*)'Function located at ',ICX,ICY,' out of bounds'
            else
            write(LERR,*)'Function located at ',ICX,ICY,' inside box'
            endif


            if (IWRN .eq. 1) go to 100

c----
c   Current function lies within survey boundaries.
c----
            if = 1

            do while (1.eq.1)

               read (luin, '(a80)', end=15, err=666) card
               go to 16

c----
c   If this is not the last function then press on...
c----
15             continue

c----
c   If this is the last function then set the character trigger for
c   end of function
c----
               if (if .gt. 1) then
                  card(1+ib:3+ib) = 'row'
               else
                  go to 10
               endif

16             continue

c----
c   Within the current function we take each card and extract the T-V
c   pairs, putting them in vectors tt & vv (the pointer "if" keeps
c   increasing within function gline)
c----
               if (card(1+ib:1+ib) .eq. 't') then

                  call gline (card, if, tt, vv)

c----
c   The end of the current function has been found. Repack T-V pairs
c   into integer arrays. Then determine the number of 7-column TDFN
c   cards needed and pack T-V pairs into them. Write them out.
c----
               elseif (card(1+ib:3+ib) .eq. 'row') then

                  if = if - 1
                  iff = 0
                  do  i = 1, if
                      itimi = nint (tscl * tt(i))
                      if (itimi .lt. itmax .AND. vv(i) .gt. 0) then
                         iff = iff + 1
                         ivel (iff) = nint (vv(iff))
                         itim (iff) = itimi
                      endif
                  enddo
                  if = iff
                  call sort (itim, key, if)
                  do  i = 1, if
                      itmp (i) = ivel (key(i))
                  enddo
                  do  i = 1, if
                      ivel (i) = itmp (i)
                  enddo

                  xcards = float (if) / 7.0
                  ncards = ifix  (xcards - .001)
                  left = if - 7 * ncards
                  i1 = 7 * ncards + left + 1
                  i2 = 7 * (ncards + 1) 
                  do  i = i1, i2
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
    
                  write (luout,555) ir0, tag, li, di
555               format (i1, a4, 2i5)
 
                  ih = -7
                   itag = 0
                  if (ncards .gt. 0) then
                     do  i = 1, ncards
                         itag = itag + 1
                         if (itag .ge. 9) itag = 1
                         ih = (i-1) * 7
                         write (luout,777) itag, tag,
     1                   (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
                     enddo
                  endif
                  ih = ih + 7
                  write (luout,777) i9, tag,
     1            (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
777               format (i1, a4, 7(I4,I5), 7X, I5)
 
c----
c   Initialize T-V and character arrays for next function then
c   jump out of loop which reads a function to the loop that
c   looks for next function.
c----
                  do  i = 1, if
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
                  do  i = 1, 80
                      card (i:i) = ' '
                  enddo

                  go to 100

               endif
              
            enddo

         ENDIF
         
100      CONTINUE
 
      ENDDO

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din bfile reader:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nf,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din bfile reader:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nf,' line was:',card
 
999   continue

      return
      end
