C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine virfvds (luin, luout, ivel, itim, minli, maxli,
     1                    mindi, maxdi, key, itmp, verbos, scl,
     2                    tscl, itmax)

#include <f77/iounit.h>

      integer     itim (*), ivel (*), key (*), itmp (*)
      integer     minli, maxli, mindi, maxdi, li, di
      integer     lilast, dilast
      character   card * 80, tag * 4, clim * 40
      logical     verbos,got,EOF

      tag = 'TDFN'
      ir0 = 0
      ir1 = 1
      i9  = 9

C**********************************************************************C
C     read input vel file
C**********************************************************************C
      lilast = 0
      dilast = 0
      mf = 0
      if = 0
      nf = 0
      got = .false.
 
      DO while (1.eq.1)
 
         read (luin, '(a80)', end=10, err=666) card
 
         go to 11
10       continue

         if (if .gt. 0) then
            got = .true.
            EOF = .true.
            IWRN = 0
            IF (lilast .LT. MINLI) IWRN = 1
            IF (lilast .GT. MAXLI) IWRN = 1
            IF (dilast .LT. MINDI) IWRN = 1
            IF (dilast .GT. MAXDI) IWRN = 1
            go to 12
         elseif (nf .eq. 0) then
            go to 667
         endif

11        continue

         if (card(1:5) .eq. 'VIRF1') then

             mf = mf + 1
             got = .true.
             read (card,101) LI, DI
101          format(36x,i5,1x,i5)

             IWRN = 0
             IF (lilast .LT. MINLI) IWRN = 1
             IF (lilast .GT. MAXLI) IWRN = 1
             IF (dilast .LT. MINDI) IWRN = 1
             IF (dilast .GT. MAXDI) IWRN = 1
 
             nf = nf + 1
             if (mf .gt. 1) then
                 got = .true.
                 go to 12
             endif

         elseif (card(1:5) .eq. 'VIRF6') then

             got = .false.
             if = if + 1
             if (if .eq. 1) then
                lilast = li
                dilast = di
             endif
             call fsscnf (card,'%s %d %d'//char(0), clim, itt, ivv)
             itim (if) = nint ( scl * float(itt) )
             ivel (if) = nint ( scl * float(ivv) )

         endif

12       continue

         if (got .AND. IWRN .eq. 1) then
            do  i = 1, if
                itim (i) = 0
                ivel (i) = 0
            enddo
            if = 0
            got = .false.
            if ( EOF ) go to 999
         endif

            IF (got) THEN
 
c----
c   for completed valid function:
c   sort in case times are not in ascending order
c----
               if ( if .gt. 1) then

                  iff = 0
                  do  i = 1, if
                      itimi = nint (tscl * itim(i))
                      if (itimi .lt. itmax .AND. ivel(i) .gt. 0) then
                         iff = iff + 1
                         ivel (iff) = ivel (i)
                         itim (iff) = itimi
                      endif
                  enddo
                  if = iff
                  call sort (itim, key, if)
                  do  i = 1, if
                      itmp (i) = ivel (key(i))
                  enddo
                  do  i = 1, if
                          ivel (if) = itmp (if)
                  enddo

c----
c   build TDFN input for vi3d
c----
                  xcards = float (if) / 7.0
                  ncards = ifix  (xcards - .001)
                  left = if - 7 * ncards
                  i1 = 7 * ncards + left + 1
                  i2 = 7 * (ncards + 1) 
                  do  i = i1, i2
                      itim (i) = 0
                      ivel (i) = 0
                  enddo

    
                  write (luout,555) ir0, tag, lilast, dilast
555               format (i1, a4, 2i5)
 
                  ih = -7
                  itag = 0
                  if (ncards .gt. 0) then
                     do  i = 1, ncards
                         itag = itag + 1
                         if (itag .ge. 9) itag = 1
                         ih = (i-1) * 7
                         write (luout,777) itag, tag,
     1                   (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
                     enddo
                  endif
                  ih = ih + 7
                  write (luout,777) i9, tag,
     1            (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
777               format (i1, a4, 7(I4,I5), 7X, I5)
 
c----
c   clear velocity & time arrays. If this is really the last function
c   then we don't want to jump up to read another card - we need to exit
c----
                  do  i = 1, if
                      itim (i) = 0
                      ivel (i) = 0
                      key  (i) = 0
                  enddo
                  if = 0
                  got = .false.
                  if (EOF) go to 999
 
               endif

            ENDIF

      ENDDO

      if (nf .eq. 0) go to 667

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din virf option:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nf,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din virf option:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nf,' line was:',card

      go to 999
 
667   continue
 
      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din virf option:'
      write(LERR,*)'Yikes! no valid functions read from file. Check'
      write(LERR,*)'to see if corner coords are correct; check XYs'
      write(LERR,*)'in input file; is each funtion together not'
      write(LERR,*)'scattered throughout input file?'
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din virf option:'
      write(LER ,*)'Yikes! no valid functions read from file. Check'
      write(LER ,*)'to see if corner coords are correct; check XYs'
      write(LER ,*)'in input file; is each funtion together not'
      write(LER ,*)'scattered throughout input file?'

 
999   continue

      return
      end
