C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs some arcane geophysical process
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     lhed ( SZLNHD )
      integer     itr  ( SZLNHD )
      real        head ( SZLNHD )

      integer     nsamp, nsi, ntrc, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
 
c  dynamic memory allocation for big arrays, eg whole records
      real        velin(SZLNHD), velout(SZLNHD)
      real        timin(SZLNHD)
      integer     line, trace, nvels
      pointer     (wkadrl, line (1))
      pointer     (wkadrt, trace(1))
      pointer     (wkadrn, nvels(1))
      real        time, vels
      pointer     (wktime, time (1))
      pointer     (wkvels, vels (1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      real        vmin, vmax, timn, timx
      integer     linmin, linmax, trcmin, trcmax
      integer     tmax, tmin, tlast
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      character   ntap * 256, otap * 256, name*11
      character   card * 80, tagr * 3, tagc * 3, tagi * 1
      character   tago * 1
      logical     verbos, query, heap, zero, bfile
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'ZMAPVEL2SIS'/
      data tagi/'R'/,  tago/'R'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,
     1             vmin,vmax,nsi,verbos,zero,
     2             timn,timx,floor, ceil, bfile, tagi, tago)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      if (ntap(1:1) .eq. ' ') then
          luin = LIN
      else
          luin = 57
      endif
      open (unit=luin, file=ntap, status='old',iostat=ierr)
 
       if (ierr .ne. 0) then
          write(LERR,*)'zmapvel2sis: Fatal Error...'
          write(LERR,*)'Could not open ZMAP sorted file ',otap
          write(LERR,*)'Check existence'
          write(LER ,*)'zmapvel2sis: Fatal Error...'
          write(LER ,*)'Could not open ZMAP sorted file ',otap
          write(LER ,*)'Check existence'
          stop
       endif

       nent = 0
       rewind luin

       IF (bfile) THEN

          nfunc = 0
          do  while (1.eq.1)
              read (luin,'(a80)',end=7,err=997) card
              if (card(2:4) .eq. 'row') nfunc = nfunc + 1
              if (card(2:2) .eq. 't') then
                  nc = 0
                  do  ii = 1, 80
                      if (card(ii:ii) .eq. 't') nc = nc + 1
                  enddo
                  nent = nent + nc
              endif
          enddo
          go to 7

997       continue
          write(LERR,*)'zmapvel2sis: Fatal Error...'
          write(LERR,*)'Error reading ZMAP bfile file ',otap
          write(LERR,*)'Check to make sure it is compete'
          write(LER ,*)'zmapvel2sis: Fatal Error...'
          write(LER ,*)'Error reading ZMAP bfile file ',otap
          write(LER ,*)'Check to make sure it is compete'
          stop

7         continue
          write(LER ,*)'number functions in file= ',nfunc

       ELSE

          do  while (1.eq.1)
              read (luin,'(a80)',end=9,err=998) card
              nent = nent + 1
              call fsscnf (card,'%f %f %f %f'//char(0),
     1            dum1, dum2, dum3, dum4)
          enddo
          go to 9

998       continue
          write(LERR,*)'zmapvel2sis: Fatal Error...'
          write(LERR,*)'Error reading ZMAP sorted file ',otap
          write(LERR,*)'Check to make sure it is compete'
          write(LER ,*)'zmapvel2sis: Fatal Error...'
          write(LER ,*)'Error reading ZMAP sorted file ',otap
          write(LER ,*)'Check to make sure it is compete'
          stop

9         continue

       ENDIF
       write(LER ,*)'number functions in file= ',nent
c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      items = (nent+1)  * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
c--------
 
      call galloc (wkadrl, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heap = .false.
      call galloc (wkadrt, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heap = .false.
      call galloc (wktime, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heap = .false.
      call galloc (wkvels, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heap = .false.
 
 
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) items,'  bytes'
         write(LER ,*) items,'  bytes'
         write(LER ,*) items,'  bytes'
         write(LER ,*) items,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------


       linmin =  9999999
       linmax = -9999999
       trcmin =  9999999
       trcmax = -9999999
       tmax   = -9999999
       tmin   = +9999999
       vvmin  = +9999999.
       vvmax  = -9999999.
       ttmin  = +9999999.
       ttmax  = -9999999.
       rewind luin

       IF (bfile) THEN

          i = 1
          do  j = 1, nent

              read (luin,'(a80)',end=11,err=995) card
              if     (card(2:4) .eq. 'row') then
                  call fsscnf (card,'%s %d'//char(0), tagr, irow)
                  read (luin,'(a80)',end=11,err=995) card
                  call fsscnf (card,'%s %d'//char(0), tagc, icol)
              elseif (card(2:2) .eq. 't') then
                  call bfread (card, nent, i, time, vels, line,
     1                         trace, irow, icol)
              endif

          enddo
995       continue
          write(LERR,*)'zmapvel2sis: Fatal Error...'
          write(LERR,*)'Error reading BFILE ',otap
          write(LERR,*)'Check to make sure it is compete'
          write(LER ,*)'zmapvel2sis: Fatal Error...'
          write(LER ,*)'Error reading BFILE ',otap
          write(LER ,*)'Check to make sure it is compete'
          stop

11        continue
          ic = 0
          do  j = 1, nent
              if ( vels (j) .gt. 0. ) then
                 ic = ic + 1
                 vels  (ic) = vels  (j)
                 time  (ic) = time  (j)
                 line  (ic) = line  (j)
                 trace (ic) = trace (j)
              endif
          enddo
          nent = ic

          do  j = 1, nent

c     write(0,*)'j= ',line(j),trace(j),time(j),vels(j)
              if (line(j)  .ge. linmax) linmax = line(j)
              if (line(j)  .le. linmin) linmin = line(j)
              if (trace(j) .ge. trcmax) trcmax = trace(j)
              if (trace(j) .le. trcmin) trcmin = trace(j)
              if (vels (j) .le. vvmin ) vvmin  = vels (j)
              if (vels (j) .ge. vvmax ) vvmax  = vels (j)
              if (time (j) .le. ttmin ) ttmin  = time (j)
              if (time (j) .ge. ttmax ) ttmax  = time (j)
          enddo

       ELSE

          do  j = 1, nent
              read (luin,'(a80)',end=31,err=994) card
              call fsscnf (card,'%f %f %f %f'//char(0),
     1            dum1, dum2, dum3, dum4)
              line  (j) = nint (dum1)
              trace (j) = nint (dum2)
              time  (j) = dum3
              vels  (j) = dum4
              if (line(j)  .ge. linmax) linmax = line(j)
              if (line(j)  .le. linmin) linmin = line(j)
              if (trace(j) .ge. trcmax) trcmax = trace(j)
              if (trace(j) .le. trcmin) trcmin = trace(j)
              if (dum4 .gt. floor .and. dum4 .lt. ceil) then
                 if (dum4 .ge. vvmax) vvmax = dum4
                 if (dum4 .le. vvmin) vvmin = dum4
              endif
              if (dum3 .gt. floor .and. dum3 .lt. ceil) then
                 if (dum3 .ge. ttmax) ttmax = dum3
                 if (dum3 .le. ttmin) ttmin = dum3
              endif
          enddo
994       continue
          write(LERR,*)'zmapvel2sis: Fatal Error...'
          write(LERR,*)'Error reading ZMAP sorted file ',otap
          write(LERR,*)'Check to make sure it is compete'
          write(LER ,*)'zmapvel2sis: Fatal Error...'
          write(LER ,*)'Error reading ZMAP sorted file ',otap
          write(LER ,*)'Check to make sure it is compete'
          stop

31        continue


       ENDIF

          trace (nent+1) = 0
          line  (nent+1) = 0
   
          linlst = line (1)
          tlast  = trace (1)
          jline  = 1
          ntrc   = 1
          do  j = 2, nent
              if (line (j) .ne. linlst) then
                  jline  = jline + 1
                  linlst = line (j)
                  if (ntrc .ge. tmax) tmax = ntrc
                  if (ntrc .le. tmin) tmin = ntrc
                  ntrc = 0
              else
                  if (trace(j) .ne. tlast) then
                      tlast= trace(j)
                      ntrc = ntrc + 1
                  endif
              endif
          enddo
       if (jline .gt. 1) ntrc = tmax
       if (timn .lt. 0.) timn = nsi
       if (timx .eq. 0.) timx = ttmax
       if (vmax .eq. 0.) vmax = vvmax
       if (vmin .eq. 0.) vmin = vvmin
       nsamp = nint ( (timx - timn)/float(nsi) + .1)

       write(LER,*)' '
       write(LER,*)'number of lines       = ',jline
       write(LER,*)'min line number       = ',linmin
       write(LER,*)'max line number       = ',linmax
       write(LER,*)'number of traces      = ',ntrc
       write(LER,*)'min trace number      = ',trcmin
       write(LER,*)'max trace number      = ',trcmax
       write(LER,*)'min number trcs/line  = ',tmin
       write(LER,*)'max number trcs/line  = ',tmax
       write(LER,*)'max velocity in file  = ',vvmax
       write(LER,*)'min velocity in file  = ',vvmin
       write(LER,*)'max time in file      = ',ttmax
       write(LER,*)'min time in file      = ',ttmin
       write(LER,*)'number samples/trc    = ',nsamp
       write(LER,*)'sample interval (ms)  = ',nsi
       write(LER,*)'input velocity type   = ',tagi
       write(LER,*)'output velocity type  = ',tago
       write(LER,*)' '
       write(LERR,*)' '
       write(LERR,*)'number of lines       = ',jline
       write(LERR,*)'min line number       = ',linmin
       write(LERR,*)'max line number       = ',linmax
       write(LERR,*)'number of traces      = ',ntrc
       write(LERR,*)'min trace number      = ',trcmin
       write(LERR,*)'max trace number      = ',trcmax
       write(LERR,*)'min number trcs/line  = ',tmin
       write(LERR,*)'max number trcs/line  = ',tmax
       write(LERR,*)'max velocity in file  = ',vvmax
       write(LERR,*)'min velocity in file  = ',vvmin
       write(LERR,*)'max time in file      = ',ttmax
       write(LERR,*)'min time in file      = ',ttmin
       write(LERR,*)'number samples/trc    = ',nsamp
       write(LERR,*)'sample interval (ms)  = ',nsi
       write(LERR,*)'input velocity type   = ',tagi
       write(LERR,*)'output velocity type  = ',tago
       write(LERR,*)' '
       maxtime = ttmax

      heap = .true.
      items = ntrc * jline * SZSMPD

      call galloc (wkadrn, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) items,'  bytes'
         write(LER ,*) items,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
      endif

       tlast  = trace (1)
       ic = 1
       live = 0
       if ((vels(1) .gt. floor .and. vels(1) .lt. ceil) .and.
     1     (time(1) .gt. floor .and. time(1) .lt. ceil)) live = 1

       do  j = 2, nent+1
           if (trace (j) .ne. tlast) then
               nvels (ic) = live
               tlast = trace (j)
               ic = ic + 1
               live = 0
               if ((vels(j) .gt. floor .and. vels(j) .lt. ceil) .and.
     1             (time(j) .gt. floor .and. time(j) .lt. ceil)) then
                   live = live + 1
               endif
           else
               if ((vels(j) .gt. floor .and. vels(j) .lt. ceil) .and.
     1             (time(j) .gt. floor .and. time(j) .lt. ceil)) then
                   live = live + 1
               endif
           endif
       enddo

       nfunc = ic - 1
       write (LER,*)' '
       write (LERR,*)' '
       write (LER,*)'number of velocity functions= ',nfunc
       if (verbos) then
       write (LERR,*)'number velocities in each function:'
       write (LERR,*)(nvels(i),i=1,nfunc)
       endif
       write (LER,*)' '
       write (LERR,*)' '

      call getln(luout, otap,'w', 1)
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)


      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call savew(itr, 'NumSmp', nsamp, LINHED)
      call savew(itr, 'SmpInt', nsi  , LINHED)
      call savew(itr, 'NumTrc', ntrc , LINHED)
      call savew(itr, 'NumRec', jline, LINHED)
      call savew(itr, 'Format',   3  , LINHED)

      call savew(itr, 'MnLnIn',linmin, LINHED)
      call savew(itr, 'MxLnIn',linmax, LINHED)
      call savew(itr, 'MnDpIn',trcmin, LINHED)
      call savew(itr, 'MxDpIn',trcmax, LINHED)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
c     call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      if (ns .eq. 0) ns = -9999999
      if (ne .eq. 0) ne = +9999999
      if (irs .eq. 0) irs = -9999999
      if (ire .eq. 0) ire = +9999999
 
c-----
c     modify line header to reflect actual number of traces output
c-----
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      obytes = SZTRHD + SZSMPD*nsamp
      lbytes = HSTOFF
      nbyt = 2 * SZHFWD
      call savew( itr, 'HlhEnt',  0   , LINHED)
      call savew( itr, 'HlhByt', nbyt , LINHED)
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout  )
 
      si = nsi
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
 
c*****
c     only write out velocity traces that were input
c*****

         tlast  = trace (1)
         ic = 1
         live = 0
         if ((vels(1) .gt. floor .and. vels(1) .lt. ceil) .and.
     1       (time(1) .gt. floor .and. time(1) .lt. ceil)) live = 1

         timin (1) = timn
         velin (1) = vmin
         timin (2) = timn
         velin (2) = vmin
         linj      = line  (1)
         jtrc      = trace (1)

         DO  j = 2, nent+1
 
             if (trace (j) .ne. tlast) then

                 if (live .gt. 0) then
                   live = live + 2
                   velin  (live) = vmax
                   timin  (live) = timx
                   call velcon (live, velin, timin, tagi, tago, maxtime,
     1                          vvmin, nsi)
                   call vel (timin, velin, nsamp, si, live, velout)
                   call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                             0  , TRACEHEADER)
                 else
                   call vclr (velout, 1, nsamp)
                   call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                         30000  , TRACEHEADER)
                 endif
                 call vmov (velout, 1, lhed(ITHWP1), 1, nsamp)
              
                     call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                           linj   , TRACEHEADER)
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           jtrc   , TRACEHEADER)
                     call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                           linj   , TRACEHEADER)
                     call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                           jtrc   , TRACEHEADER)
                     call wrtape (luout, itr, obytes)

                 if (verbos) then
                 write(LERR,*)'line= ',line(j-1),' trc= ',trace(j-1),
     1           live,(timin(i),i=1,live),(velin(i),i=1,live)
                 endif

                 linj  = line  (j)
                 jtrc  = trace (j)
                 tlast = trace (j)
                 ic = ic + 1
                 live = 0

                 if ((vels(j) .gt. floor .and. vels(j) .lt. ceil) .and.
     1               (time(j) .gt. floor .and. time(j) .lt. ceil)) then
                     live = live + 1
                     timin (live+1) = time (j)
                     velin (live+1) = vels (j)
                 endif

             else

                 if ((vels(j) .gt. floor .and. vels(j) .lt. ceil) .and.
     1               (time(j) .gt. floor .and. time(j) .lt. ceil)) then
                     live = live + 1
                     timin (live+1) = time (j)
                     velin (live+1) = vels (j)
                 endif
   
             endif

 
         ENDDO

c*****
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      close ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of zmapvel2sis, processed',nfunc,' functions'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'zmapvel2sis does dark and terrible things to seismic data:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute zmapvel2sis by typing zmapvel2sis followed by the paramet
     :ers listed below'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)          : input zmap gridded vel file'
        write(LER,*)
     :' -O [otap]    (stdout)         : output 3D velocity volume'
c       write(LER,*)
c    :' -ns[ns]      (default = first)   : start trace number'
c       write(LER,*)
c    :' -ne[ne]      (default = last)    : end trace number'
c       write(LER,*)
c    :' -rs[irs]     (default = first)   : start record number'
c       write(LER,*)
c    :' -re[ire]     (default = last)    : end record number'
        write(LER,*)
     :' -vmin[vmin]  (default = 4850)    : surface velocity (ft,m/s)'
        write(LER,*)
     :' -vmax[vmax]  (def = max in input): bottom velocity (ft,m/s)'
        write(LER,*)
     :' -tmin[tmin]  (default = samp int): surface time (ms)'
        write(LER,*)
     :' -tmax[tmax]  (def = max in input): bottom time (ms)'
        write(LER,*)
     :' -si[si]      (default = 4)       : sample interval (ms)'
        write(LER,*)
     :' -floor[floor](default = 0)       : value below this is a missing 
     : or zero function'
        write(LER,*)
     :' -ceil[ceil]  (default = 1.E10)   : value above this is a missing 
     : or zero function'
        write(LER,*)
     :' -vi[vi]  (def = R):    input velocity type (R=rms,A=ave,I=int)'
        write(LER,*)
     :' -vo[vo]  (def = R):    output velocity type (R=rms,A=ave,I=int)'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :' -B  include on command line if input velocity file is b-file'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   zmapvel2sis -N[ntap] -O[otap] -vmin[] -tmin[]'
        write(LER,*)
     :'                     -vmax[] -tmax[] -si[] -floor[] -ceil[]'
        write(LER,*)
     :'                     -vi[] -vo[] [ -B -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,
     1                  vmin,vmax,nsi,verbos,zero,
     2                  tmin,tmax,floor, ceil, bfile, tagi, tago)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      character   tagi * 1, tago * 1
      integer     ns, ne, irs, ire, nsi
      real        vmin,vmax,tmin,tmax
      logical     verbos, zero, bfile
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program prgm might be invoked in the following way:
 
c     prgm  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ls', ns ,   0  ,  0    )
            call argi4 ( '-le', ne ,   0  ,  0    )
            call argi4 ( '-ts', irs ,   0  ,  0    )
            call argi4 ( '-te', ire ,   0  ,  0    )
            call argi4 ( '-si', nsi ,   4  ,  4    )
            call argr4 ( '-vmin', vmin, 4850., 4850. )
            call argr4 ( '-vmax', vmax,    0.,    0. )
            call argr4 ( '-tmin', tmin,   -1.,   -1. )
            call argr4 ( '-tmax', tmax,    0.,    0. )
            call argr4 ( '-floor', floor,  0.,    0. )
            call argr4 ( '-ceil', ceil,    0.,    0. )
            if (floor .eq. 0.) floor = 0.
            if (ceil  .eq. 0.) ceil  = 1.e10
            call argstr( '-vi', tagi, 'R', 'R' )
            call argstr( '-vo', tago, 'R', 'R' )
            zero    =   (argis('-Z') .gt. 0)
            bfile  =   (argis('-B') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
