C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       KWPM                                                 *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE: PRE STACK CONSTANT ANGLE DEPTH MIGRATION                   *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   N. D. Whitmore, Jr.                ORIGIN DATE: 89/03/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/01/22  *
C
C  Changes:  James Childress		 Change Date:        91/06/04  *
C
C            The changes added for the 91/06/04 verstion include the   *
C            following:  
C
C		Heap storage was added to the main program to          *
C	        allocate memory dynamically.  Getvel was modified to   *
C		compute several values needed for the Heap allocation. *
C		I changed the name of the "v" array to "vel" to make   *
C               easier to find with the editor.
C
C		All of the multi-dimensioned arrays were changed to be *
C		one-D arrays.
C
C		The Subroutine Smooth had its name changed to Smoothk  *
C		to prevent a name conflict    			       *
C
C               The Modio routines were removed and replaced with      *
C		standard Fortran IO statements.			       *
C
C		The Saver and Savew commands and include files were    *
C		added.
C
C     REVISED: Mary Ann Thornton   V:2.1   DATE: 91/09/10
C           Move code to the sun for maintenance/distribution
C     REVISED: Mary Ann Thornton   V:2.2   DATE: 91/11/14
C           Changed size of itime array (allocation and clearing)
C     REVISED: N. D. Whitmore, Jr. V:2.3   DATE: 92/01/08
C           Changed Computation of nx to make all arrays for velocity
C           grids the correct size for the data when migrating selected
C           traces.
C     REVISED: N. D. Whitmore, Jr. V:2.3   DATE: 92/01/21
C           Changed definitions of ix1 and ix2
C           Changed size of itime array (by defining itime_size)
C           Changed definition of xtmp (xtmp=last allowable xsrc loc.)
C           also  added the variable xsrc2 and passed it to timrfl
C           and computed ix2 from xsrc2 
C           Added xbias to call to cxznode
C     REVISED: Mary Ann Thornton   V:2.6   DATE: 92/03/25
C           Call openpr with full program name for OS 6.1
C     REVISED: Mary Ann Thornton   V:3.0   DATE: 92/04/24
C           Allow dynamic allocation on sun, do not pack the travel
C           time tables when on sun (data will be integer*2)  allocate
C           space for mray and tray in main, and remove 'implicit none'
C           statments in zerock, smoothk, zsmoo to rid compiler errors,
C           Routine 'second' is a cray timing routine, so I added
C           'etime' for the sun. Added 'include <f77/HeaderSize.h>' 
C           to getvel subroutine.  "ifdefs" were added before the
C           Pointer arithmetic as it is done in bytes on sun and in
C           words for the Crays.  Array "cstab" was defined as 
C           real*8 to agree with the libmbs library routines.
C           "cdstk2" must be changed to accept the travel times as
C           integer*2.  "migblk" (no. blocks to migrate at one
C           time) is read in as a command line argument.  It can be up
C           to 8 (default is 8).                           
C           Code is now portable to 32 bit machine
C     REVISED: N. D. Whitmore, Jr. V:3.1   DATE: 92/05/27
C           Changed definition of source depth to source depth * 2.0
C     REVISED: N. D. Whitmore, Jr. V:3.3   DATE: 92/08/10
C           Changed definition of source depth to source depth * 3.0
C           Changed phase to match phase of the phaseshift codes    
C     REVISED: Mary Ann Thornton   V:3.4   DATE: 92/08/12
C           Added a check for velocity tape dx and dz = 0 on both the
C           command line and the tape, to write a message and abort.
C  ATTENTION:  A message was placed into this code after mbsdate stamp
C           stating the change of phase and old code is kmpw.old, and 
C           this comment should be removed at some future date.
C     REVISED: N. D. Whitmore, Jr. V:3.5   DATE: 92/28/10
C           Changed definition of source depth to source depth * 2.0
C           Removed the warning mentioned above.                     
C     REVISED: N. D. Whitmore, Jr. V:4.0   DATE: ll/12/92
C           Major restructure of code to calibrate model           
C     REVISED: Mary Ann Thornton,  V:4.1   DATE: 02/19/93
C           Recompiled using dstk2.f from this directory, not the 
C           library.
C     REVISED: Mary Ann Thornton,  V:4.2   DATE: 03/23/93
C           Added logical unit ler = 7 if on an HP system and ler=0 for
C           all other machines, Added SZLNHD for the lineheader size
C           which is set to 10000.  Changed statements that write to
C           '0' to write to ler or ltrm (ltrm = ler).
C     REVISED: Mary Ann Thornton,  V:4.3   DATE: 09/21/93
C           Added auditing
C     REVISED: Mary Ann Thornton,  V:4.4   DATE: 02/04/94
C           Removed auditing, corrected the dztap,dxout parameters in the
C           line header to be * 1000.
C           added call to savhlh
C     REVISED: M.J. O'Brien        V:4.5   DATE: 06/12/2004
C           inlined the siftray() function. i686 optimizers were handling
C           the fuction poorly. Fixed the man page to work on Linux
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
C  Include the header files for Saver and Savew:
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
C
C     MEMORY SPACE
C
      parameter (nxmax=2501,nxbig=2501)
      parameter (nzmax=1501,nanmx=361,nzbig=1501)
      parameter (ntmax = 4201, nrmax = 2501, mxtot = nxmax*nzmax)
      parameter (napmx =903, maxblk = 8)
      parameter (lcrd = 25, llist = 27)
      parameter (lhead = SZLNHD)

      integer nzmax1, nxmax1, nzbig1, nxbig1, napmx1, ntmax1, nrmax1
C     
C     ARRAY FOR THE TIMER
C   
      real tarray(2)
      character*24 fdate

c     COMPUTED WAVEFRONT ANGLES:

      real    theta(nrmax)

c     SPATIAL ARRAYS:

      real    vmina(nzmax)
      real    pwamp(1)
      real    awork(1), vel(1), vdsx(1), vdsz(1), vdt(1), data2d(1)
      pointer (pawork, awork), (pdata2d, data2d) 
      pointer (ppwamp, pwamp)
      pointer (pvel, vel), (pvdsx, vdsx), (pvdsz, vdsz), (pvdt, vdt)

c     COMPUTED WAVEFRONT RAY POSITIONS:

      real    bwork(1), xray(1), zray(1)
      pointer (pbwork, bwork), (pxray, xray), (pzray, zray)

c     WORK AREAS FOR RAYS:

      real    tray(1)
      integer mray(1)
      pointer (ptray, tray), (pmray, mray)

c     data arrays
c     itime and itmrl should not be equivalenced

      integer*2 itime(1), itmrfl(1)
      integer*2 itminc(1)

      real    depth(1)

      pointer (pdepth, depth)
      pointer (itmincp, itminc)
      pointer (itmrflp, itmrfl), (itimep, itime)

c     resampling arrays
c     cubic interpolator

      real    tabl1(ntmax*3), tabl2(ntmax*3), zz(ntmax*9)
      integer iz(ntmax*9)

      parameter(nwork=30000)
      real    xwork(nwork), zwork(nwork)

c     miscl arrays  

      integer nzst(napmx), nzen(napmx), lutim(maxblk+4)
      logical verbose, ljerr
      integer ij, lutst
      real    coswgt(1)
      pointer (pcoswgt, coswgt)
      real    pray(maxblk), angtmp(nanmx), angl(nanmx)

C     HEADER ARRAYS:
      integer     ihder(lhead)
      integer     ihead(lhead)
      integer*2   irx(LNTRHD)
      real        rxx(ntmax+ITRWRD), data(ntmax)
      equivalence (rxx(1), irx(1)), (rxx(ITHWP1), data(1))

C     CHARACTER ARRAYS:
      character*1   parr(66)
      character*4   version
      character*4   ppname
      character*128 ntap, otap, input, ntpv, otpr, otpi
      character     word*4, word5*5, word9*9, card*80

      data version / ' 4.5'/
      data ppname / 'KMPW' /
      data parr / ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
     1            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'K', 'I', 
     2            'R', 'C', 'H', 'H', 'O', 'F', 'F', ' ', 'M', 'I', 
     3            'G', 'R', 'A', 'T', 'I', 'O', 'N', ' ', 'B', 'E', 
     4            'F', 'O', 'R', 'E', ' ', 'S', 'T', 'A', 'C', 'K', 
     5            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
     6            ' ', ' ', ' ', ' ', ' ', ' '/

C
C***********************************************************************
C
      call vclr( xwork,  1, nwork )
      call vclr( zwork,  1, nwork )
C
C     OPEN PRINT FILE
C
      ltrm = ler
      lprt = 26
      call openpr (llist, lprt, ppname, jerr) 
      if (jerr .ne. 0) stop 200
      lprt=ler
#include <mbsdate.h>
      lprt=26
#include <mbsdate.h>

C
C     PROCESS COMMAN LINE ARGUMENTS
C
#ifdef CRAYSYSTEM
      character*24 time
      call date(fdate)
      call clock(time)
      write(lprt,*)fdate,time
#else
      write(lprt,*)fdate() 
#endif
      call cmdlin(ntpv, ntap, otap, otpr, otpi, input, dxgrid, dzgrid, 
     &           ipipiv, ipipi, ipipo, ipipor, ipipoi, strch, strcht,
     &           istrid, migblk, ltrm, ntskip,verbose )
C
C     OPEN INPUT DATASET (OR PIPE) 
C
      if (ipipi .eq. 0) then
c        lu14 is an input dataset
         call lbopen (lu14, ntap, 'r')
      else
c        lu14 is a pipe
         lu14 = 0                  
      endif
C
C     PROCESS INPUT LINE HEADER
C
      jeof = 0
      call rtape (lu14, ihder, jeof) 

      if (jeof .eq. 0) then
         write (lprt, *) 'ERROR READING INPUT LINEHEADER'
         stop
      endif

      call saver( ihder, 'NumTrc', ntr,    LINHED )
      call saver( ihder, 'NumRec', nrec,   LINHED )
      call saver( ihder, 'SmpInt', isi,    LINHED )
      call saver( ihder, 'NumSmp', nsamp,  LINHED )
      call saver( ihder, 'Format', itpfmt, LINHED )

      if (itpfmt .ne. 3) then
         write (lprt, *) 'INPUT TAPE FORMAT NE 3 - JOB TERMINATED'
         stop 100
      endif
C
C     PROCESS HISTORICAL LINE HEADER
C
      nlin = 1
      call gamoco (parr, nlin, lprt) 

      len  = 4
      call hlhprt (ihder, jeof, ppname, len, lprt) 

      write (lprt, *) '              '
      write (lprt, *) 'Input dataset characteristics:'
      write (lprt, *) 'Input dataset name: ',ntap
      write (lprt, *) '#tr/rec      = ', ntr
      write (lprt, *) '#rec         = ', nrec
      write (lprt, *) '#sample rate = ', isi
      write (lprt, *) '#samples     = ', nsamp
      write (lprt, *) 'data will be migrated in blocks of ',migblk

c     check to see that no of traces/rec does not exceed nxmax+00

      if (ntr+00 .gt. nxmax) then
         write (lprt, *) '# of input traces/rec exceeds', nxmax-00
         write (ler, *)    '# of input traces/rec exceeds', nxmax-00
         write (lprt, *) 'job terminated abnormally'
         write (ler, *)    'job terminated abnormally'
         stop 100
      endif

C***********************************************************************
C     PROCESS INPUT PARAMETER CARDS
C***********************************************************************

      if (input .ne. ' ') then
         open (unit = lcrd, file = input, status = 'OLD', iostat = jerr)
         if (jerr .ne. 0) then
            write (lprt, *) '  ERROR OPENING EXTERNAL CARD FILE'
            stop 50
         endif
      else
         jerr = icopen ('-kmpw.crd', lcrd) 
      endif

c     READ INPUT CARDS

      write (lprt, *) '              '
      write (lprt, *) 'Input parameter cards:'
      write (lprt, *) '                      '

C     JOB CONSTANT TIME PARAMETERS

      read (lcrd, '(A80)') card
      read (lcrd, '(A4, 6X, 5F10.0)') word,tend,tpad0,tbeg,dtms,tmute

      if (word .ne. 'TIME') then
         write (lprt, *) '"TIME" CARD MISORDERED', word, ' CARD ENTERED'
         call ccexit (100) 
      endif

      if (dtms  .le.  0.0) dtms = float( isi ) 
      if (tmute .lt.  0.0) tmute = 0.0
      if (tmute .gt. tend ) tmute = tend
      if (tend  .le.  0.0) tend = nsamp * dtms
      if (tpad0 .le.  0.0) tpad0 = 0.0

      dtsec = dtms / 1000.0
      imute = tmute / dtms
      itbeg = nint(tbeg / dtms) + 1

      write (lprt, '(A80)') card
      write (lprt, '(A4, 6X, 5F10.2)') word,tend,tpad0,tbeg,dtms,tmute

C     JOB CONSTANT FREQUENCY PARAMETERS

      read (lcrd, '(A80)') card
      read (lcrd, '(A9, 1X, 4F10.0)') word9, fmin, f2, f3, fmax

      if (word9 .ne. 'FREQUENCY') then
         write (lprt, *) '"FREQUENCY" CARD MISORDERED', word9,
     &                   ' CARD ENTERED'
         call ccexit (100) 
      endif

      write (lprt, '(A80)') card
      write (lprt, '(A9, 1X, 4F10.0)') word9, fmin, f2, f3, fmax

C     prevent minimum frequency from being zero

      if (fmin .eq. 0) fmin = 1.0
      f1 = fmin
      f4 = fmax

c     set extra fftflt parameters

      phase = -45.0
      expon =  0.5
      mrsmp =  1

C     DEPTH PARAMETERS

      read (lcrd, '(A80)') card
      read (lcrd,'(A5,5X,4F10.0)') word5,zmax,dztap,zfrst,z2nd

      if (word5 .ne. 'DEPTH') then
         write (lprt, *) '"DEPTH" CARD MISORDERED', word5,
     &                   ' CARD ENTERED'
         call ccexit (100) 
      endif

      write (lprt, '(A80)') card
      write (lprt,'(A5,5X,4F10.2)') word5,zmax,dztap,zfrst,z2nd

C     WIDTH PARAMETERS

      read (lcrd, '(A80)') card
      read (lcrd, '(A5, 5X, F10.0, 5I10)') word5, dx, irbeg, irend,
     &                                     irinc, itrbeg, itrend
      if (word5 .ne. 'WIDTH') then
         write (lprt, *) '"WIDTH" CARD MISORDERED', word5,
     &                   ' CARD ENTERED'
         call ccexit (100) 
      endif

      if (irbeg  .le. 0   ) irbeg  = 1
      if (irend  .le. 0   ) irend  = nrec
      if (irend  .gt. nrec) irend  = nrec
      if (irinc  .le. 0   ) irinc  = 1
      if (irinc  .gt. nrec) irinc  = nrec
      if (itrbeg .le. 0   ) itrbeg = 1
      if (itrend .le. 0   ) itrend = ntr
      if (itrend .gt. ntr ) itrend = ntr
      nx = itrend
      
      write (lprt, '(A80)') card
      write (lprt, '(A5, 5X, F10.2, 5I10)') word5, dx, irbeg, irend,
     &                                      irinc, itrbeg, itrend

C     COMPUTE LEAD IN SKIP

       ixskp = (irbeg - 1) * ntr + (itrbeg - 1) 
       ixblk = 1

C     COMPUTE BLOCK (RECORD) PARAMETERS

       jxblk  = (irend - irbeg) / irinc + 1
       jxntr  = itrend - itrbeg + 1
       jxskip = (ntr - jxntr) + ntr * (irinc - 1) 

C     REF VEL, REFL EMERG, DIPMAX

      read (lcrd, '(A80)') card
      read (lcrd, '(A5,5X,4F10.0)')word5,velref,emerg,dipmax,xbegin

      if (dipmax .le. 0.0) dipmax = 90.0
      if (word5 .ne. 'MODEL') then
         write (lprt, *) '"MODEL" CARD MISORDERED', word5,
     &                   ' CARD ENTERED'
         call ccexit (100) 
      endif

      if (emerg .eq. 0.0) emerg = 45.0

      write (lprt, '(A80)') card
      write (lprt, '(A5,5X,4F10.0)')word5,velref,emerg,dipmax,xbegin

C     IMAGING CONTROL PARAMETERS

      read (lcrd, '(A80)') card
      read (lcrd, '(A5, 5X, I10, 2F10.0, 3I10)') word5, nabot, dzout,
     &                                    dtmig, nrinc, ismoo, istrid

      natop = 1
      if (istrid .le. 0    ) istrid = 1
      if (nabot  .le. 0    ) nabot  = 100
      if (nabot  .gt. napmx) nabot  = jxntr
      if (nabot  .gt. napmx) nabot  = napmx
      if (nabot  .lt. natop) nabot  = natop
      if (dtmig  .le. 0.0  ) dtmig  = 2.0
      dtmig  = 2.0
      if (nrinc  .lt. 3    ) nrinc  = 3
      if (ismoo  .le. 0    ) ismoo  = 5
      if (dzout  .le. 0.0  ) dzout  = dztap

      nztemp = zmax / dzout
      if (nztemp .gt. nzbig-4) then
         dzout = zmax / (nzbig + 5) 
         write (ler, *) 'dzgrid too small, reset to = ', dzout
      endif

      dztemp = dzout
      dzout  = dzout * strch

      if (word5 .ne. 'IMAGE') then
         write (lprt, *) '"IMAGE" CARD MISORDERED', word5,
     &                   ' CARD ENTERED'
         call ccexit (100) 
      endif

      write (lprt, '(A80)') card
      write (lprt, '(A5, 5X, I10, 2F10.2, 3I10)') word5, nabot, dzout,
     &                                     dtmig, nrinc, ismoo, istrid

C     READ ANGLE CARDS

      np = 0
      read (lcrd, '(A80)') card

  101 continue
	 read (lcrd, '(i10, 2f10.0)', end = 102) np1, astrt, ainc
         if (np1 .le. 0) go to 102

         angtmp(np+1)  = astrt
         write (lprt, *) 'INPUT ANGLE(', np+1, ') = ', angtmp(np+1) 

         if (np1 .gt. 1) then
            do 135 i = np+2, np+np1
               angtmp(i) = angtmp(i-1) + ainc
               write (lprt, *) 'INPUT ANGLE(', i, ') = ', angtmp(i) 
  135       continue
         endif
         np = np + np1
         go to 101

  102  continue
       if (np .le. 0) then
          write (lprt, *) 'ERROR IN ANGLE CARDS'
          call ccexit (100) 
       endif

       write (lprt, *) ' '
       write (lprt, *) ' '

       jkont = 0
       do 40 j = irbeg, irend, irinc
          jkont = jkont + 1
          angl(jkont) = angtmp(j) 
          write (lprt, *) 'OUTPUT ANGLE(', jkont, ') = ', angl(jkont) 
   40  continue

       write (lprt, *) '#angles to migrate = ', jkont

C      SET SCATTERED RAY FAN ANGULAR PARAMETERS

       angle = emerg + 5.0
       if (angle .gt. 90.0) angle = 90.0
       anginc = 0.5
       nang   = angle / anginc

C      SET HORIZONTAL SPATIAL PARAMETERS

       nirec  = jkont
       nrrec  = jxntr
cdan
       if(nrinc.gt.jxntr) nrrec = 1
       xbeg   = (itrbeg - 1) * dx
       dxout  = dx
       xinc   = dx
       nap    = max0( natop, nabot ) 
       nxap   = nap * 2 + 1
       apfeet = (nap+1) * dxout

C      SET VERTICAL SPATIAL PARAMETERS

       nzout  = (ifix ( zmax / dztemp ) + 3) / 4 * 4
       nztap  = zmax / dztap + 0.00001
       nzfrst = zfrst / dztemp + 1
       nz2nd  = z2nd / dztemp + 1
       if(nzfrst.le.1) nzfrst = 1
       if(nzfrst.gt.nzout) nzfrst = 1
       if(nz2nd.le.1) nz2nd  = nzout
       if(nz2nd.lt.nzfrst) nz2nd  = nzout
       kbytes = nzout * ISZBYT
       jbytes = kbytes + SZTRHD

C***********************************************************************
C     READ VELOCITY TAPE
C***********************************************************************

C     OPEN VELOCITY TAPE

      if (ipipiv .eq. 0) then
         call lbopen (luv, ntpv, 'r')
C LUV is an input dataset
      else
         write (lprt, *) 'ERROR NO INPUT VELOCITY DATASET'
         stop 100
      endif

      write (lprt, 37) ntpv
   37 format ('  INPUT VELOCITY DATASET = ' / , a128) 

c     read and expand velocities into V

      nxtmp = 1
      nztmp = 1
      call getvel(ltrm, lprt, luv, ihead, rxx, irx, data, dxout, nap,
     &            vel, nzmax, nxmax, nzgrid, nxgrid, nzout, nx,
     &            dzgrid, dxgrid, strch, xbegin, nxtmp, nztmp)

C***********************************************************************
C
      nzmax1 = min0( nzmax, 2*max0( 
     &         nzgrid + 5, nzout+int((dzgrid*strch)/dzout)+1 ) + 1 )

      nxmax1 = min0( nxmax, nxgrid + 5 + mod(nxgrid, 2) )
      nzbig1 = min0( nzbig, nzout + 4 + mod(nzout+1,2) )
      nxbig1 = min0( nxbig, max0( ntr, jxntr ) +
     &                      mod(max0( ntr, jxntr )+1, 2) ) 
      napmx1 = min0( napmx, 2*nap + 1 )
      nrmax1 = max0( 2*nang+1, jxntr+1+mod(jxntr,2),
     &               nzout+int((dzgrid*strch)/dzout)+1 )
      nrmax1 = min0( nrmax, nrmax1 + mod(nrmax1+1,2) )

      lawork = max0( 4*nzmax1*nxmax1 + 2*nzmax1*(nxmax1+napmx1), 
     &               nzbig1*nxbig1*migblk ) + 1

      itime_size = max0( nxap*nzout, jxntr*nzout )

      jerr   = 0
      iabort = 0
      
      call galloc( pawork, lawork*ISZBYT, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'galloc error: ', jerr
         stop
      endif
#ifdef CRAYSYSTEM 
      ibyte = 1
      iplus = 1
#else
      ibyte = ISZBYT
      iplus = 0
#endif
      itmincp = pawork
      pvdt    = pawork
      pvdsx   = pawork + (  nzmax1*nxmax1 + iplus )*ibyte
      pvdsz   = pawork + (2*nzmax1*nxmax1 + iplus )*ibyte
      pvel    = pawork + (3*nzmax1*nxmax1 + iplus )*ibyte
      pdata2d = pawork + (4*nzmax1*nxmax1 + iplus )*ibyte

      jerr = 0
      iabort = 0
      call galloc( ppwamp, (nzmax1*(nxmax1+napmx1))*ISZBYT,
     &             jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      iabort = 0
      call galloc( itimep, itime_size*SZHFWD, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne. 0) then
         write(ler,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      iabort = 0
      call galloc( itmrflp, nzbig1*nxbig1*SZHFWD, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      iabort = 0
      call galloc( pcoswgt, (napmx1*nzbig1*migblk)*ISZBYT, 
     &             jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'galloc error: ', jerr
         stop
      endif

C     initialize any arrays that expect to be zero:
      call vclr( awork,  1, lawork )
      call vclr( pwamp,  1, nzmax1*(nxmax1+napmx1) )
c     vclr works with full words, not half words
      itimwrd = (itime_size*SZHFWD)/ISZBYT
      call vclr( itime,  1, itimwrd )
      itmr_word = (nzbig1*nxbig1*SZHFWD)/ISZBYT
      call vclr( itmrfl, 1, itmr_word )
      call vclr( coswgt, 1, napmx1*nzbig1*migblk )

      nxtmp = nxmax1
      nztmp = nzmax1
      call getvel(ltrm, lprt, luv, ihead, rxx, irx, data, dxout, nap,
     &            vel, nzmax1, nxmax1, nzgrid, nxgrid, nzout, nx,
     &            dzgrid, dxgrid, strch, xbegin, nxtmp, nztmp)

c     Compute angle dependent mute

      call anmute (vel, nzmax1, nxmax1, nzgrid, nxgrid, nzout, 
     &             dzout, dzgrid, dxout, emerg, xwork, nzst, nap, 
     &             vmina, angl, velref, nirec, nzen, vmax, tmxtmp, 
     &             nzfrst,nz2nd,lprt) 

C     SET TEMPORAL PARAMETERS

      tmxtmp = tmxtmp * 0.7
      tmax   = (tend + tpad0) / 2000.
CDAN  if (tmxtmp .gt. tmax) tmax = tmxtmp
      ntsmp  = (tend + tpad0 - tbeg) / dtms
      dtmig0 = 0.9 * (1000.0 * dzout / vmax) 
      if ( dtmig .ge. dtmig0) dtmig = dtmig0
      dt     = dtmig / 1000.0
      dtray  = dt * ntskip
      itref  = 0.064 / dtray
      dtref  = float( itref ) * dtray
      ntinc  = 1
      nt     = tmax / dt
      if(nt.gt.ntmax) then
       write(ler,*) 'ERROR'
       write(ler,*) 'ray tracing time steps too large'
       write(ler,*) 'either decrease maximum time or '
       write(ler,*) 'increase dzmig                  '
       write(lprt,*) 'ERROR'
       write(lprt,*) 'ray tracing time steps too large'
       write(lprt,*) 'either decrease maximum time or '
       write(lprt,*) 'increase dzmig                  '
       stop 100
      endif
c
      ntmax1 = min0( ntmax, 
     &               max0( nxmax1+napmx1, nt+max0(ntinc, ntskip)+1 ) )
      ntmax1 = ntmax1 + mod( ntmax1+1, 2 )
      lbwork = max0( 2*nrmax1*ntmax1, nzbig1*nxbig1*migblk ) + 1
      jerr   = 0
      iabort = 0
      call galloc( pbwork, lbwork*ISZBYT, jerr, iABORT  )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'galloc error: ', jerr
         stop
      endif
      pdepth = pbwork
      pxray  = pbwork
      pzray  = pbwork + ( nrmax1*ntmax1 + iplus )*ibyte
      call vclr( bwork,  1, lbwork )
      theta(1) = 0.

      jerr   = 0
      iabort = 0
      msize = max0(ntmax1,10000)
      call galloc( pmray, msize*ISZBYT, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'galloc error: ', jerr
         stop
      endif
      call vclr(mray,1,msize)

      jerr   = 0
      iabort = 0
      call galloc( ptray, nrmax1*ntmax1*ISZBYT, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'galloc error: ', jerr
         stop
      endif
      call vclr(tray,1,nrmax1*ntmax1)

c
c     write (ler, *) 'computed tmax = ', tmax * 2.0
c     write (ler, *) 'ray tracing delta t = ', dt

C***********************************************************************
C     OPEN OUTPUT TAPE AND WRITE HEADER TO TAPE
C***********************************************************************

      call savew( ihder, 'NumTrc', jxntr, LINHED )
      call savew( ihder, 'NumRec', jxblk, LINHED )
      call savew( ihder, 'NumSmp', nztap, LINHED )
cmat  dztap is used for output header for depth sampling
cmat  dzout is the internal depth sample for the migration
      idx = dxout*1000.0
      idz = dztap*1000.0
      call savew( ihder, 'Dx1000', idx,   LINHED )
      call savew( ihder, 'Dz1000', idz,   LINHED )
     
c     write output dataset characteristics

      write (lprt, *) '              '
      write (lprt, *) 'Output dataset characteristics:'
      write (lprt, *) 'Output dataset name: ',otap
      write (lprt, *) '#tr/rec      = ', jxntr
      write (lprt, *) '#rec         = ', jxblk
      write (lprt, *) '#sample rate = ', isi
      write (lprt, *) '#samples     = ', nztap

      do 199  ij=1, migblk+4
         lutst = 99 - ij
         if ( lutst .le. 7 ) then
            write(ler,*)'Too many open files - program stopped.'
            stop
         endif
         inquire( unit=lutst, opened=ljerr )
         if ( .not. ljerr ) then
            lutim(ij) = lutst
         endif
 199  continue

      luhdr = lutim( migblk+1 )
      lurfl = lutim( migblk+2 )
      luinc = lutim( migblk+3 )
      luamp = lutim( migblk+4 )

      if (ipipo .eq. 0) then
         call lbopen (lu24, otap, 'w')     
C LU24 is an output dataset
      else
         lu24 = 1                          
C LU24 is a pipe
      endif

      call savhlh (ihder, jeof, jeofo)
      jeof = jeofo
      call wrtape (lu24, ihder, jeof) 

C***********************************************************************
C      OPEN LUHDR TO STORE TRACE HEADERS
C***********************************************************************

      open( unit=luhdr, status='scratch', form='unformatted' )

C***********************************************************************
C      OPEN LUTIM(1-MIGBLK) TO STORE TRACE DATA
C***********************************************************************

      do 200 nmod = 1, migblk
         open( unit=lutim(nmod), status='scratch', form='unformatted' )
 200  continue

C***********************************************************************
C    PROCESS REFLECTED TRAVEL TIME FILE LINE HEADER / DIRECT ACCESS FILE
C***********************************************************************

      if (ipipor .eq. 0) then
         call lbopen (lu2, otpr, 'w') 
         write (lprt, 38) otpr

         call savew( ihder, 'NumTrc', nxap,         LINHED )
         num_rec = nrrec/3
         if(num_rec.le.0) num_rec=1
         call savew( ihder, 'NumRec', num_rec,      LINHED )
         call savew( ihder, 'NumSmp', nzout,        LINHED )
         call savew( ihder, 'AngInc', int(xinc),    LINHED )
         call savew( ihder, 'UnitFl', int(xinc),    LINHED )
cmat     dztap is used for output header for depth sampling
cmat     dzout is the internal depth sample for the migration
         idx = dxout*1000.0
         idz = dztap*1000.0
         call savew( ihder, 'Dx1000', idx,   LINHED )
         call savew( ihder, 'Dz1000', idz,   LINHED )

         call wrtape (lu2, ihder, jeof) 
         if (jeof .eq. 0) then
            write (lprt, *) ' ERROR WRITING LINE HEADER'
            stop 75
         endif
      endif

   38 format (' OUTPUT REFLECTED TRAVELTIMES = ' / , a128) 

C     OPEN LURFL

#ifdef CRAYSYSTEM
      nsmp = (nxap * nzout + 3) / 4
#else
      nsmp = nxap*nzout
#endif
      open( unit=lurfl, access='direct', status='scratch',
     &      form='unformatted', recl=SZHFWD*nsmp )

C***********************************************************************
C    PROCESS INCIDENT TRAVEL TIME FILE LINE HEADER / DIRECT ACCESS FILE
C***********************************************************************

      if (ipipoi .eq. 0) then          
C LU3 IS A OUTPUT DATASET
         call lbopen (lu3, otpi, 'w') 
         write (lprt, 39) otpi

         call savew( ihder, 'NumTrc', jxntr,      LINHED )
         call savew( ihder, 'NumRec', nirec,      LINHED )
         call savew( ihder, 'NumSmp', nzout,      LINHED )
         call savew( ihder, 'AngInc', int(xinc),  LINHED )
         call savew( ihder, 'UnitFl', int(xinc),  LINHED )
cmat     dztap is used for output header for depth sampling
cmat     dzout is the internal depth sample for the migration
         idx = dxout*1000.0
         idz = dztap*1000.0
         call savew( ihder, 'Dx1000', idx,   LINHED )
         call savew( ihder, 'Dz1000', idz,   LINHED )

         call wrtape (lu3, ihder, jeof) 
         if (jeof .eq. 0) then
            write (lprt, *) ' ERROR WRITING LINE HEADER'
            stop 75
         endif
      endif

   39 format (' OUTPUT INCIDENT TRAVELTIMES = ' / , a128) 

C     OPEN LUINC

      open( unit=luinc, status='scratch', form='unformatted' )

C***********************************************************************
C      OPEN LUAMP TO STORE PLANE WAVE AMPLITUDE DATA
C***********************************************************************

      open( unit=luamp, status='scratch', form='unformatted' )

C***********************************************************************
C     GENERATE REFLECTED FIELD TRAVEL TIME DATA SET
C***********************************************************************

      write (ler, *) 'tracing scattered wave travel times'

C     RAYTRACE reflected field 1 first:
c     compute x location relative to velocity matrix vel

      jr   = 1
      zsrc = dzgrid * strch * 2.0
      xsrc = xbeg + (jr - 1) * xinc + apfeet

c     Ray Trace and grid traveltimes (init = 0 initializes tables) 

      init  = 0
      call timrfl (zsrc, xsrc, angle, nang, dtref, tmax, data2d,
     &             dzout, dxout, nzmax1, nxmax1, nrmax1, ntmax1, 
     &             nzgrid, nxgrid, nray, nt, ntskip, ntinc, 
     &             strch*dzgrid, dxgrid, dt, vel, ismoo, vdsz, vdsx,
     &             vdt, init, theta, zray, xray, dipmax, lprt,
     &             napmx1, mray) 
      init  = 1

c      write(102,*) nzmax1,nxmax1+napmx1
c      do jx=0,nxmax+napmx-1
c        do jz=1,nzmax
c          ip= jz + jx*nzmax
c          write(102,*) data2d(ip)
c        enddo
c      enddo
c      close(102)
c      stop

c     DATA2D now contains gridded traveltimes

      izsrc = 0
      x1    = (xsrc - apfeet) 
      ix1   = x1 / dxout + .5
      ind2d = -nzout
C     TRACE LOOP 500

      do  500 jx = 1, nxap

C        SAMPLE LOOP 450

         ind2d = ind2d + nzout
         do  450 jz = 1, nzout
            data(jz)        = data2d( nzmax1*(jx+ix1-1) + jz+izsrc )
            itime(jz+ind2d) = data(jz) / dt
  450    continue

         if (ipipor .eq. 0) then
C           DO IF OUTPUT TAPE OF TRAVEL TIMES ARE REQUIRED
            i109 = int((jr-1)*xinc + xbeg)
            i119 = (jx-(nap+1))*int(dxout)
            call savew(irx, 'RecNum', jr, TRCHED)
            call savew(irx, 'TrcNum', jx, TRCHED)
            call savew(irx, 'SrcLoc', i109, TRCHED)
            call savew(irx, 'DstSgn', i119, TRCHED)

            call wrtape (lu2, rxx, jbytes) 
            if (jbytes .eq. 0) then
               write (lprt, *) 'ERROR IN OUTPUT, RECORD, TRACE = ',jr,jx
               stop 75
            endif
         endif

  500 continue     
C END OF TRACE LOOP

C     PACK ITIME 4 to 1 into ITMRFL

      jrcont = 1
#ifdef CRAYSYSTEM
      isb   = 1
      isnum = nxap * nzout
      islen = 2
      isinc = 1
      call usicti (itime, itmrfl, isb, isnum, islen, iserr, isinc) 

C     write traveltime to direct access file

      write(lurfl, rec=jrcont)(itmrfl(ij), ij=1, (nxap*nzout+3)/4)
#else
      write(lurfl, rec=jrcont)(itime(ij), ij=1, (nxap*nzout))
#endif

C     RECORD LOOP 2000 over remaining surface locations:

      idat1 = 2
      idat2 = 1

      if (nrrec .lt. 2) go to 2001
      do 2000 jr = 1+nrinc, nrrec+nrinc+1, nrinc

c        FLIP DATA2D INDICIES

         idtemp = idat1
         idat1  = idat2
         idat2  = idtemp

c        compute x location relative to velocity matrix vel

         zsrc  = dzgrid * strch * 2.
         xsrc  = xbeg + (jr - 1) * xinc + apfeet
         xsrc2 = xsrc
         xtmp  = (nxgrid - nap-1) * dxgrid
         if (xsrc2.gt. xtmp) xsrc2 = xtmp 

c        Ray Trace and grid traveltimes (init = 0 initializes tables) 

         call timrfl (zsrc, xsrc2, angle, nang, dtref, tmax, 
     &                data2d( (idat2-1)*nzmax1*(nxmax1+napmx1)+1 ),
     &                dzout, dxout, nzmax1, nxmax1,
     &                nrmax1, ntmax1, nzgrid, nxgrid, nray, nt, ntskip,
     &                ntinc, strch*dzgrid, dxgrid, dt, vel, ismoo, 
     &                vdsz, vdsx, vdt, init, theta, zray, xray, dipmax,
     &                lprt, napmx1, mray)

c        DATA2D (.,.,IDAT2) now contains new gridded traveltimes

c        SPATIAL INTERPOLATION LOOP 1600:

         izsrc = 0
         x1    = (xsrc - xinc * nrinc - apfeet) + 0.00001
         x2    = (xsrc2 - apfeet) + 0.00001
         ix1   = x1 / dxout  + .5
         ix2   = x2 / dxout  + .5
         do 1600 js = 1, nrinc
            jrcont = jrcont + 1
            if ((jrcont-1) / 3 * 3 .ne. jrcont-1 ) go to 1600

            beta   = float(js) / float(nrinc) 
            alpha  = 1. - beta
            alpha  = alpha / dt
            beta   = beta / dt
            ind2d  = -nzout

            if (jrcont .gt. nrrec) go to 2001

C           TRACE LOOP 1500:

            do 1500 jx = 1, nxap
	       jx1   = jx + ix1
	       jx2   = jx + ix2
               ind2d = ind2d + nzout
               if (js .eq. nrinc) then
C                 SAMPLE LOOP
                  do 1450 jz = 1, nzout
                     itime(jz+ind2d) = data2d(
     &               (idat2-1)*nzmax1*(nxmax1+napmx1) + nzmax1*(jx2-1) +
     &               izsrc + jz ) / dt
 1450             continue
               else
C                 SAMPLE LOOP
                  do 1451 jz = 1, nzout
		     jz2 = jz + izsrc
                     itime(jz+ind2d) = alpha * data2d(
     &               (idat1-1)*nzmax1*(nxmax1+napmx1)+
     &                            nzmax1*(jx1-1)+jz2 )
     &                               + beta  * data2d(
     &               (idat2-1)*nzmax1*(nxmax1+napmx1)+
     &                            nzmax1*(jx2-1)+jz2 )
 1451             continue
               endif

               if (ipipor .eq. 0) then
C                 DO IF OUTPUT TAPE OF TRAVEL TIMES ARE REQUIRED
                  do 1452 jz = 1, nzout
                     data(jz) = itime(jz+ind2d) * dt
 1452             continue
                  i109 = int((jrcont-1)*xinc+xbeg)
                  i119 = (jx-(nap+1))*int(dxout)
                  call savew(irx, 'RecNum', jrcont, TRCHED)
                  call savew(irx, 'TrcNum', jx, TRCHED)
                  call savew(irx, 'SrcLoc', i109, TRCHED)
                  call savew(irx, 'DstSgn', i119, TRCHED)

                  call wrtape (lu2, rxx, jbytes) 
                  if (jbytes .eq. 0) then
                     write (lprt, *) 'ERROR IN OUTPUT, RECORD, TRACE =',
     &                               jrcont, jx
                     stop 75
                  endif
               endif

 1500       continue     
C END TRACE LOOP 1500:

C           PACK ITIME 4 to 1 into ITMRFL
            jrmod  = (jrcont) / 3 + 1
#ifdef CRAYSYSTEM
            isb   = 1
            isnum = nxap * nzout
            islen = 2
            isinc = 1
            call usicti (itime, itmrfl, isb, isnum, islen, iserr, isinc)

C           write traveltime to direct access file

	    write(lurfl, rec=jrmod)(itmrfl(ij), ij=1, (nxap*nzout+3)/4)
#else
            write(lurfl, rec=jrmod)(itime(ij), ij=1, (nxap*nzout))
#endif

 1600    continue     
C END SPATIAL INTERPOLATION LOOP:

 2000 continue     
C END RECORD LOOP 2000:

 2001 continue
      if (ipipor .eq. 0) call lbclos (lu2) 

CCCCC      rewind lurfl

C***********************************************************************
C     GENERATE INCIDENT FIELD TRAVEL TIME DATA SET
C***********************************************************************

      write (ler, *) 'tracing plane wave travel times'

C     RECORD LOOP 3000 over angles locations:


      do 3000 jr = 1, nirec

c        compute x location relative to velocity matrix vel

         zsrc  = dzgrid * strch * 2.
         xsrc  = xbeg + apfeet
         width = (jxntr - 1) * dxout
         angle = angl(jr) 
         pr    = sin(angle * 3.14159 / 180.0) / velref
         tmpwi = tmax + width * abs( pr ) 
         tmpwi = tmax
c        write (ler, *) 'angle', angle

c        Ray Trace and grid traveltimes (init = 0 initializes tables) 

         call timpwi (zsrc, xsrc, width, angle, velref, tmpwi,
     &              data2d, dzout, dxout, nzmax1, nxmax1, nrmax1,
     &              ntmax1, nzgrid, nxgrid, nray, nt, ntskip, ntinc, 
     &              strch*dzgrid, dxgrid, dt, vel, ismoo, vdsz, vdsx,
     &              vdt, init, theta, zray, xray, nxap, dipmax,nzout, 
     &              napmx1, mray, tray )

c        DATA2D now contains gridded traveltimes

         ix1   = nint(xsrc / dxout) -1
         izsrc = 0
         ind2d = -nzout

C        TRACE LOOP 2500:

         do 2500 jx = 1, jxntr

C           SAMPLE LOOP:

            ind2d = ind2d + nzout
            do 2450 jz = 1, nzout
               data(jz)        = data2d(nzmax1*(jx+ix1-1)+jz+izsrc)
               itime(jz+ind2d) = data(jz) / dt + 1
               pwamp(jz+ind2d) = xray(jz+izsrc + nrmax1*(jx+ix1-1))
 2450       continue

            if (ipipoi .eq. 0) then
C              DO IF OUTPUT TAPE OF TRAVEL TIMES ARE REQUIRED
               call savew(irx, 'RecNum', jr, TRCHED)
               call savew(irx, 'TrcNum', jx, TRCHED)
               call savew(irx, 'SrcLoc', 0, TRCHED)
               call savew(irx, 'DstSgn', 0, TRCHED)

               call wrtape (lu3, rxx, jbytes) 

               if (jbytes .eq. 0) then
                  write (lprt, *) 'ERROR IN OUTPUT, RECORD, TRACE = ',
     &                            jr, jx
                  stop 75
               endif
            endif

 2500    continue     
C END TRACE LOOP 2500:

C        PACK ITIME 4 to 1 into ITMRFL
#ifdef CRAYSYSTEM
         isb   = 1
         isnum = jxntr * nzout
         islen = 2
         isinc = 1
         call usicti (itime, itmrfl, isb, isnum, islen, iserr, isinc) 
	  
C        write traveltime to direct access file
 
         write(luinc)(itmrfl(ij), ij=1, (jxntr*nzout+3)/4 )
#else
         write(luinc)(itime(ij), ij=1, (jxntr*nzout))
#endif
	  
C        write amplitude to direct access file

         write(luamp)(pwamp(ij), ij=1, jxntr*nzout)

 3000 continue     
C END RECORD LOOP 3000:

      if (ipipoi .eq. 0) call lbclos (lu3) 

      endfile luamp
      rewind  luamp

      endfile luinc
      rewind  luinc

C***********************************************************************
C      BEGIN TRACE PROCESSING
C***********************************************************************

C     SKIP OVER  IXBLK*IXSKP  INPUT TRACES

      iskip = ixblk * ixskp
      if (iskip .gt. 0) call skipt (lu14, iskip) 

C***********************************************************************
C     LOOP 6000: OVER BLOCKS (RECORDS) 
C***********************************************************************

      do 6000 jblk = 1, jxblk, migblk
         ibst = jblk
         iben = min0(jblk+migblk-1, jxblk) 
         write (ler, *) 'imaging data'
         write (ler, *) 'angle range = ', angl(ibst), angl(iben) 

         jbcont = 0
         do 7000 jb = ibst, iben
            jbcont = jbcont + 1

C           COMPUTE BLOCK DEPENDENT PARAMETERS / VECTORS

            write (lprt, *) '                        '
            write (lprt, *) 'BLOCK (RECORD) = ', jb
            write (lprt, *) '              '

C           build time interpolation tables

            icinit = 1
            if (icinit .eq. 1) then
               ntime = ntsmp * dtms / (dtmig * strcht) 
               do 300 j = 1, ntmax*3
                  xj1      = float( j - 1 )
                  tabl1(j) = xj1 * dtms
                  tabl2(j) = xj1 * dtmig * strcht
  300          continue
            endif

c           define ray parameter

            pray(jbcont) = sin(angl(jb) * 3.14159 / 180.0) / velref

c           build cosine weights

            call cosamp1 ( coswgt((jbcont-1)*napmx1*nzbig1 + 1),
     &                     nzout, nap, dzout, dxout, angl(jb) )

C           READ A SEISMIC RECORD INTO A AND WRITE HEADER TO DISK

            nhead  = jbcont
            call rdrecm (lu14, rxx, irx, data, xwork, ntsmp, itbeg,
     &                  jxntr, lutim(jbcont), luhdr, nhead, lprt, imute)

C           SKIP JXSKIP TRACES:

            if (jxskip .gt. 0) then
               if (jb .lt. jxblk) then
                  call skipt (lu14, jxskip) 
               endif
            endif

C           CLEAR OUTPUT DEPTH RECORDS

            call vclr (depth((jbcont-1)*nzbig1*nxbig1+1 ),
     &                 1, jxntr*nzout) 

c           read incident field traveltime record & unpack(on Cray)
#ifdef CRAYSYSTEM
            read(luinc)(itmrfl(ij), ij=1, (jxntr*nzout+3)/4 )
            call usictc (itmrfl, 1, 
     &                   itminc((jbcont-1)*nzbig1*nxbig1+1),
     &                   jxntr*nzout, 2, 1)
#else
            i1 = (jbcont-1)*nzbig1*nxbig1+1
            i2 = i1 + (jxntr*nzout) - 1
            read(luinc)(itminc(ij), ij=i1,i2)
#endif
 7000    continue

         if ( jblk .eq. 1 ) endfile luhdr
         rewind luhdr

	 do 197 ij=1, migblk
	    if( jblk .eq. 1 ) endfile lutim(ij)
	    rewind lutim(ij)
 197     continue

C        IMAGE SEISMIC RECORDS
#ifdef CRAYSYSTEM
         cptime1 = second() 
#else
         te0 = etime(tarray)
         tu0 = tarray(1)
         ts0 = tarray(2)
#endif
         nxbias = -ntsmp + 1
         do 6100 jx = 1, jxntr

c           compute migration indices

            nxbias = nxbias + ntsmp
            iin1   = jx - nap
            iin2   = jx + nap
            irn1   = 1

            if (jx-nap .le. 0) then
               iin1 = 1
               irn1 = nap - jx + 2
            endif

            if (jx+nap .gt. jxntr) then
               iin2 = jxntr
            endif

            iib    = (iin1 - 1) * nzout
            irb    = (irn1 - 1) * nzout
            nrbias = iib - irb
            nabias = irn1 - iin1
            itlen  = (iin2 - iin1 + 1) * nzout

c           read and unpack (on cray) reflected traveltimes

            if (jx .eq. 1 ) then
#ifdef CRAYSYSTEM
               read(lurfl, rec=jx)(itime(ij), ij=1, (nxap*nzout+3)/4)
               call usictc (itime, 1, itmrfl, nxap*nzout, 2, 1) 
#else
               read(lurfl, rec=jx)(itmrfl(ij), ij=1, (nxap*nzout))
#endif
            endif

            if ((jx-1) / 3 * 3 .eq. jx-1 .and. nrrec.gt.1 ) then
#ifdef CRAYSYSTEM
               read(lurfl,rec=jx/3+1)(itime(ij), ij=1,(nxap*nzout+3)/4)
               isb =  1
               call usictc (itime(irb/4+1), isb, itmrfl(irb+1), itlen,
     &                      2, 1)
#else
               read(lurfl,rec=jx/3+1)(itmrfl(ij), ij=1,(nxap*nzout))
#endif
            endif

            jbcont = 0
            do 7100 jb = ibst, iben
               jbcont = jbcont + 1

c              fetch jx trace from lutim(jbcont) 

               read(unit=lutim(jbcont))(xwork(ij), ij=1, ntsmp)
               if (jx / istrid * istrid .ne. jx ) go to 7100

c              if jx is not a 'istrid' trace skip processing

c              itbias = plane wave time retardation

               if (pray(jbcont) .ge. 0.0) then
                  itbias = pray(jbcont)*float(jx   -1)*dxout / dt + 1.
                  itbig  = pray(jbcont)*float(jxntr-1)*dxout / dt + 1.
               else
                  itbias = -pray(jbcont)*float(jxntr-jx)*dxout / dt + 1.
                  itbig  = -pray(jbcont)*float(jxntr-1 )*dxout / dt + 1.
               endif


c              resample input trace into xwork

               call fftflt (xwork, zwork, ntsmp, nsampo, mrsmp, dtsec,
     &                      f1, f2, f3, f4, phase, expon, icinit, lprt)
	
               call ccuint (tabl1, zwork, ntsmp, tabl2,
     &                      xwork(itbias), ntime, iz, zz, icinit) 

c              clear work buffer

               call vclr (xwork(itbias+ntime+1), 1, itbig) 
               icinit = 0

c              compute diffraction stack

               nrbias2 = 0
               nzend   = nzen(jb) 
               nzend   = nzout 

               call cdstk2 (iib, iin1, iin2, nabias, nrbias, nrbias2,
     &                      nzend, nzout, nzst, itmrfl,
     &                      itminc( (jbcont-1)*nzbig1*nxbig1 + 1 ),
     &                      xwork,
     &                      coswgt( (jbcont-1)*napmx1*nzbig1 + 1 ),
     &                      depth( (jbcont-1)*nzbig1*nxbig1 + 1 ) )
 7100       continue
 6100    continue

         jbcont = 0
         do 7200 jb = ibst, iben
            jbcont = jbcont + 1


c           read incident amplitude from disk

            read(luamp)(pwamp(ij), ij=1, jxntr*nzout)

c           scale depth section by incident amplitude

            ind2d = -nzout+1
            do 7400 jx=1,jxntr
               ind2d = ind2d+nzout
               do 7300 jzx=ind2d,ind2d+nzout
               depth( (jbcont-1)*nzbig1*nxbig1 + jzx ) =
     &         depth( (jbcont-1)*nzbig1*nxbig1 + jzx )*pwamp(jzx)/
     &         (.5+pwamp(jzx)**2)
 7300          continue
 7400       continue

C           WRITE IMAGED SEISMIC RECORD TO OUTPUT DATASET

            nhead = jbcont
            call wrrec (lu24, rxx, irx, data, nzout, jxntr,
     &                  depth( (jbcont-1)*nzbig1*nxbig1+1 ),
     &                  luhdr, nhead, lprt, jb,
     &                  nztap, istrid, dztap, dzout, strch) 
 7200    continue

         rewind luhdr
	 do 198 ij=1, migblk
	    rewind lutim(ij)
 198     continue

#ifdef CRAYSYSTEM
         cptime2 = second() 
         cptim12 = (cptime2 - cptime1) / (iben - ibst + 1) 
         write (lprt,*)'completed processing records ', ibst, '-', iben
         write (lprt,*)'(CP TIME) / RECORD = ', cptim12
         write (ler,*) 'completed processing records ', ibst, '-', iben
         write (ler, *)   '(CP TIME) / RECORD = ', cptim12
#else
         te1 = etime(tarray)
         tu1 = tarray(1)
         ts1 = tarray(2)
         user = (tu1 - tu0) / (iben - ibst + 1)
         elapse = te1 - te0
         systm = ts1 - ts0
         write(ler,*)'completed processing records ', ibst, '-', iben
         write(ler,*)'(CP TIME) / RECORD = ', user
         write(lprt,*)'completed processing records ', ibst, '-', iben
         write(lprt,*)'(CP TIME) / RECORD = ', user
#endif
 6000 continue
#ifdef CRAYSYSTEM
      call date(fdate)
      call clock(time)
      write(lprt,*)fdate,time
#else
      write(lprt,*)fdate() 
#endif


C * * * * * * * * DATA PROCESSING COMPLETED * * * * * * * * * * * *

c     CLOSE MOD I/O DATASETS

      close( unit=lurfl )
      close( unit=luinc )
      close( unit=luhdr )
      close( unit=luamp )
      do 8200 nmod = 1, migblk
         close( lutim(nmod) )
8200  continue

      call lbclos (lu14) 
      call lbclos (lu24) 
      write (lprt, *) ' JOB COMPLETE'
      stop
      end
