C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c - modified all loops which ran from 1 to nwlim to instead run from 2 to nwlim
c   to prevent division by zero problems, since w0=0
c						- j.m. wade 10/13/98
c
c subroutine to downward continue a 2d  zero-offset wavefield using phase shift
c over an "iz0" jump
c
	subroutine dwn2d0(c_data,v,s,nkx,nw,nz,iz,kx2,nwlim,
     1			 dz,nxfft2,dw,c_mult,iz0,time,irev)
c
c
	integer	nkx,nw,iz,iz0
	integer	iw,nz,ikx,nwlim
c
	real	omega,dw,dz
	real	viz,viz1,vizviz,varg,sarg,siz
c
	complex	c_data(nw,nkx),c_mult(nw,nkx)
	real	disc
	real    v(nz),s(nz),kx2(nkx)
        logical time
 
        viz = v(iz)
        vizviz = viz * viz
        siz = s(iz)
        if ( time ) then
           siz = dz * float(iz0-1)
        else
           siz = dz * siz * float(iz0-1)
        endif

	do iw=2,nwlim

	   omega=(iw-1)*dw
           varg = irev * vizviz /(omega*omega)
           sarg = siz * omega

c
c make the complex multipliers
c	
	       do ikx=1,nxfft2

                  disc = 1. - varg * kx2(ikx)

  		     if(disc .ge. 0.0)then
  		       c_mult(iw,ikx)= cexp (cmplx(0.,sarg*sqrt(disc)))
  		     end if

                  if (ikx .gt. 1 .and. ikx .lt. nxfft2) then
                     c_mult(iw,nkx+2-ikx)=c_mult(iw,ikx)
                  endif

	       end do

c End of first frequency loop 
c
	end do

c
c Ok, apply the phase shift
c
        do ikx=1,nkx
           do iw=2,nwlim
              c_data(iw,ikx)=c_data(iw,ikx)*c_mult(iw,ikx)
           end do
        end do

c all done with this depth jump
c
	return
	end
