C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gazmig (data,nt,dt,nx,dx,dz,v,s,c_data,c_image,mult,
     :		         kx2,w0,depth,nx_fft,nt_fft,time,npadx,npadt,
     :                   dip_option,izfilt,m_order,dip_cutoff,aper,
     :                   nv_bin,nz,nwlim,iz0,verbos,nover,irev,interp)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

************************************************************************
*
*	GAZMIGSUB -- Gazdag phase shift migration (const. vel)
*
* 	new code routines by John Etgen (image2d, dwn2d)
*

	logical time
c
c normal declarations
c
	integer	nz,nx,nt_fft,nt,nwlim
	integer	nx_fft,npadx
	integer	iz,ix,ikx,it,iz0
	integer	nv_bin
	integer	dip_option,m_order,izfilt,irev,nover
c
	real	dw,w0,dx,dz,ds,dt
	real	sincut,dip_cutoff,aper
	real	pi,dkx
	real	vmin,vmax
	real	smin,smax
c
	complex c_data(nt_fft,nx_fft)
	complex c_image(nz,nx_fft),mult(nt_fft,nx_fft)
        complex ctemp(SZLNHD)
c
	real	data(nt,nx)
	real	v(nz),kx2(nx_fft)
	real	s(nz),depth(nz)

        logical verbos,interp

c
        pi=3.14159265358979323846
        dip_cutoff = pi/180.*dip_cutoff
        sincut = sin (dip_cutoff)
c
c find the min and the max velocities
c
          vmin=v(1)
          vmax=v(1)
          do iz=2,nz
            if(v(iz).lt.vmin)vmin=v(iz)
            if(v(iz).gt.vmax)vmax=v(iz)
          end do

c
c now discretize it more coarsely 
c
          smax=1./vmin
          smin=1./vmax
c
          do iz=1,nz
                s(iz)=1./v(iz)
                 if (verbos)
     1           write(LERR,*)'step ',iz,'  input velocity ',v(iz)
          end do
c
          ds=(smax-smin)/(nv_bin-1)
c
          if(ds.ne.0.0)then
            do iz=1,nz
                s(iz)=smin+ds*nint((s(iz)-smin)/ds)
                v(iz)=1./s(iz)
                if (verbos)
     1          write(LERR,*)'step ',iz,'  discretized velocity ',v(iz)
            end do
          end if

c if we are migrating in time, the velocity function has to be in time
c and the step has to be in time (dz=dt)
c Now fix up the "slowness" trace depending

        if(time)then
            do iz=1,nz
                s(iz)=dz
            end do
        else
            do iz=1,nz
                s(iz)=dz*s(iz)
            end do
        end if
c
c Compute the w values
c
	dw=2*pi/(nt_fft*dt)
	w0=0.
c
c Compute the kx values
c
	dkx=2*pi/(nx_fft*dx)
c
	do ikx=1,nx_fft/2+1
	   kx2(ikx)=((ikx-1)*dkx)**2
	end do
c
	do ikx=nx_fft/2+2,nx_fft
	   kx2(ikx)=((nx_fft+1-ikx)*dkx)**2
	end do

        nxfft2 = nx_fft / 2
        nxfft21 = nxfft2 + 1

c
c
c in any case, for dip filtering, we need to know the depth we are
c at for any iz
c
        if(.not. time)then
c
            do iz=1,nz
               depth(iz)=iz*dz
            end do
c
        else
c
            depth(1)=v(1)*dz
c
            do iz=2,nz
               depth(iz)=v(iz)*dz+depth(iz-1)
            end do
c
        end if


c
c initialize
c
	   do it=1,nt_fft
	  	do ix=1,nx_fft
		   c_data(it,ix)=cmplx(0.,0.)
		end do
	   end do
c

	   do it=1,nt
	      do ix=1,nx
		   c_data(it,ix+npadx)=cmplx(data(it,ix),0.)
                   data(it,ix) = 0.
	      end do
	   end do
c
           call cfft2d (c_data,nt_fft,nx_fft,1)

c
c initialize the output for this line, this vel
c
	     do iz=1,nz
	        do ix=1,nx_fft
		   c_image(iz,ix)=cmplx(0.,0.)
	        end do
	     end do
c
c for start times > 1 need to compute average velocity and
c start depth/time vector at appropriate level
c     iz0=2
c
      vav = 0
      do  i = 1, iz0
          vav = vav + v(i)
      enddo
      vav = vav / float(iz0)
      do  i = 1, iz0
          v(i) = vav
      enddo

      if (iz0 .gt. 1) then

         call dwn2d0(c_data,v,s,nx_fft,nt_fft,nz,1,kx2,nwlim,
     1               dz,nxfft21,dw,mult,iz0,time,irev)
      endif
 
c now loop over all depths and do the migration
c
	     do iz = iz0, nz
c
c make the image here
c
	       call image2d(c_image,c_data,nz,nt_fft,nx_fft,iz,
     1                      nwlim)
c
c downward continue the data one level

        call dwn2d(c_data,v,s,nx_fft,nt_fft,nz,iz,kx2,nwlim,
     1             nxfft21,dw,mult,depth,dip_option,iz0,
     2             m_order,dip_cutoff,sincut,aper,izfilt,irev)
c
c end loop over individual z levels c

	     end do

c
c Inverse 1Dfft this image
c
             ii = 0
	     do iz=1,nz,nover
                ii = ii + 1
c
		do ix=1,nx_fft
		ctemp(ix)=c_image(iz,ix)
	        end do
c
                call cfft (ctemp,nx_fft,-1)
c
c Extract out the part we want
c
	        do ix=1,nx
		   data (ii,ix)=real(ctemp(ix+npadx))
	        end do
c
	     end do

	return
	end
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
