C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C     PROGRAM MODULE  stolt
C
C**********************************************************************C
C
C stolt READS SEISMIC TRACE DATA FROM AN INPUT FILE, record-by-record,
C performs a stolt or optionally a phase shift migration,
C and writes the results to otap
c
c
c changes:
c
c     put in dynamic memory allocation for taper array as routine
c     blew out of memory with stacks containing greater than 10000 traces
c     Dec/96 Garossino
c
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR   ( SZLNHD )
      INTEGER     LHED  ( SZLNHD )
      INTEGER     ntrv  ( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes,luout,luvel
      integer     lvbytes
      integer     argis, ordfft
      integer     nsampo, ns, ne, irs, ire, itaper
      integer     imute(SZLNHD)

      real        dx, kmax, fmax, dt, dtw, pi, vdtodx, alpha
      real        head  ( SZLNHD )
      real        vel(SZLNHD), xtr(SZLNHD)
      real        s(SZLNHD), kx2(SZLNHD)
      real        rec(SZLNHD), depth(SZLNHD)
      real        tabl1(SZLNHD), tabl2(SZLNHD), zz(SZLNHD)
      integer     iz(SZLNHD), dip_option

      integer     itrh, itemi, item1, item2, item3, item4, item5, item6
      integer     errcod, item7, nsinc
      real        data, wrk4, wrk5, taper, wsinc
      complex     wrk2, wrk6, mult, c_data, c_image, cwork

      pointer     (wrkitrh, itrh(1))
      pointer     (wkaddr, data(1))
      pointer     (wkadr2, wrk2(1))
      pointer     (wkadr4, wrk4(1))
      pointer     (wkadr5, wrk5(1))
      pointer     (wkadr6, wrk6(1))
      pointer     (wkmult, mult(1))
      pointer     (wkwsinc, wsinc(1))
      pointer     (wkc_data, c_data(1))
      pointer     (wkc_image, c_image(1))
      pointer     (ptr_taper, taper(1))
      pointer     (wkcwork, cwork(1))

      CHARACTER   NAME * 5, ntap * 256, otap * 256
      character   vtap * 256, card * 80

      logical     verbos, heap, first, phz, const, time, automut
      logical     interp
 
      EQUIVALENCE ( ITR(  1), LHED(1), HEAD(1) )

      DATA NAME     /'STOLT'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      DATA first/.true./
      DATA const/.true./
      DATA automut/.false./
      DATA pi/3.14159265/
      DATA nsinc/32/

c  get online help if necessary

      if ( argis ('-?') .gt. 0 .or. 
     :     argis ('-h') .gt. 0 .or. 
     :     argis ('-help') .gt. 0 ) then
         call help ()
         stop
      endif

c  open printout file

#include <f77/open.h>

C read program parameters from command line argument string

      call cmdln (ntap,otap,vtap,ist,iend,ns,ne,irs,ire,verbos,
     1            alpha,kmax,fmax,v,dx,dtw,itaper,phz,const,time,
     2            npadx,npadt,dip_option,izfilt,m_order,
     3            dip_cutoff,aper,nv_bin,dz,nz,it0,irev)

c open input, output and velocity datasets

      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
      call getln (luvel, vtap, 'r', -1 )

C read and update line header, write line header, save key parameters.

      lbytes = 0
      call rtape ( luin, itr, lbyte )
      lbytes = lbyte
      if(lbytes .eq. 0) then
         write(LER,*)'phzshft: no header read on unit ',ntap
         write(LER,*)'FATAL'
         write(LER,*)'Check existence of file & rerun'
         write(LERR,*)'phzshft: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop 100
      endif
      CALL HLHprt    ( ITR , LBYTE, NAME, 5, LERR )

c  save key header values

#include <f77/saveh.h>

c     save certain parameters
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c Do we have a stacked section?

      if (ntrc .eq. 1) then
         ntrc = nrec
         nrec = 1
         write(LERR,*)' '
         write(LERR,*)'WARNING::'
         write(LERR,*)'Input data set has single trace records:'
         write(LERR,*)'we will assume input data is stacked section'
         write(LERR,*)' '
      endif

c  check to see if samp int is in micro secs

      dt = float(nsi)

      if (phz) dtw = dt

      if (dtw .eq. 0.0) then
          dtw = dt / 2.0
      endif
      nover = nint (dt/dtw)
      if (dt .ne. dtw) then
          nsampw = nover * nsamp - 1
          interp = .true.
      else
          nsampw = nsamp
          interp = .false.
      endif
      dt  = unitsc * dt
      dtw = unitsc * dtw

c ensure that command line values are compatible with data set

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

      nrecc  = ire - irs + 1
      ntr    = ne - ns + 1
      ntro   = ntr
      nsampo = nsamp

      if ( phz ) then
          nx = ntrc
          nt = nsampw
          if ( time ) then
c           dz = unitsc * nsi
            dz = dtw
            nz = nsampw
          else
            if (nz .eq. 0) nz = nsampw
          endif
          nsampo = nz
          if (nv_bin .eq. 0) then
             nv_bin = nz/10
          endif
          if (aper .eq. 0.0) then
              aper = nx * dx
          endif
          nv_bin = max (2 ,nv_bin)
          nx_padded = nx+2*npadx
          nt_padded = nt+npadt
          kmax = 1 / kmax
          ikmax = nint(kmax)
          ikmax = 1
          if (ikmax .ne. 1) then
                 ikmax = 2**ordfft(ikmax)
              kmax = 1 / float(ikmax)
          endif
1         continue
          nx_fft = 2 ** ordfft(nx_padded) / ikmax
c  can get by nicely without this (will work it out later) -- prg
c         if (nx_fft .lt. nsamp) then
c             if (ikmax .gt. 1) then
c                 write(LERR,*)'WARNING: gazdag option'
c                 write(LERR,*)'ikmax ',ikmax,' too large'
c                 ikmax = ikmax / 2
c                 if (ikmax .eq. 0) ikmax = 1
c                 kmax = 1 / float(ikmax)
c                 write(LERR,*)'changed to ',ikmax
c                 go to 1
c             endif
c         endif
          nt_fft = 2 ** ordfft(nt_padded)
          nwlim  = nt_fft
          nxpad  = nx_fft
          ntpad  = nt_fft
      else
         nu = ordfft( nsampw )
         ntpad = 2 ** nu
         nu = ordfft( ntro )
         nxpad = 2 ** nu
         do  i = 1, nsamp
             tabl1 (i) = (i-1) * dt
         enddo
          do  i = 1, nsamp
             tabl2 (i) = (i-1) * dt/2
          enddo
      endif

      ist  = ist/(dtw / unitsc)
      iend = iend/(dtw / unitsc)
      if(ist .le. 1)   ist = 1
      if(iend .le. 1) iend = nsampw
      if (phz .AND. it0 .lt. 0) then
         automut = .true.
      else
         it0 = it0 / nsi
         if (it0 .lt. 1) it0 = 1
      endif

c set fmax

      fnyq = .5/dtw

      if    (fmax .eq. 0.)    then
            fmax = .5 * fnyq
      elseif( fmax .gt. fnyq) then
            fmax = fnyq
      endif

      if ( phz ) then
         nwlim = nint (fmax * float(nwlim) / fnyq)
      else
         ntlim = fmax * float(ntpad) / fnyq + 1
         if (ntlim .gt. ntpad) ntlim = ntpad
         if (ntlim .le. .1*ntpad) then
            write(LERR,*)'Warning: '
            write(LERR,*)'  frequency ',fmax,' set too low'
         endif
      endif

c  save headers: exchange # traces/rec & # samples/rec

      call savew( itr, 'NumSmp', nsampo, LINHED)
      call savew( itr, 'NumTrc', ntro  , LINHED)
      call savew( itr, 'NumRec', nrecc , LINHED)

      IF (vtap(1:1) .ne. ' ') THEN

         if (phz) then

            if (const) then

               do  i = 1, nsampw
                  vel (i) = v
               enddo

            else

               lvbytes = 0
               call rtape ( luvel, ntrv, lvbytes )
               if(lvbytes .eq. 0) then
                  write(LER,*)'phzshft: no header read on unit ',vtap
                  write(LER,*)'Failure to open velocity tape -- FATAL'
                  write(LER,*)'Check existence of file & rerun'
                  write(LERR,*)'phzshft: no header read on unit ',vtap
                  write(LERR,*)'Failure to open velocity tape -- FATAL'
                  write(LERR,*)'Check existence of file & rerun'
                  stop 100
               endif
               call saver( ntrv, 'NumRec',  nrecv, LINHED)
               call saver( ntrv, 'NumTrc',  ntrcv, LINHED)
               call saver( ntrv, 'NumSmp', nsampv, LINHED)
               nv = ntrcv

            endif
            
         else

            call alloclun ( luvel )
            lo = lenth ( vtap )
            open (luvel, file = vtap(1:lo), status = 'unknown',
     :           iostat = ierr)
            if(ierr .ne. 0) then
               write(LER,*)'stolt: Could not open velocity file ',
     :              vtap
               write(LER,*)'Check permissions/spelling and rerun '
               write(LER,*)'using -v[]'
               write(LERR,*)'stolt: Could not open velocity file ',
     :              vtap
               write(LERR,*)'Check permissions/spelling and rerun '
               write(LERR,*)'using -v[]'
               stop 100
            endif

            rewind luvel
            nv = 0
            do  while (1.eq.1)

               read (luvel, '(a80)', end=4, err=666) card
               nv = nv + 1
               go to 5
 4             continue
               if (nv .eq. 0) then
                  write(LERR,*)' '
                  write(LERR,*)'ERROR in stolt:'
                  write(LERR,*)'End of file without reading any vels.'
                  write(LERR,*)'This might be a velocity tape input in'
                  write(LERR,*)'which case only -P option can be used'
                  write(LER ,*)' '
                  write(LER ,*)'ERROR in stolt:'
                  write(LER ,*)'End of file without reading any vels.'
                  write(LER ,*)'This might be a velocity tape input in'
                  write(LER ,*)'which case only -P option can be used'
                  stop 666
               endif
               go to 3

 5             continue
               call fsscnf (card,'%f %f',rec(nv), vel(nv) )
            enddo

 3          continue

            write(LERR,*)' '
            do  j = 1, nv
               vel (j) = vel (j) / 2
               write(LERR,*)'Record= ',rec(j),'  velocity= ',vel(j)
            enddo
            write(LERR,*)' '
            if (nv .eq. 1) v = vel (1)
            
            go to 6
 666        continue
 
           write(LERR,*)' '
           write(LERR,*)'ERROR in stolt:'
           write(LERR,*)'Something bad happened while reading input vel'
           write(LERR,*)'file for function number ',nv,' line was:',card
           write(LER ,*)' '
           write(LER ,*)'ERROR in stolt:'
           write(LER ,*)'Something bad happened while reading input vel'
           write(LER ,*)'file for function number ',nv,' line was:',card
 6         continue

        endif

      ENDIF

      dtr = dtw / dx
c------------------
c  v*dt/dx
c  for stolt
      if (.not.phz .AND. nv.le.1) then
          vdtodx = v * dtr
      endif
 
c------------------
c  migration factor
c  for stolt
          onea = 1. - alpha

c---------------------------------
c  change output bytes to reflect change from time to # traces
      obytes = SZTRHD + SZSMPD * nsampo


c---------------------------------
c  verbos printout
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', dt  
        write(LERR,*) ' Traces per Record  =  ', ntrc
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Output # samples   =  ', nsampo
        write(LERR,*) ' Working # samples  =  ', nsampw
        write(LERR,*) ' Working smaple int =  ', dtw
        write(LERR,*) ' Sample scaler      =  ', iscl
        write(LERR,*) ' Output # traces    =  ', ntr
        write(LERR,*) ' Output records     =  ', nrecc
        write(LERR,*) ' length padded trcs =  ', ntpad
        write(LERR,*) ' # padded traces    =  ', nxpad
        write(LERR,*) ' Input trace space  =  ', dx
        write(LERR,*) ' Upper freq limit   =  ', fmax
        if (.not. phz) then
        write(LERR,*) ' Stolt constant velocity migration'
        write(LERR,*) ' onea, vdtodx= ',alpha,onea,vdtodx
        else
        write(LERR,*) ' Phase Shift V(t) migration'
        endif
        if (phz) then
          write(LERR,*) ' Number freqs to use=  ', nwlim
          write(LERR,*) ' Wavenumber maximum =  ', kmax
          write(LERR,*) ' Trace pad (1 side) =  ', npadx
          write(LERR,*) ' Sample pad (bottom)=  ', npadt
          if (automut) then
          write(LERR,*) ' Using auto start time detect'
          else
          write(LERR,*) ' Mig sample start   =  ',it0,' (samps)'
          endif
          write(LERR,*) ' Velocity discretize step= ',nv_bin,' (samps)'
          write(LERR,*) ' Dip option         =  ',dip_option
          write(LERR,*) ' 0 = no dip filter'
          write(LERR,*) ' 1 = constant dip filter'
          write(LERR,*) ' 2 = time/depth variable dip filter'
          if (dip_option .eq. 2) then
          write(LERR,*) '   filter increment (samps) = ',izfilt
          write(LERR,*) '   filter order             = ',m_order
          write(LERR,*) '   maximum dip (deg)        = ',dip_cutoff
          write(LERR,*) '   aperture (ft or m)       = ',aper
          endif
        else
          if (irev .eq. 1)
     1    write(LERR,*) ' forward migration'
          if (irev .eq. -1)
     1    write(LERR,*) ' reverse migration'
          write(LERR,*) ' Number freqs to use=  ', ntlim
        endif

        if(vtap(1:1) .eq. ' ') then
        write(LERR,*) ' Migration Velocity =  ',2*v
        else
        write(LERR,*) ' Migration Velocity File =  ', vtap
        endif

c-----------------------------------------------
c  adjust historical line header & write header
      call savhlh ( itr, lbyte, lbyout )
 
      call wrtape(luout,itr,lbyout)

c------------------------------------------------
c  skip to start record
      call recskp(1,irs-1,luin,ntrc,itr)

c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.
      nmax = max0(ntpad,nxpad)

      itemi = ntrc * ITRWRD * SZSMPD

      item1 = nsampw*ntrc*SZSMPD

      if ( phz ) then
         item2 = 1
         item4 = 1
         item5 = 1
         item6 = 1
         item8 = 2*nt_fft*nx_fft*SZSMPD
         item9 = 2*nz*nx_fft*SZSMPD
      else
         item2 = 2*(ntpad+1)*(nxpad+1)*SZSMPD
         item3 = 1*nxpad*SZSMPD
         item4 = 2*(max(ntpad,nxpad)+1)*SZSMPD
         item5 = 1*ntpad*SZSMPD
         item6 = 2*(max(ntpad,nxpad)+1)*SZSMPD
         item8 = 1
         item9 = 1
      endif

      item7 = ntr * SZSMPD

      call galloc (wrkitrh, itemi, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkaddr, item1, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr2, item2, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr4, item4, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr5, item5, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkadr6, item6, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (ptr_taper, item7, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkmult, item8, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkc_data, item8, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkc_image, item9, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkcwork, 2*item4, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkwsinc, 2*(nsinc+1)*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item4,'  bytes'
         write(LERR,*) item5,'  bytes'
         write(LERR,*) item6,'  bytes'
         write(LERR,*) item7,'  bytes'
         write(LERR,*) item8,'  bytes'
         write(LERR,*) item8,'  bytes'
         write(LERR,*) item9,'  bytes'
         write(LER,*)'Unable to allocate workspace - ',
     1        'check printout file'
         go to 999
      else
         write(LERR,*)'Allocated workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item4,'  bytes'
         write(LERR,*) item5,'  bytes'
         write(LERR,*) item6,'  bytes'
         write(LERR,*) item7,'  bytes'
         write(LERR,*) item8,'  bytes'
         write(LERR,*) item8,'  bytes'
         write(LERR,*) item9,'  bytes'
      endif

c---------------------------------
c  compute taper

      call vfill (1.0, taper, 1, ntr)
      rtaper = itaper/100.
      itaper = rtaper * ntr

      write(LERR,*)' '
      write(LERR,*)'Number of traces each side of section to taper= ',
     1              itaper
 
      if (itaper .gt. 0) then
      do  7  i = 1, itaper
 
          fac = float(itaper - i)/float(itaper)
          taper(i) = 0.5 * (1. + cos (pi * fac))
          taper(ntr-i+1) = taper(i)
          write(LERR,*)'Taper(',i,') = ',taper(i)
 
7     continue
      endif


      write(LERR,*)' '

C**********************************************************************C
C
C     READ RECORD, DO phzshft MIGRATION, WRITE OUTPUT RECORD
C
C**********************************************************************C
      ifunc = 1
 
      DO 100 JJ = irs, ire

c-------------------------------
c  skip to desired trace
c-------------------------------
             call trcskp(jj,1,ns-1,luin,ntrc,itr)

c--------------------------------------------------
c  read record & store
c----------------------
           sumergi = 0.
           nlive = 0
           ntro = ntr
           ic = 0
           icinit = 1
           call vclr (data, 1, nsampw*ntrc)

           DO 99 KK = ns, ne

                 nbytes = 0
                 CALL RTAPE  ( LUIN , ITR, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'WARNING'
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 59
                 endif
                 call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       istatic, TRACEHEADER)
                 if (istatic .eq. 30000) then
                    call vclr (xtr,1,nsamp)
                 else
                    call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          idis   , TRACEHEADER)
                    nlive = nlive + 1
                 endif
                 ic = ic + 1
                 call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
                 call detmut (xtr, imute(ic), nsamp)
                 call vsmul (xtr, 1, taper(ic), xtr, 1, nsamp)

c-------------------
c  store record in
c  long vector
                 istrc = (ic-1)* nsampw
                 if (interp) then
                 call oversampt (xtr, nsamp,data(istrc+1) ,nsampw, 2,
     1                               wsinc, nsinc, icinit)
                 else
                 call vmov (xtr,1, data(istrc+1),1,nsampw)
                 endif
c                if(ic.eq.100)then
c                do ii=1,nsampw
c                write(15,*)ii,data(istrc+ii)
c                enddo
c                endif
c-------------------
c  save tr headers
                 ishdr = (ic-1) * ITRWRD
                 call vmov (itr,1, itrh(ishdr+1),1,ITRWRD)
 
   99      CONTINUE

   59      ntrk = ic

           if (ntrk .ne. ntr) then
               write(LERR,*)'WARNING:'
               write(LERR,*)'read ',ntrk,' traces from record ',jj
               write(LERR,*)'instead of ',ntr
               write(LERR,*)'processing continuing'
               ntro = ntrk
           endif

           minmut = nsamp
           do  k = 1, ntrk
               if (imute(k) .le. minmut) minmut = imute(k)
           enddo
           if (minmut .le. 2) minmut = 1
           if ( phz .AND. automut) it0 = minmut

           nlive = 0
           do  jtr = 1, ntrk
               istrc = (jtr-1) * nsampw
               do  i = it0, nsamp
                   amp = data(istrc+i)
                   if (amp .ne. 0.0) then
                       nlive = nlive + 1
                       sumergi = sumergi + amp * amp
                   endif
               enddo
           enddo
           
           sumergi = sqrt (sumergi/float(nlive))

c--------------------------------------------------

           IF (.not. phz) THEN
c-------------------
c   do stolt
           if (nlive .gt. 2) then
              if (nv .gt. 1)
     1        call rectrp (rec,v,vel,jj,dtr,vdtodx,ifunc,nv,
     2                     nsampw,phz)
              call stoltmg (data,ntpad,nxpad,onea,vdtodx,ntr,
     1                      nsampw,wrk2,wrk4,wrk6,first, irev,
     2                      tabl1, tabl2, zz, iz, isflg, cwork,
     3                      interp)
              first = .false.
           endif
c-------------------
           ELSE
c-------------------
c   do phzshft
           if (nlive .gt. 2) then
              if (const) then
              call rectrp (rec,v,vel,jj,dtr,vdtodx,ifunc,nv,
     1                     nsampw,phz)
              else
              call getvel (vel,nsampv,nsampw,ntpad,luvel,
     1                     const,ITHWP1,itr)
              endif

              write(LERR,*)'Migration start time= ',(it0-1)*nsi
              call  gazmig (data,nsampw,dtw,nx,dx,dz,vel,s,
     1                      c_data,c_image,mult,kx2,w0,depth,
     2                      nx_fft,nt_fft,time,npadx,npadt,
     3                      dip_option,izfilt,m_order,dip_cutoff,
     4                      aper,nv_bin,nz,nwlim,it0,verbos,
     5                      nover,irev,interp)
              first = .false.
           endif
c-------------------
           ENDIF

c------------------------------------------------
c  extract output
c  data from vector
           sumergo = 0.

           DO  j = 1, ntro
               nlive = 0
               istrc = (j-1) * nsampw
               do  i = it0, nsampw
                   xtri = data(istrc+i)
                   if (xtri .ne. 0.0) then
                      nlive = nlive + 1
                      sumergo = sumergo + xtri * xtri
                   endif
               enddo
           ENDDO
           sumergo = sqrt (sumergo/float(nlive))
           scl = sumergi / sumergo

           icinit = 1

           DO 199 KK = 1, ntro
                 istrc = (kk-1) * nsampw
                 call vmov (data(istrc+1), 1, xtr, 1, nsampo)
c--------------------
c  get back headers
                 ishdr = (kk-1) * ITRWRD
                 call vmov (itrh(ishdr+1), 1, itr, 1, ITRWRD)

                 call resmut (xtr, imute(kk), nsampo)
                 call vsmul   (xtr, 1, scl, itr(ITHWP1),1, nsampo)
                 CALL WRTAPE  ( LUOUT , ITR, OBYTES         )
 
  199      CONTINUE
c------------------------------------------------

           if (phz) then
              write(LERR,*) 'gazdag: processed Record=  ',jj
              write(LER ,*) 'gazdag: processed Record=  ',jj
           else
              write(LERR,*) 'stolt: processed Record=  ',jj
              write(LER ,*) 'stolt: processed Record=  ',jj
           endif

c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
             call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)


  100 CONTINUE

  999 continue
       call lbclos(luin)
       call lbclos(luout)
       stop 0
      END

c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for stolt: phase shift'
        write(LER,*)'V(t) migration or constant velocity migration'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-F[vtap]   -- optional velocity file name (see man)
     1'
        write(LER,*)'              -s[] & -e[] for phase shift option'
        write(LER,*)'-ns[ns]    -- start trace #                (first)'
        write(LER,*)'-ne[ne]    -- end trace #                   (last)'
        write(LER,*)'-rs[irs]   -- start record                 (first)'
        write(LER,*)'-re[ire]   -- end record                    (last)'
        write(LER,*)'-dx[dx]    -- input trace spacing (ft,m)    (none)'
        write(LER,*)'-ot[itap]  -- % taper each side of input rec   (5)'
        write(LER,*)'-v[v]      -- migration velocity (ft, m/s)  (none)'
        write(LER,*)'-fh[fmax]  -- upper freq limit (Hz)      (1/2 Nyq)'
        write(LER,*)'-R         -- reverse migration'
        write(LER,*)'-P         -- v(t) phase shift  migration, else'
        write(LER,*)'              stolt constant velocity migration'
        write(LER,*)'Phase Shift Options:'
        write(LER,*)'-dz[dz]    -- output time/depth interval      (dt)'
        write(LER,*)'-nz[nz]    -- output number samps  (same as input)'
        write(LER,*)'-t0[t0]    -- global migration start time   (0 ms)'
        write(LER,*)'-padx[pdx] -- pad trcs to sides of data set    (0)'
        write(LER,*)'-padt[pdt] -- pad samps to bottom of data set  (0)'
        write(LER,*)'-dip[id]   -- output dip options:'
        write(LER,*)'              -dip 0     (no dip filter)'
        write(LER,*)'              -dip 1     (constant dip filter)'
        write(LER,*)'              -dip 2     (time varying dip filter)'
        write(LER,*)'-mdip[mdip]-- maximum dip (deg)               (80)'
        write(LER,*)'-ord[ord]  -- (-dip2) filter order             (5)'
        write(LER,*)'-aper[aper]-- (-dip2) aperture in ft,m (ntrc * dx)'
        write(LER,*)'-izf[izf]  -- (-dip2) filter update samp incr (32)'
        write(LER,*)'-D         -- output in depth               (time)'
        write(LER,*)' '
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'     stolt -N[] -O[] -ns[] -ne[] -rs[] -re[]'
        write(LER,*)'           -dx[] [-R -F[] -v[]] -fh[] -ot[]'
        write(LER,*)'            [-P -dz[] -nz[] -padx[] -padt[] -dip[]'
        write(LER,*)'             -t0[] -izf[] -ord[] -mdip[] -aper[] ]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*256  input file name
c     otap  - C*256  output file name
c     vtap  - C*256  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c     irs   - I      start record
c     ire   - I      stop end record
c      ns   - I      start trace
c      ne   - I      end trace
c     dx    - R      shot spacing (input)
c     dtw   - R      working sample interval
c      v    - R      migration const vel
c    fmax   - R      upper  freq limit
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,vtap,ist,iend,ns,ne,irs,ire,verbos,
     1                  alpha,kmax,fmax,v,dx,dtw,itaper,phz,const,time,
     2                  npadx,npadt,dip_option,izfilt,m_order,
     3                  dip_cutoff,aper,nv_bin,dz,nz,it0,irev)

#include <f77/iounit.h>
      character  ntap*(*), otap*(*), vtap*(*)
      real       dz, dx, fmax, dtw, alpha, v, kmax
      real       dip_cutoff, aper, pi
      integer    argis,ist,iend,irs,ire,ns,ne,itaper,it0,irev
      integer    npadx, npadt, dip_option, izfilt, m_order, nv_bin
      logical    verbos, phz, const, time, depth, rev

      pi = 3.14159265
      irev = 1

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argstr('-F',vtap,' ',' ') 
          ist = 1
          iend = 0
c         call argi4('-s',ist,1,1)
c         call argi4('-e',iend,0,0)
          call argi4('-ns',ns,1,1)
          call argi4('-ns',ns,1,1)
          call argi4('-ne',ne,0,0)
          call argi4('-rs',irs,1,1)
          call argi4('-re',ire,0,0)
          call argi4('-ot',itaper,5,5)
          call argr4('-dx',dx,0.,0.)
          call argr4('-dz',dz,0.,0.)
          call argr4('-dt',dtw,0.,0.)
          call argr4('-v',v,0.,0.)
          call argr4('-fh',fmax,0.,0.)
          call argr4('-km',kmax,.5,.5)
          call argi4('-nz',nz,0,0)
          call argi4('-nv',nv_bin,0,0)
          call argi4('-padx',npadx,0,0)
          call argi4('-padt',npadt,0,0)
          call argi4('-dip',dip_option,0,0)
          call argi4('-t0',it0,0,0)
          if(dip_option .gt.0)then
            call argi4('-izf',izfilt,32,32)
            call argi4('-ord',m_order,5,5)
            call argr4('-mdip',dip_cutoff,80.,80.)
            call argr4('-aper',aper,0.,0.)
          end if
          call argr4('-a',alpha,0.01,0.01)

          rev    = (argis('-R') .gt. 0)
          phz    = (argis('-P') .gt. 0)
          depth  = (argis('-D') .gt. 0)
          verbos = (argis('-V') .gt. 0)

          if (rev) irev = -1

          time = .true.
          if ( depth ) time = .false.

          if (depth .AND. nz .eq. 0) then
             write(LER,*)'Must enter number depth samples - FATAL'
             write(LERR,*)'Must enter number depth samples - FATAL'
             stop 100
          endif
          if (depth .AND. dz .eq. 0.0) then
             write(LER,*)'Must enter depth sample interval - FATAL'
             write(LERR,*)'Must enter depth sample interval - FATAL'
             stop 100
          endif

          if (v .ne. 0.0) then
             const = .true.
             v = v / 2.
          else
             const = .false.
          endif

          if (dx .eq. 0.) then
             write(LER,*)'Must enter input trace interval - FATAL'
             write(LERR,*)'Must enter input trace interval - FATAL'
             stop 100
          endif
          if (v .eq. 0. .and. vtap(1:1) .eq. ' ') then
             write(LER,*)'Must enter velocity info - FATAL'
             write(LER,*)'either -v[const velocity] or,'
             write(LER,*)'-F[vel tape format file name]'
             write(LERR,*)'Must enter velocity info - FATAL'
             write(LERR,*)'either -v[const velocity] or,'
             write(LERR,*)'-F[vel tape format file name]'
             stop 100
          endif

      return
      end
