C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c----
c   routine to read a line of GECO (or BFILE) format time-velocity
c   pairs and pack them into the proper absolute positions of T & V
c   arrays.  "i" contains the starting pointer into these arrays,
c   e.g. for the first card i=1; for the second card i=6, etc
c----
      subroutine gline (card, i, time, vels)

      real       time (*), vels (*)
      character  card * 80, tag * 1

c----
c   determine number of T-V pairs on this card (go by "v" flag
c   in case we have a hanging "t")
c----
      ipair = 0
      do  ic = 1, 80
          if (card(ic:ic) .eq. 'v') ipair = ipair + 1
      enddo

c----
c   depending on how many pairs we have, read the values from
c   the card and pack them into the T & V vectors
c----
      if     (ipair .eq. 5) then

                      call fsscnf (card,'%s %f %s %f %s %f %s %f %s %f %
     1s %f %s %f %s %f %s %f %s %f'//char(0),tag,time(i),tag,vels(i),
     2      tag,time(i+1),tag,vels(i+1), tag,time(i+2),tag,vels(i+2),
     3      tag,time(i+3),tag,vels(i+3), tag,time(i+4),tag,vels(i+4))
            i = i + 5

      elseif (ipair .eq. 4) then

                      call fsscnf (card,'%s %f %s %f %s %f %s %f %s %f %
     1s %f %s %f %s %f'//char(0),tag,time(i),tag,vels(i),
     2      tag,time(i+1),tag,vels(i+1), tag,time(i+2),tag,vels(i+2),
     3      tag,time(i+3),tag,vels(i+3)                             )
            i = i + 4

      elseif (ipair .eq. 3) then

                      call fsscnf (card,'%s %f %s %f %s %f %s %f %s %f %
     1s %f'//char(0),tag,time(i),tag,vels(i),
     2      tag,time(i+1),tag,vels(i+1), tag,time(i+2),tag,vels(i+2))
            i = i + 3

      elseif (ipair .eq. 2) then

                      call fsscnf (card,
     1      '%s %f %s %f %s %f %s %f'//char(0),
     2      tag,time(i),tag,vels(i), tag,time(i+1),tag,vels(i+1))
            i = i + 2

      elseif (ipair .eq. 1) then

                      call fsscnf (card,'%s %f %s %f'//char(0),
     1      tag,time(i),tag,vels(i)                                 )
            i = i + 1

      endif

      return
      end
