C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine hint2d (lupik, nhor, maxpik, nrec, ntrc, nsamp,
     1                   unitr, unitt, units, offr, offt, name)

#include <f77/iounit.h>

      integer    lupik, nhor, maxpik, nrec, ntrc, nsamp
      real       unitr, unitt, units, offr, offt
      character  name*(*)
      character  card * 160

      rewind lupik

      read (lupik, '(a160)', end=999, err=666) card
      if (card(1:4) .ne. 'Unit') then
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in ',name
         write(LERR,*)'This is not a standard xsd pick file. First'
         write(LERR,*)'line of file reads as: ',card
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR in ',name
         write(LER ,*)'This is not a standard xsd pick file. First'
         write(LER ,*)'line of file reads as: ',card
         call ccexit (666)
      endif


c---
c  read standard xsd pick file
c---
      call fsscnf (card,
     1  '%s %f %f %f %d %d %d %s %f %f %f %s %d %d'//char(0),
     2             s1, unitr, unitt, units, nrec, ntrc, nsamp, s2,
     3             offr, offt, offs, s3, nhor, maxpik)

c---
c  ooops! this wasn't a standard xsd pick file; it might be an xmplot pick file
c---
      IF (nhor .eq. 0) THEN

         rewind lupik
         nhor = 0
         nent = 0
         maxent = 0
         read (lupik, '(a160)', end=999, err=666) card
         do while (1.eq.1)

            read (lupik, '(a160)', end=111, err=666) card
            if (card(1:1) .eq. 'S') then

                nhor = nhor + 1
                if (nhor .gt. 1) then
                   if (nent .eq. 0) then
                    write(LERR,*)' '
                    write(LERR,*)'FATAL ERROR in slvr 2D horz reader:'
                    write(LERR,*)'No picks found in a segment!'
                    go to 666
                   endif
                   if (nent .ge. maxent) maxent = nent
                   nent = 0
                endif

            else

                nent = nent + 1

            endif


         enddo

111      continue
         if (nent .eq. 0) then
          write(LERR,*)' '
          write(LERR,*)'FATAL ERROR in slvr 2D horz reader:'
          write(LERR,*)'No picks found in a segment!'
          go to 666
         endif
         if (nent .ge. maxent) maxent = nent

      ENDIF

      if (ntrc .ne. 1) then
         write(LERR,*)' '
         write(LER ,*)'WARNING from ',name,' See printout file'
         write(LERR,*)'WARNING from ',name
         write(LERR,*)'Picks were made on stack with greater than 1 trc'
         write(LERR,*)'records. Output velocity file will be single trc'
         write(LERR,*)'records'
         write(LERR,*)'Velocity functions must be keyed to seql rec #'
      endif

      return

999   continue

      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR in ',name
      write(LERR,*)'Pick file appears to be empty!'
      write(LER ,*)' '
      write(LER ,*)'FATAL ERROR in ',name
      write(LER ,*)'Pick file appears to be empty!'
      call ccexit (999)

666   continue
         
      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR in ',name
      write(LERR,*)'Unable to read pick file!'
      write(LER ,*)' '
      write(LER ,*)'FATAL ERROR in ',name
      write(LER ,*)'Unable to read pick file!'
      call ccexit (666)

      end
