C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine hint3d (lupik, nhor, limin, limax, dimin, dimax,
     1                   nli, ndi, xsd, lmk, name, XYs, IX1, IY1,
     2                   NX, NY, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     3                   DX, DY)

#include <f77/iounit.h>

      integer    lupik, nhor, limin, limax, dimin, dimax, nli, ndi
      integer    nl, nd, numli, numdi, nlmin, ndmin, nlmax, ndmax
      integer    li, di, lilst, dilst, NX, NY, IX1, IY1
      real       DX, DY
      real * 8   XX, XY, YX, YY, XXT, XYT, YXT, YYT
      character  name*(*)
      character  card * 80
      logical    xsd, lmk, XYs, limit

      rewind lupik

      if ( limax.eq.0 .AND. dimax.eq.0) then

         limin =  99999999
         limax = -99999999
         dimin =  99999999
         dimax = -99999999
         limit = .false.

      else

         limit = .true.

      endif
         
      ll    = 0
      nl    = 0
      nd    = 0
      nhor  = 0
      numli = 0
      numdi = 0
      lilst = -99999999
      dilst = -99999999
      nlmin =  99999999
      ndmin =  99999999
      nlmax = -99999999
      ndmax = -99999999

      DO while (1.eq.1)

         nhor = nhor + 1

         DO while (1.eq.1)

            ll = ll + 1
            read (lupik, '(a80)', end=111, err=666) card
            go to 112
111         continue
            if (ll .ge. 1) then
                write(LERR,*)' '
                write(LERR,*)'Message from horizon file reader:'
                write(LERR,*)'Hit EOF at line ',ll,' after reading'
                write(LERR,*)nhor,' horizons.'
                go to 777
            else
                go to 999
            endif
112         continue

            nch = lenth (card)
            if (nch .eq. 0) then

               go to 1

            else

               call fsscnf (card,'%f %f %f %f %f'//char(0),
     1			xli, xdi, CX, CY, t)

               IWRN = 0
               IF ( XYs ) THEN

                  call xfmfwd (CX, CY, LI, DI, CXT, CYT, BXT, BYT,
     1                         IWRN, IX1, IY1, XX, XY, YX, YY, XXT, XYT,
     2                         YXT, YYT, DX, DY, NDI, NLI)

                 if (LI .LT. limin .AND. limit) then
                   write(LERR,*)'WARNING for horizon ',nhor
                   write(LERR,*)'Found LI ',li,' < specified min ',limin
                   write(LERR,*)'Card entry:'
                   write(LERR,*) card
                 endif
                 if (LI .GT. limax .AND. limit) then
                   write(LERR,*)'WARNING for horizon ',nhor
                   write(LERR,*)'Found LI ',li,' > specified max ',limax
                   write(LERR,*)'Card entry:'
                   write(LERR,*) card
                 endif
                 if (DI .LT. limin .AND. limit) then
                   write(LERR,*)'WARNING for horizon ',nhor
                   write(LERR,*)'Found DI ',di,' < specified min ',dimin
                   write(LERR,*)'Card entry:'
                   write(LERR,*) card
                 endif
                 if (DI .GT. limax .AND. limit) then
                   write(LERR,*)'WARNING for horizon ',nhor
                   write(LERR,*)'Found DI ',di,' > specified max ',dimax
                   write(LERR,*)'Card entry:'
                   write(LERR,*) card
                 endif
 
               ELSE

                  li = nint (xli)
                  di = nint (xdi)

               ENDIF

               if (di .ne. dilst) then
                   dilst = di
                   nd = nd + 1
               endif
               if (li .ne. lilst) then
                   nl = nl + 1
                   if (nd .ge. numdi) numdi = nd
                   nd = 0
                   lilst = li
               endif

               if (li .le. nlmin) nlmin = li
               if (li .ge. nlmax) nlmax = li
               if (di .le. ndmin) ndmin = di
               if (di .ge. ndmax) ndmax = di


            endif

         ENDDO

1        continue

         if (nl .ge. numli) numli = nl

      ENDDO

777   continue

      write(LERR,*)' '
      write(LERR,*)'Using 3D options:'
      write(LERR,*)'Number horizons found        =  ',nhor
      write(LERR,*)'Max number of DIs per line   =  ',nd
      write(LERR,*)'Max number of LIs per horizon=  ',nl
      write(LERR,*)' '


      IF ( limit ) THEN

        if (dimin .lt. ndmin) then
           write(LERR,*)' '
           write(LERR,*)'WARNING from horizon reader:'
           write(LERR,*)'Requested minimum DI ',dimin,' which is less'
           write(LERR,*)'than ',ndmin,' available in horizon file. Will'
           write(LERR,*)'adjust min DI to correspond to horz file.'
           write(LERR,*)' '
           dimin = ndmin
        endif

        if (dimax .gt. ndmax) then
           write(LERR,*)' '
           write(LERR,*)'WARNING from horizon reader:'
           write(LERR,*)'Requested maximum DI ',dimax,' which is larger'
           write(LERR,*)'than ',ndmax,' available in horizon file. Will'
           write(LERR,*)'adjust max DI to correspond to horz file.'
           write(LERR,*)' '
           dimin = ndmin
        endif

        if (limin .lt. nlmin) then
           write(LERR,*)' '
           write(LERR,*)'WARNING from horizon reader:'
           write(LERR,*)'Requested minimum DI ',limin,' which is less'
           write(LERR,*)'than ',nlmin,' available in horizon file. Will'
           write(LERR,*)'adjust min DI to correspond to horz file.'
           write(LERR,*)' '
           limin = nlmin
        endif
 
        if (limax .gt. nlmax) then
           write(LERR,*)' '
           write(LERR,*)'WARNING from horizon reader:'
           write(LERR,*)'Requested maximum DI ',limax,' which is larger'
           write(LERR,*)'than ',nlmax,' available in horizon file. Will'
           write(LERR,*)'adjust max DI to correspond to horz file.'
           write(LERR,*)' '
           limax = nlmax
        endif

      ELSE

        limin = nlmin
        limax = nlmax
        dimin = ndmin
        dimax = ndmax

      ENDIF

      write(LERR,*)' '
      write(LERR,*)'Using 3D option:'
      write(LERR,*)'Min DI found in horizon file=  ', ndmin
      write(LERR,*)'Max DI found in horizon file=  ', ndmax
      write(LERR,*)'Min LI found in horizon file=  ', nlmin
      write(LERR,*)'Max LI found in horizon file=  ', nlmax
      write(LERR,*)'Min LI limit =  ',limin
      write(LERR,*)'Max LI limit =  ',limax
      write(LERR,*)'Min DI limit =  ',dimin
      write(LERR,*)'Max DI limit =  ',dimax

      nli = limax - limin + 1
      ndi = dimax - dimin + 1

      return

999   continue

      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR in ',name
      write(LERR,*)'Horizon file appears to be empty!'
      write(LER ,*)' '
      write(LER ,*)'FATAL ERROR in ',name
      write(LER ,*)'Horizon file appears to be empty!'
      call ccexit (999)

666   continue

      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR in ',name
      write(LERR,*)'Unable to read horizon file!'
      write(LER ,*)' '
      write(LER ,*)'FATAL ERROR in ',name
      write(LER ,*)'Unable to read horizon file!'
      call ccexit (666)


      end
