C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine rdvels (luvel, maxnum, maxfunc, velocities, times,
     1                    livec, divec, verbos, si, nhor, ndi, nli,
     2                    fmap, D3, name, IX1, IY1, DX, DY, NX, NY,
     3                    XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     4                    minli, maxli, mindi, maxdi, geco, tdfn, digi,
     5                    XYs, tim, vel, work, key, nv)

#include <f77/iounit.h>

c----
c   routine to read in velocity functions and fill out appropriate location
c   vectors (either 2D or 3D)
c----

      real      velocities (maxnum, maxfunc)
      real      times      (maxnum, maxfunc)
      real      tim (nv), vel (nv), work (nv)

      integer   livec (maxfunc), divec (maxfunc)
      integer   fmap (ndi, nli), key (nv)

      character  name*(*), card * 80, tard * 80, c1 * 1, c2 * 1
      integer    luvel, maxnum, maxfunc, nhor, ndi, nli
      integer    lidel, didel, li, di
      integer    minli, maxli, mindi, maxdi
      real       si
      real       DX, DY
      REAL*8     XX, XY, YX, YY, XXT, XYT, YXT, YYT
      logical    D3, tdfn, digi, geco, XYs, verbos, got, EOF

      rewind luvel

      do  jj = 1, maxfunc
          call vclr (times     (1,jj), 1, maxnum)
          call vclr (velocities(1,jj), 1, maxnum)
      enddo

c----
c   Read 3D functions
c----
      IF ( D3 .and. digi ) THEN

c----
c   clear location matrix (ndi rows x nli cols). There will be a sequence
c   number corresponding to the function at some LI/DI and there will be
c   a zero elsewhere. Also there will be vectors of LI & DI locations.
c----
         do  j = 1, nli
             do  i = 1, ndi
                 fmap (i,j) = 0
             enddo
         enddo

C**********************************************************************C
C     read input vel file
C**********************************************************************C
         ixlst  = 0
         iylst  = 0
         iif = 0
         nf  = 0
         got = .false.
         EOF = .false.
 
         DO while (1.eq.1)
 
            read (luvel, '(a80)', end=10) card
    
            go to 12
c----
c   last function read hit end of input file
c----
10          continue
 
c----
c   if we've already written out last valid function then exit routine
c   otherwise we need to jump into that part of the "IF" below that
c   builds the TDFN output and tell the program this will be the last
c   function.
c   also if there are less than 2 entries in the last cards read it is
c   not a valid function and so exit
c----
            ixlst = 0
            iylst = 0
            got = .true.
            EOF = .true.
 
            if (iif .le. 1) go to 299
            if (got) go to 12
 
            go to 13
 
12          continue

c----
c   read "card" for input values. The valid ones are ICX,ICY,time,vel
c   the first 2 can be dummy integers (this is basically Landmark format).
c   We either use the XY locations OR the LI/DIs
c----
            call fsscnf (card,'%d %d %d %d %f %f'//char(0),
     1                   nline,ixline,ICX,ICY,time,veloc)
            if (.not. XYs) then
               ICX = nline
               ICY = ixline
            endif

13          continue
 
c----
c   assuming each function is together in the file determine end of function
c   by sensing when either the X or Y coordinate changes. got=true means we
c   have sensed a change in the X or Y coords and therefore have a complete
c   function in itim & ivel vectors. got=false means we are still reading the
c   current function.
c----

            IF (ICX .ne. ixlst .OR. ICY .ne. iylst) THEN
 
c----
c   end of current function sensed: we need to write out old function
c   and then determine if upcoming function lies within box defined on
c   cmd line
c   we have a valid function ONLY if there are more than 2 entries
c----
               if (got) then
 
c----
c   for completed valid function:
c   sort in case times are not in ascending order
c   then store in time-velocity arrays and update function map
c----
                  if ( iif .gt. 1) then
 
                     nf = nf + 1
 
                     if (iif .gt. maxnum) then
                      write(LERR,*)' '
                      write(LERR,*)'FATAL ERROR reading velocity file:'
                      write(LERR,*)'For function ',nf,' I read ',iif,
     1                ' entries but I the max number should be ',maxnum
                      write(LER ,*)' ',name
                      write(LER ,*)'FATAL ERROR reading velocity file:'
                      write(LER ,*)'For function ',nf,' I read ',iif,
     1                ' entries but I the max number should be ',maxnum
                      call ccexit (666)
                     endif

                     call sort (tim, key, iif)
                     do  i = 1, iif
                         work (i) = vel (key(i))
                     enddo

                     do  i = 1, iif
                         times      (i, nf) = tim  (i)
                         velocities (i, nf) = work (i)
                     enddo

c----
c   clear velocity & time arrays. If this is really the last function
c   then we don't want to jump up to read another card - we need to exit
c   Bump up the function counter
c----
                     do  i = 1, iif
                         tim (i) = 0
                         vel (i) = 0
                     enddo

                     if (EOF) go to 299
 
                  endif
   
               endif
 
c----
c   see if upcoming function lies with defined box (also pick up first
c   read T-V pair and put into time & velocity arrays in case).
c----
               iif = 1
               vel (iif) = veloc
               tim (iif) = time
               CX = ICX
               CY = ICY
               IWRN = 0

               if (XYs) then
 
                  CALL XFMFWD (CX, CY, LI, DI, CXT, CYT,BXT,BYT, IWRN,
     1                         IX1, IY1, XX, XY, YX, YY,XXT,XYT,YXT,YYT,
     2                         DX, DY, NY, NX)
               else
 
                  li = ICX
                  di = ICY
 
               endif

               IF (LI .LT. MINLI) IWRN = 1
               IF (LI .GT. MAXLI) IWRN = 1
               IF (DI .LT. MINDI) IWRN = 1
               IF (DI .GT. MAXDI) IWRN = 1
c----
c   if function lies within box set got=true to say we have a valid function
c   being read; set the ixlst,iylst to the current X,Y so we will be able to
c   sense when this function ends. then drop out og the "IF" and back to
c   read the next function.
c----
               if (IWRN .eq. 0) then
c----
c   If first entry of current function then store the LI/DI values
c----
                  livec (nf+1) = LI
                  divec (nf+1) = DI
 
                  got = .true.
                  ixlst = ICX
                  iylst = ICY
c----
c   if function does not lie within the box set got=false and set ixlst,iylst
c   to zero. This will cause the next card to be read, and its XY checked for
c   position in the box. If this is still part of the current outside function
c   then the flow control will return to this point. The cycle repeats until
c   a function lying within the box is found.
c----
               else
                  got = .false.
                  ixlst = 0
                  iylst = 0
               endif
 
c----
c   while reading current function values we need to check the possibility
c   that there are XY entries that contain "null" velocity entries (added
c   to work on geostat output). "if" will be the total number of entries
c   in current function.
c----
            ELSE
 
               if (veloc .gt. 0.0) then
                  iif = iif + 1
                  vel (iif) = veloc
                  tim (iif) = time
               endif
 
            ENDIF
 
 
 
 
         ENDDO

299      continue

         do  j = 1, maxfunc
             fmap ( divec(j), livec(j) ) = j
         enddo

         return

      ELSEIF ( D3 .and. geco ) THEN

c----
c   clear location matrix (ndi rows x nli cols). There will be a sequence
c   number corresponding to the function at some LI/DI and there will be
c   a zero elsewhere. Also there will be vectors of LI & DI locations.
c----
         do  j = 1, nli
             do  i = 1, ndi
                 fmap (i,j) = 0
             enddo
         enddo
 
C**********************************************************************C
C     read input vel file
C**********************************************************************C

c----
c   read every line in input velocity file. Check for EOF and if so
c   make sure we have at least 1 valid function, otherwise emit error
c   message
c----
         DO while (1.eq.1)
 
            read (luvel, '(a80)', end=30, err=366) card
c----
c   As we read each card we find any blank offset and use this as a
c   pointer offset into the card field
c----
            ib = 0
            do  i = 1, 80
                if (card(i:i) .eq. ' ') then
                   ib = ib + 1
                else
                   go to 31
                endif
            enddo
31          continue
 
c----
c   jump around EOF messages
c----
            go to 32
30          continue

            if (nf .gt. 0) then
               write (LERR,*)'GECO format input file:'
               write (LERR,*)'Hit end of file finding ',nf,' functions'
               go to 399
            else
               write(LERR,*)'FATAL ERROR in slvr geco format:'
               write(LERR,*)'Found no functions. Check input file fmt'
               go to 399
            endif
 
32          continue
 
c----
c   If a card begins with 'sp' it contains XY info and is the start of
c   the next function
c----
            IF (card(1+ib:2+ib) .eq. 'sp') THEN
 
c----
c   Increment function counter. Then check for the first occurrence of
c   either an X or a Y. Starting from this point in the card field copy
c   the remaining columns to another character vector to simplify reading
c   the XY fields with fsscnf.
c   Accomodate possible order switching of XYs and extract XY into. If
c   there's not XY into branch to error messages.
c----
               nf = nf + 1
               ip = 0
               do  i = 1, 80
 
                   if (card(i:i) .eq. 'x' .OR. card(i:i) .eq. 'y') then
                       ip = i
                       il = 0
                       do  ii = i, 80
                           il = il + 1
                           tard (il:il) = card (ii:ii)
                       enddo
                       call fsscnf (tard,'%s %d %s %d'//char(0),
     1					c1,iv1,c2,iv2)
                       if (c1 .eq. 'x' .AND. c2 .eq. 'y') then
                          ICX = iv1
                          ICY = iv2
                       elseif (c1 .eq. 'y' .AND. c2 .eq. 'y') then
                          ICX = iv2
                          ICY = iv1
                       else
                          go to 33
                       endif
                       go to 34
                   endif
               enddo
33             continue
 
               write(LERR,*)'FATAL ERROR in slvr geco format:'
               write(LERR,*)'Unable to locate X or Y coords for functn'
               write(LERR,*)nf,' Check this function in input file.'
               go to 399
 
34             continue
 
c----
c   XY info looks ok. Determine if the XY point is within the survey
c   boundaries. If not then go read input to start of next function.
c----
               CX = ICX
               CY = ICY
               IWRN = 0
               CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                      IX1, IY1, XX, XY, YX, YY, XXT, XYT,YXT,YYT,
     2                      DX, DY, NY, NX)
 
               IF (LI .LT. MINLI) IWRN = 1
               IF (LI .GT. MAXLI) IWRN = 1
               IF (DI .LT. MINDI) IWRN = 1
               IF (DI .GT. MAXDI) IWRN = 1
 
            if (IWRN .eq. 1) go to 300
 
c----
c   Current function lies within survey boundaries.
c----
               if = 1
 
               do while (1.eq.1)
 
                  read (luvel, '(a80)', end=35, err=366) card
                  go to 36
 
c----
c   If this is not the last function then press on...
c----
35                continue
 
c----
c   If this is the last function then set the character trigger for
c   end of function
c----
                  if (if .gt. 1) then
                     card(1+ib:4+ib) = 'line'
                  else
                     go to 30
                  endif
 
36                continue
 
c----
c   Within the current function we take each card and extract the T-V
c   pairs, putting them in vectors tt & vv (the pointer "if" keeps
c   increasing within function gline)
c----
                  if (card(1+ib:1+ib) .eq. 't') then
 
                     call gline (card, if, tim, vel)

c----
c   The end of the current function has been found. Determine is the
c   number of elements in current function exceeds maximum
c----
                  elseif (card(1+ib:4+ib) .eq. 'line') then
 
                     if = if - 1
                     livec (nf) = li
                     divec (nf) = di
                     call sort (tim, key, if)
                     do  i = 1, if
                         work (i) = vel (key(i))
                     enddo
 
                     do  i = 1, if
                         times      (i, nf) = tim  (i)
                         velocities (i, nf) = work (i)
                     enddo

c----
c   Initialize character array for next function then
c   jump out of loop which reads a function to the loop that
c   looks for next function.
c----
                     do  i = 1, 80
                         card (i:i) = ' '
                     enddo
 
                     go to 300
 
                  endif
 
               enddo
 
            ENDIF
 
300         CONTINUE
 
         ENDDO
 
         go to 399
 
366      continue
 
         write(LERR,*)' '
         write(LERR,*)'ERROR in slvr geco reader:'
         write(LERR,*)'Something bad happened while reading input vel'
         write(LERR,*)'file for function number ',nf,' line was:',card
         write(LER ,*)' '
         write(LER ,*)'ERROR in slvr geco reader:'
         write(LER ,*)'Something bad happened while reading input vel'
         write(LER ,*)'file for function number ',nf,' line was:',card
 
399      continue
 
         do  j = 1, maxfunc
             fmap ( divec(j), livec(j) ) = j
         enddo
 
         return

      ELSEIF ( D3 .and. tdfn ) THEN
c----
c   clear location matrix (ndi rows x nli cols). There will be a sequence
c   number corresponding to the function at some LI/DI and there will be
c   a zero elsewhere. Also there will be vectors of LI & DI locations.
c----
         do  j = 1, nli
             do  i = 1, ndi
                 fmap (i,j) = 0
             enddo
         enddo

         do  jj = 1, maxfunc

             call Rd0_TDFN ( luvel, maxnum, npairs, velocities(1,jj),
     1                       times(1,jj), livec(jj), divec(jj), verbos,
     2                       si, name, jj)
             fmap ( divec(jj), livec(jj) ) = jj

         enddo

         lidel = 9999999
         didel = 9999999
         do  jj = 1, maxfunc
         do  kk = 1, maxfunc
             idifdi = iabs (divec (jj) - divec (kk))
             idifli = iabs (livec (jj) - livec (kk))
             if (idifdi .ne. 0 .and. idifli .ne. 0) then
                if (idifdi .le. didel) didel = idifdi
                if (idifli .le. lidel) lidel = idifli
             endif
         enddo
         enddo
         write(LERR,*)' '
         write(LERR,*)'Minimum DI separation of velocity functions= ',
     1                 didel
         write(LERR,*)'Minimum LI separation of velocity functions= ',
     1                 lidel
         write(LERR,*)' '


c----
c   Read 2D functions
c----
      ELSE

         do  jj = 1, maxfunc

             call Rd_TDFN ( luvel, maxnum, npairs, velocities(1,jj),
     1                      times(1,jj), divec(jj), verbos, si, name,
     2                      jj)
         enddo

      ENDIF

      return
      end
