C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine velinit (luvel, tdfn, geco, g2d, digi, D3,
     1               maxnum, maxfunc, name, IX1, IY1, DX, DY,
     2               XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     3               minli, maxli, mindi, maxdi, NX, NY,
     4               XYs)

c---
c  routine to make a pass through the velocity function file to
c  determine (1) the number of functions and (2) the maximum
c  number of entries in a function. This is necessary for
c  dynamic memory allocation later in the main code.
c---

#include <f77/iounit.h>

      integer   luvel, maxnum, maxfunc
      integer   card_number, icount, ivel(7), itim(7), LI, DI
      logical   tdfn, geco, g2d, digi, D3, got, EOF, XYs
      character name*(*), card * 80, tard * 80, c1 * 1, c2 * 1
      REAL*8    XX, XY, YX, YY, XXT, XYT, YXT, YYT
      REAL      DX, DY
      integer   minli, maxli, mindi, maxdi, NX, NY

      rewind luvel

      maxnum  = 0
      maxfunc = 0

      IF (tdfn .AND. .not.D3) THEN

         DO While (1.eq.1)
 
c read the TDFN cards and retrieve the time_depth, velocity pairs
c while doing this only watch for the 9TDFN card which will signal the
c end of the current function.  The number of cards that come before
c is unimportant.
            do while ( 1 .eq. 1 )
    
               icount = icount + 7
 
               read ( luvel, 109, end=899, err=890 ) card_number,
     :              ( itim(i), ivel(i), i= 1,7 ), DI
 109           format( i1, 4x, 7(I4,I5), 7x, i5 )

               IF ( card_number .ne. 9 ) then
 
                    npairs = npairs + 7
 
               ELSEIF ( card_number .eq. 9 ) then
 
                  do i = 1, 7
 
c watch for zero entries on the last card
c prg: watch for a fully filled last card (if we don't break out we'll
c prg: end up going back to read the very next card as part of the
c prg: current function
 
                     if( ivel(i) .gt. 0.) then
                        npairs = npairs + 1
                        if (i .eq. 7 ) then
                           go to 880
                        endif
                     else
                           go to 880
                     endif
    
                  enddo
 
               ENDIF
 
            enddo

 880        continue

            if (npairs .ge. maxnum) maxnum = npairs
            icount = -6
            npairs = 0
            maxfunc = maxfunc + 1
 
         ENDDO
 
 890     continue
 
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in ',name
         write(LERR,*)'Error reading standard TDFN file '
         write(LERR,*)'Check file and resubmit '
         write(LER,*)' '
         write(LER ,*)'FATAL ERROR in ',name
         write(LER ,*)'Error reading standard TDFN file '
         write(LER ,*)'Check file and resubmit '
         stop
 
 
 899     continue
         return


      ELSEIF (tdfn .AND. D3) THEN

c read the 0TDFN card and retrieve the LI and DI values
 
         DO While (1.eq.1)

            npairs = 0
            icount = -6
 
            read(luvel, 15, end=999, err=990 ) card_number, LI, DI
 15         format(i1,4x,i5,i5)
 
            if ( card_number .ne. 0 ) then
               write(LERR,*)' '
               write(LERR,*)'FATAL ERROR in ',name
               write(LERR,*)' No 0TDFN card found'
               write(LER,*)' '
               write(LER ,*)'FATAL ERROR in ',name
               write(LER ,*)' No 0TDFN card found'
               stop
            endif
 
c read the TDFN cards and retrieve the time_depth, velocity pairs
c while doing this only watch for the 9TDFN card which will signal the
c end of the current function.  The number of cards that come before
c is unimportant.
            do while ( 1 .eq. 1 )
 
               icount = icount + 7
 
               read ( luvel, 110, end=999, err=990 ) card_number,
     :              ( itim(i), ivel(i), i= 1,7 )
 110           format( i1, 4x, 7(I4,I5) )
 
               IF ( card_number .ne. 9 ) then
 
                    npairs = npairs + 7
 
               ELSEIF ( card_number .eq. 9 ) then
 
                  do i = 1, 7
 
c watch for zero entries on the last card
c prg: watch for a fully filled last card (if we don't break out we'll
c prg: end up going back to read the very next card as part of the
c prg: current function
 
                     if( ivel(i) .gt. 0.) then
                        npairs = npairs + 1
                        if (i .eq. 7 ) then
                           go to 980
                        endif
                     else
                        goto 980
                     endif
 
                  enddo
 
               ENDIF
 
            enddo

 980        continue

            if (npairs .ge. maxnum) maxnum = npairs
            maxfunc = maxfunc + 1
   
         ENDDO

 990     continue
 
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in ',name
         write(LERR,*)'Error reading 3D TDFN file '
         write(LERR,*)'Check file and resubmit '
         write(LER,*)' '
         write(LER ,*)'FATAL ERROR in ',name
         write(LER ,*)'Error reading 3D TDFN file '
         write(LER ,*)'Check file and resubmit '
         stop

 
 999     continue
         return


      ELSEIF ( digi ) THEN

C**********************************************************************C
C     read input vel file
C**********************************************************************C
      ixlst  = 0
      iylst  = 0
      if = 0
      nf = 0
      got = .false.
      EOF = .false.
 
      DO while (1.eq.1)
 
         read (luvel, '(a80)', end=20, err=266) card
 
         go to 22
c----
c   last function read hit end of input file
c----
20       continue
 
c----
c   if we've already written out last valid function then exit routine
c   otherwise we need to jump into that part of the "IF" below that
c   builds the TDFN output and tell the program this will be the last
c   function.
c   also if there are less than 2 entries in the last cards read it is
c   not a valid function and so exit
c----
         ixlst = 0
         iylst = 0
         got = .true.
         EOF = .true.
 
         if (if .le. 1) go to 299
         if (got) go to 22
 
         go to 23
 
22       continue
 
c----
c   read "card" for input values. The valid ones are ICX,ICY,time,vel
c   the first 2 can be dummy integers (this is basically Landmark format).
c----
         call fsscnf (card,'%d %d %d %d %f %f'//char(0),
     1                nline,ixline,ICX,ICY,time,vel)

         if (.not. XYs) then
            ICX = nline
            ICY = ixline
         endif
 
23       continue
 
c----
c   assuming each function is together in the file determine end of function
c   by sensing when either the X or Y coordinate changes. got=true means we
c   have sensed a change in the X or Y coords and therefore have a complete
c   function in itim & ivel vectors. got=false means we are still reading the
c   current function.
c----
         IF (ICX .ne. ixlst .OR. ICY .ne. iylst) THEN
 
c----
c   end of current function sensed: we need to write out old function
c   and then determine if upcoming function lies within box defined on
c   cmd line
c   we have a valid function ONLY if there are more than 2 entries
c----
            if (got) then
c----
c   for completed valid function:
c   sort in case times are not in ascending order
c----
               if ( if .gt. 1) then

                  nf = nf + 1
                  if (if .ge. maxnum) maxnum = if
                  if (EOF) go to 299
 
               endif
 
            endif

c----
c   see if upcoming function lies with defined box (also pick up first
c   read T-V pair and put into time & velocity arrays in case).
c----
            if = 1
            CX = ICX
            CY = ICY
            IWRN = 0

            if (XYs) then

               CALL XFMFWD (CX, CY, LI, DI, CXT, CYT,BXT,BYT, IWRN,
     1                      IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT,YYT,
     2                      DX, DY, NY, NX)
            else

               li = ICX
               di = ICY

            endif
 

            IF (LI .LT. minli) IWRN = 1
            IF (LI .GT. maxli) IWRN = 1
            IF (DI .LT. mindi) IWRN = 1
            IF (DI .GT. maxdi) IWRN = 1

c----
c   if function lies within box set got=true to say we have a valid function
c   being read; set the ixlst,iylst to the current X,Y so we will be able to
c   sense when this function ends. then drop out og the "IF" and back to
c   read the next function.
c----
            if (IWRN .eq. 0) then
               got = .true.
               ixlst = ICX
               iylst = ICY

c----
c   if function does not lie within the box set got=false and set ixlst,iylst
c   to zero. This will cause the next card to be read, and its XY checked for
c   position in the box. If this is still part of the current outside function
c   then the flow control will return to this point. The cycle repests until
c   a function lying within the box is found.
c----
            else
               got = .false.
               ixlst = 0
               iylst = 0
            endif
 
c----
c   while reading current function values we need to check the possibility
c   that there are XY entries that contain "null" velocity entries (added
c   to work on geostat output). "if" will be the total number of entries
c   in current function.
c----
         ELSE
 
            if (vel .gt. 0.0) then
               if = if + 1
            endif
 
         ENDIF
 
      ENDDO
 
      if (nf .eq. 0) go to 267
 
266   continue
 
      write(LERR,*)' '
      write(LERR,*)'ERROR in slvr digicon velocity read:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nf,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in slvr digicon velocity read:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nf,' line was:',card
 
      call ccexit (266)
 
267   continue
 
      write(LERR,*)' '
      write(LERR,*)'ERROR in slvr digicon velocity read:'
      write(LERR,*)'Yikes! no valid functions read from file. Check'
      write(LERR,*)'to see if corner coords are correct; check XYs'
      write(LERR,*)'in input file; is each funtion together not'
      write(LERR,*)'scattered throughout input file?'
      write(LER ,*)' '
      write(LER ,*)'ERROR in slvr digicon velocity read:'
      write(LER ,*)'Yikes! no valid functions read from file. Check'
      write(LER ,*)'to see if corner coords are correct; check XYs'
      write(LER ,*)'in input file; is each funtion together not'
      write(LER ,*)'scattered throughout input file?'
 
 
299   continue

      maxfunc = nf

      return

      ELSEIF (g2d) THEN

        write(LERR,*)' '
        write(LERR,*)'FATAL ERROR in slvr:'
        write(LERR,*)'g2d option velocity format currently not'
        write(LERR,*)'supported. Use -tdfn or -digi or -geco'
        write(LER ,*)' '
        write(LER ,*)'FATAL ERROR in slvr:'
        write(LER ,*)'g2d option velocity format currently not'
        write(LER ,*)'supported. Use -tdfn or -digi or -geco'
        call ccexit (666)

      ELSEIF (geco) THEN

c----
c   read every line in input velocity file. Check for EOF and if so
c   make sure we have at least 1 valid function, otherwise emit error
c   message
c----
         DO while (1.eq.1)
 
            read (luvel, '(a80)', end=30, err=366) card
c----
c   As we read each card we find any blank offset and use this as a
c   pointer offset into the card field
c----
            ib = 0
            do  i = 1, 80
                if (card(i:i) .eq. ' ') then
                   ib = ib + 1
                else
                   go to 31
                endif
            enddo
31          continue

c----
c   jump around EOF messages
c----
            go to 32
30          continue

            if (nf .gt. 0) then
               write (LERR,*)'GECO format input file:'
               write (LERR,*)'Hit end of file finding ',nf,' functions'
               go to 399
            else
               write(LERR,*)'FATAL ERROR in slvr geco format:'
               write(LERR,*)'Found no functions. Check input file fmt'
               go to 399
            endif
 
32          continue
 
c----
c   If a card begins with 'sp' it contains XY info and is the start of
c   the next function
c----
            IF (card(1+ib:2+ib) .eq. 'sp') THEN
 
c----
c   Increment function counter. Then check for the first occurrence of
c   either an X or a Y. Starting from this point in the card field copy
c   the remaining columns to another character vector to simplify reading
c   the XY fields with fsscnf.
c   Accomodate possible order switching of XYs and extract XY into. If
c   there's not XY into branch to error messages.
c----
               nf = nf + 1
               ip = 0
               do  i = 1, 80

                   if (card(i:i) .eq. 'x' .OR. card(i:i) .eq. 'y') then
                       ip = i
                       il = 0
                       do  ii = i, 80
                           il = il + 1
                           tard (il:il) = card (ii:ii)
                       enddo
                       call fsscnf (tard,'%s %d %s %d'//char(0),
     1				c1,iv1,c2,iv2)
                       if (c1 .eq. 'x' .AND. c2 .eq. 'y') then
                          ICX = iv1
                          ICY = iv2
                       elseif (c1 .eq. 'y' .AND. c2 .eq. 'y') then
                          ICX = iv2
                          ICY = iv1
                       else
                          go to 33
                       endif
                       go to 34
                   endif
               enddo
33             continue

               write(LERR,*)'FATAL ERROR in slvr geco format:'
               write(LERR,*)'Unable to locate X or Y coords for functn'
               write(LERR,*)nf,' Check this function in input file.'
               go to 399
 
34             continue
 
c----
c   XY info looks ok. Determine if the XY point is within the survey
c   boundaries. If not then go read input to start of next function.
c----
               CX = ICX
               CY = ICY
               IWRN = 0
               CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                      IX1, IY1, XX, XY, YX, YY, XXT, XYT,YXT,YYT,
     2                      DX, DY, NY, NX)
 
               IF (LI .LT. MINLI) IWRN = 1
               IF (LI .GT. MAXLI) IWRN = 1
               IF (DI .LT. MINDI) IWRN = 1
               IF (DI .GT. MAXDI) IWRN = 1
 
            if (IWRN .eq. 1) go to 300
 
c----
c   Current function lies within survey boundaries.
c----
               if = 1
 
               do while (1.eq.1)
 
                  read (luvel, '(a80)', end=35, err=366) card
                  go to 36
 
c----
c   If this is not the last function then press on...
c----
35                continue

c----
c   If this is the last function then set the character trigger for
c   end of function
c----
                  if (if .gt. 1) then
                     card(1+ib:4+ib) = 'line'
                  else
                     go to 30
                  endif
 
36                continue
 
c----
c   Within the current function we take each card and extract the T-V
c   pairs, putting them in vectors tt & vv (the pointer "if" keeps
c   increasing within function gline)
c----
                  if (card(1+ib:1+ib) .eq. 't') then
 
                     call gline (card, if, tt, vv)
 
c----
c   The end of the current function has been found. Determine is the
c   number of elements in current function exceeds maximum
c----
                  elseif (card(1+ib:4+ib) .eq. 'line') then
 
                     if = if - 1
                     if (if .ge. maxnum) maxnum = if
c----
c   Initialize character array for next function then
c   jump out of loop which reads a function to the loop that
c   looks for next function.
c----
                     do  i = 1, 80
                         card (i:i) = ' '
                     enddo
 
                     go to 300
 
                  endif
 
               enddo
 
            ENDIF

300         CONTINUE
 
         ENDDO
 
366      continue
 
         write(LERR,*)' '
         write(LERR,*)'ERROR in slvr geco reader:'
         write(LERR,*)'Something bad happened while reading input vel'
         write(LERR,*)'file for function number ',nf,' line was:',card
         write(LER ,*)' '
         write(LER ,*)'ERROR in slvr geco reader:'
         write(LER ,*)'Something bad happened while reading input vel'
         write(LER ,*)'file for function number ',nf,' line was:',card
 
399      continue
         maxfunc = nf

         return

      ENDIF

      return
      end
