C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rho(x,lx,y,sr,ierr)
#include <localsys.h>
      real x(*), y(*), work(1)
      real fnyq,delf,sr
      complex wc(1), fop
      POINTER (pw, work),(pwc,wc)
      integer lx,ierr,n2,iget,iabort,i,n6

      n2 = 32
      lx2 = lx+lx
      do while(n2.lt.lx2)
       n2=n2+n2
      end do
      n3 = n2/2+1
      n6=n3+n3
      fnyq=1./(2.*sr)
      delf=fnyq/float(n3-1)
#ifndef CRAYSYSTEM
      iget = n6*4
#else
      iget = n6*8
#endif
      ierr = 0
      iabort = 0
      call galloc(pw,iget,ierr,iabort)
      call galloc(pwc,iget,ierr,iabort)
      if(ierr.ne.0)return
      do i=lx,n6
        work(i)=0.
      end do
      do i=1,lx
       work(i)=x(i)
      end do
      call rfft(work,n2,1)
      call rfftsc(work,n2,3,1)
      j=-1
      do i=1,n3
        j=j+2
        fop=cmplx(float(i-1)*delf,0.0)
        wc(i)=cmplx(work(j),work(j+1))*fop
      end do
      j=-1
      do i=1,n3
       j=j+2
       work(j)=real(wc(i))
       work(j+1)=aimag(wc(i))
      end do
      call rfftsc(work,n2,-3,0)
      call rfft(work,n2,-1)
      do i=1,lx
       y(i)=work(i)
      end do
      call gfree(pw)
      call gfree(pwc)
      return
      end
