C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c taupf reads seismic trace data from an input file,
c performs reverse tau-p transform in the frequency domain and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ltaper,nw,nspad,istpr,nwt1,nwt2
      integer     irs,ire,ns,ne
      real        vel,fmax,tp1,tp2,ftaper,domega,delf,deltp
#include <f77/pid.h>
      integer     recnum, trcnum, static
      real        p(SZLNHD),weight(SZLNHD),taper(SZLNHD)
      real        dist(SZLNHD),work1(SZLNHD), work2(SZLNHD)
c------
c  static memory allocation
c     real        data ( SZLNHD ), datarr(SZSPRD*SZLNHD)
c     complex     data2d(SZSPRD*SZLNHD)
c------
c  dynamic memory allocation
      integer     itrhdr
      real        data ( SZLNHD ), datarr
      complex     data2d
      pointer     (wkadri, itrhdr(1))
      pointer     (wkadr1, datarr(1))
      pointer     (wkadr2, data2d(1))
c------
      character   ntap * 256, otap * 256, name*5, cfile*256
      logical     verbos,query,crdin,split,orig,heap1,heap2,slnt
      logical     heapi
      integer     argis

      common / thdr /
     1   ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     2   ifmt_RecNum,l_RecNum,ln_RecNum,
     3   ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     4   ifmt_RecInd,l_RecInd,ln_RecInd,
     5   ifmt_DphInd,l_DphInd,ln_DphInd,
     6   ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     7   ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     8   ifmt_StaCor,l_StaCor,ln_StaCor,
     9   ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     a   ifmt_MulSkw,l_MulSkw,ln_MulSkw,
     b   ifmt_FlReFN,l_FlReFN,ln_FlReFN,
     c   ifmt_SGRNum,l_SGRNum,ln_SGRNum,
     d   ifmt_SGRDat,l_SGRDat,ln_SGRDat

 
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'TAUPR'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ('-?').gt.0 .or. argis('-h').gt.0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
c-----
c     get some global command line args
c-----
      call cmdln(ntap,otap,cfile,ftaper,crdin,split,orig,slnt,verbos)

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'TAUPR: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'DptInt', dpint, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)
      call savelu('SGRDat',ifmt_SGRDat,l_SGRDat,ln_SGRDat,TRACEHEADER)
      call savelu('SGRNum',ifmt_SGRNum,l_SGRNum,ln_SGRNum,TRACEHEADER)
      call savelu('FlReFN',ifmt_FlReFN,l_FlReFN,ln_FlReFN,TRACEHEADER)
      call savelu('SGRNum',ifmt_SGRNum,l_SGRNum,ln_SGRNum,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 5, LERR)
c-----
c     read in remaining parameters from either command line or cards
c-----
      call rdcrd (vel,irs,ire,dxrec,fmax,npad,nwt1,nwt2,
     1              p,tp1,tp2,numtp,cfile,crdin,split,orig)

      call saver (itr, 'OrNSMP', nsampo, LINHED)

      if (orig) then
         call saver (itr, 'OrNTRC', ntrci, LINHED)
         numtp = ntrci
      endif

      if (numtp .eq. 0) then
         write(LERR,*)'taupr WARNING:'
         write(LERR,*)'No number ray parameter entry -np[] or no valid'
         write(LERR,*)'entry in line header slot OrNTRC (orig # trcs).'
         write(LERR,*)'Will assume # ray params = # input traces'
         write(LERR,*)'[and Charlie Mims is a putz! At least says Wepfer
     1]'
         write(LER ,*)'taupr WARNING:'
         write(LER ,*)'No number ray parameter entry -np[] or no valid'
         write(LER ,*)'entry in line header slot OrNTRC (orig # trcs).'
         write(LER ,*)'Will assume # trc dists = # taupf input traces'
         write(LER ,*)'[and Charlie Mims is a putz! At least says Wepfer
     1]'
         numtp = ntrc
         orig = .false.
      endif
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c-----
c     initialize tp parameters
c-----
      call tpinit (nsamp,nspad,nw,ncmplx,nsi,si,fnyq,tp1,tp2,
     1             numtp,fmax,ltaper,ftaper,domega,nwt1,nwt2,
     2             delf,deltp,p,weight,taper,istpr,ntrc,crdin,split,
     3             orig,itr,unitsc)

c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.
 
      itemi = max(ntrc,numtp) * ITRWRD  * SZSMPD
      items = max(ntrc,numtp) * (nspad)

      call galloc (wkadri, itemi, errcdi, abori)
      if (errcdi .ne. 0.) heapi = .false.
      call galloc (wkadr1, items*SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heap1 = .false.
      call galloc (wkadr2, 2*items*SZSMPD, errcd2, abort2)
      if (errcd2 .ne. 0.) heap2 = .false.
      if (.not. heapi .or. .not. heap1 .or. .not. heap2) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) 2*items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) 2*items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

      maxtrc = max(ntrc,numtp)
      call vclr (itrhdr, 1, maxtrc * ITRWRD)
c-----
c-----
c     modify line header to reflect actual number of traces output
c-----
      obytes = SZTRHD + SZSMPD * nsampo
      nsamp4 = SZSMPD * nsampo
      nrecc=ire - irs+1
      call savew(itr, 'NumSmp', nsampo, LINHED)
      call savew(itr, 'NumTrc', numtp , LINHED)
      call savew(itr, 'NumTrc', numtp , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     output of all pertinent information before
c     processing begins
c-----
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vel,numtp,tp1,tp2,delf,deltp,
     2                  nw,ltaper,fmax,p,weight,nwt1,nwt2,
     3                  istpr,ntap,otap,nsampo)

c-----
c     BEGIN PROCESSING
c     read trace, do taupf, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      DO 1000 jj = irs, ire
 
 
               ic = 0
               nlive = 0
               do 1001  kk = 1, ntrc

                  ic = ic+1
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr(ITHWP1), 1, data, 1, nsamp)

                  if (slnt) then
                     call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idist , TRACEHEADER)
                     call saver2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                           ivref , TRACEHEADER)
                     vref = ivref
                     dist(kk) = float(idist)
                  else
                     call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idist , TRACEHEADER)
                     call saver2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                           irayp , TRACEHEADER)
                     dist(kk) = float(irayp) / 10000000.
                  endif
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static, TRACEHEADER)
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum, TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum, TRACEHEADER)

                  IF(static .eq. 30000) THEN
                   call vclr (data,1,nsamp)
                  ELSE
                    call getfp2(itr, ifmt_SGRNum, l_SGRNum, ln_SGRNum,
     1                          rms, TRACEHEADER)
                    nlive = nlive + 1
                  ENDIF
                  if (orig) p(kk) = idist
                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (itr, 1, itrhdr(ishdr+1), 1, ITRWRD)
                  call vmov (data,1,datarr(istrc+1),1,nsamp)

1001           continue
 

c----------------------
c  do tp processing
c----------------------

               call taupee (nsamp,ntrc,nspad,nw,nlive,ncmplx,domega,
     1                     numtp,istpr,vel,p,weight,taper,datarr,dist,
     2                     slnt,orig,data2d,vref,rms)
 
c-------------------
c  fill in headers
c  write out data
c-------------------
               do 1002  kk = 1, numtp

                   idx = 0
                   irp =  p(kk)

                   ishdr = (kk-1) * ITRWRD
                   call vmov (itrhdr(ishdr+1), 1, itr, 1, ITRWRD)
                   call savhdr (itr,JJ,kk,irp,idx)
                   istrc = (kk-1) * nsamp
                   call vmov (datarr(istrc+1),1,itr(ITHWP1),1,nsampo)
c                  call vmov (datarr(istrc+1),1,work1,1,nsampo)
c                  call rho (work1, nsampo, work2, si, ierr)
c                  call vmov (work2, 1, itr(ITHWP1),1,nsampo)
                   call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                         static, TRACEHEADER)
                   if (static .eq. 30001) then
                      call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000 , TRACEHEADER)
                   endif
c                  if (static .eq. 30000) call vclr (data,1,nsampo)
                   call wrtape (luout, itr, obytes)

1002           continue

1000        CONTINUE
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of taupr, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
 

      subroutine cmdln( ntap,otap,cfile,ftaper,crdin,split,orig,slnt,
     1                  verbos)

#include <f77/iounit.h>
c-------
c     ntap    C*100 - input data set name
c     otap    C*100 - output data set name
c     cfile   C*100 - card file name
c    ftaper   R     - frequency to start taper
c    verbos   L     - verbos printout
c     crdin   L     - card input
c     split   L     - split spread
c      orig   L     - use original trace distances
c      slnt   L     - input data is from program SLNT
c-------
      character  ntap*(*), otap*(*), cfile*(*)
      integer    argis
      logical    verbos, crdin, split, orig, slnt

        call argstr('-N',ntap, ' ', ' ')
        call argstr('-O',otap, ' ', ' ')
        call argstr('-C',cfile, '1', ' ')
        call argr4 ('-ft',ftaper,0.,0.)
        if( cfile(1:1) .eq. ' ') then
            crdin = .false.
        else
            crdin = .true.
        endif
         orig  = ( argis('-D') .gt. 0 )
        split  = ( argis('-S') .gt. 0 )
        slnt   = ( argis('-M') .gt. 0 )
        verbos = ( argis('-V') .gt. 0 )

      return
      end

      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     1'***************************************************************'
       write(LER,*)' '
        write(LER,*)
     1'execute taup by typing taup and  list of program parameters.'
        write(LER,*)
     1'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     1'a character(s) corresponding to some parameter.'
        write(LER,*)
     1'users enter the following parameters, or use the default values'
       write(LER,*)' '
        write(LER,*)
     1' -N [ntap]    (no default)       : input data file name'
        write(LER,*)
     1' -O [otap]    (default = stdout ): output data file name'
        write(LER,*)
     1' -C [cfile] enter file name containing cards for input'
        write(LER,*)
     1'If no -C[] is given then input is on command line or job stream'
        write(LER,*)' '
        write(LER,*)
     1' -ft[ftaper] enter freq (hz) to start frequency taper (no taper)'
        write(LER,*)
     1'If command line:'
        write(LER,*)
     1' -rs [nstrt] start record'
        write(LER,*)
     1' -re [nend] end record'
        write(LER,*)
     1' -fmax [fmax] maximum frequency to use'
        write(LER,*)
     1' -ot [nwt1] linear taper this many outside traces'
        write(LER,*)
     1' -it [nwt2] linear taper this many inside traces'
        write(LER,*)
     1' -p [pmin] minimum ray parameter (0.0)'
        write(LER,*)
     1' -P [pmax] maximum ray parameter (0.0)'
        write(LER,*)
     1'Note: if -D is given or both -p & -P entries are zero, then use'
        write(LER,*)
     1'      trace distances'
        write(LER,*)
     1' -J [np] number ray parameters'
        write(LER,*)
     1' -D  if present, or pmin and pmax = 0, use input trace distances'
        write(LER,*)
     1' -M  if present, input data is from program SLNT'
       write(LER,*)' '
       write(LER,*)
     1'usage:   taupr -N[ntap] -O[otap] -C[cfile] -ft[ftaper]  -D -S -V'
       write(LER,*)
     1'               -rs[] -re[] -fmax[] -ot[] -it[] -p[] -P[] -J[]'
       write(LER,*)' '
         write(LER,*)
     1'***************************************************************'

      return
      end

      subroutine savhdr ( itr,nr, jp, irp, idx )

#include <f77/lhdrsz.h>

      integer    nr, jp, irp, idx
      integer    itr(*)

      common / thdr /
     1   ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     2   ifmt_RecNum,l_RecNum,ln_RecNum,
     3   ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     4   ifmt_RecInd,l_RecInd,ln_RecInd,
     5   ifmt_DphInd,l_DphInd,ln_DphInd,
     6   ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     7   ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     8   ifmt_StaCor,l_StaCor,ln_StaCor,
     9   ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     a   ifmt_MulSkw,l_MulSkw,ln_MulSkw,
     b   ifmt_FlReFN,l_FlReFN,ln_FlReFN,
     c   ifmt_SGRNum,l_SGRNum,ln_SGRNum,
     d   ifmt_SGRDat,l_SGRDat,ln_SGRDat

c
c    save trace header values
c

c          itr(106) = nr
c          itr(107) = jp
c          itr(119) = irp
c          itr(117) = iabs(irp)
c          itr(5) = idx
c          itr(125) = itr(1)
           irpd = iabs (irp)
           call saver2(itr,ifmt_SGRNum,l_SGRNum, ln_SGRNum,
     1                 istat , 1)
           call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 istat , 1)
           call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                 irp   , 1)
           call savew2(itr,ifmt_FlReFN,l_FlReFN, ln_FlReFN,
     1                 idx   , 1)
           call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                 nr    , 1)
           call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                 jp    , 1)
           call savew2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                 irpd  , 1)

      return
      end
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vel,numtp,tp1,tp2,delf,deltp,
     2                  nw,ltaper,fmax,p,weight,nwt1,nwt2,
     3                  istpr, ntap,otap,nsampo)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - R*4 shot velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c      tp1  - R*4 start taup value
c      tp2  - R*4 end taup value
c    numtp  - I*4 number taup values
c     delf  - R*4 delta freq
c    deltp  - R*4 delta taup
c        p  - R*4 vector of ray parameters
c   weight  - R*4 spread weights
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      real        p(*), weight(*)
      integer * 4 nsamp, nsi, ntrc, nrec
      integer     numtp
      real        vel,tp1,tp2,delf,deltp
      character ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' # of output samples=  ', nsampo
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' shot medium velocity =  ', vel
            write(LERR,*) ' start taup value     =  ', tp1
            write(LERR,*) ' end taup value       =  ', tp2
            write(LERR,*) ' number taup values   =  ', numtp
            write(LERR,*) ' taup increment       =  ', deltp
            write(LERR,*) ' frequency increment=  ', delf
            write(LERR,*) ' max freq to use    =  ',fmax
            write(LERR,*) ' number freqs in x-form= ',nw
            write(LERR,*) ' number freqs to taper = ',ltaper
            write(LERR,*) ' start taper at freq indx= ',istpr
            write(LERR,*) ' number inside traces taper = ',nwt2
            write(LERR,*) ' number outside traces taper = ',nwt1
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if (nwt1 .gt. 0 .or. nwt2 .gt. 1) then
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,*) ' weights:'
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,1000) (weight(j),j=1,ntrc)
1000           format(10(1x,f7.3))
            endif
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,*) ' taup values used:'
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,1001) (p(j),j=1,numtp)
1001           format(8(1x,f10.3))
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 

