C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  apend   (with apolgies for bad spelling)
C
C**********************************************************************C
C
C APEND reads seismic trace data from an input file and puts it at the
C end of the data set specified as the output file after adjusting the
C line header accordingly.  This appending process  is done on a
C record basis.  The traces/rec, samples/trace, etc, for each dataset
C are assumed to be the same.
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C Aug 13, 2003 - M. O'Brien, Allied Geophysics
C        made trace memory dynamic
C        added flag to force append when SmpInt NumSmp, and NumTrc
c          are different on input nd output.
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     ilhd_in(SZLNHD)
      integer     ilhd_out(SZLNHD)
      integer     luin, luout
      integer     nsampi, nsii, ntrci, nreci
      integer     nsampo, nsio, ntrco, nreco
      integer     lbytesi,lbyteso, nbytes,obytes
      integer     argis
      character   name*5, otap*256, ntap*256
      logical     verbos, lrnum, lforce, lread, lstop
      integer     irec,itrc,irec_out, nrec_out,nrec_remap
      integer     ier, abort, idummy

      integer TrcSize
      real    Trace(1)
      pointer (ptr_Trace,Trace)

      data  name /'APEND'/

c--------------------------------
c get online help if requested
c--------------------------------
      if (argis('-h').gt.0 .or. argis('-?').gt.0) then
        call help()
        stop
      endif

c----------------------
c open printout file
c----------------------
#include <f77/open.h>

c-------------------------------
c get command line parameters
c-------------------------------
      call cmdln(ntap,otap,lrnum,lforce,verbos)

      if (otap .eq. ' ') then
        write(LERR,*)'Output data set cannot be a pipe -- FATAL'
        write(LERR,*)'use a named file after -O'
        write(LERR,*)'then rerun job'
        stop
      endif

c------------------
c open i/o files
c------------------
      call getln(luin, ntap, 'r', 0)
 
      call lbopen(luout,otap,'a+')
      if (luout.lt.0) then
        write(LERR,*)' UNABLE OPEN OUTPUT FILE - STOP'
        stop
      endif

c--------------------------------------------------------
c read input line header and retrieve pertiment values
c--------------------------------------------------------
      lbytesi=0
      call rtape (luin, ilhd_in, lbytesi)
      if (lbytesi.eq.0) then
        write(LERR,*)name,': no header read on input unit ',luin
        write(LERR,*)'for data set ',ntap
        write(LERR,*)'FATAL'
        write(LERR,*)'check existence of file & rerun'
        stop
      endif

      call saver(ilhd_in, 'NumSmp', nsampi, LINHED)
      call saver(ilhd_in, 'SmpInt', nsii  , LINHED)
      call saver(ilhd_in, 'NumTrc', ntrci , LINHED)
      call saver(ilhd_in, 'NumRec', nreci , LINHED)

c-----------------------------------------------
c barf the input lineheader to the print file
c-----------------------------------------------
      call hlhprt (ilhd_in, lbytesi, name, 5, LERR)

c------------------------------------------
c check to see if output data set exists
c------------------------------------------
      lbyteso=0
      call rtape (luout, ilhd_out, lbyteso)

c----------------------------------------------------------
c if output does not exist, create one based on the input
c----------------------------------------------------------
      if (lbyteso .eq. 0) then
        call rwd(luout)
        call wrtape(luout,ilhd_in,lbytesi)
        ntrco  = ntrci
        nsampo = nsampi
        nreco  = 0
      endif

c----------------------------------------------------
c if output does exist, perform consistency checks 
c----------------------------------------------------
      if (lbyteso .gt. 0) then
        call saver(ilhd_out, 'NumSmp', nsampo, LINHED)
        call saver(ilhd_out, 'SmpInt', nsio  , LINHED)
        call saver(ilhd_out, 'NumTrc', ntrco , LINHED)
        call saver(ilhd_out, 'NumRec', nreco , LINHED)
        if (.not.lforce) then
          lstop = .false.
          if (nsampi.ne.nsampo) then
            write(LERR,*)'input/output samples/trace not equal'
            write(LER,*)'input/output samples/trace not equal'
            lstop = .true.
          endif
          if (nsii.ne.nsio) then
            write(LERR,*)'input/output sample interval not equal'
            write(LER,*)'input/output sample interval not equal'
            lstop = .true.
          endif
          if (ntrci.ne.ntrco) then
            write(LERR,*)'input/output traces/rec not equal'
            write(LER,*)'input/output traces/rec not equal'
            lstop = .true.
          endif
          if (lstop) then
            write(LERR,*)'FATAL'
            write(LER,*)'FATAL'
            stop
          endif
        endif
      endif

c----------------------------------------------------------------------
c if needed, remap number of input records to output record size and
c set the new number of output records
c----------------------------------------------------------------------
      nrec_remap = nreci
      if (lforce .and. ntrci.ne.ntrco) then
        nrec_remap = ntrci*nreci/ntrco
        if (mod(ntrci*nreci,ntrco).ne.0.0) then
          nrec_remap=nrec_remap+1
          write(LERR,*)name,': must pad dead traces for symetry'
          write(LER ,*)name,': must pad dead traces for symetry'
        endif
      endif
      nrec_out = nreco + nrec_remap

c--------------------
c allocate a trace
c--------------------
      TrcSize = SZTRHD + SZSMPD*max(nsampi,nsampo)
      call galloc(ptr_Trace, TrcSize, ier, abort)

      if (ier.ne.0) then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate a trace with ',TrcSize,' bytes'
        write(LERR,*)'FATAL'
        write(LERR,*)' '
        write(LER,*)' '
        write(LER,*)'Unable to allocate a trace with ',TrcSize,' bytes'
        write(LER,*)'FATAL'
        write(LER,*)' '
        stop
      else
        write(LERR,*)' '
        write(LERR,*)name,': Allocated a trace with ',TrcSize,' bytes'
        write(LERR,*)' '
      endif

c-----------------------------------
c  initialize the trace to zeroes
c-----------------------------------
      call vclr(Trace,1,TrcSize/SZSMPD)

c-------------------------------------------
c  set the number of bytes/trace to write
c-------------------------------------------
      obytes = SZTRHD + SZSMPD * nsampo

c-------------------------------
c  verbos messages if desired
c-------------------------------
      if (verbos) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)'   # of Samples/Trace   = ', nsampi
        write(LERR,*)'   Sample Interval      = ', nsii  
        write(LERR,*)'   Traces per Record    = ', ntrci
        write(LERR,*)
        write(LERR,*)' New value for NumRec   = ', nrec_out
        write(LERR,*)
      endif

c-----------------------------------------------------------
c retrieve access info for interesting trace header words
c-----------------------------------------------------------
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)

c----------------------------------------------------------------------
c   if there first exists an otap then...
c   adjust NumRec in the line header, rewind the output and dump the
c   adjusted line header, skip to the end of the file. since the
c   historical line header is not being changed the line header will
c   remain the same length
c----------------------------------------------------------------------
      if (lbyteso.ne.0) then

        write(LERR,*)'Appending input data to output data set'
        write(LERR,*)'skipping ',nreco,' records with ',ntrci,' traces'
     &             //' to end of current output file'

        call savew(ilhd_out,'NumRec',nrec_out,LINHED)
        call rwd(luout)
        call wrtape(luout,ilhd_out,lbyteso)
        call skipt(luout,ntrco*nreco,idummy)

      endif

C**********************************************************************C
C
C     Now we read data off NTAP and append it to the end of OTAP
C
C**********************************************************************C

      lread = .true.

      DO JJ = 1, nrec_remap
        irec_out = nreco + jj
        DO KK = 1, ntrco

          if (lread) then
            nbytes = 0
            call rtape (luin , Trace, nbytes)
            if (nbytes .eq. 0) then
              write(LERR,*)'End of file on input:',
     :                     '  rec= ',jj,'  trace= ',kk
              if (lforce) then
                call vclr(Trace(ITHWP1),1,nsampi)
                lread=.false.
              else
                call lbclos(luin)
                call lbclos(luout)
                stop
              endif
            endif
          endif

          if (verbos) then
            call saver2(Trace,ifmt_RecNum,l_RecNum, ln_RecNum,
     :                  irec, TRACEHEADER)
            call saver2(Trace,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     :                  itrc, TRACEHEADER)
            write(LERR,*)'LUIN=  ',luin,' Rec= ',irec,' Trace= ',itrc
            write(LERR,*)'LUOUT= ',luout,' Rec= ',irec_out,
     :                   ' Trace= ',itrc
          endif

          if (lrnum)
     :      call savew2(Trace,ifmt_RecNum,l_RecNum, ln_RecNum,
     :                  irec_out, TRACEHEADER)

          call wrtape(luout,Trace,obytes)
 
        ENDDO
      ENDDO

      call lbclos(luin)
      call lbclos(luout)

      END


c-------------------------------------
c  online help
c-------------------------------------
      subroutine help(name)
      character*(*) name
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)
     :           'Command Line Arguments for',name,': append a data set'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap] -- input data set                 (stdin)'
        write(LER,*)'-O[otap] -- output data set                 (none)'
        write(LER,*)'            (cannot be a pipe)'
        write(LER,*)' '
        write(LER,*)' the records of ntap are placed at the end of the'
        write(LER,*)' the file otap.  traces/rec, samples/trace, etc of'
        write(LER,*)' both files are assumed the same'
        write(LER,*)' '
        write(LER,*)'-R -- renumber output record numbers     (.FALSE.)'
        write(LER,*)'-f -- force the append function even     (.FALSE.)'
        write(LER,*)'      if NumSmp, NumTrc and SmpInt differ'
        write(LER,*)'      between datasets (Dangerous!!)'
        write(LER,*)' '
        write(LER,*)'-V -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        apend -N[] -O[] [-R -f V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     lrnum  - L     renumber output data
c     lforce - L     force append when datasets don't match
c     verbos - L     verbose output or not
c-----
      subroutine cmdln(ntap,otap,lrnum,lforce,verbos)
      integer    argis
      character  ntap*(*), otap*(*)
      logical    lrnum, lforce, verbos

      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')

      lrnum = .false.
      lforce = .false.
      verbos = .false.

      lrnum = (argis('-R') .gt. 0)
      lforce = (argis('-f') .gt. 0)
      verbos = (argis('-V') .gt. 0)

      return
      end
