C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w)=0.5*DVp/Vp*(sec^2(w)+C*(1-K*sin^2(w))                     *
c *               - K*sin^2(w)*DVs/Vs                                *
c *   R(w)=A(1+c*(1-K*sin^2(w)) + b sin^2
c *    where K = (2*Vs/Vp)^2                                         *
c *     w  = incident angle                                          *
c *     C  = Gardner's coefficient of rho/Vp relation.               *
c *    Written by Richard Crider
c ******************************************************************** c
      subroutine matrixV_2(data,angles,nsamp,ntrc,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,K,C,sa)
c                                                            
      real data(*), K,C
      real angles(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real work1(*),ztol
      integer iperm(3)
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine=sin(theta)
        sine=sine*sine
        tang=tan(theta)
        tang=tang*tang
        work3(m)=0.5*((1.+tang)+(1.- K*sine)*C)
        m=m+nrow
        work3(m)=K*sine
        vect3(n)=y
       endif
      end do
      if(n.ge.np)then
       np = n
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w)=0.5*DVp/Vp*sec^2(w) - K*sin^2(w)*DVs/Vs +                 *
c *              0.5*(1-K*sin^2)Drhob/rhob)                          *
c *    where K = (2*Vs/Vp)^2                                         *
c *     w  = incident angle                                          *
c *    Written by Richard Crider and Ganyuan Xia 4/99                * c
c ******************************************************************** c
      subroutine matrixV_3(data,angles,nsamp,ntrc,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,K,sa)
c                                                            
      real data(*), K,Ksine
      real angles(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real work1(*),ztol
      integer iperm(3)
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine=sin(theta)
        sine=sine*sine
        tang=tan(theta)
        tang=tang*tang
        Ksine = K*sine
        cose=cos(theta)*cos(theta)
        work3(m)=0.5*(1. + tang)
        m=m+nrow
        work3(m)=Ksine
        m=m+nrow
        work3(m)=0.5*(1.- Ksine)
        vect3(n)=y
       endif
      end do
      if(n.ge.np)then
       np = n
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w)=A + b sin^2(w) + C tan^2(w)                               *
c *    where K = (2*Vs/Vp)^2                                         *
c *     w  = incident angle                                          *
c *     A = R0 = 0.5*(DVp/Vp + Drho/rho)                             *
c *     B = - 0.5*K*Dmu/mu                                           *
c *     C = 0.5*DVp/Vp                                               *
c *    Written by Richard Crider and Ganyuan Xia 4/99                * c
c ******************************************************************** c
      subroutine matrixA(data,angles,nsamp,ntrc,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,K,sa)
c                                                            
      real data(*), K
      real angles(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real work1(*),ztol
      integer iperm(3)
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine=sin(theta)
        sine=sine*sine
        tang=tan(theta)
        tang=tang*tang
        work3(m)=1.
        m=m+nrow
        work3(m)=sine
        m=m+nrow
        work3(m)=tang
        vect3(n)=y
       endif
      end do
      if(n.ge.np)then
       np = n
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
       gw5(2)=-gw5(2)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w) = B0 + B1*sin^2(w) + B2*sin^2(w)*tan^2(w)                 *
c *    where                                                         *
c *     w  = incident angle                                          *
c *    Written by Richard Crider and Ganyuan Xia 4/99                * 
c ******************************************************************** c
      subroutine matrixB_3(data,angles,nsamp,ntrc,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,sa)
c                                                            
      implicit none
      real data(*),angles(*),work1(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real astrt,aend
      integer nsamp,ntrc,idx,ncol,np
      logical sa

      real ztol,sy2,sy,Sx2y,Sx3y,theta,y,sine,tang
      real avangle,yn,syy
      integer iperm(3),i,j,ndx,mdx,n,nrow
      integer m,ierr

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      sy2=0.
      sy =0.
      Sx2y=0.
      Sx3y=0.
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine=sin(theta)
        sine=sine*sine
        tang=tan(theta)
        tang=tang*tang
        work3(m)=1.
        m=m+nrow
        work3(m)=sine
        m=m+nrow
        work3(m)=tang*sine
        if(ncol.eq.4)then
         work3(m)=tang
         m=m+nrow
         work3(m)=tang*sine
        endif
        vect3(n)=y
        sy2 = sy2+y*y
        sy  = sy +y
        Sx2y= Sx2y+sine*y
        Sx3y= Sx3y+sine*tang*y
       endif
      end do
      if(n.ge.np)then
       np = n
       yn = n
       syy=sy2-(sy*sy)/yn
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w) = B0 + B1*sin^2(w)                                        *
c *    where                                                         *
c *     w  = incident angle                                          *
c *    Written by Richard Crider and Ganyuan Xia 4/99                * 
c ******************************************************************** c
      subroutine matrixB_2(data,angles,nsamp,ntrc,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,
     :C,sa)
c                                                            
      real data(*),C,angles(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real work1(*),ztol
      integer iperm(3)
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine=sin(theta)
        sine=sine*sine
        work3(m)=1.
        if(C.ne.0.)then
         tang=tan(theta)
         tang=tang*tang
         work3(m)=(1.+(1./(1.+c))*tang*sine)
        endif
        m=m+nrow
        work3(m)=sine
        vect3(n)=y
       endif
      end do
      if(n.ge.np)then
*      np = n
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w)=D0*sin(w)+D1*sin^3(w)                                     *
c *    where                                                         *
c *     w  = incident angle                                          *
c *     D0 and D1 are coefficients which are functions of            *
c *     fractional changes in density and shear modulus              *
c ******************************************************************** c
      subroutine matrixPS_2(data,angles,nsamp,ntrc,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,K,C,sa)
c                                                            
      real data(*), K,C
      real angles(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real work1(*),ztol
      integer iperm(3)
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine=sin(theta)
        sing=sine*sine*sine
        work3(m)=sine
        m=m+nrow
        work3(m)=sing
        vect3(n)=y
       endif
      end do
      if(n.ge.np)then
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
