C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w)=0.5*DVp/Vp*(sec^2(w)+C*(1-K*sin^2(w))                     *
c *               - K*sin^2(w)*DVs/Vs                                *
c *   R(w)=A(1+c*(1-K*sin^2(w)) + b sin^2
c *    where K = (2*Vs/Vp)^2                                         *
c *     w  = incident angle                                          *
c *     C  = Gardner's coefficient of rho/Vp relation.               *
c *    Written by Richard Crider
c ******************************************************************** c
      subroutine matrixV_2avg(data,angles,nsamp,ntrc,angles2,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,K,C,sa)
c                                                            
      real data(*), K,C
      real angles(*),angles2(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real work1(*),ztol
      real theta1, theta2
      integer iperm(3)
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta2=avangle(angles2,nsamp,j,idx,sa)
       theta1= avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta1.ge.astrt.and.theta2.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      do j=0,ntrc-1
       theta1=avangle(angles,nsamp,j,idx,sa)
       theta2=avangle(angles2,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta1.ge.astrt.and.theta2.le.aend.and.y.ne.0.0)then
        delth = theta2-theta1
        n = n+1
        m=n
        sine=sin(2.*theta2)-sin(2*theta1)
        sine=sine/4.
        tang=tan(theta2)-tan(theta1)
        work3(m)=tang+C*(delth-K*(delth/2-sine))
        work3(m)=0.5/delth*work3(m)
        m=m+nrow
        work3(m)= K/delth*(sine - delth/2.)           ! -Int(K*sin^2)
        vect3(n)=y
       endif
      end do
      if(n.ge.np)then
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w) = B0 + B1*sin^2(w) + B2*sin^2(w)*tan^2(w)                 *
c *    where                                                         *
c *     w  = incident angle                                          *
c *    Written by Richard Crider and Ganyuan Xia 4/99                * 
c ******************************************************************** c
      subroutine matrixB_3avg(data,angles,nsamp,ntrc,angles2,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,sa)
c                                                            
      implicit none
      real data(*),angles(*),work1(*),angles2(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real astrt,aend
      integer nsamp,ntrc,idx,ncol,np
      logical sa

      real ztol,sy2,sy,Sx2y,Sx3y,y,sine,tang
      real avangle,yn,syy,delth,theta1,theta2
      integer iperm(3),i,j,ndx,mdx,n,nrow
      integer m,ierr

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta1=avangle(angles,nsamp,j,idx,sa)
       theta2=avangle(angles2,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta1.ge.astrt.and.theta2.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      sy2=0.
      sy =0.
      Sx2y=0.
      Sx3y=0.
      do j=0,ntrc-1
       theta1=avangle(angles,nsamp,j,idx,sa)
       theta2=avangle(angles2,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta1.ge.astrt.and.theta2.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine = sin(2*theta2)-sin(2*theta1)
        sine = sine/4.
        delth = theta2-theta1
        tang=tan(theta2)-tan(theta1)
        work3(m)=1.
        m=m+nrow
        work3(m)=1./delth*(delth/2.-sine)
        m=m+nrow
        work3(m)=1./delth*(tang-3.*delth/2+sine)
        vect3(n)=y
        sy2 = sy2+y*y
        sy  = sy +y
        Sx2y= Sx2y+(delth/2-sine)*y/delth
        Sx3y= Sx3y+(tang-3.*delth/2+sine)*y/delth
       endif
      end do
      if(n.ge.np)then
       np = n
       yn = n
       syy=sy2-(sy*sy)/yn
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w) = B0 + B1*sin^2(w)                                        *
c *    where                                                         *
c *     w  = incident angle                                          *
c *    Written by Richard Crider and Ganyuan Xia 4/99                * 
c ******************************************************************** c
      subroutine matrixB_2avg(data,angles,nsamp,ntrc,angles2,
     *work3,vect3,work1,aw3,gw3,aw5,gw5,idx,astrt,aend,ncol,np,
     :C,sa)
      
      implicit none
c                                                            
      real data(*),C,angles(*),angles2(*)
      real work3(*),vect3(*),aw3(*),gw3(*),gw5(*),aw5(*)
      real work1(*),ztol
      real astrt,aend
      real avangle
      integer nsamp,ntrc,idx,ncol,np
      real sine,theta1,theta2,delth,tang
      real y
      integer iperm(3),m,mdx,ndx,ierr,i,n,j,nrow
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta1=avangle(angles,nsamp,j,idx,sa)
       theta2=avangle(angles2,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta1.ge.astrt.and.theta2.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      do j=0,ntrc-1
       theta1=avangle(angles,nsamp,j,idx,sa)
       theta2=avangle(angles2,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y  = data(ndx)
       if(theta1.ge.astrt.and.theta2.le.aend.and.y.ne.0.0)then
        delth = theta2-theta1
        n = n+1
        m=n
        sine=sin(2.*theta2)-sin(2.*theta1)
        sine = sine/4.
        if(C.ne.0.)then
         tang=tan(theta2)-tan(theta1)
         work3(m)=1./delth*(delth+
     :      (1./(1.+c))*(tang - 3*delth/2.+sine))
        else
         work3(m)=1.
        endif
        m=m+nrow
        work3(m)=1./delth*(delth/2.-sine)
        vect3(n)=y
       endif
      end do
      if(n.ge.np)then
       np = n
c +=================================================+
c | Form the normal equations and get the solution. |
c +=================================================+
c |   Get transpose of prediction matrix            |
c +=================================================+
       call rmtran(work3,nrow,work1,ncol,nrow,ncol)
c +=================================================+
c |   Multiply prediction matrix by transpose       |
c +=================================================+
       call rmmul(work1,work3,aw3,ncol,ncol,nrow)
c +=================================================+
c |   Multiply observation vector by transpose      |
c |   of prediction matrix.                         |
c +=================================================+
       call rmmul(work1,vect3,gw3,ncol,1,nrow)
c +===================================================+
c |   Get inverse of the product of prediction matrix |
c |   and its transpose.                              |
c +===================================================+
       ztol=1.0e-10
       call rmfuin(aw3,ncol,ncol,ztol,iperm,aw5,ncol,ierr)
c +=====================+
c | solve the equations |
c +=====================+
       call rmmul(aw5,gw3,gw5,ncol,1,ncol)
      else
       gw5(1)=0.
       gw5(2)=0.
       gw5(3)=0.
      endif
      return
      end
