C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w)=0.5*DVp/Vp*(sec^2(w)+C*(1-K*sin^2(w))                     *
c *               - K*sin^2(w)*DVs/Vs                                *
c *    where K = (2*Vs/Vp)^2                                         *
c *     w  = incident angle                                          *
c *     C  = Gardner's coefficient of rho/Vp relation.               *
c *    Written by Richard Crider and Ganyuan Xia 4/99                *
c ******************************************************************** c
      subroutine matrixV_2R(data,angles,nsamp,ntrc,
     *work3,vect3,gw5,idx,astrt,aend,K,C,sa)
c                                                            
      real data(*), K,C
      real angles(*)
      real work3(*),vect3(*),gw5(*)
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      nrow=n
      n=0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        m=n
        sine=sin(theta)
        sine=sine*sine
        tang=tan(theta)
        tang=tang*tang
        work3(m)=0.5*((1.+tang)+(1.- K*sine)*C)
        m=m+nrow
        work3(m)=-K*sine
        vect3(n)=y
       endif
      end do
      if(n.ge.3)then
       call Robust(vect3,work3,n,gw5(1),gw5(2))
      else
       gw5(1)=0.
       gw5(2)=0.
      endif
      return
      end
c ******************************************************************** c
c *  Subroutine to obtain the least squares solution of the          *
c *   simultaneous equations                                         *
c *   R(w) = B0 + B1*sin^2(w)                                        *
c *    where                                                         *
c *     w  = incident angle                                          *
c *    Written by Richard Crider and Ganyuan Xia 4/99                * 
c ******************************************************************** c
      subroutine matrixB_2R(data,angles,nsamp,ntrc,
     *work3,vect3,gw5,idx,astrt,aend,C,sa)
c                                                            
      implicit none
      real data(*),C,angles(*)
      real work3(*),vect3(*),gw5(*)
      real astrt,aend
      real theta,sine,tang,work0
      real avangle,y
 
      integer nsamp,ntrc,idx
      integer i,j,mdx,ndx,n
      logical sa

      do i=1,ntrc
       vect3(i)=0.
      end do
      n = 0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
       endif
      end do
      n=0
      do j=0,ntrc-1
       theta=avangle(angles,nsamp,j,idx,sa)
       ndx=j*nsamp+idx
       mdx=idx+1
       y     = data(ndx)
       if(theta.ge.astrt.and.theta.le.aend.and.y.ne.0.0)then
        n = n+1
        sine=sin(theta)
        sine=sine*sine
        work0=1.
        if(C.ne.0.)then
         tang=tan(theta)
         tang=tang*tang
         work0=(1.+(1./(1.+c))*tang*sine)
        endif
        work3(n)=sine
        vect3(n)=y
       endif
      end do
      if(n.ge.3)then
      call Robust(vect3,work3,n,gw5(1),gw5(2))
      else
       gw5(1)=0.
       gw5(2)=0.
      endif
      return
      end
      subroutine Robust(Y,Z,n,A,B)
c +===========================================================+
c *   Based on A.T. Walden, Making AVO Sections More Robust   *
c *   Geophysical Prospecting, 39, 915-942, 1991              *
c +===========================================================+
      implicit none
      real Y(*), Z(*)
      real A, B
      integer n

      real beta1, beta2, ZL(1),ZR(1),hZ(1),BH,AH
      real get_beta
      real U(1)
      real zmed
      real sigma,W(1),psi,pi
      real sumY,sumZY,sumZ,sumZ2,sumW,Determ
 
      integer indZR(1),indZL(1)
      integer i,j,k,m,isz,iab,ier,ip1,ip2

      pointer (pZL,ZL),(pZR,ZR),(phZ,hZ)
      pointer (pindR,indZR),(pindL,indZL)
      pointer (pU,U),(pW,W)

      pi = 4.0*atan(1.0)
      call sizefloat(isz)
      m = n/2+1
      iab=0
      ier=0
      call galloc(pZL    , isz*n,ier,iab)
      call galloc(pZR    , isz*n,ier,iab)
      call galloc(phZ    , isz*n,ier,iab)
      call galloc(pU     , isz*n,ier,iab)
      call galloc(pW     , isz*n,ier,iab)
      call galloc(pindR  , isz*n,ier,iab)
      call galloc(pindL  , isz*n,ier,iab)

      call vmov(Z,1,hZ,1,n)
      call hsort(n,hZ)
      if(n/2*2.eq.n)then
       zmed = 0.5*(hz(n/2)+hZ(n/2+1))
      else
       zmed = hZ(n/2+1)
      endif
      j=0
      k=0
      do i=1,n
       if(Z(i).lt.zmed)then
        j=j+1
        ZL(j)=Z(i)
        indZL(j)=i
       else
        k=k+1
        ZR(k)=Z(i)
        indZR(k)=i
       endif
      end do
      beta1=get_beta(j,k,ZL,ZR,indZL,indZR,Y)
      do i=1,n
       U(i)=Y(i)-beta1*Z(i)
      end do
      call vmov(Z,1,hZ,1,n)
      call hsort(n,hZ)
      if(n/2*2.eq.n)then
       zmed = 0.5*(hZ(n/2)+hZ(n/2+1))
      else
       zmed = hZ(n/2+1)
      endif
      j=0
      k=0
      m=n/2
      do i=1,n
       indZL(i)=1
       indZR(i)=1
      end do
      do i=1,n
       if(Z(i).lt.zmed)then
        j=j+1
        ZL(j)=Z(i)
        indZL(j)=i
       elseif(Z(i).gt.zmed)then
        k=k+1
        ZR(k)=Z(i)
        indZR(k)=i
       endif
      end do
      beta2=get_beta(j,k,ZL,ZR,indZL,indZR,U)
      B = beta1+beta2
      BH = B
      do i=1,n
       U(i)=Y(i)-B*Z(i)
      end do
      call hsort(n,U)
      if(n/2*2.eq.n)then
       ip1 = n/2
       ip2 = n/2+1
       A = 0.5*(U(ip1)+U(ip2))
      else
       A = U(n/2+1)
      endif
      AH = A
c +=================+
c | Do the MLE part |
c +=================+
      do i=1,n
       U(i)=Y(i)-(A+B*Z(i))
      end do
      do i=1,n
       hZ(i)=abs(U(i))
      end do
      call hsort(n,hZ)
      if(n/2*2.eq.n)then
       ip1 = n/2
       ip2 = n/2+1
       sigma = 0.5*(hZ(ip1)+hZ(ip2))
      else
       sigma = hZ(n/2+1)
      endif
      sigma = 2.1*sigma
      if(sigma.eq.0)then
       A=0.
       B=0.
       call gfree(pZL)
       call gfree(pZR)
       call gfree(phZ)
       call gfree(pU)
       call gfree(pW)
       call gfree(pindR)
       call gfree(pindL)
       return
      endif
      do i=1,n
       if(U(i).ne.0.0)then
        psi = U(i)/sigma
        if(abs(psi).lt.pi)then
         W(i)=sin(psi)/U(i)
        else
         W(i)=0.
        endif
       else
        W(i)=0.
       endif
      end do
      sumY=0.
      sumZY=0.
      sumZ=0.
      sumZ2=0.
      sumW=0.
      do i=1,n
       sumY  = sumY  + Y(i)*W(i)
       sumZY = sumZY + Z(i)*Y(i)*W(i)
       sumZ  = sumZ  + Z(i)*W(i)
       sumZ2 = sumZ2 + Z(i)*Z(i)*W(i)
       sumW  = sumW  + W(i)
      end do
      Determ = sumZ*sumZ - sumW*sumZ2
      if(Determ.ne.0.0)then
       A = (sumZ*sumZY - sumZ2*sumY)/Determ
       B = (sumZ*sumY  - sumW*sumZY)/Determ
      else
       A=0.
        B=0.
      endif
      call gfree(pZL)
      call gfree(pZR)
      call gfree(phZ)
      call gfree(pU)
      call gfree(pW)
      call gfree(pindR)
      call gfree(pindL)
      return
      end
      real function get_beta(j,k,ZL,ZR,indZL,indZR,Y)
      implicit none
      real ZL(*),ZR(*),Y(*)
      integer j,k,indZL(*),indZR(*)
      integer ip1,ip2,n,i
     
      real zlmed,zrmed,ylmed,yrmed,beta

      do i=1,j
      end do
      call hsort2(j,ZL,indZL)
      call hsort2(k,ZR,indZR)
      do i=1,j
      end do
      if(j/2*2.eq.j)then
       zlmed = 0.5*(ZL(j/2)+ZL(j/2+1))
       ip1 = indZL(j/2)
       ip2 = indZL(j/2+1)
       ylmed = 0.5*(Y(ip1)+Y(ip2))
      else
       zlmed = ZL(n/2+1)
       ip1 = indZL(n/2+1)
       ylmed = Y(ip1)
      endif
      if(k/2*2.eq.k)then
       zrmed = 0.5*(ZR(k/2)+ZR(k/2+1))
       ip1 = indZR(k/2)
       ip2 = indZR(k/2+1)
       yrmed = 0.5*(Y(ip1)+Y(ip2))
      else
       zrmed = ZR(n/2+1)
       ip1 = indZR(n/2+1)
       yrmed = Y(ip1)
      endif
      beta = zrmed - zlmed
      if(beta.ne.0)then
       beta = (yrmed - ylmed)/beta
      endif
      get_beta=beta
      return
      end
