C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine attrstk(b0,b1,b2,angmin,angmax,angles, vsvpsqr,
     :nsamp,ntrc,iopt)
      implicit none
      real b0(*),b1(*),b2(*),angles(*),vsvpsqr(*)
      real angmin, angmax,cosx1,cosx2,tanx1,tanx2,sinx1,sinx2
      real ax,ay
      integer nsamp, ntrc, iopt,indx

      real awt1,awt2,awt3,awt4,ang1,ang2,a1,a2,anga,angc
      integer i,j

      do i=1,nsamp
       ang1 = angmin
       ang2 = angmax
       a2 = ang1
       a2 = ang2
       j=0
       indx=j*nsamp+i
       anga=angles(indx)
       j=ntrc-1
       indx=j*nsamp+i
       angc = angles(indx)
       a2 = angc
       if(anga.gt.angmin)a1=anga
       if(angc.gt.angmax)a2=angmax
       if(a1.gt.a2)a2=a1
       ang1 = a1
       ang2 = a2
       sinx1 = sin(ang1)
       cosx1 = cos(ang1)
       tanx1 = tan(ang1)
       sinx2 = sin(ang2)
       cosx2 = cos(ang2)
       tanx2 = tan(ang2)
       awt1=ang2-ang1
       IF(iopt.eq.1)then
c +===================+
c |  2-term solution  |
c +===================+
c +==========================================+
* | integral sin^2(t) = (t/2 - sin(2t)/4     |
* |                   = (t/2 - 2*cost*sint/4 |
* |                   = 0.5*(t - cost*sint)  |
c +==========================================+
        ay=0.5*(ang2 - cosx2*sinx2)
        ax=0.5*(ang1 - cosx1*sinx1)
        awt2=ay-ax
        if(awt1.le.0.0)then
         b0(i)=0.
         b1(i)=0.
        else
         b1(i)=awt2*b1(i)/awt1
        endif
       ELSEIF(iopt.eq.2)then
c +===================+
c |  3-term solution  |
c +===================+
        ay=0.5*(ang2 - cosx2*sinx2)
        ax=0.5*(ang1 - cosx1*sinx1)
        awt2=ay-ax
c +===========================================+
* | integral sin^2(t)*tan^2(t) = (sin(2t)/4 + |
* |                              tan(t)-3t/2  |  
c +===========================================+
        ay=(sin(2.*ang2)/4.+tan(ang2)-3*ang2/2.)
        ax=(sin(2.*ang1)/4.+tan(ang1)-3*ang1/2.)
        awt3=ay-ax
        if(awt1.le.0.0)then
         b0(i)=0.
         b1(i)=0.
         b2(i)=0.
        else
         b1(i)=awt2*b1(i)/awt1
         b2(i)=awt3*b2(i)/awt1
        endif
       ELSEIF(iopt.eq.3)then
c +=========================+
c |  2-term solution, Vp,Vs |
c +=========================+
        ay = tan(ang2)
        ax = tan(ang1)
        awt2 = ay-ax
        ay=0.5*(ang2 - cosx2*sinx2)
        ax=0.5*(ang1 - cosx1*sinx1)
        awt3=ay-ax
        if(awt1.le.0.0)then
         b0(i)=0.
         b1(i)=0.
        else
         b0(i)=0.5*awt2*b0(i)/awt1
         b1(i)=vsvpsqr(i)*8.*awt3*b1(i)/awt1
        endif
       ELSEIF(iopt.eq.4)then
c +=============================+
c |  3-term solution, Vp,Vs,rho |
c +=============================+
        ay = tan(ang2)
        ax = tan(ang1)
        awt2 = ay-ax
        ay=0.5*(ang2 - cosx2*sinx2)
        ax=0.5*(ang1 - cosx1*sinx1)
        awt3=ay-ax
        ay = ang2-vsvpsqr(i)*ay
        ax = ang1-vsvpsqr(i)*ax
        awt4 = ay-ax
        if(awt1.le.0.0)then
         b0(i)=0.
         b1(i)=0.
         b2(i)=0.
        else
         b0(i)=0.5*awt2*b0(i)/awt1
         b1(i)=vsvpsqr(i)*8.*awt3*b1(i)/awt1
         b2(i)=awt4*b2(i)/awt1
        endif
       ELSE
        b0(i)=0.
        b1(i)=0.
        b2(i)=0.
       ENDIF
      end do
      return
      end
