C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      real function runs(a,b,c,data,angles,nsamp,ntrc,
     :angb,ange,vsvp,gc,iopt,idx,sigma,ierr)
*
      implicit none
      real a,b,c,data(*),angles(*)
      real angb, ange,sigma,vsvp,gc
      real denom
      integer ntrc,ierr,nsamp,idx,iopt
  
      real resid(1)
      real angl,yl
      real n2,n1,U,n_sum,mu,cont
      real yhat
      integer ndx,i,n_resid,n_half
      integer isz,iget,ier,iab
     
      pointer (pres,resid)

      call sizefloat(isz)
      ier = 0
      iab = 0
      iget = isz*ntrc
      call galloc(pres,iget,ier,iab)
      
      if(a.eq.0.and.b.eq.0.and.c.eq.0)then
       runs = 0.
       sigma = 0.
       call gfree(pres)
       return
      endif
      n2=0.
      n1=0.
      n_resid=0
      do i=1,ntrc
       ndx=(i-1)*nsamp+idx
       angl = angles(ndx)
       yl = data(ndx)
       if(angl.ge.angb.and.angl.le.ange.and.yl.ne.0.0)then
        n_resid = n_resid+1
        resid(i)=yl-yhat(a,b,c,angl,iopt,gc,vsvp)
        if(resid(i).gt.0.0)then
         n1=n1+1.
         resid(i)=1.
        elseif(resid(i).lt.0.0)then
         n2=n2+1.
         resid(i)=-1.
        endif
       endif
      end dO
      n_half = n_resid/2-1
      if((n1+n2).lt.n_half)then
       runs = 0.
       sigma = 0.
       call gfree(pres)
       return
      endif
      U=1.
      do i=2,n_resid
       if(resid(i).ne.resid(i-1))U=U+1.
      end do
      n_sum = n2+n1
      sigma = 2.*n1*n2*(2.*n1*n2-n1-n2)
      denom = (n1+n2)*(n1+n2)*((n1+n2)-1)
      sigma = sigma/((n1+n2)*(n1+n2)*((n1+n2)-1))
      sigma = sqrt(sigma)
      mu = (2.*n2*n1)/n_sum + 1.
      if(mu .lt. U)then
        cont = -0.5
      else
        cont = 0.5
      endif
      if(sigma.ne.0.0)then
      runs = (U-mu+cont)/sigma
      else
       runs = 0.
      endif
*      print *,' denom = ',denom,' nsum = ',n_sum,sigma,runs
*     print *,' runs = ',runs,U,n2,n1,mu,cont,sigma,n_resid
      call gfree(pres)
      return
      end
