C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*****************************************************************
c                                                                 
c     SUBROUTINE - solver     
c                                                               
c     LANGUAGE - FORTRAN 77                                    
c     SYSTEM(S) - SUN
c     AUTHOR - Richard Crider                                
c     DATE WRITTEN - 
c                                                          
c                     BP AMOCO PROPRIETARY
c                 TO BE MAINTAINED IN CONFIDENCE
c                                                        
c     ABSTRACT - Set up storage space for matrix equation solutions
c                and call the appropriate solution manager for the 
c                option requested.
c     USAGE                                                 
c                                                          
c       call solver(nsamp,ntrc, data, vsvpsqr, stacka, 
c              stackb, stackc, angles, astrt,aend,np,rc,iopt,c,sa,ierr)
c                                                       
c             nsamp   =  Number of samples per trace (rows)
c             ntrc    =  Number of traces per record (columns)
c             data    =  Matrix of trace data
c             vsvpsqr =  square of ratio of average Vs to average Vp
c             stacka  =  Returned coefficient corresponding to Drho/rho
c             stackb  =  Returned coefficient corresponding to Dmu/mu
c             stackc  =  Returned coefficient corresponding to DVp/Vp
c             angles  =  Matrix of incident angles from ray tracing
c             astrt   =  Start angle for sum for angle-limited stack
c             aend    =  End angle for sum for angle-limited stack
c              np     =  Minimum number samples in the solution
c              rc     =  Correlation coeff.
c             iopt    =  computation option
c               c     =  Gardner coefficient
c              sa     =  flag true = average incident angles
c                             false = do not average
c             IERR    =  Error flag 
c                                                      
c     ERROR/RETURN CODES - ierr                 
c                          .ne. 0 = memory allocation error
c                                              
c***************************************************************
      subroutine solver(nsamp,ntrc, data, vsvpsqr,stacka, 
     : stackb,stackc, angles, astrt,aend, np, rc, iopt,
     : C,sa,robust,resids,runsz,tol1,tol2,tol3,kp,var,
     : ierr)


       implicit none
      real data(*), vsvp,C,vsvpsqr(*),resids(*)
      real runsz(*),tol1(*),tol2(*),tol3(*),var(*)
      real stacka(*), stackb(*),stackc(*)
      real angles(*),astrt,aend, rc(*),kp(*)
      real work3(1),vect3(1),work1(1),work5(1)
      real aw3(1),gw3(1),gw5(1),aw5(1)
      real yhat,sumy,sumy2,ydat,resid,sumresid,yhatavg
      real sumx1y, sumx2y,sumx3y
      real dn,an1
      real b0,b1,b2,syy
      real runs
      integer ntrc,nsamp,np,iopt,ierr,jp
      integer i,j,ndx,isz,iget,ier,istop
      integer ncol
      pointer (pw3,work3),(pv3,vect3)
      pointer (pw5,work5),(pw1,work1),(paw5,aw5)
      pointer (paw3,aw3),(pgw3,gw3), (pgw5,gw5)
      logical sa,robust
c +==========================================+
c | Need work matrices ntrc x 3 and ntrc x 2 |
c +==========================================+
      call sizefloat(isz)
      iget = 4*ntrc*5*isz
      ier = 0
      ierr=0
      istop = 0
      call galloc(pw3, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(pw1, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(pw5, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(paw3, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(paw5, iget,ier,istop)
      if(ier.ne.0)ierr=1

      iget=3*ntrc*isz
      call galloc(pv3, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(pgw3, iget,ier,istop)
      if(ier.ne.0)ierr=1
      call galloc(pgw5, iget,ier,istop)
      if(ier.ne.0)ierr=1
      iget = nsamp*isz

      if(ierr.ne.0)return

      jp = np
      if(iopt.eq.1)then
       ncol = 2
       do i=1,nsamp
        np = jp
        if(robust)then
          call matrixB_2(data,angles,nsamp,ntrc,
     :    work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,
     :    C,sa)
         call matrixB_2R(data,angles,nsamp,ntrc,
     :   work3,vect3,gw5,i,astrt,aend,C,sa)
         call matrixB_2R(data,angles,nsamp,ntrc,
     :   work3,vect3,gw5,i,astrt,aend,C,sa)
        else
         np=jp
          call matrixB_2(data,angles,nsamp,ntrc,
     :    work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,
     :    C,sa)
        endif
        kp(i)=np
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=0.
        tol1(i)=aw5(1)
        tol2(i)=aw5(4)
        tol3(i)=0.
       end do
      elseif(iopt.eq.2)then
       ncol = 2
       do i=1,nsamp
        np = jp
        vsvp = vsvpsqr(i)*4.
         call matrixV_2(data,angles,nsamp,ntrc,
     :   work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,vsvp,
     :   c,sa)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=0.
        tol1(i)=aw5(1)
        tol2(i)=aw5(4)
        tol3(i)=0.
       end do
      elseif(iopt.eq.3)then
       ncol = 3
       do i=1,nsamp
        np = jp
        vsvp = vsvpsqr(i)*4.
        call matrixV_3(data,angles,nsamp,ntrc,
     :  work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,vsvp,sa)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=gw5(3)
        tol1(i)=aw5(1)
        tol2(i)=aw5(5)
        tol3(i)=aw5(9)
       end do
      elseif(iopt.eq.4)then
       ncol=3
       do i=1,nsamp
        np = jp
         call matrixB_3(data,angles,nsamp,ntrc,
     :  work3,vect3,work1,aw3,gw3,aw5,gw5,i,astrt,aend,ncol,np,sa)
        stacka(i)=gw5(1)
        stackb(i)=gw5(2)
        stackc(i)=gw5(3)
        tol1(i)=aw5(1)
        tol2(i)=aw5(5)
        tol3(i)=aw5(9)
        kp(i) = np
       end do
      else
       do i=1,nsamp
        stacka(i)=0.
        stackb(i)=0.
        stackc(i)=0.
       end do
      endif
c +=============+
c | get the r^2 |
c +=============+
      do i=1,nsamp
       sumy = 0.
       sumy2 = 0.
       sumx1y = 0.
       sumx2y = 0.
       sumx3y = 0.
       sumresid = 0.
       b0 = stacka(i)
       b1 = stackb(i)
       b2 = stackc(i)
       vsvp = vsvpsqr(i)*4.
       if(iopt.eq.1)b2=0.
       dn=0.
       do j=1,ntrc
        ndx=(j-1)*nsamp+i
        an1 = angles(ndx)
        ydat = data(ndx)
        if(an1.ge.astrt.and.an1.le.aend.and.ydat.ne.0.0)then
         dn=dn+1.
         sumy = sumy + ydat
         sumy2 = sumy2 + ydat*ydat
         resid = ydat - yhat(b0,b1,b2,an1,iopt,c,vsvp)
         sumresid = sumresid + resid*resid
        endif
       end do
       resids(i)=0.
       if(dn.gt.jp)then
        resids(i)=sqrt(sumresid/dn)
        syy = sumy2-((sumy*sumy)/dn)
        if(syy.ne.0)then
         rc(i) = 1.0 - sumresid/syy
          if(rc(i).lt.0.)rc(i)=0.
        else
         rc(i)=0.
        endif
       else
        rc(i)=0.
       endif
      end do
c  get runsz
      do i=1,nsamp
       vsvp = vsvpsqr(i)*4.
       b0 = stacka(i)
       b1 = stackb(i)
       b2 = stackc(i)
       runsz(i)=runs(b0,b1,b2,
     :  data,angles,nsamp,ntrc,astrt,aend,vsvp,c,iopt,i,var(i),ierr)
      end do
c get tolerances
      do i=1,nsamp
       tol1(i)=2.*var(i)*sqrt(tol1(i))
       tol2(i)=2.*var(i)*sqrt(tol2(i))
       tol3(i)=2.*var(i)*sqrt(tol3(i))
      end do
      call gfree(pw3)
      call gfree(pw1)
      call gfree(pw5)
      call gfree(paw3)
      call gfree(paw5)
      call gfree(pv3)
      call gfree(pgw3)
      call gfree(pgw5)
      return
      end
