C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      real function yhat(b0,b1,b2,angl,iopt,c,k)
      implicit none
      real b0,b1,b2,angl,c,k
      integer iopt

      real ar1, ar2, ar3,tang,sing

      tang = tan(angl)*tan(angl)
      sing = sin(angl)*sin(angl)
      if(iopt.eq.1)then
       if(c.ne.0.0)then
        ar1 =1.+(1./(1.+c))*tang*sing
       else
        ar1 = 1.
       endif
       ar2 = sing
       ar3 = 0.
      elseif(iopt.eq.2)then
       ar1 = 0.5*((1.+tang)+(1.-K*sing)*c)
       ar2 = K*sing
       ar3 = 0.
      elseif(iopt.eq.3)then
       ar1 = 0.5*(1.+tang)
       ar2 = K*sing
       ar3 = 0.5*(1.-K*sing)
      elseif(iopt.eq.4)then
       ar1 = 1.
       ar2 = sing
       ar3 = tang*sing
      elseif(iopt.eq.6)then
       ar1 = 1.
       ar2 = K*sing
       ar3 = 0.5*tang
      else
       ar1 = 0.
       ar2 = 0.
       ar3 = 0.
      endif
      yhat = b0*ar1+b1*ar2+b2*ar3
      return
      end
