C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      real function yhatavg(b0,b1,b2,ang1,ang2,iopt,c,k)
c + ============================================================================ + 
c + Computes the value of the average (integral/deltheta) for angles between
c + ang1 and ang2            
c + Int(sin^2) from a1 to a2 is
c +  (a2-a1)/2. - (sin(2*a2)-sin(2a1))/4.
c + Int(tan^2) from a1 to a2 is
c +  (tan(a2)-tan(a1)) - (a2-a1)
c + Int(tan^2*sin^2) from a1 to a2 is
c +  (tan(a2)-tan(a1)) - 3*(a2-a1)/2 + (sin(2*a2)-sin(2a1))/4.
c + ============================================================================ + 

      implicit none
      real b0,b1,b2,ang1,c,k,ang2
      integer iopt

      real ar1, ar2, ar3,tang,sing
      real delth,sine,del3

      delth = ang2-ang1
      sine = sin(2.*ang2) - sin(2.*ang1)
      sine = sine/4.
      tang = tan(ang2) - tan(ang1)
      del3 = 3.*delth/2.

      if(iopt.eq.1)then
       if(c.ne.0.0)then
*       ar1 =1.+(1./(1.+c))*tang*sing
        ar1  = delth                               ! Int(1*delth)
        ar1 = ar1 + (1./(1.+c))*(tang-del3+sine)   ! Int(tan^2sin^2)delth
        ar1 = ar1/delth
       else
        ar1 = 1.
       endif
*      ar2 = sing
       ar2 = 1./delth*(delth/2. - sine)            ! Int(sin^2)delth
       ar3 = 0.
      elseif(iopt.eq.2)then
*      ar1 = 0.5*((1.+tang)+(1.-K*sing)*c)
       ar1 = tang                                  ! Int((1.+tan^2)delth
       ar1 = ar1+(delth-K*(delth/2.-sine)*c)       ! Int(1-Ksin^2)delth
       ar1 = 0.5*ar1/delth
*      ar2 = K*sing
       ar2 = K/delth*(delth/2. - sine)             ! Int(sin^2)delth
       ar3 = 0.
      elseif(iopt.eq.3)then
*      ar1 = 0.5*(1.+tang)
       ar1 = 0.5/delth*(tang)                       ! Int(1+tan^2)delth
*      ar2 = K*sing
       ar2 = K/delth*(delth/2.-sine)               ! Int(K*sin^2)delth
*      ar3 = 0.5*(1.-K*sing)
       ar3 = 0.5/delth*(delth-K*(delth/2-sine))    ! Int(0.5*(1-K*sin^2))delth
      elseif(iopt.eq.4)then
       ar1 = 1.
*      ar2 = sing
       ar2 = 1/delth*(delth/2-sine)
*      ar3 = tang*sing
       ar3 = tang-del3+sine
       ar3 = ar3/delth
      elseif(iopt.eq.6)then
       ar1 = 1.
       ar2 = K*sing
       ar2 = K/delth*(delth/2-sine)
*      ar3 = 0.5*tang
       ar3 = 0.5/delth*(tang-delth)
      else
       ar1 = 0.
       ar2 = 0.
       ar3 = 0.
      endif
      yhatavg = b0*ar1+b1*ar2+b2*ar3
      return
      end
