C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine yhsum(y,angl,iopt,c,k,sumx1y,sumx2y,sumx3y)
      implicit none
      real sumx1y,sumx2y,sumx3y,angl,c,k,y
      integer iopt

      real ar1, ar2, ar3,tang,sing

      tang = tan(angl)*tan(angl)
      sing = sin(angl)*sin(angl)
      if(iopt.eq.1)then
       if(c.ne.0.0)then
        ar1 = 1.+(1./(1+c))*tang*sing
       else
        ar1 = 1.
       endif
       ar2 = sing
       ar3 = 0.
      elseif(iopt.eq.2)then
       ar1 = 0.5*((1.+tang)+(1.-K*sing)*c)
       ar2 = K*sing
       ar3 = 0.
      elseif(iopt.eq.3)then
       ar1 = 0.5*(1.+tang)
       ar2 = K*sing
       ar3 = 0.5*(1.-K*sing)
      elseif(iopt.eq.4)then
       ar1 = 1.
       ar2 = sing
       ar3 = tang*sing
      elseif(iopt.eq.6)then
       ar1 = 1.
       ar2 = K*sing
       ar3 = 0.5*tang
      else
       ar1 = 0.
       ar2 = 0.
       ar3 = 0.
      endif
      sumx1y  = sumx1y + ar1*y
      sumx2y  = sumx2y + ar2*y
      sumx3y  = sumx3y + ar3*y
      return
      end
