C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c     PROGRAM MODULE  bgrid:
c        read EarthVision grid and convert to USP format 
c
c**********************************************************************c
c
c January, 2004- Richard Crider
c     created code as a modification of program putsis
c
c**********************************************************************c
c
c     DECLARE VARIABLES
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

      integer     ilhd(1)
      pointer     (ptr_ilhd,ilhd)

      integer     Trace(1),Trhdr(1)

      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin, luout, lbytes,obytes
      integer     argis

      integer     ier1,ier2,ier3,ier4, iab1,iab2,iab3,iab4
      character   name*5, otap*256, ntap*256
      character   card*150
      logical     verbos

      real        work(1)

      pointer     (ptr_Trace,Trace),(ptr_Trhdr,Trhdr)
      pointer     (ptr_work,work)
 
      data name /'BGRID'/
      data luin /1/, luout /2/, lbytes /0/
      data verbos/.false./

c--------------------------------
c  get online help if necesssary
c--------------------------------
      if(argis('-?').gt.0 .or.
     :   argis('-h').gt.0 .or.
     :   argis('-help').gt.0) then
        call help()
        stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

c---------------------------------------------------
c     read program parameters from command line
c---------------------------------------------------
      call cmdln(ntap,otap,nsi,nsamp,ntrc,verbos,
     :                 nhdr,name,LERR,LER)

c-----------------
c     open input
c-----------------
        if (ntap .ne. ' ') then
          luin = LUCARD
          open (UNIT=luin, FILE=ntap)
          rewind luin
        else
          luin = LIN
        endif
c------------------------
c     allocate memory
c------------------------
      ier1=0
      ier2=0
      ier3=0
      ier4=0
      iab1=0
      iab2=0
      iab3=0
      iab4=0

      iget = ntrc*nsamp*SZSMPD
      call galloc(ptr_work, iget,ier1,iab1)
      call vclr (work, 1, nsamp*ntrc)
      iget=2*ntrc*ITRWRD*SZSMPD
      call galloc(ptr_Trhdr, iget,ier1,iab1)
      iget = ntrc*ITRWRD*SZSMPD

      iget = SZTRHD + nsamp*SZSMPD
      call galloc(ptr_Trace,iget,ier3,iab3)

      iget = SZLNHD
      call galloc(ptr_ilhd,iget,ier4,iab4)

      if(ier1.ne.0 .or. ier2.ne.0 .or. ier3.ne.0 .or. ier4.ne.0)then
        write(LER ,*)'Memory allocation error.  FATAL!'
        stop
      endif

C----------------------------------------------
C     open output data set; build line header
C----------------------------------------------
      call getln( luout, otap, 'w', 1)

      nrec  = 1
      iform = 3
      unitsc = .001

      call savew(ilhd, 'SmpInt', nsi   , LINHED)
      call savew(ilhd, 'UnitSc', unitsc, LINHED)
      call savew(ilhd, 'NumSmp', nsamp , LINHED)
      call savew(ilhd, 'NumTrc', ntrc  , LINHED)
      call savew(ilhd, 'NumRec', nrec  , LINHED)
      call savew(ilhd, 'Format', iform , LINHED)

c-------------------------------------
c  update line header; historical LH
c-------------------------------------
      write(LERR,*)' '
      write(LERR,*)'Number samples      =  ',nsamp
      write(LERR,*)'Number records      =  ',nrec
      write(LERR,*)'Number traces       =  ',ntrc
      write(LERR,*)'Sample interval     =  ',nsi
      write(LERR,*)' '

      lbytes = HSTOFF
      nbyt = 2 * SZHFWD
      call savew(ilhd, 'HlhEnt',  0  , LINHED)
      call savew(ilhd, 'HlhByt', nbyt, LINHED)
      call savhlh(ilhd, lbytes, lbyout)

c--------------------------
c write line hdr to luout
c--------------------------
      call wrtape(luout, ilhd, lbyout)

c-----------------------------
c get trace header info (for stufing trace headers in main loop)
c-----------------------------
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)

c-----------------------------
c set the number of bytes in each output trace
c-----------------------------
      obytes = SZTRHD+SZSMPD*nsamp

c------------------------------
c proceed with processing
c------------------------------
 2000 format(' Sample at time ',1x,i6,' sample',i5,1x,i6,1x,i6,1x,f9.5)
            do mm = 1,nhdr
              read(luin,*)card(1:80)
            end do
            DO mm = 1,nsamp
             do itrc = 1, ntrc
              ndx = (itrc-1)*nsamp
              read(luin,*,IOSTAT=ier1)Line,Jtrc,Itime,sclr,j1,j2,j3
              isamp = Itime/nsi+1
              if(isamp.gt.nsamp)isamp=nsamp
              samp  = float(Itime)/float(nsi)+1.0
              if(verbos)then
               if(itrc.eq.1)
     :          write(LER , 2000)Itime,isamp,Line,Jtrc,sclr
              endif
              work(ndx+isamp)=sclr
              if (ier1.gt.0) then
                write(LER,*)name,': ERROR reading input trace ',itrc
                write(LERR,*)name,': ERROR reading input trace ',itrc
                stop
              endif
              if(mm.eq.1)then
               mdx = (itrc-1)*ITRWRD+1
               call savew2(Trhdr(mdx),ifmt_TrcNum,l_TrcNum,
     :                    ln_TrcNum,Jtrc,TRACEHEADER)
               call savew2(Trhdr(mdx),ifmt_RecNum,l_RecNum,
     :                    ln_RecNum,Line,TRACEHEADER)
               call savew2(Trhdr(mdx),ifmt_DphInd,l_DphInd,
     :                    ln_DphInd,Jtrc,TRACEHEADER)
               call savew2(Trhdr(mdx),ifmt_LinInd,l_LinInd,
     :                    Ln_LinInd,Line,TRACEHEADER)
              endif
             end do
            end DO
200         continue
            do mm=1,ntrc
             ndx=  (mm-1)*nsamp+1
             mdx = (mm-1)*ITRWRD+1
             call vmov(Trhdr(mdx),1,Trace,1,ITRWRD)
             call vmov (work(ndx), 1, Trace(ITHWP1), 1, nsamp)
             call wrtape(luout,Trace,obytes)
            end do

c------------------------

      call lbclos(luout)

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'Command Line Arguments for bgrid: put EV grid in'
      write(LER,*)'sis trace format'
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[ntap]   -- input data set name          (stdin)'
      write(LER,*)'-O[otap]   -- output data set name        (stdout)'
      write(LER,*)'-ns[nsamp] -- number input/output samples   (none)'
      write(LER,*)'-nt[ntrc]  -- number input traces              (1)'
      write(LER,*)'-si[nsi]   -- output sample interval, ms       (1)'
      write(LER,*)'-nh[nhdr]  -- number header line in EV file   (22)'
      write(LER,*)'-V         -- verbos printout              (false)'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'      bgrid  -N[] -F -v[] ] -O[] -ns[] -nt[]'
      write(LER,*)'               -si[] -nh [] -V'
      write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c-----
      subroutine cmdln(ntap,otap,nsi,nsamp,ntrc,verbos,
     :                 nhdr,name,LERR,LER)
      character  ntap*(*), otap*(*),name*(*)
      integer    argis, nsi, nsamp, ntrc,ierr
      integer    nhdr,LER,LERR
      logical    verbos

      ierr=0
      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')
      call argi4('-ns',nsamp,0,0)
      call argi4('-nt',ntrc,1,1)
      call argi4('-si',nsi,1,1)
      call argi4('-nh',nhdr,22,22)
      verbos = ( argis( '-V' ) .gt. 0 )

      if (nsamp .eq. 0) then
         write(LERR,*)'FATAL ERROR in bgrid:'
         write(LERR,*)'Must enter number samples -ns[]'
         write(LER ,*)'FATAL ERROR in bgrid:'
         write(LER ,*)'Must enter number samples -ns[]'
         ierr=ierr+1
      endif
      if (ntrc .eq. 0) then
         write(LERR,*)'FATAL ERROR in bgrid:'
         write(LERR,*)'Must enter number traces -nt[]'
         write(LER ,*)'FATAL ERROR in bgrid:'
         write(LER ,*)'Must enter number traces -nt[]'
         ierr=ierr+1
      endif
      if (nhdr .eq. 0) then
         write(LERR,*)'FATAL ERROR in bgrid:'
         write(LERR,*)'Must enter number header lines -nh[]'
         write(LER ,*)'FATAL ERROR in bgrid:'
         write(LER ,*)'Must enter number header lines -nh[]'
         ierr=ierr+1
      endif
      if(ierr.ne.0)then
         write(LERR,*)'Program bgrid terminated due to ',ierr,' errors'
         write(LER ,*)'Program bgrid terminated due to ',ierr,' errors'
         stop
      endif
C *****************************************************************
C *** check for extraneous arguments and abort if found ***********
C ***** (catch all manner of user typo's) *************************
C *****************************************************************

        call xtrarg (name, LER, .FALSE., .FALSE.)
        call xtrarg (name, LERR, .FALSE., .TRUE.)

      return
      end
