C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bd_detmut (x, im, n, flag, value, threshold )

      implicit none

c  routine to detect the first live sample going down a trace
c  or up a trace depending on the flag

c  x  - input data
c  n  - length of x
c im  - last 'value' sample from top
c       or first 'value' sample at bottom
c       flag = 0 do top
c       flag = 1 do bottom

      integer  im, n, flag, i
      real     x(n)
      real     value

      logical threshold

      im = 0
      if ( flag .eq. 0 ) then
         im = 1

         if ( threshold ) then

            do  i = 1, n
               if (abs(x(i)) .le. value) then
                  im = im + 1
               else
                  return
               endif
            enddo

         else

            do  i = 1, n
               if (abs(x(i)) .eq. value) then
                  im = im + 1
               else
                  return
               endif
            enddo

         endif

      elseif ( flag .eq. 1 ) then

         if ( threshold ) then

            do  i = n,1,-1
               if (abs(x(i)) .le. value) then
                  im = im + 1
               else
                  if ( i .eq. n )then
                     im = n
                  else
                     im = n - im + 1
                  endif
                  return
               endif
            enddo

         else

            do  i = n,1,-1
               if (abs(x(i)) .eq. value) then
                  im = im + 1
               else
                  if ( i .eq. n )then
                     im = n
                  else
                     im = n - im + 1
                  endif
                  return
               endif
            enddo

         endif

      endif

      return
      end
