C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bd_detmute_salt (x, im, n, flag, value)

c  routine to detect the first occurance of value going down a trace
c  or up a trace depending on the flag

c  x  - input data
c  n  - length of x
c im  - last 'value' sample from top
c       or first 'value' sample at bottom
c       flag = 0 do top
c       flag = 1 do bottom

      integer  im, n, flag, i
      real     x(n)
      real     value

      im = 0
      if ( flag .eq. 0 ) then
         im = 1
         do  i = 1, n
            if (abs(x(i)) .eq. value) then
               return
            endif
            im = im + 1
         enddo

         im = 0
         return

      elseif ( flag .eq. 1 ) then

         do  i = n,1,-1
            if (abs(x(i)) .eq. value) then
               if ( i .eq. n )then
                  im = n
 1             else
                  im = n - im 
               endif
               return
            endif
            im = im + 1
         enddo

c if we get here then no salt was detected so return
c with im set to zero

         im = 0
         return

      endif

      return
      end
