C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- detmute ----- ----- ----- ----- ----- ----- ---
c
c Changes:

c       Sept 21, 2004  Added -threshold capability to detect first 
c                      time amp rises above -val[] from top and bottom
c       Garossino

      implicit none

c declare variables

c get machine dependent parameters

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne, argis, jerr

      real        tri(SZLNHD)
      real        value

      character   ntap*255, otap*255, name*7

      logical     verbos, salt

c dimension program specific variables

      integer     l_Hw1, ln_Hw1, ifmt_Hw1, Hw1
      integer     l_Hw2, ln_Hw2, ifmt_Hw2, Hw2
      integer     l_StaCor, ln_StaCor, ifmt_StaCor, StaCor
      integer     mutesample, JJ, KK

      character   mnemonic1*6, mnemonic2*6

      logical     restore, threshold

c Initialize variables

      data lbytes/0/
      data nbytes/0/
      data name/'DETMUTE'/
      data restore/.false./

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln( ntap, otap, ns, ne, irs, ire, mnemonic1, mnemonic2, 
     :     restore, verbos, salt, value, threshold )

c open input and output datasets

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read line header of input save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LOT,*)'DETMUTE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

      call savelu(mnemonic1,ifmt_Hw1,l_Hw1,ln_Hw1,TRACEHEADER)
      call savelu(mnemonic2,ifmt_Hw2,l_Hw2,ln_Hw2,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call hlhprt (itr, lbytes, name, 7, LERR)

c ensure that command line values are compatible with data set

      call cmdchk( ns, ne, irs, ire, ntrc, nrec )

c modify line header to reflect actual number of traces output

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + nsamp * SZSMPD

c save out hlh and line header

      call savhlh(itr, lbytes, lbyout)
      call wrtape (luout, itr, lbyout)

c verbose output of all pertinent information before processing begins

      call verbal( ntap, nsamp, nsi, ntrc, nrec, iform, otap, irs, ire, 
     :     ns, ne, mnemonic1, mnemonic2, restore, value, salt, 
     :     threshold )

c BEGIN PROCESSING

c skip unwanted records 

      call recskp(1,irs-1,luin,ntrc,itr)

c  process desired trace records 

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp(JJ,1,ns-1,luin,ntrc,itr)
      
         DO KK = ns, ne

c read trace

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            call vmov(itr(ITHWP1), 1, tri, 1, nsamp)

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :           TRACEHEADER )
            

            if ( StaCor .ne. 30000 ) then

               if (restore) then
                  
                  call saver2( itr, ifmt_Hw1, l_Hw1, ln_Hw1, Hw1, 
     :                 TRACEHEADER )
                  call saver2( itr, ifmt_Hw2, l_Hw2, ln_Hw2, Hw2, 
     :                 TRACEHEADER )

                  Hw1 = Hw1 / nsi + 1
                  Hw2 = Hw2 / nsi + 1

                  if ( Hw1 .gt. 0 ) call vclr ( tri, 1, Hw1 )
                  if ( Hw2 .gt. 0 ) 
     :                 call vclr ( tri(Hw2), 1, (nsamp - Hw2 + 1) )
                    
               else 

c detect first live sample

                  if ( salt ) then
                     call bd_detmute_salt ( tri, mutesample, nsamp, 
     :                    0, value)
                  else
                     call bd_detmut ( tri, mutesample, nsamp, 0, value,
     :                    threshold )
                  endif

                  Hw1 = (mutesample-1) * nsi

c load time in milliseconds to header

                  call savew2 ( itr, ifmt_Hw1, l_Hw1, ln_Hw1, Hw1, 
     :                 TRACEHEADER )


c detect last live sample

                  if ( salt ) then
                     call bd_detmute_salt ( tri, mutesample, nsamp, 
     :                    1, value)
                  else
                     call bd_detmut ( tri, mutesample, nsamp, 1, value, 
     :                    threshold )
                  endif

                  Hw2 = (mutesample-1) * nsi

c load time in milliseconds to header

                  call savew2 ( itr, ifmt_Hw2, l_Hw2, ln_Hw2, Hw2, 
     :                 TRACEHEADER )

               endif
            endif

c write out trace

            call vmov(tri, 1, itr(ITHWP1), 1, nsamp)
            call wrtape (luout, itr, obytes)

         ENDDO
 
c  skip to end of record 

         call trcskp(JJ,ne+1,ntrc,luin,ntrc,itr)

      ENDDO


c  close data files 

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'end of prgm, processed',nreco,' record(s)',
     :             ' with ',ntrc, ' traces'

      write(LER,*)' detmute: Normal Termination'
      stop
      end
