C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Decompose ( tri, nsamp, tri_buffer, t_size, ist, iend, 
     :     nskip, trbias, nomega, iwind, ihalf, ctable, t, sum, radeg, 
     :     phase, normal_live, normal_energy )

      implicit none

c variables passed from calling routine

      integer nsamp, ist, iend, nskip, nomega, iwind, ihalf
      integer t_size

      real tri(nsamp), tri_buffer(t_size)
      real t(iwind+1)
      real sum(nsamp)
      real radeg

      complex ctable(iwind+1)

      logical trbias, phase, normal_live, normal_energy

c local variables
      
      integer icount, i, N_live

      real sumavg, xtmp, xr, xi, sumtmp, sum2

      complex cb, csum

c initialize variables


c do decomposition of this trace
      
      DO icount = ist+ihalf, iend, nskip
                  
         cb = ( 0., 0. )
         sumavg = 0.
         call vclr ( tri_buffer, 1, t_size)

c load windowed data to buffer

         do i = 1, iwind
            tri_buffer(i) = tri(icount - ihalf + i - 1)
         enddo
                  
         if ( trbias ) then

c ok to calculate from input tri() array as no change to tri() value
c is required
         
            do i=icount-ihalf, icount+ihalf
               sumavg=t(i-icount+ihalf+1)*tri(i) + sumavg
            enddo
            
            sumavg=sumavg/(2*ihalf+1)

         endif

c normalize by energy, do this to tri_buffer() so as not to 
c change tri() prior to next usage.  This would be bad, especially
c if windows overlap, which they often do. 

         if ( normal_energy ) then
            sum2 = 0.0
            
            do i = 1, iwind
               sum2 = sum2 + tri_buffer(i) * tri_buffer(i)
            enddo

            sum2 = sqrt(sum2)

            if (sum2 .gt. 0) then

               do i = 1, iwind
                  tri_buffer(i) = tri_buffer(i) / sum2
               enddo
            endif
         endif

c normalize by number of live samples in window, again do this to 
c tri_buffer() so as not to change tri() prior to next usage

         if (normal_live) then
            N_live = 0

            do i = 1, iwind
               if (tri_buffer(i) .NE. 0.0) then
                  N_live = N_live + 1
               endif
            enddo

            if (N_live .GE. 1) then
               do i= 1, iwind
                  tri_buffer(i) = tri_buffer(i) / N_live
               enddo
            endif
         endif
 
                  
         cb=(0.,0.)
                     
         do i = 1, iwind
                        
            csum=(0.,0.)

            if ( trbias ) then
               xtmp = tri_buffer(i) * t(i) - sumavg
               csum = ctable(i) *
     :              cmplx(xtmp,0.)
            else 
               xtmp = tri_buffer(i) * t(i) 
               csum = ctable(i) *
     :              cmplx(xtmp,0.)
            endif
                        
               cb = csum + cb

            enddo
                  
            if (phase) then
               xr = real(cb)
               xi = aimag(cb)
            else
               call cvabs(cb,2,sumtmp,1,1)
               sumtmp = sumtmp / iwind
            endif

c store spectral information in sum [ sample, frequency ] array

            sum(icount) = sumtmp

            sumtmp=0.

c phase calculation

            if (phase) then
               if(xr .eq. 0.) then
                  sum(icount)=0.
               else
                  sum(icount) = 
     :                 radeg*( atan2 (xi,xr))
               endif
            endif
                     
      ENDDO

      return
      end
