C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ACCSSQ(M, N, X, A, ICODE, SSQ)
      REAL X, A, SSQ
      INTEGER M, N, ICODE
      DIMENSION X(N), A(M)
C
C CALCULATES SUM OF SQUARES ACCURATELY, FROM FIRST
C PRINCIPLES.
C
C LOCAL VARIABLES -
      REAL APX, TSSQ
      INTEGER I, J, NMM
      TSSQ = 0.0
      NMM = N - M
      IF (ICODE) 50, 10, 10
C FORWARD ONLY
   10 CONTINUE
      SSQ = 0.0
      DO 30 I=1,NMM
         APX = 0.0
         DO 20 J=1,M
            APX = APX + A(J)*X(M+I-J)
   20    CONTINUE
         SSQ = SSQ + (X(M+I)-APX)**2
   30 CONTINUE
      IF (ICODE) 50, 40, 80
C SAVE FORWARD SSQ FOR 'BOTH' CALCULATION.
   40 TSSQ = SSQ
C BACKWARD ONLY
   50 CONTINUE
      SSQ = 0.0
      DO 70 I=1,NMM
         APX = 0.0
         DO 60 J=1,M
            APX = APX + A(J)*X(J+I)
   60    CONTINUE
         SSQ = SSQ + (X(I)-APX)**2
   70 CONTINUE
C ADD FORWARD AND BACKWARD TO FORM 'BOTH' SSQ.
      SSQ = SSQ + TSSQ
   80 CONTINUE
      RETURN
      END
